/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.multiContact.KinematicsToolboxSnapshotDescription;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.log.LogTools;

public class MultiContactScriptReader {
    private int currentMessageIndex = 0;
    private final List<KinematicsToolboxSnapshotDescription> loadedMessages = new ArrayList<KinematicsToolboxSnapshotDescription>();

    public boolean loadScript(File scriptFile) {
        if (scriptFile == null) {
            LogTools.info((String)"No file provided");
            return false;
        }
        if (!scriptFile.exists()) {
            LogTools.info((String)("Script file does not exist: " + scriptFile));
            return false;
        }
        if (!scriptFile.isFile()) {
            LogTools.info((String)("Not a file: " + scriptFile));
            return false;
        }
        try {
            return this.loadScript(new FileInputStream(scriptFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadScript(InputStream inputStream) {
        if (inputStream == null) {
            LogTools.info((String)"Stream is null");
            return false;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(inputStream);
            ArrayList<KinematicsToolboxSnapshotDescription> messages = new ArrayList<KinematicsToolboxSnapshotDescription>();
            for (int i = 0; i < jsonNode.size(); ++i) {
                JsonNode child = jsonNode.get(i);
                messages.add(KinematicsToolboxSnapshotDescription.fromJSON(child));
            }
            this.loadedMessages.clear();
            this.loadedMessages.addAll(messages);
            this.currentMessageIndex = -1;
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int size() {
        return this.loadedMessages.size();
    }

    public int getCurrentMessageIndex() {
        return this.currentMessageIndex;
    }

    public boolean hasNext() {
        return this.currentMessageIndex < this.loadedMessages.size() - 1;
    }

    public KinematicsToolboxSnapshotDescription rewind() {
        this.currentMessageIndex = 0;
        return this.getCurrent();
    }

    public KinematicsToolboxSnapshotDescription getFirst() {
        if (this.loadedMessages.isEmpty()) {
            return null;
        }
        return this.loadedMessages.get(0);
    }

    public KinematicsToolboxSnapshotDescription next() {
        ++this.currentMessageIndex;
        if (this.currentMessageIndex >= this.loadedMessages.size()) {
            this.currentMessageIndex = this.loadedMessages.size() - 1;
        }
        return this.getCurrent();
    }

    public KinematicsToolboxSnapshotDescription previous() {
        --this.currentMessageIndex;
        if (this.currentMessageIndex < 0) {
            this.currentMessageIndex = 0;
        }
        return this.getCurrent();
    }

    public KinematicsToolboxSnapshotDescription getCurrent() {
        if (this.loadedMessages.isEmpty() || this.currentMessageIndex == -1) {
            return null;
        }
        return this.loadedMessages.get(this.currentMessageIndex);
    }

    public List<KinematicsToolboxSnapshotDescription> getAllItems() {
        return this.loadedMessages;
    }

    public void applyTransform(Transform transform) {
        for (KinematicsToolboxSnapshotDescription description : this.loadedMessages) {
            description.applyTransform(transform);
        }
    }
}

