/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.multiContact.KinematicsToolboxSnapshotDescription;
import us.ihmc.commons.nio.FileTools;

public class MultiContactScriptWriter {
    private File scriptFile = null;
    private final List<KinematicsToolboxSnapshotDescription> messagesToWrite = new ArrayList<KinematicsToolboxSnapshotDescription>();

    public boolean startNewScript(File scriptFile, boolean overrideExistingFile) {
        if (!scriptFile.exists()) {
            try {
                FileTools.ensureDirectoryExists((Path)scriptFile.getParentFile().toPath());
                scriptFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (!overrideExistingFile) {
            return false;
        }
        try {
            scriptFile.delete();
            scriptFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.scriptFile = scriptFile;
        return true;
    }

    public void clear() {
        this.messagesToWrite.clear();
    }

    public void recordConfiguration(KinematicsToolboxSnapshotDescription description) {
        this.messagesToWrite.add(description);
    }

    public boolean isEmpty() {
        return this.messagesToWrite.isEmpty();
    }

    public boolean removeLast() {
        if (this.messagesToWrite.isEmpty()) {
            return false;
        }
        this.messagesToWrite.remove(this.messagesToWrite.size() - 1);
        return true;
    }

    public boolean writeScript() {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(this.scriptFile);
            JsonFactory jsonFactory = new JsonFactory();
            ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
            ArrayNode arrayNode = objectMapper.createArrayNode();
            for (KinematicsToolboxSnapshotDescription message : this.messagesToWrite) {
                arrayNode.add(message.toJSON(objectMapper));
            }
            objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)printStream, (Object)arrayNode);
            printStream.close();
            this.scriptFile = null;
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (printStream != null) {
                printStream.close();
            }
            return false;
        }
    }
}

