/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controller_msgs.msg.dds.KinematicsToolboxOneDoFJointMessage;
import controller_msgs.msg.dds.KinematicsToolboxOneDoFJointMessagePubSubType;
import java.io.IOException;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;

public class OneDoFMotionControlAnchorDescription {
    public static final String ANCHOR_JSON = OneDoFMotionControlAnchorDescription.class.getSimpleName();
    public static final String JOINT_NAME_JSON = "jointName";
    public static final String IS_TRACKING_CONTROLLER_JSON = "isTrackingController";
    public static final String IK_SOLVER_MESSAGE_JSON = "ikSolverMessage";
    private static final ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
    private static final JSONSerializer<KinematicsToolboxOneDoFJointMessage> messageSerializer = new JSONSerializer((TopicDataType)new KinematicsToolboxOneDoFJointMessagePubSubType());
    public String jointName;
    private boolean isTrackingController;
    public KinematicsToolboxOneDoFJointMessage inputMessage;

    public OneDoFMotionControlAnchorDescription() {
    }

    public OneDoFMotionControlAnchorDescription(OneDoFMotionControlAnchorDescription other) {
        this.jointName = other.jointName;
        this.isTrackingController = other.isTrackingController;
        this.inputMessage = new KinematicsToolboxOneDoFJointMessage(other.inputMessage);
    }

    public static OneDoFMotionControlAnchorDescription fromJSON(JsonNode node) {
        JsonNode anchorNode = node.get(ANCHOR_JSON);
        try {
            OneDoFMotionControlAnchorDescription description = new OneDoFMotionControlAnchorDescription();
            description.setJointName(anchorNode.get(JOINT_NAME_JSON).asText());
            description.setTrackingController(anchorNode.get(IS_TRACKING_CONTROLLER_JSON).asBoolean());
            description.setInputMessage((KinematicsToolboxOneDoFJointMessage)messageSerializer.deserialize(anchorNode.get(IK_SOLVER_MESSAGE_JSON).toString()));
            return description;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode toJSON(ObjectMapper objectMapper) {
        ObjectNode root = objectMapper.createObjectNode();
        ObjectNode anchorJSON = root.putObject(ANCHOR_JSON);
        anchorJSON.put(JOINT_NAME_JSON, this.jointName);
        anchorJSON.put(IS_TRACKING_CONTROLLER_JSON, this.isTrackingController);
        try {
            anchorJSON.set(IK_SOLVER_MESSAGE_JSON, OneDoFMotionControlAnchorDescription.messageToJSON(messageSerializer, this.inputMessage));
            return root;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T> JsonNode messageToJSON(JSONSerializer<T> serializer, T message) throws IOException {
        return objectMapper.readTree(serializer.serializeToString(message));
    }

    public String getJointName() {
        return this.jointName;
    }

    public boolean isTrackingController() {
        return this.isTrackingController;
    }

    public KinematicsToolboxOneDoFJointMessage getInputMessage() {
        return this.inputMessage;
    }

    public void setJointName(String jointName) {
        this.jointName = jointName;
    }

    public void setTrackingController(boolean isTrackingController) {
        this.isTrackingController = isTrackingController;
    }

    public void setInputMessage(KinematicsToolboxOneDoFJointMessage inputMessage) {
        this.inputMessage = inputMessage;
    }

    public String toString() {
        return String.format("[%s=%s, %s=%s]", JOINT_NAME_JSON, this.jointName, IK_SOLVER_MESSAGE_JSON, this.inputMessage);
    }
}

