/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controller_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import controller_msgs.msg.dds.KinematicsToolboxRigidBodyMessagePubSubType;
import java.io.IOException;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;

public class SixDoFMotionControlAnchorDescription {
    public static final String ANCHOR_JSON = SixDoFMotionControlAnchorDescription.class.getSimpleName();
    public static final String RIGID_BODY_NAME_JSON = "rigidBodyName";
    public static final String IS_CONTACT_STATE_JSON = "isContactState";
    public static final String IS_TRACKING_CONTROLLER_JSON = "isTrackingController";
    public static final String IK_SOLVER_MESSAGE_JSON = "ikSolverMessage";
    private static final ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
    private static final JSONSerializer<KinematicsToolboxRigidBodyMessage> messageSerializer = new JSONSerializer((TopicDataType)new KinematicsToolboxRigidBodyMessagePubSubType());
    private String rigidBodyName;
    private boolean isContactState;
    private boolean isTrackingController;
    private KinematicsToolboxRigidBodyMessage inputMessage;

    public SixDoFMotionControlAnchorDescription() {
    }

    public SixDoFMotionControlAnchorDescription(SixDoFMotionControlAnchorDescription other) {
        this.rigidBodyName = other.rigidBodyName;
        this.isContactState = other.isContactState;
        this.isTrackingController = other.isTrackingController;
        this.inputMessage = new KinematicsToolboxRigidBodyMessage(other.inputMessage);
    }

    public static SixDoFMotionControlAnchorDescription fromJSON(JsonNode node) {
        JsonNode anchorNode = node.get(ANCHOR_JSON);
        try {
            SixDoFMotionControlAnchorDescription description = new SixDoFMotionControlAnchorDescription();
            description.setRigidBodyName(anchorNode.get(RIGID_BODY_NAME_JSON).asText());
            description.setContactState(anchorNode.get(IS_CONTACT_STATE_JSON).asBoolean());
            description.setTrackingController(anchorNode.get(IS_TRACKING_CONTROLLER_JSON).asBoolean());
            description.setInputMessage((KinematicsToolboxRigidBodyMessage)messageSerializer.deserialize(anchorNode.get(IK_SOLVER_MESSAGE_JSON).toString()));
            return description;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode toJSON(ObjectMapper objectMapper) {
        ObjectNode root = objectMapper.createObjectNode();
        ObjectNode anchorJSON = root.putObject(ANCHOR_JSON);
        anchorJSON.put(RIGID_BODY_NAME_JSON, this.rigidBodyName);
        anchorJSON.put(IS_CONTACT_STATE_JSON, this.isContactState);
        anchorJSON.put(IS_TRACKING_CONTROLLER_JSON, this.isTrackingController);
        try {
            anchorJSON.set(IK_SOLVER_MESSAGE_JSON, SixDoFMotionControlAnchorDescription.messageToJSON(messageSerializer, this.inputMessage));
            return root;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T> JsonNode messageToJSON(JSONSerializer<T> serializer, T message) throws IOException {
        return objectMapper.readTree(serializer.serializeToString(message));
    }

    public String getRigidBodyName() {
        return this.rigidBodyName;
    }

    public boolean isContactState() {
        return this.isContactState;
    }

    public boolean isTrackingController() {
        return this.isTrackingController;
    }

    public KinematicsToolboxRigidBodyMessage getInputMessage() {
        return this.inputMessage;
    }

    public void setRigidBodyName(String rigidBodyName) {
        this.rigidBodyName = rigidBodyName;
    }

    public void setContactState(boolean isContactState) {
        this.isContactState = isContactState;
    }

    public void setTrackingController(boolean isTrackingController) {
        this.isTrackingController = isTrackingController;
    }

    public void setInputMessage(KinematicsToolboxRigidBodyMessage inputMessage) {
        this.inputMessage = inputMessage;
    }

    public void applyTransform(Transform transform) {
        this.inputMessage.getDesiredPositionInWorld().applyTransform(transform);
        this.inputMessage.getDesiredOrientationInWorld().applyTransform(transform);
    }

    public String toString() {
        return String.format("[%s=%s, %s=%s, %s=%s, %s=%s]", RIGID_BODY_NAME_JSON, this.rigidBodyName, IS_CONTACT_STATE_JSON, this.isContactState, IS_TRACKING_CONTROLLER_JSON, this.isTrackingController, IK_SOLVER_MESSAGE_JSON, this.inputMessage);
    }
}

