/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor;

import controller_msgs.msg.dds.PlanarRegionsListMessage;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessorParameters;
import us.ihmc.avatar.networkProcessor.directionalControlToolboxModule.DirectionalControlModule;
import us.ihmc.avatar.networkProcessor.fiducialDetectorToolBox.FiducialDetectorToolboxModule;
import us.ihmc.avatar.networkProcessor.footstepPlanningModule.FootstepPlanningModuleLauncher;
import us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule.KinematicsPlanningToolboxModule;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxModule;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KinematicsStreamingToolboxMessageLogger;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KinematicsStreamingToolboxModule;
import us.ihmc.avatar.networkProcessor.modules.RosModule;
import us.ihmc.avatar.networkProcessor.modules.ZeroPoseMockRobotConfigurationDataPublisherModule;
import us.ihmc.avatar.networkProcessor.modules.mocap.IHMCMOCAPLocalizationModule;
import us.ihmc.avatar.networkProcessor.modules.mocap.MocapPlanarRegionsListManager;
import us.ihmc.avatar.networkProcessor.objectDetectorToolBox.ObjectDetectorToolboxModule;
import us.ihmc.avatar.networkProcessor.quadTreeHeightMap.HeightQuadTreeToolboxModule;
import us.ihmc.avatar.networkProcessor.reaStateUpdater.HumanoidAvatarREAStateUpdater;
import us.ihmc.avatar.networkProcessor.reaStateUpdater.HumanoidAvatarStereoREAStateUpdater;
import us.ihmc.avatar.networkProcessor.supportingPlanarRegionPublisher.BipedalSupportPlanarRegionPublisher;
import us.ihmc.avatar.networkProcessor.walkingPreview.WalkingControllerPreviewToolboxModule;
import us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule.WholeBodyTrajectoryToolboxModule;
import us.ihmc.avatar.sensors.DRCSensorSuiteManager;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.communication.net.ObjectCommunicator;
import us.ihmc.footstepPlanning.FootstepPlanningModule;
import us.ihmc.footstepPlanning.graphSearch.parameters.FootstepPlannerParametersBasics;
import us.ihmc.humanoidBehaviors.IHMCHumanoidBehaviorManager;
import us.ihmc.log.LogTools;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;
import us.ihmc.robotEnvironmentAwareness.updaters.LIDARBasedREAModule;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.REAPlanarRegionPublicNetworkProvider;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.tools.processManagement.JavaProcessSpawner;
import us.ihmc.tools.thread.CloseableAndDisposable;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;

public class HumanoidNetworkProcessor
implements CloseableAndDisposable {
    private static final String NETWORK_PROCESSOR_ROS2_NODE_NAME = "network_processor";
    private static final String DEFAULT_REA_CONFIG_FILE_PATH = System.getProperty("user.home") + "/.ihmc/Configurations/defaultREAModuleConfiguration.txt";
    private boolean hasStarted = false;
    private boolean isShutdownHookSetup = false;
    private final List<Runnable> modulesToStart = new ArrayList<Runnable>();
    private final List<CloseableAndDisposable> modulesToClose = new ArrayList<CloseableAndDisposable>();
    private final DRCRobotModel robotModel;
    private final DomainFactory.PubSubImplementation pubSubImplementation;
    private RealtimeROS2Node realtimeROS2Node;
    private URI rosURI;
    private ObjectCommunicator simulatedSensorCommunicator;

    public static HumanoidNetworkProcessor newFromParameters(DRCRobotModel robotModel, DomainFactory.PubSubImplementation pubSubImplementation, HumanoidNetworkProcessorParameters parameters) {
        HumanoidNetworkProcessor humanoidNetworkProcessor = new HumanoidNetworkProcessor(robotModel, pubSubImplementation);
        humanoidNetworkProcessor.setRosURI(parameters.getRosURI());
        humanoidNetworkProcessor.setSimulatedSensorCommunicator((ObjectCommunicator)parameters.getSimulatedSensorCommunicator());
        if (parameters.isUseZeroPoseRobotConfigurationPublisherModule()) {
            humanoidNetworkProcessor.setupZeroPoseRobotConfigurationPublisherModule();
        }
        if (parameters.isUseWholeBodyTrajectoryToolboxModule()) {
            humanoidNetworkProcessor.setupWholeBodyTrajectoryToolboxModule(parameters.isVisualizeWholeBodyTrajectoryToolboxModule());
        }
        if (parameters.isUseKinematicsToolboxModule()) {
            humanoidNetworkProcessor.setupKinematicsToolboxModule(parameters.isVisualizeKinematicsToolboxModule());
        }
        if (parameters.isUseKinematicsPlanningToolboxModule()) {
            humanoidNetworkProcessor.setupKinematicsPlanningToolboxModule(parameters.isVisualizeKinematicsPlanningToolboxModule());
        }
        if (parameters.isUseKinematicsStreamingToolboxModule()) {
            humanoidNetworkProcessor.setupKinematicsStreamingToolboxModule(null, null, parameters.isUseKinematicsStreamingToolboxModule());
        }
        if (parameters.isUseFootstepPlanningToolboxModule()) {
            humanoidNetworkProcessor.setupFootstepPlanningToolboxModule();
        }
        if (parameters.isUseMocapModule()) {
            humanoidNetworkProcessor.setupMocapModule();
        }
        if (parameters.isUseBehaviorModule()) {
            humanoidNetworkProcessor.setupBehaviorModule(parameters.isVisualizeBehaviorModule(), parameters.isUseAutomaticDiagnostic(), parameters.getAutomatedDiagnosticInitialDelay());
        }
        if (parameters.isUseROSModule()) {
            humanoidNetworkProcessor.setupRosModule();
        }
        if (parameters.isUseSensorModule()) {
            humanoidNetworkProcessor.setupSensorModule();
        }
        if (parameters.isUseHeightQuadTreeToolboxModule()) {
            humanoidNetworkProcessor.setupHeightQuadTreeToolboxModule();
        }
        if (parameters.isUseFiducialDetectorToolboxModule()) {
            humanoidNetworkProcessor.setupFiducialDetectorToolboxModule();
        }
        if (parameters.isUseObjectDetectorToolboxModule()) {
            humanoidNetworkProcessor.setupObjectDetectorToolboxModule();
        }
        if (parameters.isUseRobotEnvironmentAwerenessModule()) {
            humanoidNetworkProcessor.setupRobotEnvironmentAwerenessModule(parameters.getREAConfigurationFilePath());
        }
        if (parameters.isUseBipedalSupportPlanarRegionPublisherModule()) {
            humanoidNetworkProcessor.setupBipedalSupportPlanarRegionPublisherModule();
        }
        if (parameters.isUseWalkingPreviewModule()) {
            humanoidNetworkProcessor.setupWalkingPreviewModule(parameters.isVisualizeWalkingPreviewModule());
        }
        if (parameters.isUseHumanoidAvatarREAStateUpdater()) {
            humanoidNetworkProcessor.setupHumanoidAvatarLidarREAStateUpdater();
        }
        if (parameters.isUseDirectionalControlModule()) {
            humanoidNetworkProcessor.setupDirectionalControlModule(false);
        }
        return humanoidNetworkProcessor;
    }

    public HumanoidNetworkProcessor(DRCRobotModel robotModel, DomainFactory.PubSubImplementation pubSubImplementation) {
        this.robotModel = robotModel;
        this.pubSubImplementation = pubSubImplementation;
    }

    public void setupShutdownHook() {
        if (this.isShutdownHookSetup) {
            LogTools.info((String)"Shutdown hook already setup.");
            return;
        }
        this.isShutdownHookSetup = true;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogTools.info((String)"Shutting down network processor modules.");
            this.closeAndDispose();
            ThreadTools.sleep((long)10L);
        }, this.getClass().getSimpleName() + "Shutdown"));
    }

    public void setRosURI(URI rosURI) {
        if (this.rosURI != null) {
            throw new RuntimeException("The ROS URI has already been set or used, cannot modify it.");
        }
        this.rosURI = rosURI;
    }

    public void setSimulatedSensorCommunicator(ObjectCommunicator simulatedSensorCommunicator) {
        if (this.simulatedSensorCommunicator != null) {
            throw new RuntimeException("The simulated sensor communicator has already been set, cannot modify it.");
        }
        this.simulatedSensorCommunicator = simulatedSensorCommunicator;
    }

    public RealtimeROS2Node getOrCreateROS2Node() {
        if (this.realtimeROS2Node == null) {
            LogTools.info((String)"Creating ROS 2 node in {} mode", (Object)this.pubSubImplementation.name());
            this.realtimeROS2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)this.pubSubImplementation, (String)NETWORK_PROCESSOR_ROS2_NODE_NAME);
            this.modulesToClose.add(() -> ((RealtimeROS2Node)this.realtimeROS2Node).destroy());
        }
        return this.realtimeROS2Node;
    }

    public URI getOrCreateRosURI() {
        if (this.rosURI == null) {
            this.rosURI = NetworkParameters.getROSURI();
        }
        return this.rosURI;
    }

    public ObjectCommunicator getSimulatedSensorCommunicator() {
        if (this.simulatedSensorCommunicator == null) {
            throw new RuntimeException("Simulated sensor communicator has not been set.");
        }
        return this.simulatedSensorCommunicator;
    }

    public ZeroPoseMockRobotConfigurationDataPublisherModule setupZeroPoseRobotConfigurationPublisherModule() {
        this.checkIfModuleCanBeCreated(ZeroPoseMockRobotConfigurationDataPublisherModule.class);
        try {
            ZeroPoseMockRobotConfigurationDataPublisherModule module = new ZeroPoseMockRobotConfigurationDataPublisherModule(this.robotModel, this.pubSubImplementation);
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public WholeBodyTrajectoryToolboxModule setupWholeBodyTrajectoryToolboxModule(boolean enableYoVariableServer) {
        this.checkIfModuleCanBeCreated(WholeBodyTrajectoryToolboxModule.class);
        try {
            WholeBodyTrajectoryToolboxModule module = new WholeBodyTrajectoryToolboxModule(this.robotModel, enableYoVariableServer, this.pubSubImplementation);
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public KinematicsToolboxModule setupKinematicsToolboxModule(boolean enableYoVariableServer) {
        this.checkIfModuleCanBeCreated(KinematicsToolboxModule.class);
        try {
            KinematicsToolboxModule module = new KinematicsToolboxModule(this.robotModel, enableYoVariableServer, this.getOrCreateROS2Node());
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public KinematicsPlanningToolboxModule setupKinematicsPlanningToolboxModule(boolean enableYoVariableServer) {
        this.checkIfModuleCanBeCreated(KinematicsPlanningToolboxModule.class);
        try {
            KinematicsPlanningToolboxModule module = new KinematicsPlanningToolboxModule(this.robotModel, enableYoVariableServer, this.pubSubImplementation);
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public KinematicsStreamingToolboxModule setupKinematicsStreamingToolboxModule(Class<?> launcherClass, String[] programArgs, boolean enableYoVariableServer) {
        try {
            this.modulesToClose.add(new KinematicsStreamingToolboxMessageLogger(this.robotModel.getSimpleRobotName(), this.pubSubImplementation));
            if (launcherClass == null) {
                this.checkIfModuleCanBeCreated(KinematicsStreamingToolboxModule.class);
                KinematicsStreamingToolboxModule module = new KinematicsStreamingToolboxModule(this.robotModel, enableYoVariableServer, this.pubSubImplementation);
                this.modulesToClose.add(module);
                return module;
            }
            Process process = new JavaProcessSpawner(true, true).spawn(launcherClass, programArgs);
            this.modulesToClose.add(process::destroy);
            return null;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public FootstepPlanningModule setupFootstepPlanningToolboxModule() {
        this.checkIfModuleCanBeCreated(FootstepPlanningModule.class);
        try {
            FootstepPlanningModule module = FootstepPlanningModuleLauncher.createModule((ROS2NodeInterface)this.getOrCreateROS2Node(), this.robotModel);
            this.modulesToClose.add((CloseableAndDisposable)module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public IHMCMOCAPLocalizationModule setupMocapModule() {
        this.checkIfModuleCanBeCreated(IHMCMOCAPLocalizationModule.class);
        try {
            MocapPlanarRegionsListManager planarRegionsListManager = new MocapPlanarRegionsListManager();
            ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.getOrCreateROS2Node(), PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.outputTopic, s -> planarRegionsListManager.receivedPacket((PlanarRegionsListMessage)s.takeNextData()));
            return new IHMCMOCAPLocalizationModule(this.robotModel, planarRegionsListManager);
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public IHMCHumanoidBehaviorManager setupBehaviorModule(boolean enableYoVariableServer, boolean automaticDiagnostic, double diagnosticInitialDelay) {
        this.checkIfModuleCanBeCreated(IHMCHumanoidBehaviorManager.class);
        try {
            HumanoidRobotSensorInformation sensorInformation = this.robotModel.getSensorInformation();
            LogModelProvider logModelProvider = this.robotModel.getLogModelProvider();
            IHMCHumanoidBehaviorManager behaviorManager = automaticDiagnostic ? IHMCHumanoidBehaviorManager.createBehaviorModuleForAutomaticDiagnostic((String)this.robotModel.getSimpleRobotName(), (FootstepPlannerParametersBasics)this.robotModel.getFootstepPlannerParameters(), (WholeBodyControllerParameters)this.robotModel, (FullHumanoidRobotModelFactory)this.robotModel, (LogModelProvider)logModelProvider, (boolean)enableYoVariableServer, (HumanoidRobotSensorInformation)sensorInformation, (double)diagnosticInitialDelay) : new IHMCHumanoidBehaviorManager(this.robotModel.getSimpleRobotName(), this.robotModel.getFootstepPlannerParameters(), (WholeBodyControllerParameters)this.robotModel, (FullHumanoidRobotModelFactory)this.robotModel, logModelProvider, enableYoVariableServer, sensorInformation);
            this.modulesToClose.add((CloseableAndDisposable)behaviorManager);
            return behaviorManager;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public RosModule setupRosModule() {
        this.checkIfModuleCanBeCreated(RosModule.class);
        try {
            RosModule rosModule = new RosModule(this.robotModel, this.getOrCreateRosURI(), this.simulatedSensorCommunicator, this.getOrCreateROS2Node());
            this.modulesToClose.add(rosModule);
            return rosModule;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public DRCSensorSuiteManager setupSensorModule() {
        LogTools.info((String)"Setting up sensor module...");
        try {
            DRCSensorSuiteManager sensorSuiteManager = this.robotModel.getSensorSuiteManager((ROS2NodeInterface)this.getOrCreateROS2Node());
            if (sensorSuiteManager == null) {
                return null;
            }
            this.checkIfModuleCanBeCreated(sensorSuiteManager.getClass());
            if (this.robotModel.getTarget() == RobotTarget.SCS) {
                sensorSuiteManager.initializeSimulatedSensors(this.simulatedSensorCommunicator);
            } else {
                sensorSuiteManager.initializePhysicalSensors(this.getOrCreateRosURI());
            }
            this.modulesToClose.add(sensorSuiteManager);
            this.modulesToStart.add(sensorSuiteManager::connect);
            return sensorSuiteManager;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public HeightQuadTreeToolboxModule setupHeightQuadTreeToolboxModule() {
        this.checkIfModuleCanBeCreated(HeightQuadTreeToolboxModule.class);
        try {
            HeightQuadTreeToolboxModule module = new HeightQuadTreeToolboxModule(this.robotModel.getSimpleRobotName(), this.robotModel.createFullRobotModel(), this.robotModel.getLogModelProvider(), this.pubSubImplementation);
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public FiducialDetectorToolboxModule setupFiducialDetectorToolboxModule() {
        this.checkIfModuleCanBeCreated(FiducialDetectorToolboxModule.class);
        try {
            FiducialDetectorToolboxModule module = new FiducialDetectorToolboxModule(this.robotModel.getSimpleRobotName(), this.robotModel.getTarget(), this.robotModel.createFullRobotModel(), this.robotModel.getLogModelProvider(), this.pubSubImplementation);
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public ObjectDetectorToolboxModule setupObjectDetectorToolboxModule() {
        this.checkIfModuleCanBeCreated(ObjectDetectorToolboxModule.class);
        try {
            ObjectDetectorToolboxModule module = new ObjectDetectorToolboxModule(this.robotModel.getSimpleRobotName(), this.robotModel.createFullRobotModel(), this.robotModel.getLogModelProvider(), this.pubSubImplementation);
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public LIDARBasedREAModule setupRobotEnvironmentAwerenessModule(String reaConfigurationFilePath) {
        this.checkIfModuleCanBeCreated(LIDARBasedREAModule.class);
        try {
            REAPlanarRegionPublicNetworkProvider networkProvider = new REAPlanarRegionPublicNetworkProvider((ROS2NodeInterface)this.getOrCreateROS2Node(), REACommunicationProperties.outputTopic, REACommunicationProperties.lidarOutputTopic, REACommunicationProperties.stereoOutputTopic, REACommunicationProperties.depthOutputTopic);
            FilePropertyHelper filePropertyHelper = reaConfigurationFilePath != null ? new FilePropertyHelper(reaConfigurationFilePath) : new FilePropertyHelper(DEFAULT_REA_CONFIG_FILE_PATH);
            LIDARBasedREAModule module = LIDARBasedREAModule.createRemoteModule((FilePropertyHelper)filePropertyHelper, (REANetworkProvider)networkProvider);
            this.modulesToClose.add(() -> ((LIDARBasedREAModule)module).stop());
            this.modulesToStart.add(() -> ((LIDARBasedREAModule)module).start());
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public BipedalSupportPlanarRegionPublisher setupBipedalSupportPlanarRegionPublisherModule() {
        this.checkIfModuleCanBeCreated(BipedalSupportPlanarRegionPublisher.class);
        try {
            BipedalSupportPlanarRegionPublisher module = new BipedalSupportPlanarRegionPublisher(this.robotModel, this.getOrCreateROS2Node());
            this.modulesToClose.add(module);
            this.modulesToStart.add(module::start);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public WalkingControllerPreviewToolboxModule setupWalkingPreviewModule(boolean enableYoVariableServer) {
        this.checkIfModuleCanBeCreated(WalkingControllerPreviewToolboxModule.class);
        try {
            WalkingControllerPreviewToolboxModule module = new WalkingControllerPreviewToolboxModule(this.robotModel, enableYoVariableServer, this.getOrCreateROS2Node());
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public HumanoidAvatarREAStateUpdater setupHumanoidAvatarLidarREAStateUpdater() {
        this.checkIfModuleCanBeCreated(HumanoidAvatarREAStateUpdater.class);
        try {
            HumanoidAvatarREAStateUpdater module = new HumanoidAvatarREAStateUpdater(this.robotModel, this.getOrCreateROS2Node());
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public HumanoidAvatarStereoREAStateUpdater setupHumanoidAvatarRealSenseREAStateUpdater() {
        this.checkIfModuleCanBeCreated(HumanoidAvatarStereoREAStateUpdater.class);
        try {
            HumanoidAvatarStereoREAStateUpdater module = new HumanoidAvatarStereoREAStateUpdater(this.robotModel, this.pubSubImplementation, REACommunicationProperties.stereoInputTopic);
            this.modulesToClose.add(module);
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    public DirectionalControlModule setupDirectionalControlModule(boolean enableYoVariableServer) {
        this.checkIfModuleCanBeCreated(DirectionalControlModule.class);
        try {
            DirectionalControlModule module = new DirectionalControlModule(this.robotModel, enableYoVariableServer, this.getOrCreateROS2Node());
            return module;
        }
        catch (Throwable e) {
            HumanoidNetworkProcessor.reportFailure(e);
            return null;
        }
    }

    private static void reportFailure(Throwable e) {
        LogTools.error((String)"Failed to start a module in the network processor, stack trace:");
        e.printStackTrace();
    }

    private void checkIfModuleCanBeCreated(Class<?> moduleType) {
        if (this.hasModuleBeenSetup(moduleType)) {
            throw new IllegalStateException("Attempting to instantiate a second time the module: " + moduleType.getSimpleName());
        }
        if (this.hasStarted) {
            throw new IllegalStateException("Attempting to instantiate a module but the network processor has already started.");
        }
    }

    private boolean hasModuleBeenSetup(Class<?> moduleType) {
        return this.modulesToClose.stream().anyMatch(module -> module.getClass().equals(moduleType));
    }

    public void start() {
        if (this.hasStarted) {
            LogTools.warn((String)"Network is already running, ignoring request.");
            return;
        }
        if (this.realtimeROS2Node != null) {
            this.realtimeROS2Node.spin();
        }
        this.hasStarted = true;
        for (Runnable module : this.modulesToStart) {
            try {
                module.run();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void closeAndDispose() {
        if (!this.hasStarted) {
            LogTools.warn((String)"Network was not running, ignoring request.");
            return;
        }
        for (CloseableAndDisposable module : this.modulesToClose) {
            try {
                module.closeAndDispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.modulesToClose.clear();
        if (this.realtimeROS2Node != null) {
            this.realtimeROS2Node.destroy();
        }
    }
}

