/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.directionalControlToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import controller_msgs.msg.dds.PlanarRegionsListMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WalkingControllerFailureStatusMessage;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.directionalControlToolboxModule.DirectionalControlController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerAPIDefinition;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.directionalControlToolboxAPI.DirectionalControlConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.directionalControlToolboxAPI.DirectionalControlInputCommand;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;

public class DirectionalControlModule
extends ToolboxModule {
    private IHMCRealtimeROS2Publisher<PauseWalkingMessage> pauseWalkingPublisher;
    private IHMCRealtimeROS2Publisher<FootstepDataListMessage> footstepPublisher;
    private IHMCRealtimeROS2Publisher<FootstepDataListMessage> footstepVisualizationPublisher;
    private final DirectionalControlController steppingController;
    private static final int UPDATE_PERIOD_IN_MS = 10;

    public DirectionalControlModule(DRCRobotModel robotModel, boolean startYoVariableServer, RealtimeROS2Node ros2Node) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 10, ros2Node);
        this.steppingController = new DirectionalControlController(this.fullRobotModel, robotModel.getWalkingControllerParameters(), this.statusOutputManager, this.registry);
        this.setup(robotModel);
    }

    public DirectionalControlModule(DRCRobotModel robotModel, boolean startYoVariableServer, DomainFactory.PubSubImplementation pubSubImplementation) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 10, pubSubImplementation);
        this.steppingController = new DirectionalControlController(this.fullRobotModel, robotModel.getWalkingControllerParameters(), this.statusOutputManager, this.registry);
        this.setup(robotModel);
    }

    private void setup(DRCRobotModel robotModel) {
        this.steppingController.setPauseWalkingPublisher(arg_0 -> this.pauseWalkingPublisher.publish(arg_0));
        this.steppingController.setFootstepPublisher(arg_0 -> this.footstepPublisher.publish(arg_0));
        this.steppingController.setFootstepVisualizationPublisher(arg_0 -> this.footstepVisualizationPublisher.publish(arg_0));
        this.commandInputManager.registerHasReceivedInputListener(commandClass -> {
            DirectionalControlInputCommand inputCommand;
            DirectionalControlConfigurationCommand configCommand = (DirectionalControlConfigurationCommand)this.commandInputManager.pollNewestCommand(DirectionalControlConfigurationCommand.class);
            if (configCommand != null) {
                this.steppingController.updateConfiguration(configCommand);
            }
            if ((inputCommand = (DirectionalControlInputCommand)this.commandInputManager.pollNewestCommand(DirectionalControlInputCommand.class)) != null) {
                this.steppingController.updateInputs(inputCommand);
            }
        });
        this.startYoVariableServer();
    }

    @Override
    public void registerExtraPuSubs(RealtimeROS2Node realtimeROS2Node) {
        ROS2Topic controllerPubGenerator = ControllerAPIDefinition.getOutputTopic((String)this.robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, RobotConfigurationData.class, (ROS2Topic)controllerPubGenerator, s -> {
            if (this.steppingController != null) {
                this.steppingController.updateRobotConfigurationData((RobotConfigurationData)s.takeNextData());
            }
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, FootstepStatusMessage.class, (ROS2Topic)controllerPubGenerator, s -> {
            if (this.steppingController != null) {
                this.steppingController.updateFootstepStatusMessage((FootstepStatusMessage)s.takeNextData());
            }
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.outputTopic, s -> {
            if (this.steppingController != null) {
                this.steppingController.updatePlanarRegionsListMessage((PlanarRegionsListMessage)s.takeNextData());
            }
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, WalkingControllerFailureStatusMessage.class, (ROS2Topic)controllerPubGenerator, s -> {
            if (this.steppingController != null) {
                this.steppingController.updateWalkingControllerFailureStatusMessage((WalkingControllerFailureStatusMessage)s.takeNextData());
            }
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, CapturabilityBasedStatus.class, (ROS2Topic)controllerPubGenerator, s -> {
            if (this.steppingController != null) {
                this.steppingController.updateCapturabilityBasedStatus((CapturabilityBasedStatus)s.takeNextData());
            }
        });
        ROS2Topic controllerSubGenerator = ControllerAPIDefinition.getInputTopic((String)this.robotName);
        this.pauseWalkingPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)realtimeROS2Node, PauseWalkingMessage.class, (ROS2Topic)controllerSubGenerator);
        this.footstepPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)realtimeROS2Node, FootstepDataListMessage.class, (ROS2Topic)controllerSubGenerator);
        this.footstepVisualizationPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)realtimeROS2Node, FootstepDataListMessage.class, DirectionalControlModule.getOutputTopic(this.robotName));
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.steppingController;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return DirectionalControlModule.supportedCommands();
    }

    public static List<Class<? extends Command<?, ?>>> supportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(DirectionalControlConfigurationCommand.class);
        commands.add(DirectionalControlInputCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return DirectionalControlModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        return status;
    }

    @Override
    public void sleep() {
        LogTools.info((String)"Directional control toolbox told to sleep");
        super.sleep();
    }

    @Override
    public void wakeUp() {
        LogTools.info((String)"Directional control toolbox told to wake up");
        super.wakeUp();
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return DirectionalControlModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return ROS2Tools.DIRECTIONAL_CONTROL_TOOLBOX.withRobot(robotName).withOutput();
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return DirectionalControlModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return ROS2Tools.DIRECTIONAL_CONTROL_TOOLBOX.withRobot(robotName).withInput();
    }
}

