/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.externalForceEstimationToolboxModule;

import com.google.common.base.CaseFormat;
import controller_msgs.msg.dds.ExternalForceEstimationConfigurationMessage;
import controller_msgs.msg.dds.ExternalForceEstimationConfigurationMessagePubSubType;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.RobotConfigurationDataPubSubType;
import controller_msgs.msg.dds.RobotDesiredConfigurationData;
import controller_msgs.msg.dds.RobotDesiredConfigurationDataPubSubType;
import controller_msgs.msg.dds.ToolboxStateMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.avatar.networkProcessor.externalForceEstimationToolboxModule.ExternalForceEstimationToolboxModule;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.Packet;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;

public class ExternalForceEstimationMessageLogger {
    private static final DomainFactory.PubSubImplementation pubSubImplementation = DomainFactory.PubSubImplementation.FAST_RTPS;
    private static final long recordPeriodMillis = 10L;
    private static final double maximumRecordTimeSeconds = 120.0;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final String logDirectory = System.getProperty("user.home") + File.separator + ".ihmc" + File.separator + "logs" + File.separator;
    private final String robotName;
    static final String timestampName = "Timestamp";
    static final String robotConfigurationDataName = RobotConfigurationData.class.getSimpleName();
    static final String robotDesiredConfigurationDataName = RobotDesiredConfigurationData.class.getSimpleName();
    static final String externalForceEstimationConfigName = ExternalForceEstimationConfigurationMessage.class.getSimpleName();
    private final RealtimeROS2Node ros2Node;
    private final AtomicBoolean firstMessage = new AtomicBoolean();
    private final AtomicBoolean stopRequested = new AtomicBoolean();
    private final AtomicReference<RobotConfigurationData> robotConfigurationData = new AtomicReference();
    private final AtomicReference<RobotDesiredConfigurationData> robotDesiredConfigurationData = new AtomicReference();
    private final AtomicReference<ExternalForceEstimationConfigurationMessage> externalForceEstimationConfigurationMessage = new AtomicReference();
    private final JSONSerializer<RobotConfigurationData> robotConfigurationDataSerializer = new JSONSerializer((TopicDataType)new RobotConfigurationDataPubSubType());
    private final JSONSerializer<RobotDesiredConfigurationData> robotDesiredConfigurationDataSerializer = new JSONSerializer((TopicDataType)new RobotDesiredConfigurationDataPubSubType());
    private final JSONSerializer<ExternalForceEstimationConfigurationMessage> externalForceEstimationConfigurationSerializer = new JSONSerializer((TopicDataType)new ExternalForceEstimationConfigurationMessagePubSubType());
    private final ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
    private long startTimeMillis;
    private FileOutputStream outputStream = null;
    private PrintStream printStream = null;
    private Runnable loggerRunnable = null;
    private ScheduledFuture<?> loggerTaskScheduled = null;

    public ExternalForceEstimationMessageLogger(String robotName) {
        this.robotName = robotName;
        this.ros2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)pubSubImplementation, (String)("ihmc_" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, "ExternalForceEstimationMessageLogger")));
        ROS2Topic controllerOutputTopic = ROS2Tools.getControllerOutputTopic((String)robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> this.robotConfigurationData.set((RobotConfigurationData)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, RobotDesiredConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> this.robotDesiredConfigurationData.set((RobotDesiredConfigurationData)s.takeNextData()));
        ROS2Topic toolboxInputTopic = ExternalForceEstimationToolboxModule.getInputTopic(robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, ToolboxStateMessage.class, (ROS2Topic)toolboxInputTopic, s -> this.processToolboxStateMessage((ToolboxStateMessage)s.takeNextData()));
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.ros2Node, ExternalForceEstimationConfigurationMessage.class, (ROS2Topic)toolboxInputTopic, s -> this.externalForceEstimationConfigurationMessage.set((ExternalForceEstimationConfigurationMessage)s.takeNextData()));
        this.ros2Node.spin();
    }

    private void processToolboxStateMessage(ToolboxStateMessage message) {
        boolean sleepRequested;
        boolean loggingRequested = message.getRequestLogging();
        boolean bl = sleepRequested = message.getRequestedToolboxState() == 2;
        if (!sleepRequested && loggingRequested) {
            this.startLogging();
        } else {
            this.stopLogging();
        }
    }

    public void startLogging() {
        LogTools.info((String)"Starting logger...");
        if (this.loggerRunnable != null) {
            return;
        }
        String fileName = logDirectory + dateFormat.format(new Date()) + "_" + this.robotName + "ExternalForceEstimationToolbox.json";
        try {
            this.outputStream = new FileOutputStream(fileName);
            this.printStream = new PrintStream(this.outputStream);
            this.loggerRunnable = this::logMessageFrame;
            this.startTimeMillis = System.currentTimeMillis();
            this.firstMessage.set(true);
            this.stopRequested.set(false);
            this.printStream.println("[");
            this.loggerTaskScheduled = this.executorService.scheduleAtFixedRate(this.loggerRunnable, 0L, 10L, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            this.loggerRunnable = null;
            this.executorService.shutdownNow();
            e.printStackTrace();
        }
    }

    public void stopLogging() {
        if (this.loggerRunnable == null) {
            return;
        }
        this.stopRequested.set(true);
    }

    private void logMessageFrame() {
        if (this.stopRequested.get() || (double)(System.currentTimeMillis() - this.startTimeMillis) > Conversions.secondsToMilliseconds((double)120.0)) {
            this.closeLog();
        }
        if (!this.containsNewMessage()) {
            return;
        }
        if (!this.firstMessage.get()) {
            this.printStream.println("},");
        }
        this.printStream.println("{");
        this.printStream.print("\"Timestamp\" : " + System.nanoTime());
        try {
            ExternalForceEstimationMessageLogger.writeIfPresent(this.robotConfigurationData, robotConfigurationDataName, this.robotConfigurationDataSerializer, this.printStream);
            ExternalForceEstimationMessageLogger.writeIfPresent(this.robotDesiredConfigurationData, robotDesiredConfigurationDataName, this.robotDesiredConfigurationDataSerializer, this.printStream);
            ExternalForceEstimationMessageLogger.writeIfPresent(this.externalForceEstimationConfigurationMessage, externalForceEstimationConfigName, this.externalForceEstimationConfigurationSerializer, this.printStream);
        }
        catch (IOException e) {
            LogTools.error((String)"Error logging messages. Shutting down logging process");
            this.shutdown();
            return;
        }
        if (this.firstMessage.get()) {
            this.firstMessage.set(false);
        }
    }

    private boolean containsNewMessage() {
        return this.robotConfigurationData.get() != null || this.robotDesiredConfigurationData.get() != null || this.externalForceEstimationConfigurationMessage.get() != null;
    }

    private void closeLog() {
        LogTools.info((String)"Closing log...");
        this.printStream.println("}");
        this.printStream.println("]");
        this.printStream.flush();
        this.printStream.close();
        this.shutdown();
    }

    private void shutdown() {
        this.loggerTaskScheduled.cancel(true);
        this.loggerTaskScheduled = null;
        this.loggerRunnable = null;
        this.printStream = null;
        this.outputStream = null;
    }

    private static <T extends Packet> void writeIfPresent(AtomicReference<T> messageReference, String messageName, JSONSerializer<T> serializer, PrintStream printStream) throws IOException {
        Packet message = messageReference.getAndSet(null);
        if (message == null) {
            return;
        }
        printStream.println(",");
        printStream.println("\"" + messageName + "\" : ");
        printStream.write(serializer.serializeToBytes((Object)message));
    }

    public static void main(String[] args) {
        String robotName = "Valkyrie";
        new ExternalForceEstimationMessageLogger(robotName);
    }
}

