/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.fiducialDetectorToolBox;

import boofcv.abst.fiducial.SquareBinary_to_FiducialDetector;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.factory.fiducial.ConfigFiducialBinary;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import controller_msgs.msg.dds.DetectedFiducialPacket;
import controller_msgs.msg.dds.IntrinsicParametersMessage;
import controller_msgs.msg.dds.VideoPacket;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.producers.JPEGDecompressor;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;
import us.ihmc.tools.Timer;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FiducialDetectorToolboxController
extends ToolboxController {
    private static final RescaleOp imageRescalingForSim = new RescaleOp(3.5f, 35.0f, null);
    private static final RescaleOp imageRescalingForRealRobot = new RescaleOp(1.5f, 35.0f, null);
    private static RescaleOp imageRescalingOperation;
    private final AtomicReference<VideoPacket> videoPacket = new AtomicReference();
    private final Timer statusTimer = new Timer();
    private static final boolean DEBUG = false;
    private JFrame frame;
    private ImageIcon image;
    private final Se3_F64 fiducialToCamera = new Se3_F64();
    private final Polygon2D_F64 bounds = new Polygon2D_F64();
    private final RotationMatrix fiducialRotationMatrix = new RotationMatrix();
    private final Vector3D cameraRigidPosition = new Vector3D();
    private final RigidBodyTransform cameraRigidTransform = new RigidBodyTransform();
    private final ReferenceFrame cameraReferenceFrame;
    private final ReferenceFrame detectorReferenceFrame;
    private final SquareBinary_to_FiducialDetector<GrayF32> detector;
    private final JPEGDecompressor jpegDecompressor = new JPEGDecompressor();
    private final String prefix = "fiducial";
    private static final double expectedFiducialSize = 0.2032;
    private final FramePose3D cameraPose = new FramePose3D(ReferenceFrame.getWorldFrame());
    private final FramePose3D reportedFiducialPoseInWorldFrame = new FramePose3D(ReferenceFrame.getWorldFrame());
    private final AtomicReference<Boolean> inProcessingThread = new AtomicReference();

    public FiducialDetectorToolboxController(RobotTarget target, StatusMessageOutputManager statusOutputManager, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        imageRescalingOperation = target == RobotTarget.REAL_ROBOT ? imageRescalingForRealRobot : imageRescalingForSim;
        this.inProcessingThread.set(false);
        this.detector = FactoryFiducial.squareBinary((ConfigFiducialBinary)new ConfigFiducialBinary(0.2032), (ConfigThreshold)ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_GAUSSIAN, (int)10), GrayF32.class);
        this.cameraReferenceFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((String)"fiducialCameraReferenceFrame", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.cameraRigidTransform);
        this.detectorReferenceFrame = new ReferenceFrame("fiducialDetectorReferenceFrame", this.cameraReferenceFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set(0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0);
            }
        };
    }

    @Override
    public boolean initialize() {
        LogTools.info((String)"Initializing");
        return true;
    }

    public void receivedPacket(VideoPacket packet) {
        if (packet != null) {
            this.videoPacket.set(packet);
        }
    }

    @Override
    public void updateInternal() {
        VideoPacket latest;
        if (!this.inProcessingThread.get().booleanValue() && (latest = (VideoPacket)this.videoPacket.getAndSet(null)) != null) {
            Thread packetProcessor = new Thread(() -> {
                this.inProcessingThread.set(true);
                this.detectFromVideoPacket(latest);
                this.inProcessingThread.set(false);
            }, "FiducialDetectorToolboxController image processing");
            packetProcessor.start();
        }
    }

    private void detectFromVideoPacket(VideoPacket videoPacket) {
        BufferedImage bufferedImage = this.jpegDecompressor.decompressJPEGDataToBufferedImage(videoPacket.getData().toArray());
        this.detect(bufferedImage, (Point3DReadOnly)videoPacket.getPosition(), (QuaternionReadOnly)videoPacket.getOrientation(), (CameraPinhole)HumanoidMessageTools.toIntrinsicParameters((IntrinsicParametersMessage)videoPacket.getIntrinsicParameters()));
    }

    private void detect(BufferedImage bufferedImage, Point3DReadOnly cameraPositionInWorld, QuaternionReadOnly cameraOrientationInWorldXForward, CameraPinhole intrinsicParameters) {
        this.detector.setLensDistortion((LensDistortionNarrowFOV)new LensDistortionPinhole(intrinsicParameters), intrinsicParameters.getWidth(), intrinsicParameters.getHeight());
        imageRescalingOperation.filter(bufferedImage, bufferedImage);
        this.cameraRigidTransform.getRotation().set((Orientation3DReadOnly)cameraOrientationInWorldXForward);
        this.cameraRigidPosition.set((Tuple3DReadOnly)cameraPositionInWorld);
        this.cameraRigidTransform.getTranslation().set((Tuple3DReadOnly)this.cameraRigidPosition);
        this.cameraReferenceFrame.update();
        this.detectorReferenceFrame.update();
        this.cameraPose.getOrientation().set(cameraOrientationInWorldXForward);
        this.cameraPose.getPosition().set((Tuple3DReadOnly)cameraPositionInWorld);
        GrayF32 grayImage = (GrayF32)ConvertBufferedImage.convertFrom((BufferedImage)bufferedImage, (boolean)true, (ImageType)ImageType.single(GrayF32.class));
        this.detector.detect((ImageGray)grayImage);
        for (int i = 0; i < this.detector.totalFound(); ++i) {
            this.detector.getFiducialToCamera(i, this.fiducialToCamera);
            this.fiducialRotationMatrix.set(this.fiducialToCamera.getR().data);
            this.reportedFiducialPoseInWorldFrame.setReferenceFrame(this.detectorReferenceFrame);
            this.reportedFiducialPoseInWorldFrame.getOrientation().set((Orientation3DReadOnly)this.fiducialRotationMatrix);
            this.reportedFiducialPoseInWorldFrame.getPosition().set(this.fiducialToCamera.getX(), this.fiducialToCamera.getY(), this.fiducialToCamera.getZ());
            this.reportedFiducialPoseInWorldFrame.changeFrame(ReferenceFrame.getWorldFrame());
            this.detector.getBounds(i, this.bounds);
            DetectedFiducialPacket packet = new DetectedFiducialPacket();
            packet.fiducial_id_ = this.detector.getId(i);
            for (int j = 0; j < this.bounds.size(); ++j) {
                ((Point3D)packet.getBounds().add()).set(this.bounds.get(j).getX(), this.bounds.get(j).getY(), 0.0);
            }
            Pose3D pose = new Pose3D((Tuple3DReadOnly)this.reportedFiducialPoseInWorldFrame.getPosition(), (Orientation3DReadOnly)this.reportedFiducialPoseInWorldFrame.getOrientation());
            if (!this.statusTimer.isRunning(5.0)) {
                LogTools.info((String)"Found fiducial: id: {} pose: {}", (Object)packet.getFiducialId(), (Object)pose);
                this.statusTimer.reset();
            }
            packet.fiducial_transform_to_world_ = pose;
            this.reportMessage(packet);
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

