/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.footstepPlanningModule;

import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.trajectories.SwingOverPlanarRegionsTrajectoryExpander;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.footstepPlanning.FootstepPlan;
import us.ihmc.footstepPlanning.PlannedFootstep;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FootstepDataListWithSwingOverTrajectoriesAssembler {
    private final SwingOverPlanarRegionsTrajectoryExpander swingOverPlanarRegionsTrajectoryExpander;
    private final HumanoidReferenceFrames humanoidReferenceFrames;
    private final FramePose3D stanceFootPose;
    private final FramePose3D swingStartPose;
    private final FramePose3D swingEndPose;
    private final ConvexPolygon2D partialFootholdPolygon;
    private static final double maxSwingSpeed = 1.0;

    public FootstepDataListWithSwingOverTrajectoriesAssembler(HumanoidReferenceFrames humanoidReferenceFrames, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        this.humanoidReferenceFrames = humanoidReferenceFrames;
        this.swingOverPlanarRegionsTrajectoryExpander = new SwingOverPlanarRegionsTrajectoryExpander(walkingControllerParameters, parentRegistry, graphicsListRegistry);
        this.stanceFootPose = new FramePose3D();
        this.swingStartPose = new FramePose3D();
        this.swingEndPose = new FramePose3D();
        this.partialFootholdPolygon = new ConvexPolygon2D();
    }

    public SwingOverPlanarRegionsTrajectoryExpander.SwingOverPlanarRegionsStatus getStatus() {
        return this.swingOverPlanarRegionsTrajectoryExpander.getStatus();
    }

    public FootstepDataListMessage assemble(FootstepPlan footstepPlan, double swingTime, double transferTime, ExecutionMode executionMode, PlanarRegionsList planarRegionsList) {
        FootstepDataListMessage footstepDataListMessage = new FootstepDataListMessage();
        footstepDataListMessage.setDefaultSwingDuration(swingTime);
        footstepDataListMessage.setDefaultTransferDuration(transferTime);
        for (int i = 0; i < footstepPlan.getNumberOfSteps(); ++i) {
            double maxSpeed;
            if (i == 0) {
                this.swingStartPose.setToZero((ReferenceFrame)this.humanoidReferenceFrames.getSoleFrame(footstepPlan.getFootstep(0).getRobotSide()));
                this.stanceFootPose.setToZero((ReferenceFrame)this.humanoidReferenceFrames.getSoleFrame(footstepPlan.getFootstep(0).getRobotSide().getOppositeSide()));
            }
            PlannedFootstep footstep = footstepPlan.getFootstep(i);
            footstep.getFootstepPose(this.swingEndPose);
            FootstepDataMessage footstepDataMessage = HumanoidMessageTools.createFootstepDataMessage((RobotSide)footstep.getRobotSide(), (Point3DReadOnly)new Point3D((Tuple3DReadOnly)this.swingEndPose.getPosition()), (Orientation3DReadOnly)new Quaternion((QuaternionReadOnly)this.swingEndPose.getOrientation()));
            double maxSpeedDimensionless = this.swingOverPlanarRegionsTrajectoryExpander.expandTrajectoryOverPlanarRegions((FramePose3DReadOnly)this.stanceFootPose, (FramePose3DReadOnly)this.swingStartPose, (FramePose3DReadOnly)this.swingEndPose, planarRegionsList);
            footstepDataMessage.setTrajectoryType(TrajectoryType.CUSTOM.toByte());
            Point3D[] waypoints = new Point3D[]{new Point3D(), new Point3D()};
            waypoints[0].set((Tuple3DReadOnly)this.swingOverPlanarRegionsTrajectoryExpander.getExpandedWaypoints().get(0));
            waypoints[1].set((Tuple3DReadOnly)this.swingOverPlanarRegionsTrajectoryExpander.getExpandedWaypoints().get(1));
            MessageTools.copyData((Settable[])waypoints, (RecyclingArrayList)footstepDataMessage.getCustomPositionWaypoints());
            if (footstep.hasFoothold()) {
                this.partialFootholdPolygon.set(footstep.getFoothold());
                if (this.partialFootholdPolygon.getNumberOfVertices() != 4) {
                    ConvexPolygonTools.limitVerticesConservative((ConvexPolygon2DBasics)this.partialFootholdPolygon, (int)4);
                }
                ArrayList<Point2D> fourPartialFootholdCorners = new ArrayList<Point2D>();
                for (int j = 0; j < 4; ++j) {
                    fourPartialFootholdCorners.add(new Point2D((Tuple2DReadOnly)this.partialFootholdPolygon.getVertex(j)));
                }
                HumanoidMessageTools.packPredictedContactPoints(fourPartialFootholdCorners, (FootstepDataMessage)footstepDataMessage);
            }
            if ((maxSpeed = maxSpeedDimensionless / swingTime) > 1.0) {
                double adjustedSwingTime = maxSpeedDimensionless / 1.0;
                footstepDataMessage.setSwingDuration(adjustedSwingTime);
                footstepDataMessage.setTransferDuration(transferTime);
            }
            ((FootstepDataMessage)footstepDataListMessage.getFootstepDataList().add()).set(footstepDataMessage);
            this.swingStartPose.setIncludingFrame((FramePose3DReadOnly)this.stanceFootPose);
            this.stanceFootPose.setIncludingFrame((FramePose3DReadOnly)this.swingEndPose);
        }
        footstepDataListMessage.getQueueingProperties().setExecutionMode(executionMode.toByte());
        footstepDataListMessage.getQueueingProperties().setPreviousMessageId(-1L);
        return footstepDataListMessage;
    }

    public FootstepDataListMessage assemble(List<Footstep> footstepList, double swingTime, double transferTime, ExecutionMode executionMode, PlanarRegionsList planarRegionsList) {
        FootstepDataListMessage footstepDataListMessage = new FootstepDataListMessage();
        footstepDataListMessage.setDefaultSwingDuration(swingTime);
        footstepDataListMessage.setDefaultTransferDuration(transferTime);
        for (int i = 0; i < footstepList.size(); ++i) {
            if (i == 0) {
                this.swingStartPose.setToZero((ReferenceFrame)this.humanoidReferenceFrames.getSoleFrame(footstepList.get(0).getRobotSide()));
                this.stanceFootPose.setToZero((ReferenceFrame)this.humanoidReferenceFrames.getSoleFrame(footstepList.get(0).getRobotSide().getOppositeSide()));
            }
            Footstep footstep = footstepList.get(i);
            footstep.getPose(this.swingEndPose);
            FootstepDataMessage footstepDataMessage = HumanoidMessageTools.createFootstepDataMessage((RobotSide)footstep.getRobotSide(), (Point3DReadOnly)new Point3D((Tuple3DReadOnly)this.swingEndPose.getPosition()), (Orientation3DReadOnly)new Quaternion((QuaternionReadOnly)this.swingEndPose.getOrientation()));
            this.swingOverPlanarRegionsTrajectoryExpander.expandTrajectoryOverPlanarRegions((FramePose3DReadOnly)this.stanceFootPose, (FramePose3DReadOnly)this.swingStartPose, (FramePose3DReadOnly)this.swingEndPose, planarRegionsList);
            footstepDataMessage.setTrajectoryType(TrajectoryType.CUSTOM.toByte());
            Point3D[] waypoints = new Point3D[]{new Point3D(), new Point3D()};
            waypoints[0].set((Tuple3DReadOnly)this.swingOverPlanarRegionsTrajectoryExpander.getExpandedWaypoints().get(0));
            waypoints[1].set((Tuple3DReadOnly)this.swingOverPlanarRegionsTrajectoryExpander.getExpandedWaypoints().get(1));
            MessageTools.copyData((Settable[])waypoints, (RecyclingArrayList)footstepDataMessage.getCustomPositionWaypoints());
            if (footstep.hasPredictedContactPoints()) {
                this.partialFootholdPolygon.clear();
                this.partialFootholdPolygon.addVertices(Vertex2DSupplier.asVertex2DSupplier((List)footstep.getPredictedContactPoints()));
                this.partialFootholdPolygon.update();
                if (this.partialFootholdPolygon.getNumberOfVertices() != 4) {
                    ConvexPolygonTools.limitVerticesConservative((ConvexPolygon2DBasics)this.partialFootholdPolygon, (int)4);
                }
                ArrayList<Point2D> fourPartialFootholdCorners = new ArrayList<Point2D>();
                for (int j = 0; j < 4; ++j) {
                    fourPartialFootholdCorners.add(new Point2D((Tuple2DReadOnly)this.partialFootholdPolygon.getVertex(j)));
                }
                HumanoidMessageTools.packPredictedContactPoints(fourPartialFootholdCorners, (FootstepDataMessage)footstepDataMessage);
            }
            ((FootstepDataMessage)footstepDataListMessage.getFootstepDataList().add()).set(footstepDataMessage);
            this.swingStartPose.setIncludingFrame((FramePose3DReadOnly)this.stanceFootPose);
            this.stanceFootPose.setIncludingFrame((FramePose3DReadOnly)this.swingEndPose);
        }
        footstepDataListMessage.getQueueingProperties().setExecutionMode(executionMode.toByte());
        footstepDataListMessage.getQueueingProperties().setPreviousMessageId(-1L);
        return footstepDataListMessage;
    }
}

