/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule;

import controller_msgs.msg.dds.KinematicsPlanningToolboxOutputStatus;
import controller_msgs.msg.dds.KinematicsToolboxOutputStatus;
import gnu.trove.TDoubleCollection;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.humanoidRobotics.communication.packets.KinematicsToolboxOutputConverter;
import us.ihmc.idl.IDLSequence;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.math.trajectories.core.Polynomial;
import us.ihmc.robotics.math.trajectories.generators.TrajectoryPointOptimizer;

public class WholeBodyTrajectoryPointCalculator {
    private final List<KinematicsToolboxOutputStatus> keyFrames = new ArrayList<KinematicsToolboxOutputStatus>();
    private final TDoubleArrayList keyFrameTimes = new TDoubleArrayList();
    private TDoubleArrayList normalizedWaypointTimes = new TDoubleArrayList();
    private final TrajectoryPointOptimizer trajectoryPointOptimizer;
    private static final int numberOfIterationsToOptimizeWaypointTimes = 100;
    private static final double initialJointVelocity = 0.0;
    private static final double finalJointVelocity = 0.0;
    private final List<String> jointNames = new ArrayList<String>();
    private final Map<String, OneDoFJointTrajectoryHolder> jointNameToTrajectoryHolderMap = new HashMap<String, OneDoFJointTrajectoryHolder>();
    private final KinematicsToolboxOutputConverter converter;
    private final boolean SAVE_TRAJECTORY_DATA = false;

    public WholeBodyTrajectoryPointCalculator(DRCRobotModel drcRobotModel) {
        OneDoFJointBasics[] allJointsExcludingHands = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)drcRobotModel.createFullRobotModel());
        int numberOfWholeBodyJoints = allJointsExcludingHands.length;
        this.trajectoryPointOptimizer = new TrajectoryPointOptimizer(numberOfWholeBodyJoints);
        this.converter = new KinematicsToolboxOutputConverter((FullHumanoidRobotModelFactory)drcRobotModel);
        for (int i = 0; i < numberOfWholeBodyJoints; ++i) {
            this.jointNames.add(allJointsExcludingHands[i].getName());
        }
        for (String jointName : this.jointNames) {
            this.jointNameToTrajectoryHolderMap.put(jointName, new OneDoFJointTrajectoryHolder());
        }
    }

    public void clear() {
        this.keyFrames.clear();
        this.keyFrameTimes.clear();
        for (String jointName : this.jointNames) {
            this.jointNameToTrajectoryHolderMap.get(jointName).clear();
        }
    }

    public void addKeyFrames(List<KinematicsToolboxOutputStatus> solutionKeyFrames, TDoubleArrayList solutionKeyFrameTimes) {
        this.keyFrames.addAll(solutionKeyFrames);
        this.keyFrameTimes.addAll((TDoubleCollection)solutionKeyFrameTimes);
    }

    public void initializeCalculator() {
        for (KinematicsToolboxOutputStatus keyFrame : this.keyFrames) {
            this.converter.updateFullRobotModel(keyFrame);
            for (String jointName : this.jointNames) {
                double jointPosition = this.converter.getFullRobotModel().getOneDoFJointByName(jointName).getQ();
                this.jointNameToTrajectoryHolderMap.get(jointName).appendTrajectoryPoint(jointPosition);
            }
        }
        TDoubleArrayList firstWayPoints = new TDoubleArrayList();
        TDoubleArrayList lastWayPoints = new TDoubleArrayList();
        TDoubleArrayList firstWayPointVelocities = new TDoubleArrayList();
        TDoubleArrayList lastWayPointVelocities = new TDoubleArrayList();
        for (String jointName : this.jointNames) {
            firstWayPoints.add(this.jointNameToTrajectoryHolderMap.get(jointName).getFirstPoint());
            lastWayPoints.add(this.jointNameToTrajectoryHolderMap.get(jointName).getLastPoint());
            firstWayPointVelocities.add(0.0);
            lastWayPointVelocities.add(0.0);
        }
        int numberOfWayPoints = this.keyFrames.size() - 2;
        ArrayList<TDoubleArrayList> wayPointSets = new ArrayList<TDoubleArrayList>();
        for (int i = 0; i < numberOfWayPoints; ++i) {
            TDoubleArrayList wayPointsForAKeyFrameTime = new TDoubleArrayList();
            for (String jointName : this.jointNames) {
                double wayPoint = this.jointNameToTrajectoryHolderMap.get(jointName).getWayPoint(i);
                wayPointsForAKeyFrameTime.add(wayPoint);
            }
            wayPointSets.add(wayPointsForAKeyFrameTime);
        }
        this.trajectoryPointOptimizer.setEndPoints(firstWayPoints, firstWayPointVelocities, lastWayPoints, lastWayPointVelocities);
        this.trajectoryPointOptimizer.setWaypoints(wayPointSets);
        double lastKeyFrameTime = this.keyFrameTimes.get(this.keyFrameTimes.size() - 1);
        this.normalizedWaypointTimes.clear();
        for (int i = 1; i < this.keyFrameTimes.size() - 1; ++i) {
            this.normalizedWaypointTimes.add(this.keyFrameTimes.get(i) / lastKeyFrameTime);
        }
    }

    public void computeOptimizingKeyFrameTimes() {
        this.trajectoryPointOptimizer.compute(100, this.normalizedWaypointTimes);
        this.updateOptimizedWaypointTimes();
        this.updateOptimizedJointVelocities();
    }

    public void computeForFixedKeyFrameTimes() {
        this.trajectoryPointOptimizer.computeForFixedTime(this.normalizedWaypointTimes);
        this.updateOptimizedJointVelocities();
    }

    private void updateOptimizedJointVelocities() {
        for (String jointName : this.jointNames) {
            this.jointNameToTrajectoryHolderMap.get(jointName).addJointVelocity(0.0);
        }
        double lastKeyFrameTime = this.keyFrameTimes.get(this.keyFrameTimes.size() - 1);
        int numberOfWayPoints = this.keyFrames.size() - 2;
        TDoubleArrayList velocityToPack = new TDoubleArrayList();
        for (int i = 0; i < numberOfWayPoints; ++i) {
            this.trajectoryPointOptimizer.getWaypointVelocity(velocityToPack, i);
            for (int j = 0; j < this.jointNames.size(); ++j) {
                this.jointNameToTrajectoryHolderMap.get(this.jointNames.get(j)).addJointVelocity(velocityToPack.get(j) / lastKeyFrameTime);
            }
        }
        for (String jointName : this.jointNames) {
            this.jointNameToTrajectoryHolderMap.get(jointName).addJointVelocity(0.0);
        }
    }

    private void updateOptimizedWaypointTimes() {
        double lastKeyFrameTime = this.keyFrameTimes.get(this.keyFrameTimes.size() - 1);
        TDoubleArrayList normalizedKeyFrameTimes = new TDoubleArrayList();
        this.trajectoryPointOptimizer.getWaypointTimes(normalizedKeyFrameTimes);
        this.keyFrameTimes.clear();
        this.keyFrameTimes.add(0.0);
        for (int i = 0; i < normalizedKeyFrameTimes.size(); ++i) {
            this.keyFrameTimes.add(normalizedKeyFrameTimes.get(i) * lastKeyFrameTime);
        }
        this.keyFrameTimes.add(lastKeyFrameTime);
    }

    public void computeVelocityBounds(double searchingTimeTick) {
        for (String jointName : this.jointNames) {
            this.jointNameToTrajectoryHolderMap.get(jointName).computeVelocityBounds(searchingTimeTick);
        }
    }

    public double getJointVelocityUpperBound(String jointName) {
        return this.jointNameToTrajectoryHolderMap.get(jointName).getUpperBound();
    }

    public double getJointVelocityLowerBound(String jointName) {
        return this.jointNameToTrajectoryHolderMap.get(jointName).getLowerBound();
    }

    public void packOptimizedVelocities(KinematicsPlanningToolboxOutputStatus solution) {
        int i;
        IDLSequence.Object robotConfigurations = solution.getRobotConfigurations();
        for (i = 0; i < robotConfigurations.size(); ++i) {
            KinematicsToolboxOutputStatus keyFrameSolution = (KinematicsToolboxOutputStatus)robotConfigurations.get(i);
            keyFrameSolution.getDesiredJointVelocities().resetQuick();
            for (String jointName : this.jointNames) {
                float wayPointVelocity = (float)this.jointNameToTrajectoryHolderMap.get(jointName).getWaypointVelocity(i);
                keyFrameSolution.getDesiredJointVelocities().add(wayPointVelocity);
            }
        }
        solution.getKeyFrameTimes().clear();
        for (i = 0; i < robotConfigurations.size(); ++i) {
            solution.getKeyFrameTimes().add(this.keyFrameTimes.get(i));
        }
    }

    private int findTrajectoryIndex(double time) {
        int indexOfTrajectory = 0;
        for (int j = this.keyFrameTimes.size() - 1; j > 0; --j) {
            if (!(this.keyFrameTimes.get(j) < time)) continue;
            indexOfTrajectory = j;
            break;
        }
        return indexOfTrajectory;
    }

    private void saveJointPositionAndVelocity(double searchingTimeTick) {
        int numberOfTicks = (int)(this.keyFrameTimes.get(this.keyFrameTimes.size() - 1) / searchingTimeTick);
        try {
            FileWriter positionFW = new FileWriter(new File(this.getClass().getSimpleName() + "_position.csv"));
            FileWriter velocityFW = new FileWriter(new File(this.getClass().getSimpleName() + "_velocity.csv"));
            positionFW.write(String.format("time", new Object[0]));
            velocityFW.write(String.format("time", new Object[0]));
            for (String jointName : this.jointNames) {
                positionFW.write(String.format("\t%s", jointName));
                velocityFW.write(String.format("\t%s", jointName));
            }
            positionFW.write(System.lineSeparator());
            velocityFW.write(System.lineSeparator());
            double time = 0.0;
            for (int i = 0; i < numberOfTicks; ++i) {
                int indexOfTrajectory = this.findTrajectoryIndex(time);
                positionFW.write(String.format("%.4f (%d)", time, indexOfTrajectory));
                velocityFW.write(String.format("%.4f (%d)", time, indexOfTrajectory));
                for (String jointName : this.jointNames) {
                    Polynomial trajectory = this.jointNameToTrajectoryHolderMap.get(jointName).getTrajectory(indexOfTrajectory);
                    trajectory.compute(time);
                    positionFW.write(String.format("\t%.4f", trajectory.getValue()));
                    velocityFW.write(String.format("\t%.4f", trajectory.getVelocity()));
                }
                positionFW.write(System.lineSeparator());
                velocityFW.write(System.lineSeparator());
                time += searchingTimeTick;
            }
            positionFW.close();
            velocityFW.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private class OneDoFJointTrajectoryHolder {
        private final TDoubleArrayList positions = new TDoubleArrayList();
        private final TDoubleArrayList velocities = new TDoubleArrayList();
        private final List<Polynomial> trajectories = new ArrayList<Polynomial>();
        private double velocityUpperBounds;
        private double velocityLowerBounds;

        private OneDoFJointTrajectoryHolder() {
        }

        public void clear() {
            this.positions.clear();
            this.velocities.clear();
        }

        public void addJointVelocity(double jointVelocity) {
            this.velocities.add(jointVelocity);
        }

        public void appendTrajectoryPoint(double jointPosition) {
            this.positions.add(jointPosition);
        }

        private void computeTrajectory() {
            this.trajectories.clear();
            for (int i = 0; i < this.positions.size() - 1; ++i) {
                Polynomial cubic = new Polynomial(4);
                cubic.setCubic(WholeBodyTrajectoryPointCalculator.this.keyFrameTimes.get(i), WholeBodyTrajectoryPointCalculator.this.keyFrameTimes.get(i + 1), this.positions.get(i), this.velocities.get(i), this.positions.get(i + 1), this.velocities.get(i + 1));
                this.trajectories.add(cubic);
            }
        }

        public void computeVelocityBounds(double searchingTimeTick) {
            this.computeTrajectory();
            int numberOfTicks = (int)(WholeBodyTrajectoryPointCalculator.this.keyFrameTimes.get(WholeBodyTrajectoryPointCalculator.this.keyFrameTimes.size() - 1) / searchingTimeTick);
            double time = 0.0;
            TDoubleArrayList velocities = new TDoubleArrayList();
            for (int i = 0; i < numberOfTicks; ++i) {
                int indexOfTrajectory = WholeBodyTrajectoryPointCalculator.this.findTrajectoryIndex(time);
                Polynomial trajectory = this.trajectories.get(indexOfTrajectory);
                trajectory.compute(time);
                velocities.add(trajectory.getVelocity());
                time += searchingTimeTick;
            }
            this.velocityLowerBounds = velocities.min();
            this.velocityUpperBounds = velocities.max();
        }

        public double getFirstPoint() {
            return this.positions.get(0);
        }

        public double getLastPoint() {
            return this.positions.get(this.positions.size() - 1);
        }

        public double getWayPoint(int i) {
            return this.positions.get(i + 1);
        }

        public double getWaypointVelocity(int i) {
            return this.velocities.get(i);
        }

        public Polynomial getTrajectory(int i) {
            return this.trajectories.get(i);
        }

        public double getUpperBound() {
            return this.velocityUpperBounds;
        }

        public double getLowerBound() {
            return this.velocityLowerBounds;
        }
    }
}

