/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.KinematicsToolboxOutputStatus;
import controller_msgs.msg.dds.MultiContactBalanceStatus;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointLimitReductionCommand;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.HumanoidKinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.idl.IDLSequence;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class HumanoidKinematicsToolboxController
extends KinematicsToolboxController {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final FullHumanoidRobotModel desiredFullRobotModel;
    private final CommonHumanoidReferenceFrames desiredReferenceFrames;
    private final FullHumanoidRobotModel currentFullRobotModel;
    private final CommonHumanoidReferenceFrames currentReferenceFrames;
    private final OneDoFJointBasics[] currentOneDoFJoints;
    private final TIntObjectHashMap<RigidBodyBasics> rigidBodyHashCodeMap = new TIntObjectHashMap();
    private final Map<RigidBodyBasics, RigidBodyBasics> endEffectorToPrimaryBaseMap = new HashMap<RigidBodyBasics, RigidBodyBasics>();
    private final YoBoolean enableAutoSupportPolygon = new YoBoolean("enableAutoSupportPolygon", this.registry);
    private final SideDependentList<YoBoolean> isFootInSupport = new SideDependentList();
    private final SideDependentList<YoFramePose3D> initialFootPoses = new SideDependentList();
    private final RecyclingArrayList<ContactingRigidBody> contactingRigidBodies = new RecyclingArrayList(ContactingRigidBody::new);
    private final YoFramePoint3D initialCenterOfMassPosition = new YoFramePoint3D("initialCenterOfMass", worldFrame, this.registry);
    private final YoBoolean holdSupportRigidBodies = new YoBoolean("holdSupportRigidBodies", this.registry);
    private final YoBoolean holdCenterOfMassXYPosition = new YoBoolean("holdCenterOfMassXYPosition", this.registry);
    private final FramePoint3D centerOfMassPositionToHold = new FramePoint3D();
    private final YoDouble supportRigidBodyWeight = new YoDouble("supportRigidBodyWeight", this.registry);
    private final YoDouble momentumWeight = new YoDouble("momentumWeight", this.registry);
    private final EnumMap<LegJointName, YoDouble> legJointLimitReductionFactors = new EnumMap(LegJointName.class);
    private final ConcurrentCopier<CapturabilityBasedStatus> concurrentCapturabilityBasedStatusCopier = new ConcurrentCopier(CapturabilityBasedStatus::new);
    private boolean hasCapturabilityBasedStatus = false;
    private final CapturabilityBasedStatus capturabilityBasedStatusInternal = new CapturabilityBasedStatus();
    private final ConcurrentCopier<MultiContactBalanceStatus> concurrentMultiContactBalanceStatusCopier = new ConcurrentCopier(MultiContactBalanceStatus::new);
    private boolean hasMultiContactBalanceStatus = false;
    private final MultiContactBalanceStatus multiContactBalanceStatusInternal = new MultiContactBalanceStatus();
    private final RecyclingArrayList<FramePoint3D> activeContactPointPositions = new RecyclingArrayList(FramePoint3D::new);

    public HumanoidKinematicsToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FullHumanoidRobotModel desiredFullRobotModel, FullHumanoidRobotModelFactory fullRobotModelFactory, double updateDT, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this(commandInputManager, statusOutputManager, desiredFullRobotModel, HumanoidKinematicsToolboxController.createListOfControllableRigidBodies(desiredFullRobotModel), fullRobotModelFactory, updateDT, yoGraphicsListRegistry, parentRegistry);
    }

    public HumanoidKinematicsToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FullHumanoidRobotModel desiredFullRobotModel, Collection<? extends RigidBodyBasics> controllableRigidBodyies, FullHumanoidRobotModelFactory fullRobotModelFactory, double updateDT, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(commandInputManager, statusOutputManager, desiredFullRobotModel.getRootJoint(), FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)desiredFullRobotModel), controllableRigidBodyies, updateDT, yoGraphicsListRegistry, parentRegistry);
        this.desiredFullRobotModel = desiredFullRobotModel;
        this.desiredReferenceFrames = new HumanoidReferenceFrames(desiredFullRobotModel);
        this.currentFullRobotModel = fullRobotModelFactory.createFullRobotModel();
        this.currentOneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.currentFullRobotModel);
        this.currentReferenceFrames = new HumanoidReferenceFrames(this.currentFullRobotModel);
        desiredFullRobotModel.getElevator().subtreeStream().forEach(rigidBody -> {
            RigidBodyBasics cfr_ignored_0 = (RigidBodyBasics)this.rigidBodyHashCodeMap.put(rigidBody.hashCode(), rigidBody);
        });
        this.supportRigidBodyWeight.set(200.0);
        this.momentumWeight.set(0.001);
        for (RobotSide robotSide : RobotSide.values) {
            if (desiredFullRobotModel.getHand(robotSide) != null) {
                this.setupVisualization(desiredFullRobotModel.getHand(robotSide));
            }
            this.setupVisualization(desiredFullRobotModel.getFoot((Enum)robotSide));
        }
        for (RobotSide robotSide : RobotSide.values) {
            String side = robotSide.getCamelCaseNameForMiddleOfExpression();
            String sidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
            this.isFootInSupport.put((Enum)robotSide, (Object)new YoBoolean("is" + side + "FootInSupport", this.registry));
            this.initialFootPoses.put((Enum)robotSide, (Object)new YoFramePose3D(sidePrefix + "FootInitial", worldFrame, this.registry));
        }
        for (RobotSide robotSide : RobotSide.values) {
            this.endEffectorToPrimaryBaseMap.put(desiredFullRobotModel.getChest(), desiredFullRobotModel.getHand(robotSide));
            this.endEffectorToPrimaryBaseMap.put(desiredFullRobotModel.getPelvis(), desiredFullRobotModel.getFoot((Enum)robotSide));
        }
        this.populateJointLimitReductionFactors();
    }

    private void populateJointLimitReductionFactors() {
        YoDouble hipReductionFactor = new YoDouble("hipLimitReductionFactor", this.registry);
        YoDouble kneeReductionFactor = new YoDouble("kneeLimitReductionFactor", this.registry);
        YoDouble ankleReductionFactor = new YoDouble("ankleLimitReductionFactor", this.registry);
        hipReductionFactor.set(0.05);
        this.legJointLimitReductionFactors.put(LegJointName.HIP_PITCH, hipReductionFactor);
        this.legJointLimitReductionFactors.put(LegJointName.HIP_ROLL, hipReductionFactor);
        this.legJointLimitReductionFactors.put(LegJointName.HIP_YAW, hipReductionFactor);
        this.legJointLimitReductionFactors.put(LegJointName.KNEE_PITCH, kneeReductionFactor);
        this.legJointLimitReductionFactors.put(LegJointName.ANKLE_PITCH, ankleReductionFactor);
        this.legJointLimitReductionFactors.put(LegJointName.ANKLE_ROLL, ankleReductionFactor);
    }

    private static Collection<RigidBodyBasics> createListOfControllableRigidBodies(FullHumanoidRobotModel desiredFullRobotModel) {
        ArrayList<RigidBodyBasics> listOfControllableRigidBodies = new ArrayList<RigidBodyBasics>();
        listOfControllableRigidBodies.add(desiredFullRobotModel.getHead());
        listOfControllableRigidBodies.add(desiredFullRobotModel.getChest());
        listOfControllableRigidBodies.add(desiredFullRobotModel.getPelvis());
        for (RobotSide robotSide : RobotSide.values) {
            listOfControllableRigidBodies.add(desiredFullRobotModel.getHand(robotSide));
            listOfControllableRigidBodies.add(desiredFullRobotModel.getFoot((Enum)robotSide));
        }
        listOfControllableRigidBodies.removeIf(Objects::isNull);
        return listOfControllableRigidBodies;
    }

    public void setInitialRobotConfiguration(DRCRobotModel robotModel) {
        HashMap<OneDoFJointBasics, Double> privilegedConfiguration = new HashMap<OneDoFJointBasics, Double>();
        DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> defaultRobotInitialSetup = robotModel.getDefaultRobotInitialSetup(0.0, 0.0);
        HumanoidFloatingRootJointRobot robot = robotModel.createHumanoidFloatingRootJointRobot(false);
        defaultRobotInitialSetup.initializeRobot(robot, robotModel.getJointMap());
        for (OneDoFJointBasics joint : this.getDesiredOneDoFJoint()) {
            double q_priv = robot.getOneDegreeOfFreedomJoint(joint.getName()).getQ();
            privilegedConfiguration.put(joint, q_priv);
        }
        this.setInitialRobotConfiguration(privilegedConfiguration);
    }

    public void setCollisionModel(RobotCollisionModel collisionModel) {
        if (collisionModel != null) {
            this.registerCollidables(collisionModel.getRobotCollidables(this.getDesiredFullRobotModel().getElevator()));
        }
    }

    @Override
    public boolean initialize() {
        MultiContactBalanceStatus multiContactBalanceStatus;
        KinematicsToolboxOutputStatus status = new KinematicsToolboxOutputStatus();
        status.setJointNameHash(-1);
        status.setSolutionQuality(Double.NaN);
        if (!super.initializeInternal()) {
            status.setCurrentToolboxState((byte)2);
            this.reportMessage(status);
            return false;
        }
        CapturabilityBasedStatus capturabilityBasedStatus = (CapturabilityBasedStatus)this.concurrentCapturabilityBasedStatusCopier.getCopyForReading();
        boolean bl = this.hasCapturabilityBasedStatus = capturabilityBasedStatus != null;
        if (this.hasCapturabilityBasedStatus) {
            this.capturabilityBasedStatusInternal.set(capturabilityBasedStatus);
        }
        boolean bl2 = this.hasMultiContactBalanceStatus = (multiContactBalanceStatus = (MultiContactBalanceStatus)this.concurrentMultiContactBalanceStatusCopier.getCopyForReading()) != null;
        if (this.hasMultiContactBalanceStatus) {
            this.multiContactBalanceStatusInternal.set(multiContactBalanceStatus);
        }
        this.contactingRigidBodies.clear();
        if (this.hasCapturabilityBasedStatus) {
            for (RobotSide robotside : RobotSide.values) {
                ((YoBoolean)this.isFootInSupport.get((Enum)robotside)).set(HumanoidMessageTools.unpackIsSupportFoot((CapturabilityBasedStatus)this.capturabilityBasedStatusInternal, (RobotSide)robotside));
            }
            this.hasMultiContactBalanceStatus = false;
        } else if (this.hasMultiContactBalanceStatus) {
            IDLSequence.Object supportPolygon = multiContactBalanceStatus.getSupportPolygon();
            IDLSequence.Integer supportRigidBodyIds = multiContactBalanceStatus.getSupportRigidBodyIds();
            for (int i = 0; i < supportPolygon.size(); ++i) {
                ContactingRigidBody contactingRigidBody = (ContactingRigidBody)this.contactingRigidBodies.add();
                contactingRigidBody.initialize((RigidBodyBasics)this.rigidBodyHashCodeMap.get(supportRigidBodyIds.get(i)), worldFrame, (Point3DReadOnly)supportPolygon.get(i));
            }
            for (RobotSide robotSide : RobotSide.values) {
                ((YoBoolean)this.isFootInSupport.get((Enum)robotSide)).set(false);
            }
        } else {
            for (IDLSequence.Object robotSide : RobotSide.values) {
                ((YoBoolean)this.isFootInSupport.get((Enum)robotSide)).set(true);
            }
        }
        if (this.initialRobotConfigurationMap != null) {
            MovingReferenceFrame desiredFrame;
            MovingReferenceFrame currentFrame;
            if (this.hasMultiContactBalanceStatus) {
                throw new UnsupportedOperationException("Initial robot configuration is not supported with multi-contact context.");
            }
            KinematicsToolboxHelper.setRobotStateFromRobotConfigurationData(this.robotConfigurationDataInternal, this.currentFullRobotModel.getRootJoint(), this.currentOneDoFJoints);
            this.currentReferenceFrames.updateFrames();
            this.rootJoint.getJointPose().setToZero();
            this.desiredReferenceFrames.updateFrames();
            if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.LEFT)).getValue()) {
                if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.RIGHT)).getValue()) {
                    currentFrame = this.currentReferenceFrames.getMidFootZUpGroundFrame();
                    desiredFrame = this.desiredReferenceFrames.getMidFootZUpGroundFrame();
                } else {
                    currentFrame = this.currentReferenceFrames.getSoleZUpFrame((Enum)RobotSide.LEFT);
                    desiredFrame = this.desiredReferenceFrames.getSoleZUpFrame((Enum)RobotSide.LEFT);
                }
            } else if (((YoBoolean)this.isFootInSupport.get((Enum)RobotSide.RIGHT)).getValue()) {
                currentFrame = this.currentReferenceFrames.getSoleZUpFrame((Enum)RobotSide.RIGHT);
                desiredFrame = this.desiredReferenceFrames.getSoleZUpFrame((Enum)RobotSide.RIGHT);
            } else {
                throw new IllegalArgumentException("We have a flying robot here, such scenario is not handled.");
            }
            RigidBodyTransform rootJointTransform = currentFrame.getTransformToDesiredFrame((ReferenceFrame)desiredFrame);
            RigidBodyTransform rotationRelocation = desiredFrame.getTransformToDesiredFrame((ReferenceFrame)this.rootJoint.getFrameAfterJoint());
            rootJointTransform.multiplyInvertOther((RigidBodyTransformReadOnly)rotationRelocation);
            rootJointTransform.preMultiply((RigidBodyTransformReadOnly)rotationRelocation);
            this.rootJoint.getJointPose().set((RigidBodyTransformReadOnly)rootJointTransform);
            this.updateTools();
            this.desiredReferenceFrames.updateFrames();
        }
        this.updateCoMPositionAndFootPoses();
        this.holdSupportRigidBodies.set(true);
        this.enableAutoSupportPolygon.set(true);
        this.holdCenterOfMassXYPosition.set(true);
        status.setCurrentToolboxState((byte)1);
        this.reportMessage(status);
        return true;
    }

    @Override
    public void updateInternal() {
        if (this.commandInputManager.isNewCommandAvailable(HumanoidKinematicsToolboxConfigurationCommand.class)) {
            HumanoidKinematicsToolboxConfigurationCommand command = (HumanoidKinematicsToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(HumanoidKinematicsToolboxConfigurationCommand.class);
            this.holdCenterOfMassXYPosition.set(command.holdCurrentCenterOfMassXYPosition());
            this.holdSupportRigidBodies.set(command.holdSupportRigidBodies());
        }
        super.updateInternal();
    }

    private void updateCoMPositionAndFootPoses() {
        this.updateTools();
        this.initialCenterOfMassPosition.setFromReferenceFrame(this.centerOfMassFrame);
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = this.desiredFullRobotModel.getFoot((Enum)robotSide);
            ((YoFramePose3D)this.initialFootPoses.get((Enum)robotSide)).setFromReferenceFrame((ReferenceFrame)foot.getBodyFixedFrame());
        }
    }

    private void addHoldSupportFootCommands(FeedbackControlCommandBuffer bufferToPack) {
        if (!this.holdSupportRigidBodies.getBooleanValue()) {
            return;
        }
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot;
            if (!((YoBoolean)this.isFootInSupport.get((Enum)robotSide)).getBooleanValue() || this.isUserControllingRigidBody(foot = this.desiredFullRobotModel.getFoot((Enum)robotSide))) continue;
            SpatialFeedbackControlCommand feedbackControlCommand = bufferToPack.addSpatialFeedbackControlCommand();
            feedbackControlCommand.set(this.rootBody, foot);
            feedbackControlCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(foot));
            feedbackControlCommand.resetControlFrame();
            feedbackControlCommand.resetControlBaseFrame();
            feedbackControlCommand.setGains((PIDSE3GainsReadOnly)this.getDefaultSpatialGains());
            feedbackControlCommand.setSelectionMatrixToIdentity();
            feedbackControlCommand.setWeightForSolver(this.supportRigidBodyWeight.getValue());
            feedbackControlCommand.setInverseKinematics((FramePose3DReadOnly)this.initialFootPoses.get((Enum)robotSide), KinematicsToolboxHelper.zeroVector6D);
        }
    }

    private void addHoldSupportRigidBodyCommands(FeedbackControlCommandBuffer bufferToPack) {
        if (!this.holdSupportRigidBodies.getBooleanValue()) {
            return;
        }
        if (this.contactingRigidBodies.isEmpty()) {
            return;
        }
        HashSet<RigidBodyBasics> controlledBodies = new HashSet<RigidBodyBasics>();
        for (int i = 0; i < this.contactingRigidBodies.size(); ++i) {
            ContactingRigidBody contactingRigidBody = (ContactingRigidBody)this.contactingRigidBodies.get(i);
            if (this.isUserControllingRigidBody(contactingRigidBody.rigidBody) || !controlledBodies.add(contactingRigidBody.rigidBody)) continue;
            SpatialFeedbackControlCommand feedbackControlCommand = bufferToPack.addSpatialFeedbackControlCommand();
            feedbackControlCommand.set(this.rootBody, contactingRigidBody.rigidBody);
            feedbackControlCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(contactingRigidBody.rigidBody));
            feedbackControlCommand.setControlFrameFixedInEndEffector((FramePoint3DReadOnly)contactingRigidBody.contactPointInBodyFixedFrame);
            feedbackControlCommand.resetControlBaseFrame();
            feedbackControlCommand.setGains((PIDSE3GainsReadOnly)this.getDefaultSpatialGains());
            feedbackControlCommand.getSpatialAccelerationCommand().setSelectionMatrixForLinearControl();
            feedbackControlCommand.setWeightForSolver(this.supportRigidBodyWeight.getValue());
            feedbackControlCommand.setInverseKinematics((FramePoint3DReadOnly)contactingRigidBody.initialPosition, KinematicsToolboxHelper.zeroVector3D);
        }
    }

    private void addHoldCenterOfMassXYCommand(FeedbackControlCommandBuffer bufferToPack) {
        if (!this.holdCenterOfMassXYPosition.getBooleanValue()) {
            return;
        }
        if (this.isUserControllingCenterOfMass()) {
            this.holdCenterOfMassXYPosition.set(false);
            return;
        }
        this.centerOfMassPositionToHold.setIncludingFrame((FrameTuple3DReadOnly)this.initialCenterOfMassPosition);
        CenterOfMassFeedbackControlCommand feedbackControlCommand = bufferToPack.addCenterOfMassFeedbackControlCommand();
        feedbackControlCommand.setGains((PID3DGains)this.getDefaultSpatialGains().getPositionGains());
        feedbackControlCommand.setWeightForSolver(this.momentumWeight.getDoubleValue());
        feedbackControlCommand.setSelectionMatrixForLinearXYControl();
        feedbackControlCommand.setInverseKinematics((FramePoint3DReadOnly)this.centerOfMassPositionToHold, KinematicsToolboxHelper.zeroVector3D);
    }

    private void addJointLimitReductionCommand(InverseKinematicsCommandBuffer bufferToPack) {
        JointLimitReductionCommand jointLimitReductionCommand = bufferToPack.addJointLimitReductionCommand();
        jointLimitReductionCommand.clear();
        for (RobotSide robotSide : RobotSide.values) {
            for (LegJointName legJointName : this.desiredFullRobotModel.getRobotSpecificJointNames().getLegJointNames()) {
                OneDoFJointBasics joint = this.desiredFullRobotModel.getLegJoint((Enum)robotSide, legJointName);
                double reductionFactor = this.legJointLimitReductionFactors.get(legJointName).getDoubleValue();
                jointLimitReductionCommand.addReductionFactor(joint, reductionFactor);
            }
        }
    }

    private void addLinearMomentumConvexConstraint2DCommand(InverseKinematicsCommandBuffer bufferToPack) {
        if (!this.enableAutoSupportPolygon.getValue()) {
            return;
        }
        if (!this.enableSupportPolygonConstraint.getValue()) {
            return;
        }
        if (this.isUserProvidingSupportPolygon()) {
            return;
        }
        this.activeContactPointPositions.clear();
        if (this.hasCapturabilityBasedStatus) {
            int i;
            IDLSequence.Object leftFootSupportPolygon2d = this.capturabilityBasedStatusInternal.getLeftFootSupportPolygon3d();
            IDLSequence.Object rightFootSupportPolygon2d = this.capturabilityBasedStatusInternal.getRightFootSupportPolygon3d();
            for (i = 0; i < leftFootSupportPolygon2d.size(); ++i) {
                ((FramePoint3D)this.activeContactPointPositions.add()).setIncludingFrame(worldFrame, (Tuple3DReadOnly)leftFootSupportPolygon2d.get(i));
            }
            for (i = 0; i < rightFootSupportPolygon2d.size(); ++i) {
                ((FramePoint3D)this.activeContactPointPositions.add()).setIncludingFrame(worldFrame, (Tuple3DReadOnly)rightFootSupportPolygon2d.get(i));
            }
        } else if (this.hasMultiContactBalanceStatus) {
            IDLSequence.Object supportPolygonFromStatus = this.multiContactBalanceStatusInternal.getSupportPolygon();
            for (int i = 0; i < supportPolygonFromStatus.size(); ++i) {
                ((FramePoint3D)this.activeContactPointPositions.add()).setIncludingFrame(worldFrame, (Tuple3DReadOnly)supportPolygonFromStatus.get(i));
            }
        }
        this.updateSupportPolygonConstraint((List<? extends FramePoint3DReadOnly>)this.activeContactPointPositions, bufferToPack);
    }

    @Override
    protected void robotConfigurationReinitialized() {
        this.updateCoMPositionAndFootPoses();
    }

    public void updateFootSupportState(boolean isLeftFootInSupport, boolean isRightFootInSupport) {
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        if (isLeftFootInSupport) {
            capturabilityBasedStatus.getLeftFootSupportPolygon3d().add();
        }
        if (isRightFootInSupport) {
            capturabilityBasedStatus.getRightFootSupportPolygon3d().add();
        }
        this.updateCapturabilityBasedStatus(capturabilityBasedStatus);
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus newStatus) {
        ((CapturabilityBasedStatus)this.concurrentCapturabilityBasedStatusCopier.getCopyForWriting()).set(newStatus);
        this.concurrentCapturabilityBasedStatusCopier.commit();
    }

    public void updateMultiContactBalanceStatus(MultiContactBalanceStatus newStatus) {
        ((MultiContactBalanceStatus)this.concurrentMultiContactBalanceStatusCopier.getCopyForWriting()).set(newStatus);
        this.concurrentMultiContactBalanceStatusCopier.commit();
    }

    @Override
    protected RigidBodyBasics getEndEffectorPrimaryBase(RigidBodyBasics endEffector) {
        return this.endEffectorToPrimaryBaseMap.get(endEffector);
    }

    @Override
    protected void getAdditionalFeedbackControlCommands(FeedbackControlCommandBuffer bufferToPack) {
        this.addHoldSupportFootCommands(bufferToPack);
        this.addHoldSupportRigidBodyCommands(bufferToPack);
        this.addHoldCenterOfMassXYCommand(bufferToPack);
    }

    @Override
    protected void getAdditionalInverseKinematicsCommands(InverseKinematicsCommandBuffer bufferToPack) {
        this.addJointLimitReductionCommand(bufferToPack);
        this.addLinearMomentumConvexConstraint2DCommand(bufferToPack);
    }

    public YoDouble getMomentumWeight() {
        return this.momentumWeight;
    }

    public FullHumanoidRobotModel getDesiredFullRobotModel() {
        return this.desiredFullRobotModel;
    }

    private static class ContactingRigidBody {
        private RigidBodyBasics rigidBody;
        private final FramePoint3D contactPointInBodyFixedFrame = new FramePoint3D();
        private final FramePoint3D initialPosition = new FramePoint3D();

        public void initialize(RigidBodyBasics rigidBody, ReferenceFrame positionFrame, Point3DReadOnly position) {
            this.rigidBody = rigidBody;
            this.initialPosition.setIncludingFrame(positionFrame, (Tuple3DReadOnly)position);
            this.contactPointInBodyFixedFrame.setIncludingFrame((FrameTuple3DReadOnly)this.initialPosition);
            this.contactPointInBodyFixedFrame.changeFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
        }
    }
}

