/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.KinematicsToolboxContactStateMessage;
import controller_msgs.msg.dds.KinematicsToolboxInputCollectionMessage;
import controller_msgs.msg.dds.KinematicsToolboxOneDoFJointMessage;
import controller_msgs.msg.dds.KinematicsToolboxPrivilegedConfigurationMessage;
import controller_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxContactStateCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxInputCollectionCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxOneDoFJointCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxPrivilegedConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.JointHashCodeResolver;
import us.ihmc.robotModels.RigidBodyHashCodeResolver;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;

public class KinematicsToolboxCommandConverter
implements CommandConversionInterface {
    private final RigidBodyHashCodeResolver rigidBodyHashCodeResolver;
    private final JointHashCodeResolver jointHashCodeResolver;
    private final ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver;

    public KinematicsToolboxCommandConverter(FullHumanoidRobotModel fullRobotModel) {
        this.rigidBodyHashCodeResolver = new RigidBodyHashCodeResolver((FullRobotModel)fullRobotModel);
        this.referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver((FullRobotModel)fullRobotModel, (ReferenceFrames)new HumanoidReferenceFrames(fullRobotModel));
        this.jointHashCodeResolver = new JointHashCodeResolver((FullRobotModel)fullRobotModel);
    }

    public KinematicsToolboxCommandConverter(RigidBodyBasics rootBody) {
        this.rigidBodyHashCodeResolver = new RigidBodyHashCodeResolver();
        this.rigidBodyHashCodeResolver.putAllMultiBodySystemRigidBodies((RigidBodyReadOnly)rootBody);
        this.referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver();
        this.referenceFrameHashCodeResolver.putAllMultiBodySystemReferenceFrames((RigidBodyReadOnly)rootBody);
        this.jointHashCodeResolver = new JointHashCodeResolver();
        this.jointHashCodeResolver.putAllMultiBodySystemJoints((RigidBodyReadOnly)rootBody);
    }

    public <C extends Command<?, M>, M extends Settable<M>> boolean isConvertible(C command, M message) {
        if (message instanceof KinematicsToolboxRigidBodyMessage) {
            return true;
        }
        if (message instanceof KinematicsToolboxOneDoFJointMessage) {
            return true;
        }
        if (message instanceof KinematicsToolboxPrivilegedConfigurationMessage) {
            return true;
        }
        if (message instanceof KinematicsToolboxContactStateMessage) {
            return true;
        }
        return message instanceof KinematicsToolboxInputCollectionMessage;
    }

    public <C extends Command<?, M>, M extends Settable<M>> void process(C command, M message) {
        if (message instanceof KinematicsToolboxRigidBodyMessage) {
            KinematicsToolboxRigidBodyMessage rigidBodyMessage = (KinematicsToolboxRigidBodyMessage)message;
            KinematicsToolboxRigidBodyCommand rigidBodyCommand = (KinematicsToolboxRigidBodyCommand)command;
            rigidBodyCommand.set(rigidBodyMessage, this.rigidBodyHashCodeResolver, this.referenceFrameHashCodeResolver);
        } else if (message instanceof KinematicsToolboxOneDoFJointMessage) {
            KinematicsToolboxOneDoFJointMessage jointMessage = (KinematicsToolboxOneDoFJointMessage)message;
            KinematicsToolboxOneDoFJointCommand jointCommand = (KinematicsToolboxOneDoFJointCommand)command;
            jointCommand.set(jointMessage, this.jointHashCodeResolver);
        } else if (message instanceof KinematicsToolboxContactStateMessage) {
            KinematicsToolboxContactStateMessage contactStateMessage = (KinematicsToolboxContactStateMessage)message;
            KinematicsToolboxContactStateCommand contactStateCommand = (KinematicsToolboxContactStateCommand)command;
            contactStateCommand.set(contactStateMessage, this.rigidBodyHashCodeResolver);
        } else if (message instanceof KinematicsToolboxPrivilegedConfigurationMessage) {
            KinematicsToolboxPrivilegedConfigurationMessage privConfMessage = (KinematicsToolboxPrivilegedConfigurationMessage)message;
            KinematicsToolboxPrivilegedConfigurationCommand privConfCommand = (KinematicsToolboxPrivilegedConfigurationCommand)command;
            privConfCommand.set(privConfMessage, this.jointHashCodeResolver);
        } else if (message instanceof KinematicsToolboxInputCollectionMessage) {
            KinematicsToolboxInputCollectionMessage collectionMessage = (KinematicsToolboxInputCollectionMessage)message;
            KinematicsToolboxInputCollectionCommand collectionCommand = (KinematicsToolboxInputCollectionCommand)command;
            collectionCommand.set(collectionMessage, this.rigidBodyHashCodeResolver, this.referenceFrameHashCodeResolver, this.jointHashCodeResolver);
        }
    }
}

