/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.KinematicsToolboxOutputStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsCollisionFrame;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsSolutionQualityCalculator;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxOptimizationSettings;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.commonWalkingControlModules.configurations.JointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerDataHolderReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCore;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutputReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.LinearMomentumConvexConstraint2DCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.MomentumCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBPoint3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBQuaternion3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.Type;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.ListWrappingIndexTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.lists.SupplierBuilder;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShape3DCollisionResult;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxContactStateCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxInputCollectionCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxOneDoFJointCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxPrivilegedConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.mecano.frames.CenterOfMassReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.controllers.pidGains.GainCoupling;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.YoPIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultYoPIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.robotics.physics.CollisionResult;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.robotics.time.ThreadTimer;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class KinematicsToolboxController
extends ToolboxController {
    private static final double GLOBAL_PROPORTIONAL_GAIN = 1200.0;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double DEFAULT_PRIVILEGED_CONFIGURATION_WEIGHT = 0.025;
    private static final double DEFAULT_PRIVILEGED_CONFIGURATION_GAIN = 50.0;
    protected final double updateDT;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    protected final RigidBodyBasics rootBody;
    protected final FloatingJointBasics rootJoint;
    private final double totalRobotMass;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final Collection<? extends RigidBodyBasics> controllableRigidBodies;
    protected final ReferenceFrame centerOfMassFrame;
    private final YoPIDSE3Gains spatialGains;
    private final YoPIDGains jointGains;
    private final KinematicsToolboxOptimizationSettings optimizationSettings;
    private final InverseKinematicsOptimizationSettingsCommand activeOptimizationSettings;
    private final ControllerCoreCommandBuffer controllerCoreCommand;
    private final WholeBodyControllerCore controllerCore;
    private final FeedbackControllerDataHolderReadOnly feedbackControllerDataHolder;
    private final KinematicsToolboxOutputStatus inverseKinematicsSolution;
    private final YoDouble timeLastSolutionPublished;
    private final YoDouble publishSolutionPeriod;
    private final YoDouble solutionQuality;
    private final KinematicsSolutionQualityCalculator solutionQualityCalculator;
    private final FeedbackControlCommandList allFeedbackControlCommands;
    private final YoDouble privilegedWeight;
    private final YoDouble privilegedConfigurationGain;
    private final YoDouble privilegedMaxVelocity;
    protected TObjectDoubleHashMap<OneDoFJointBasics> initialRobotConfigurationMap;
    private boolean submitPrivilegedConfigurationCommand;
    private final PrivilegedConfigurationCommand privilegedConfigurationCommand;
    protected final CommandInputManager commandInputManager;
    private final List<RigidBodyBasics> rigidBodiesWithVisualization;
    private final Map<RigidBodyBasics, YoGraphicCoordinateSystem> desiredCoodinateSystems;
    private final Map<RigidBodyBasics, YoGraphicCoordinateSystem> currentCoodinateSystems;
    private final ConcurrentCopier<RobotConfigurationData> concurrentRobotConfigurationDataCopier;
    protected final RobotConfigurationData robotConfigurationDataInternal;
    private final FeedbackControlCommandBuffer userFBCommands;
    private final FeedbackControlCommandBuffer previousUserFBCommands;
    private final YoBoolean isUserProvidingSupportPolygon;
    private final List<FramePoint3DReadOnly> contactPointLocations;
    private final ConvexPolygon2D supportPolygon;
    private final RecyclingArrayList<Point2D> shrunkSupportPolygonVertices;
    private final ConvexPolygonScaler convexPolygonScaler;
    private final FrameConvexPolygon2D newSupportPolygon;
    private final ConvexPolygon2D shrunkConvexPolygon;
    private final FramePoint2D centerOfMass;
    private final YoDouble centerOfMassSafeMargin;
    private final double robotMass;
    protected final YoBoolean enableSupportPolygonConstraint;
    private final YoInteger numberOfActiveCommands;
    private final YoBoolean preserveUserCommandHistory;
    private final List<Collidable> robotCollidables;
    private final YoBoolean enableCollisionAvoidance;
    private final RecyclingArrayList<CollisionResult> collisionResults;
    private final RecyclingArrayList<KinematicsCollisionFrame> collisionFrames;
    private final YoDouble collisionActivationDistanceThreshold;
    private final YoDouble maxCollisionResolutionVelocity;
    private final int numberOfCollisionsToVisualize = 20;
    private final YoDouble[] yoCollisionDistances;
    private final YoFramePoint3D[] yoCollisionPointAs;
    private final YoFramePoint3D[] yoCollisionPointBs;
    private final YoFramePose3D[] yoCollisionFramePoses;
    private final ThreadTimer threadTimer;
    private final YoBoolean minimizeAngularMomentum;
    private final YoDouble angularMomentumWeight;
    private final MomentumCommand angularMomentumCommand;
    private final List<FBPoint3D> rigidBodyPositions;
    private final List<FBQuaternion3D> rigidBodyOrientations;

    public KinematicsToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FloatingJointBasics rootJoint, OneDoFJointBasics[] oneDoFJoints, Collection<? extends RigidBodyBasics> controllableRigidBodies, double updateDT, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        this.spatialGains = new DefaultYoPIDSE3Gains("GenericSpatialGains", GainCoupling.XYZ, false, this.registry);
        this.jointGains = new YoPIDGains("GenericJointGains", this.registry);
        this.optimizationSettings = new KinematicsToolboxOptimizationSettings();
        this.activeOptimizationSettings = new InverseKinematicsOptimizationSettingsCommand();
        this.controllerCoreCommand = new ControllerCoreCommandBuffer();
        this.timeLastSolutionPublished = new YoDouble("timeLastSolutionPublished", this.registry);
        this.publishSolutionPeriod = new YoDouble("publishSolutionPeriod", this.registry);
        this.solutionQuality = new YoDouble("solutionQuality", this.registry);
        this.solutionQualityCalculator = new KinematicsSolutionQualityCalculator();
        this.allFeedbackControlCommands = new FeedbackControlCommandList();
        this.privilegedWeight = new YoDouble("privilegedWeight", this.registry);
        this.privilegedConfigurationGain = new YoDouble("privilegedConfigurationGain", this.registry);
        this.privilegedMaxVelocity = new YoDouble("privilegedMaxVelocity", this.registry);
        this.initialRobotConfigurationMap = null;
        this.submitPrivilegedConfigurationCommand = true;
        this.privilegedConfigurationCommand = new PrivilegedConfigurationCommand();
        this.rigidBodiesWithVisualization = new ArrayList<RigidBodyBasics>();
        this.desiredCoodinateSystems = new HashMap<RigidBodyBasics, YoGraphicCoordinateSystem>();
        this.currentCoodinateSystems = new HashMap<RigidBodyBasics, YoGraphicCoordinateSystem>();
        this.concurrentRobotConfigurationDataCopier = new ConcurrentCopier(RobotConfigurationData::new);
        this.robotConfigurationDataInternal = new RobotConfigurationData();
        this.userFBCommands = new FeedbackControlCommandBuffer();
        this.previousUserFBCommands = new FeedbackControlCommandBuffer();
        this.isUserProvidingSupportPolygon = new YoBoolean("isUserProvidingSupportPolygon", this.registry);
        this.contactPointLocations = new ArrayList<FramePoint3DReadOnly>();
        this.supportPolygon = new ConvexPolygon2D();
        this.shrunkSupportPolygonVertices = new RecyclingArrayList(Point2D.class);
        this.convexPolygonScaler = new ConvexPolygonScaler();
        this.newSupportPolygon = new FrameConvexPolygon2D();
        this.shrunkConvexPolygon = new ConvexPolygon2D();
        this.centerOfMass = new FramePoint2D();
        this.centerOfMassSafeMargin = new YoDouble("centerOfMassSafeMargin", "Describes the minimum distance away from the support polygon's edges.", this.registry);
        this.enableSupportPolygonConstraint = new YoBoolean("enableSupportPolygonConstraint", this.registry);
        this.numberOfActiveCommands = new YoInteger("numberOfActiveCommands", this.registry);
        this.preserveUserCommandHistory = new YoBoolean("preserveUserCommandHistory", this.registry);
        this.robotCollidables = new ArrayList<Collidable>();
        this.enableCollisionAvoidance = new YoBoolean("enableCollisionAvoidance", this.registry);
        this.collisionResults = new RecyclingArrayList(CollisionResult::new);
        this.collisionFrames = new RecyclingArrayList(SupplierBuilder.indexedSupplier(collisionIndex -> new KinematicsCollisionFrame("collisionFrame" + collisionIndex, worldFrame)));
        this.collisionActivationDistanceThreshold = new YoDouble("collisionActivationDistanceThreshold", this.registry);
        this.maxCollisionResolutionVelocity = new YoDouble("maxCollisionResolutionVelocity", this.registry);
        this.numberOfCollisionsToVisualize = 20;
        this.yoCollisionDistances = new YoDouble[20];
        this.yoCollisionPointAs = new YoFramePoint3D[20];
        this.yoCollisionPointBs = new YoFramePoint3D[20];
        this.yoCollisionFramePoses = new YoFramePose3D[20];
        this.minimizeAngularMomentum = new YoBoolean("minimizeAngularMomentum", this.registry);
        this.angularMomentumWeight = new YoDouble("angularMomentumWeight", this.registry);
        this.angularMomentumCommand = new MomentumCommand();
        this.rigidBodyPositions = new ArrayList<FBPoint3D>();
        this.rigidBodyOrientations = new ArrayList<FBQuaternion3D>();
        this.commandInputManager = commandInputManager;
        this.rootJoint = rootJoint;
        this.oneDoFJoints = oneDoFJoints;
        this.controllableRigidBodies = controllableRigidBodies;
        this.updateDT = updateDT;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        this.rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)oneDoFJoints[0].getPredecessor());
        this.totalRobotMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)this.rootBody);
        this.centerOfMassFrame = new CenterOfMassReferenceFrame("centerOfMass", worldFrame, (RigidBodyReadOnly)this.rootBody);
        this.controllerCoreCommand.setControllerCoreMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
        this.controllerCore = this.createControllerCore(controllableRigidBodies);
        this.feedbackControllerDataHolder = this.controllerCore.getWholeBodyFeedbackControllerDataHolder();
        this.inverseKinematicsSolution = MessageTools.createKinematicsToolboxOutputStatus((OneDoFJointBasics[])oneDoFJoints);
        this.inverseKinematicsSolution.setDestination(-1);
        this.robotMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)this.rootBody);
        this.centerOfMassSafeMargin.set(0.04);
        this.spatialGains.setPositionProportionalGains(1200.0);
        this.spatialGains.setPositionMaxFeedbackAndFeedbackRate(1500.0, Double.POSITIVE_INFINITY);
        this.spatialGains.setOrientationProportionalGains(1200.0);
        this.spatialGains.setOrientationMaxFeedbackAndFeedbackRate(1500.0, Double.POSITIVE_INFINITY);
        this.jointGains.setKp(1200.0);
        this.jointGains.setMaximumFeedbackAndMaximumFeedbackRate(1500.0, Double.POSITIVE_INFINITY);
        this.privilegedWeight.set(0.025);
        this.privilegedConfigurationGain.set(50.0);
        this.privilegedMaxVelocity.set(Double.POSITIVE_INFINITY);
        this.publishSolutionPeriod.set(0.01);
        this.preserveUserCommandHistory.set(true);
        this.threadTimer = new ThreadTimer("timer", updateDT, this.registry);
        this.minimizeAngularMomentum.set(false);
        this.angularMomentumWeight.set(0.125);
        this.angularMomentumCommand.setSelectionMatrixForAngularControl();
        this.enableCollisionAvoidance.set(true);
        this.collisionActivationDistanceThreshold.set(0.1);
        this.maxCollisionResolutionVelocity.set(0.1);
        this.setupCollisionVisualization();
    }

    private void setupCollisionVisualization() {
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            YoDouble collisionDistance = new YoDouble("collision_" + i + "_distance", this.registry);
            YoFramePoint3D collisionPointA = new YoFramePoint3D("collision_" + i + "_pointA" + i, worldFrame, this.registry);
            YoFramePoint3D collisionPointB = new YoFramePoint3D("collision_" + i + "_pointB" + i, worldFrame, this.registry);
            YoFramePose3D collisionFramePose = new YoFramePose3D("collision_" + i + "_frame", worldFrame, this.registry);
            if (this.yoGraphicsListRegistry != null) {
                YoAppearanceRGBColor appearance = new YoAppearanceRGBColor(new Color(random.nextInt()), 0.7);
                this.yoGraphicsListRegistry.registerYoGraphic("Collisions", (YoGraphic)new YoGraphicPosition("collision_" + i + "_pointA", collisionPointA, 0.01, (AppearanceDefinition)appearance));
                this.yoGraphicsListRegistry.registerYoGraphic("Collisions", (YoGraphic)new YoGraphicPosition("collision_" + i + "_pointB", collisionPointB, 0.01, (AppearanceDefinition)appearance));
                this.yoGraphicsListRegistry.registerYoGraphic("Collisions", (YoGraphic)new YoGraphicCoordinateSystem("collision_" + i + "_frame", collisionFramePose, 0.1, (AppearanceDefinition)appearance));
            }
            this.yoCollisionDistances[i] = collisionDistance;
            this.yoCollisionPointAs[i] = collisionPointA;
            this.yoCollisionPointBs[i] = collisionPointB;
            this.yoCollisionFramePoses[i] = collisionFramePose;
        }
    }

    public void setInitialRobotConfiguration(Map<OneDoFJointBasics, Double> initialRobotConfigurationMap) {
        if (initialRobotConfigurationMap == null) {
            this.initialRobotConfigurationMap = null;
            return;
        }
        this.initialRobotConfigurationMap = new TObjectDoubleHashMap();
        initialRobotConfigurationMap.entrySet().forEach(entry -> this.initialRobotConfigurationMap.put(entry.getKey(), ((Double)entry.getValue()).doubleValue()));
    }

    public void setInitialRobotConfigurationNamedMap(Map<String, Double> jointNameToInitialJointPosition) {
        if (jointNameToInitialJointPosition == null) {
            this.initialRobotConfigurationMap = null;
            return;
        }
        this.initialRobotConfigurationMap = new TObjectDoubleHashMap();
        for (OneDoFJointBasics joint : this.oneDoFJoints) {
            Double q_priv = jointNameToInitialJointPosition.get(joint.getName());
            if (q_priv == null) continue;
            this.initialRobotConfigurationMap.put((Object)joint, q_priv.doubleValue());
        }
    }

    public void registerCollidable(Collidable collidable) {
        this.robotCollidables.add(collidable);
    }

    public void registerCollidables(Collidable ... collidables) {
        for (Collidable collidable : collidables) {
            this.robotCollidables.add(collidable);
        }
    }

    public void registerCollidables(Iterable<? extends Collidable> collidables) {
        for (Collidable collidable : collidables) {
            this.robotCollidables.add(collidable);
        }
    }

    public void setupVisualization(RigidBodyBasics ... rigidBodies) {
        AppearanceDefinition desiredAppearance = YoAppearance.Red();
        AppearanceDefinition currentAppearance = YoAppearance.Blue();
        for (RigidBodyBasics rigidBody : rigidBodies) {
            YoGraphicCoordinateSystem desiredCoodinateSystem = this.createCoodinateSystem(rigidBody, Type.DESIRED, desiredAppearance);
            YoGraphicCoordinateSystem currentCoodinateSystem = this.createCoodinateSystem(rigidBody, Type.CURRENT, currentAppearance);
            this.rigidBodiesWithVisualization.add(rigidBody);
            this.desiredCoodinateSystems.put(rigidBody, desiredCoodinateSystem);
            this.currentCoodinateSystems.put(rigidBody, currentCoodinateSystem);
            this.yoGraphicsListRegistry.registerYoGraphic("CoordinateSystems", (YoGraphic)desiredCoodinateSystem);
            this.yoGraphicsListRegistry.registerYoGraphic("CoordinateSystems", (YoGraphic)currentCoodinateSystem);
        }
    }

    private YoGraphicCoordinateSystem createCoodinateSystem(RigidBodyBasics endEffector, Type type, AppearanceDefinition appearanceDefinition) {
        String namePrefix = endEffector.getName() + type.getName();
        return new YoGraphicCoordinateSystem(namePrefix, "", this.registry, false, 0.2, appearanceDefinition);
    }

    private WholeBodyControllerCore createControllerCore(Collection<? extends RigidBodyBasics> controllableRigidBodies) {
        OneDoFJointBasics[] controlledJoints;
        if (this.rootJoint != null) {
            controlledJoints = new JointBasics[this.oneDoFJoints.length + 1];
            controlledJoints[0] = this.rootJoint;
            System.arraycopy(this.oneDoFJoints, 0, controlledJoints, 1, this.oneDoFJoints.length);
        } else {
            controlledJoints = this.oneDoFJoints;
        }
        WholeBodyControlCoreToolbox toolbox = new WholeBodyControlCoreToolbox(this.updateDT, 0.0, this.rootJoint, (JointBasics[])controlledJoints, this.centerOfMassFrame, (ControllerCoreOptimizationSettings)this.optimizationSettings, null, this.registry);
        toolbox.setJointPrivilegedConfigurationParameters(new JointPrivilegedConfigurationParameters());
        toolbox.setupForInverseKinematicsSolver();
        FeedbackControllerTemplate controllerCoreTemplate = this.createFeedbackControllerTemplate(controllableRigidBodies, 1);
        JointDesiredOutputList lowLevelControllerOutput = new JointDesiredOutputList((OneDoFJointReadOnly[])this.oneDoFJoints);
        return new WholeBodyControllerCore(toolbox, controllerCoreTemplate, lowLevelControllerOutput, this.registry);
    }

    private FeedbackControllerTemplate createFeedbackControllerTemplate(Collection<? extends RigidBodyBasics> controllableRigidBodies, int numberOfControllersPerBody) {
        FeedbackControllerTemplate template = new FeedbackControllerTemplate();
        template.setAllowDynamicControllerConstruction(true);
        template.enableCenterOfMassFeedbackController();
        List rigidBodies = controllableRigidBodies != null ? controllableRigidBodies : this.rootBody.subtreeList();
        rigidBodies.stream().forEach(rigidBody -> template.enableSpatialFeedbackController(rigidBody, numberOfControllersPerBody));
        SubtreeStreams.fromChildren(OneDoFJointBasics.class, (RigidBodyReadOnly)this.rootBody).forEach(arg_0 -> ((FeedbackControllerTemplate)template).enableOneDoFJointFeedbackController(arg_0));
        return template;
    }

    @Override
    public boolean initialize() {
        boolean success = this.initializeInternal();
        KinematicsToolboxOutputStatus status = new KinematicsToolboxOutputStatus();
        status.setJointNameHash(-1);
        status.setSolutionQuality(Double.NaN);
        status.setCurrentToolboxState(success ? (byte)1 : 2);
        this.reportMessage(status);
        return success;
    }

    protected boolean initializeInternal() {
        boolean hasRobotConfigurationData;
        this.threadTimer.clear();
        this.userFBCommands.clear();
        this.previousUserFBCommands.clear();
        this.isUserProvidingSupportPolygon.set(false);
        RobotConfigurationData robotConfigurationData = (RobotConfigurationData)this.concurrentRobotConfigurationDataCopier.getCopyForReading();
        boolean bl = hasRobotConfigurationData = robotConfigurationData != null;
        if (!hasRobotConfigurationData) {
            this.commandInputManager.clearAllCommands();
        } else {
            this.robotConfigurationDataInternal.set(robotConfigurationData);
            KinematicsToolboxHelper.setRobotStateFromRobotConfigurationData(this.robotConfigurationDataInternal, this.rootJoint, this.oneDoFJoints);
            if (this.initialRobotConfigurationMap != null) {
                this.initialRobotConfigurationMap.forEachEntry((joint, q_priv) -> {
                    joint.setQ(q_priv);
                    return true;
                });
            }
            this.snapPrivilegedConfigurationToCurrent();
            this.privilegedWeight.set(0.025);
            this.privilegedConfigurationGain.set(50.0);
            this.updateTools();
        }
        this.enableSupportPolygonConstraint.set(true);
        return hasRobotConfigurationData;
    }

    @Override
    public void updateInternal() {
        this.threadTimer.start();
        this.controllerCoreCommand.clear();
        FeedbackControlCommandBuffer feedbackControlCommandBuffer = this.controllerCoreCommand.getFeedbackControlCommandList();
        InverseKinematicsCommandBuffer inverseKinematicsCommandBuffer = this.controllerCoreCommand.getInverseKinematicsCommandList();
        this.consumeUserCommands(feedbackControlCommandBuffer, inverseKinematicsCommandBuffer);
        this.getAdditionalFeedbackControlCommands(feedbackControlCommandBuffer);
        inverseKinematicsCommandBuffer.addInverseKinematicsOptimizationSettingsCommand().set(this.activeOptimizationSettings);
        if (this.submitPrivilegedConfigurationCommand) {
            inverseKinematicsCommandBuffer.addPrivilegedConfigurationCommand().set(this.privilegedConfigurationCommand);
            this.submitPrivilegedConfigurationCommand = false;
        }
        this.getAdditionalInverseKinematicsCommands(inverseKinematicsCommandBuffer);
        this.computeCollisionCommands((List<CollisionResult>)this.collisionResults, inverseKinematicsCommandBuffer);
        this.allFeedbackControlCommands.clear();
        this.allFeedbackControlCommands.addCommandList((FeedbackControlCommandList)feedbackControlCommandBuffer);
        if (this.minimizeAngularMomentum.getValue()) {
            this.angularMomentumCommand.setWeight(this.angularMomentumWeight.getValue());
            inverseKinematicsCommandBuffer.addMomentumCommand().set(this.angularMomentumCommand);
        }
        this.controllerCore.reset();
        this.controllerCore.submitControllerCoreCommand((ControllerCoreCommandInterface)this.controllerCoreCommand);
        this.controllerCore.compute();
        this.solutionQuality.set(this.solutionQualityCalculator.calculateSolutionQuality(this.feedbackControllerDataHolder, this.totalRobotMass, 8.333333333333334E-4));
        KinematicsToolboxHelper.setRobotStateFromControllerCoreOutput((ControllerCoreOutputReadOnly)this.controllerCore.getControllerCoreOutput(), this.rootJoint, this.oneDoFJoints);
        this.updateVisualization();
        this.inverseKinematicsSolution.setCurrentToolboxState((byte)3);
        MessageTools.packDesiredJointState((KinematicsToolboxOutputStatus)this.inverseKinematicsSolution, (FloatingJointReadOnly)this.rootJoint, (OneDoFJointReadOnly[])this.oneDoFJoints);
        this.inverseKinematicsSolution.setSolutionQuality(this.solutionQuality.getDoubleValue());
        this.updateTools();
        this.computeCollisions();
        double currentTime = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        if (this.timeLastSolutionPublished.getValue() == 0.0 || currentTime - this.timeLastSolutionPublished.getValue() >= this.publishSolutionPeriod.getValue()) {
            this.reportMessage(this.inverseKinematicsSolution);
            this.timeLastSolutionPublished.set(currentTime);
        }
        this.threadTimer.stop();
    }

    protected void updateTools() {
        this.rootBody.updateFramesRecursively();
        this.centerOfMassFrame.update();
    }

    private void consumeUserCommands(FeedbackControlCommandBuffer fbCommandBufferToPack, InverseKinematicsCommandBuffer ikCommandBufferToPack) {
        this.consumeUserConfigurationCommands();
        this.consumeUserMotionObjectiveCommands(fbCommandBufferToPack, ikCommandBufferToPack);
        this.consumeUserContactStateCommands(ikCommandBufferToPack);
    }

    private void consumeUserConfigurationCommands() {
        KinematicsToolboxConfigurationCommand command;
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxConfigurationCommand.class)) {
            command = (KinematicsToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxConfigurationCommand.class);
            if (command.getJointVelocityWeight() <= 0.0) {
                this.activeOptimizationSettings.setJointVelocityWeight(this.optimizationSettings.getJointVelocityWeight());
            } else {
                this.activeOptimizationSettings.setJointVelocityWeight(command.getJointVelocityWeight());
            }
            if (command.getJointAccelerationWeight() < 0.0) {
                this.activeOptimizationSettings.setJointAccelerationWeight(this.optimizationSettings.getJointAccelerationWeight());
            } else {
                this.activeOptimizationSettings.setJointAccelerationWeight(command.getJointAccelerationWeight());
            }
            if (command.getDisableCollisionAvoidance()) {
                this.enableCollisionAvoidance.set(false);
            }
            if (command.getEnableCollisionAvoidance()) {
                this.enableCollisionAvoidance.set(true);
            }
            if (command.getDisableJointVelocityLimits()) {
                this.activeOptimizationSettings.setJointVelocityLimitMode(InverseKinematicsOptimizationSettingsCommand.JointVelocityLimitMode.DISABLED);
            }
            if (command.getEnableJointVelocityLimits()) {
                this.activeOptimizationSettings.setJointVelocityLimitMode(InverseKinematicsOptimizationSettingsCommand.JointVelocityLimitMode.ENABLED);
            }
            if (command.getDisableInputPersistence()) {
                this.setPreserveUserCommandHistory(false);
            } else if (command.getEnableInputPersistence()) {
                this.setPreserveUserCommandHistory(true);
            }
            if (command.getEnableSupportPolygonConstraint()) {
                this.enableSupportPolygonConstraint.set(true);
            } else if (command.getDisableSupportPolygonConstraint()) {
                this.enableSupportPolygonConstraint.set(false);
            }
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxPrivilegedConfigurationCommand.class)) {
            command = (KinematicsToolboxPrivilegedConfigurationCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxPrivilegedConfigurationCommand.class);
            KinematicsToolboxHelper.setRobotStateFromPrivilegedConfigurationData((KinematicsToolboxPrivilegedConfigurationCommand)command, this.rootJoint);
            if (command.hasPrivilegedJointAngles() || command.hasPrivilegedRootJointPosition() || command.hasPrivilegedRootJointOrientation()) {
                this.robotConfigurationReinitialized();
            }
            if (command.getPrivilegedWeight() < 0.0) {
                this.privilegedWeight.set(0.025);
            } else {
                this.privilegedWeight.set(command.getPrivilegedWeight());
                this.privilegedConfigurationCommand.setDefaultWeight(this.privilegedWeight.getValue());
                this.submitPrivilegedConfigurationCommand = true;
            }
            if (command.getPrivilegedGain() < 0.0) {
                this.privilegedConfigurationGain.set(50.0);
            } else {
                this.privilegedConfigurationGain.set(command.getPrivilegedGain());
                this.privilegedConfigurationCommand.setDefaultConfigurationGain(this.privilegedConfigurationGain.getValue());
                this.submitPrivilegedConfigurationCommand = true;
            }
            if (command.hasPrivilegedJointAngles()) {
                this.snapPrivilegedConfigurationToCurrent();
            }
        }
    }

    private void consumeUserMotionObjectiveCommands(FeedbackControlCommandBuffer fbCommandBufferToPack, InverseKinematicsCommandBuffer ikCommandBufferToPack) {
        OneDoFJointFeedbackControlCommand previousCommand;
        int j;
        KinematicsToolboxRigidBodyCommand command;
        int i;
        List commands;
        KinematicsToolboxCenterOfMassCommand command2;
        this.previousUserFBCommands.set((FeedbackControlCommandList)this.userFBCommands);
        this.userFBCommands.clear();
        boolean noCommandReceived = true;
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxCenterOfMassCommand.class)) {
            noCommandReceived = false;
            command2 = (KinematicsToolboxCenterOfMassCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxCenterOfMassCommand.class);
            KinematicsToolboxHelper.consumeCenterOfMassCommand(command2, (PID3DGains)this.spatialGains.getPositionGains(), this.userFBCommands.addCenterOfMassFeedbackControlCommand());
            if (this.preserveUserCommandHistory.getValue()) {
                while (!this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().isEmpty()) {
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().get(0));
                }
            }
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxRigidBodyCommand.class)) {
            commands = this.commandInputManager.pollNewCommands(KinematicsToolboxRigidBodyCommand.class);
            for (i = 0; i < commands.size(); ++i) {
                noCommandReceived = false;
                command = (KinematicsToolboxRigidBodyCommand)commands.get(i);
                RigidBodyBasics endEffector = command.getEndEffector();
                SpatialFeedbackControlCommand rigidBodyCommand = this.userFBCommands.addSpatialFeedbackControlCommand();
                KinematicsToolboxHelper.consumeRigidBodyCommand(command, this.rootBody, (PIDSE3Gains)this.spatialGains, rigidBodyCommand);
                rigidBodyCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(rigidBodyCommand.getEndEffector()));
                if (!this.preserveUserCommandHistory.getValue()) continue;
                for (j = this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer().size() - 1; j >= 0; --j) {
                    previousCommand = (SpatialFeedbackControlCommand)this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer().get(j);
                    if (previousCommand.getEndEffector() != endEffector) continue;
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)previousCommand);
                }
            }
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxOneDoFJointCommand.class)) {
            commands = this.commandInputManager.pollNewCommands(KinematicsToolboxOneDoFJointCommand.class);
            for (i = 0; i < commands.size(); ++i) {
                noCommandReceived = false;
                command = (KinematicsToolboxOneDoFJointCommand)commands.get(i);
                OneDoFJointBasics joint = command.getJoint();
                OneDoFJointFeedbackControlCommand jointCommand = this.userFBCommands.addOneDoFJointFeedbackControlCommand();
                KinematicsToolboxHelper.consumeJointCommand((KinematicsToolboxOneDoFJointCommand)command, (PIDGainsReadOnly)this.jointGains, jointCommand);
                if (!this.preserveUserCommandHistory.getValue()) continue;
                for (j = 0; j < this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer().size(); ++j) {
                    previousCommand = (OneDoFJointFeedbackControlCommand)this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer().get(j);
                    if (previousCommand.getJoint() != joint) continue;
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)previousCommand);
                }
            }
        }
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxInputCollectionCommand.class)) {
            command2 = (KinematicsToolboxInputCollectionCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxInputCollectionCommand.class);
            RecyclingArrayList centerOfMassInputs = command2.getCenterOfMassInputs();
            for (int j2 = 0; j2 < centerOfMassInputs.size(); ++j2) {
                noCommandReceived = false;
                KinematicsToolboxCenterOfMassCommand input = (KinematicsToolboxCenterOfMassCommand)centerOfMassInputs.get(j2);
                KinematicsToolboxHelper.consumeCenterOfMassCommand(input, (PID3DGains)this.spatialGains.getPositionGains(), this.userFBCommands.addCenterOfMassFeedbackControlCommand());
                if (!this.preserveUserCommandHistory.getValue()) continue;
                while (!this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().isEmpty()) {
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().get(0));
                }
            }
            RecyclingArrayList rigidBodyInputs = command2.getRigidBodyInputs();
            for (int j3 = 0; j3 < rigidBodyInputs.size(); ++j3) {
                noCommandReceived = false;
                KinematicsToolboxRigidBodyCommand input = (KinematicsToolboxRigidBodyCommand)rigidBodyInputs.get(j3);
                RigidBodyBasics endEffector = input.getEndEffector();
                SpatialFeedbackControlCommand rigidBodyCommand = this.userFBCommands.addSpatialFeedbackControlCommand();
                KinematicsToolboxHelper.consumeRigidBodyCommand(input, this.rootBody, (PIDSE3Gains)this.spatialGains, rigidBodyCommand);
                rigidBodyCommand.setPrimaryBase(this.getEndEffectorPrimaryBase(rigidBodyCommand.getEndEffector()));
                if (!this.preserveUserCommandHistory.getValue()) continue;
                for (int k = this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer().size() - 1; k >= 0; --k) {
                    SpatialFeedbackControlCommand previousCommand2 = (SpatialFeedbackControlCommand)this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer().get(k);
                    if (previousCommand2.getEndEffector() != endEffector) continue;
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)previousCommand2);
                }
            }
            RecyclingArrayList jointInputs = command2.getJointInputs();
            for (int j4 = 0; j4 < jointInputs.size(); ++j4) {
                noCommandReceived = false;
                KinematicsToolboxOneDoFJointCommand input = (KinematicsToolboxOneDoFJointCommand)jointInputs.get(j4);
                OneDoFJointBasics joint = input.getJoint();
                OneDoFJointFeedbackControlCommand jointCommand = this.userFBCommands.addOneDoFJointFeedbackControlCommand();
                KinematicsToolboxHelper.consumeJointCommand(input, (PIDGainsReadOnly)this.jointGains, jointCommand);
                if (!this.preserveUserCommandHistory.getValue()) continue;
                for (int k = 0; k < this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer().size(); ++k) {
                    OneDoFJointFeedbackControlCommand previousCommand3 = (OneDoFJointFeedbackControlCommand)this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer().get(k);
                    if (previousCommand3.getJoint() != joint) continue;
                    this.previousUserFBCommands.removeCommand((FeedbackControlCommand)previousCommand3);
                }
            }
            if (command2.hasConstactStateInput()) {
                KinematicsToolboxContactStateCommand contactStateInput = command2.getContactStateInput();
                this.processUserContactStateCommand(contactStateInput, ikCommandBufferToPack);
            }
        }
        if (noCommandReceived) {
            fbCommandBufferToPack.addCommandList((FeedbackControlCommandList)this.previousUserFBCommands);
            this.numberOfActiveCommands.set(this.previousUserFBCommands.getNumberOfCommands());
            this.userFBCommands.set((FeedbackControlCommandList)this.previousUserFBCommands);
            this.previousUserFBCommands.clear();
        } else {
            if (this.preserveUserCommandHistory.getValue()) {
                this.userFBCommands.addCommandList((FeedbackControlCommandList)this.previousUserFBCommands);
            }
            this.previousUserFBCommands.clear();
            fbCommandBufferToPack.addCommandList((FeedbackControlCommandList)this.userFBCommands);
            this.numberOfActiveCommands.set(this.userFBCommands.getNumberOfCommands());
        }
    }

    private void consumeUserContactStateCommands(InverseKinematicsCommandBuffer bufferToPack) {
        if (this.commandInputManager.isNewCommandAvailable(KinematicsToolboxContactStateCommand.class)) {
            KinematicsToolboxContactStateCommand command = (KinematicsToolboxContactStateCommand)this.commandInputManager.pollNewestCommand(KinematicsToolboxContactStateCommand.class);
            this.processUserContactStateCommand(command, bufferToPack);
        }
    }

    private void processUserContactStateCommand(KinematicsToolboxContactStateCommand command, InverseKinematicsCommandBuffer bufferToPack) {
        this.isUserProvidingSupportPolygon.set(command.getNumberOfContacts() > 0);
        if (command.getCenterOfMassMargin() >= 0.0) {
            this.centerOfMassSafeMargin.set(command.getCenterOfMassMargin());
        }
        this.contactPointLocations.clear();
        for (int i = 0; i < command.getNumberOfContacts(); ++i) {
            this.contactPointLocations.add(command.getContactPoint(i).getPosition());
        }
        if (!this.contactPointLocations.isEmpty()) {
            this.updateSupportPolygonConstraint(this.contactPointLocations, bufferToPack);
        }
    }

    protected void updateSupportPolygonConstraint(List<? extends FramePoint3DReadOnly> contactPoints, InverseKinematicsCommandBuffer bufferToPack) {
        int i;
        if (!this.enableSupportPolygonConstraint.getValue()) {
            return;
        }
        this.newSupportPolygon.clear(worldFrame);
        for (i = 0; i < contactPoints.size(); ++i) {
            this.newSupportPolygon.addVertexMatchingFrame(contactPoints.get(i));
        }
        this.newSupportPolygon.update();
        if (this.newSupportPolygon.getNumberOfVertices() <= 2 || this.newSupportPolygon.getArea() < MathTools.square((double)0.01)) {
            return;
        }
        if (!this.newSupportPolygon.epsilonEquals((ConvexPolygon2DReadOnly)this.supportPolygon, 0.005)) {
            this.supportPolygon.set((Vertex2DSupplier)this.newSupportPolygon);
            this.convexPolygonScaler.scaleConvexPolygon((ConvexPolygon2DReadOnly)this.supportPolygon, this.centerOfMassSafeMargin.getValue(), (ConvexPolygon2DBasics)this.shrunkConvexPolygon);
            this.shrunkSupportPolygonVertices.clear();
            for (i = 0; i < this.shrunkConvexPolygon.getNumberOfVertices(); ++i) {
                ((Point2D)this.shrunkSupportPolygonVertices.add()).set((Tuple2DReadOnly)this.shrunkConvexPolygon.getVertex(i));
            }
            for (i = this.shrunkSupportPolygonVertices.size() - 1; i >= 0; --i) {
                Point2DReadOnly nextVertex;
                Point2DReadOnly previousVertex;
                Point2DReadOnly vertex = (Point2DReadOnly)this.shrunkSupportPolygonVertices.get(i);
                if (!(EuclidGeometryTools.distanceFromPoint2DToLine2D((Point2DReadOnly)vertex, (Point2DReadOnly)(previousVertex = (Point2DReadOnly)ListWrappingIndexTools.getPrevious((int)i, this.shrunkSupportPolygonVertices)), (Point2DReadOnly)(nextVertex = (Point2DReadOnly)ListWrappingIndexTools.getNext((int)i, this.shrunkSupportPolygonVertices))) < 0.001)) continue;
                this.shrunkSupportPolygonVertices.remove(i);
            }
        }
        this.centerOfMass.setToZero(this.centerOfMassFrame);
        this.centerOfMass.changeFrame(worldFrame);
        double distanceThreshold = 0.25 * this.centerOfMassSafeMargin.getValue();
        for (int i2 = 0; i2 < this.shrunkSupportPolygonVertices.size(); ++i2) {
            Point2DReadOnly nextVertex;
            Point2DReadOnly vertex = (Point2DReadOnly)this.shrunkSupportPolygonVertices.get(i2);
            double signedDistanceToEdge = EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((Point2DReadOnly)this.centerOfMass, (Point2DReadOnly)vertex, (Point2DReadOnly)(nextVertex = (Point2DReadOnly)ListWrappingIndexTools.getNext((int)i2, this.shrunkSupportPolygonVertices)));
            if (!(signedDistanceToEdge > -distanceThreshold)) continue;
            LinearMomentumConvexConstraint2DCommand command = bufferToPack.addLinearMomentumConvexConstraint2DCommand();
            command.clear();
            Vector2D h0 = command.addLinearMomentumConstraintVertex();
            Vector2D h1 = command.addLinearMomentumConstraintVertex();
            h0.sub((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)this.centerOfMass);
            h1.sub((Tuple2DReadOnly)nextVertex, (Tuple2DReadOnly)this.centerOfMass);
            h0.scale(this.robotMass / this.updateDT);
            h1.scale(this.robotMass / this.updateDT);
        }
    }

    private void computeCollisions() {
        this.collisionResults.clear();
        if (this.robotCollidables.isEmpty() || !this.enableCollisionAvoidance.getValue()) {
            return;
        }
        int collisionIndex = 0;
        for (int collidableAIndex = 0; collidableAIndex < this.robotCollidables.size(); ++collidableAIndex) {
            Collidable collidableA = this.robotCollidables.get(collidableAIndex);
            for (int collidableBIndex = collidableAIndex + 1; collidableBIndex < this.robotCollidables.size(); ++collidableBIndex) {
                Collidable collidableB = this.robotCollidables.get(collidableBIndex);
                if (!collidableA.isCollidableWith(collidableB)) continue;
                CollisionResult collisionResult = (CollisionResult)this.collisionResults.add();
                collidableA.evaluateCollision(collidableB, collisionResult);
                EuclidFrameShape3DCollisionResult collisionData = collisionResult.getCollisionData();
                if (collisionData.getSignedDistance() > this.collisionActivationDistanceThreshold.getValue()) continue;
                if (collisionIndex < 20) {
                    this.yoCollisionDistances[collisionIndex].set(collisionData.getSignedDistance());
                    this.yoCollisionPointAs[collisionIndex].setMatchingFrame((FrameTuple3DReadOnly)collisionData.getPointOnA());
                    this.yoCollisionPointBs[collisionIndex].setMatchingFrame((FrameTuple3DReadOnly)collisionData.getPointOnB());
                }
                ++collisionIndex;
            }
        }
    }

    public void computeCollisionCommands(List<CollisionResult> collisions, InverseKinematicsCommandBuffer bufferToPack) {
        if (collisions.isEmpty() || !this.enableCollisionAvoidance.getValue()) {
            return;
        }
        int collisionIndex = 0;
        this.collisionFrames.clear();
        for (int i = 0; i < collisions.size(); ++i) {
            CollisionResult collision = collisions.get(i);
            Collidable collidableA = collision.getCollidableA();
            Collidable collidableB = collision.getCollidableB();
            EuclidFrameShape3DCollisionResult collisionData = collision.getCollisionData();
            if (collisionData.getSignedDistance() > this.collisionActivationDistanceThreshold.getValue()) continue;
            RigidBodyBasics bodyA = collidableA.getRigidBody();
            double sigma = -collisionData.getSignedDistance();
            double sigmaDot = sigma / this.updateDT;
            sigmaDot = Math.min(sigmaDot, this.maxCollisionResolutionVelocity.getValue());
            KinematicsCollisionFrame collisionFrame = (KinematicsCollisionFrame)((Object)this.collisionFrames.add());
            collisionFrame.update(collision, true);
            if (collisionIndex < 20) {
                this.yoCollisionFramePoses[collisionIndex].setFromReferenceFrame((ReferenceFrame)collisionFrame);
            }
            SpatialVelocityCommand command = bufferToPack.addSpatialVelocityCommand();
            command.set(bodyA, collidableB.getRigidBody());
            command.getControlFramePose().setFromReferenceFrame((ReferenceFrame)collisionFrame);
            SelectionMatrix6D selectionMatrix = command.getSelectionMatrix();
            selectionMatrix.clearSelection();
            selectionMatrix.selectLinearZ(true);
            selectionMatrix.setSelectionFrames(null, (ReferenceFrame)collisionFrame);
            command.setConstraintType(ConstraintType.GEQ_INEQUALITY);
            command.getDesiredLinearVelocity().setZ(sigmaDot);
            ++collisionIndex;
        }
    }

    protected void robotConfigurationReinitialized() {
    }

    protected RigidBodyBasics getEndEffectorPrimaryBase(RigidBodyBasics endEffector) {
        return null;
    }

    private void updateVisualization() {
        YoGraphicCoordinateSystem coordinateSystem;
        RigidBodyBasics endEffector;
        int i;
        for (i = 0; i < this.rigidBodiesWithVisualization.size(); ++i) {
            endEffector = this.rigidBodiesWithVisualization.get(i);
            coordinateSystem = this.desiredCoodinateSystems.get(endEffector);
            this.feedbackControllerDataHolder.getPositionData(endEffector, this.rigidBodyPositions, Type.DESIRED);
            if (this.rigidBodyPositions.isEmpty()) {
                coordinateSystem.hide();
            } else {
                coordinateSystem.setPosition((FramePoint3DReadOnly)this.rigidBodyPositions.get(0));
            }
            this.feedbackControllerDataHolder.getOrientationData(endEffector, this.rigidBodyOrientations, Type.DESIRED);
            if (this.rigidBodyOrientations.isEmpty()) {
                coordinateSystem.hide();
                continue;
            }
            coordinateSystem.setOrientation((FrameQuaternionReadOnly)this.rigidBodyOrientations.get(0));
        }
        for (i = 0; i < this.rigidBodiesWithVisualization.size(); ++i) {
            endEffector = this.rigidBodiesWithVisualization.get(i);
            coordinateSystem = this.currentCoodinateSystems.get(endEffector);
            this.feedbackControllerDataHolder.getPositionData(endEffector, this.rigidBodyPositions, Type.CURRENT);
            if (this.rigidBodyPositions.isEmpty()) {
                coordinateSystem.hide();
            } else {
                coordinateSystem.setPosition((FramePoint3DReadOnly)this.rigidBodyPositions.get(0));
            }
            this.feedbackControllerDataHolder.getOrientationData(endEffector, this.rigidBodyOrientations, Type.CURRENT);
            if (this.rigidBodyOrientations.isEmpty()) {
                coordinateSystem.hide();
                continue;
            }
            coordinateSystem.setOrientation((FrameQuaternionReadOnly)this.rigidBodyOrientations.get(0));
        }
    }

    private void snapPrivilegedConfigurationToCurrent() {
        this.privilegedConfigurationCommand.clear();
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            this.privilegedConfigurationCommand.addJoint(this.oneDoFJoints[i], this.oneDoFJoints[i].getQ());
        }
        this.privilegedConfigurationCommand.setDefaultWeight(this.privilegedWeight.getDoubleValue());
        this.privilegedConfigurationCommand.setDefaultConfigurationGain(this.privilegedConfigurationGain.getDoubleValue());
        this.privilegedConfigurationCommand.setDefaultMaxVelocity(this.privilegedMaxVelocity.getDoubleValue());
        this.submitPrivilegedConfigurationCommand = true;
    }

    public void updateRobotConfigurationData(RobotConfigurationData newConfigurationData) {
        ((RobotConfigurationData)this.concurrentRobotConfigurationDataCopier.getCopyForWriting()).set(newConfigurationData);
        this.concurrentRobotConfigurationDataCopier.commit();
    }

    public boolean isUserControllingRigidBody(RigidBodyBasics rigidBody) {
        RecyclingArrayList currentFBCommands = this.userFBCommands.getSpatialFeedbackControlCommandBuffer();
        for (int i = 0; i < currentFBCommands.size(); ++i) {
            if (((SpatialFeedbackControlCommand)currentFBCommands.get(i)).getEndEffector() != rigidBody) continue;
            return true;
        }
        RecyclingArrayList previousFBCommands = this.previousUserFBCommands.getSpatialFeedbackControlCommandBuffer();
        for (int i = 0; i < previousFBCommands.size(); ++i) {
            if (((SpatialFeedbackControlCommand)previousFBCommands.get(i)).getEndEffector() != rigidBody) continue;
            return true;
        }
        return false;
    }

    public boolean isUserControllingJoint(OneDoFJointBasics joint) {
        RecyclingArrayList currentFBCommands = this.userFBCommands.getOneDoFJointFeedbackControlCommandBuffer();
        for (int i = 0; i < currentFBCommands.size(); ++i) {
            if (((OneDoFJointFeedbackControlCommand)currentFBCommands.get(i)).getJoint() != joint) continue;
            return true;
        }
        RecyclingArrayList previousFBCommands = this.previousUserFBCommands.getOneDoFJointFeedbackControlCommandBuffer();
        for (int i = 0; i < previousFBCommands.size(); ++i) {
            if (((OneDoFJointFeedbackControlCommand)previousFBCommands.get(i)).getJoint() != joint) continue;
            return true;
        }
        return false;
    }

    public boolean isUserControllingCenterOfMass() {
        return !this.userFBCommands.getCenterOfMassFeedbackControlCommandBuffer().isEmpty() || !this.previousUserFBCommands.getCenterOfMassFeedbackControlCommandBuffer().isEmpty();
    }

    public boolean isUserProvidingSupportPolygon() {
        return this.isUserProvidingSupportPolygon.getValue();
    }

    public YoPIDSE3Gains getDefaultSpatialGains() {
        return this.spatialGains;
    }

    public YoPIDGains getDefaultJointGains() {
        return this.jointGains;
    }

    protected void getAdditionalFeedbackControlCommands(FeedbackControlCommandBuffer bufferToPack) {
    }

    protected void getAdditionalInverseKinematicsCommands(InverseKinematicsCommandBuffer bufferToPack) {
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public FloatingJointBasics getDesiredRootJoint() {
        return this.rootJoint;
    }

    public OneDoFJointBasics[] getDesiredOneDoFJoint() {
        return this.oneDoFJoints;
    }

    public Collection<? extends RigidBodyBasics> getControllableRigidBodies() {
        return this.controllableRigidBodies;
    }

    public KinematicsToolboxOutputStatus getSolution() {
        return this.inverseKinematicsSolution;
    }

    public FeedbackControllerDataHolderReadOnly getFeedbackControllerDataHolder() {
        return this.feedbackControllerDataHolder;
    }

    public void setPublishingSolutionPeriod(double periodInSeconds) {
        this.publishSolutionPeriod.set(periodInSeconds);
    }

    public void setPreserveUserCommandHistory(boolean value) {
        this.preserveUserCommandHistory.set(value);
    }

    public void minimizeAngularMomentum(boolean enable) {
        this.minimizeAngularMomentum.set(enable);
    }

    public double getUpdateDT() {
        return this.updateDT;
    }

    public YoDouble getCenterOfMassSafeMargin() {
        return this.centerOfMassSafeMargin;
    }

    public TObjectDoubleHashMap<OneDoFJointBasics> getInitialRobotConfigurationMap() {
        return this.initialRobotConfigurationMap;
    }
}

