/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinematicsToolboxModule;

import controller_msgs.msg.dds.RobotConfigurationData;
import gnu.trove.list.array.TFloatArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutputReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxCenterOfMassCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxOneDoFJointCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxPrivilegedConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxRigidBodyCommand;
import us.ihmc.idl.IDLSequence;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;

public class KinematicsToolboxHelper {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    public static final FrameVector3DReadOnly zeroVector3D = new FrameVector3D(worldFrame);
    public static final SpatialVectorReadOnly zeroVector6D = new SpatialVector(worldFrame);

    static CenterOfMassFeedbackControlCommand consumeCenterOfMassCommand(KinematicsToolboxCenterOfMassCommand command, PID3DGains gains) {
        CenterOfMassFeedbackControlCommand feedbackControlCommand = new CenterOfMassFeedbackControlCommand();
        KinematicsToolboxHelper.consumeCenterOfMassCommand(command, gains, feedbackControlCommand);
        return feedbackControlCommand;
    }

    static void consumeCenterOfMassCommand(KinematicsToolboxCenterOfMassCommand command, PID3DGains gains, CenterOfMassFeedbackControlCommand feedbackControlCommandToPack) {
        feedbackControlCommandToPack.setGains(gains);
        feedbackControlCommandToPack.setWeightsForSolver(command.getWeightVector());
        feedbackControlCommandToPack.setSelectionMatrix(command.getSelectionMatrix());
        feedbackControlCommandToPack.setInverseKinematics((FramePoint3DReadOnly)command.getDesiredPosition(), zeroVector3D);
    }

    static SpatialFeedbackControlCommand consumeRigidBodyCommand(KinematicsToolboxRigidBodyCommand command, RigidBodyBasics base, PIDSE3Gains gains) {
        SpatialFeedbackControlCommand feedbackControlCommand = new SpatialFeedbackControlCommand();
        KinematicsToolboxHelper.consumeRigidBodyCommand(command, base, gains, feedbackControlCommand);
        return feedbackControlCommand;
    }

    public static void consumeRigidBodyCommand(KinematicsToolboxRigidBodyCommand command, RigidBodyBasics base, PIDSE3Gains gains, SpatialFeedbackControlCommand feedbackControlCommandToPack) {
        feedbackControlCommandToPack.set(base, command.getEndEffector());
        feedbackControlCommandToPack.setGains((PIDSE3GainsReadOnly)gains);
        feedbackControlCommandToPack.setWeightMatrixForSolver(command.getWeightMatrix());
        feedbackControlCommandToPack.setSelectionMatrix(command.getSelectionMatrix());
        feedbackControlCommandToPack.setInverseKinematics((FramePose3DReadOnly)command.getDesiredPose(), zeroVector6D);
        feedbackControlCommandToPack.setControlFrameFixedInEndEffector((FramePose3DReadOnly)command.getControlFramePose());
    }

    public static void consumeJointCommand(KinematicsToolboxOneDoFJointCommand command, PIDGainsReadOnly gains, OneDoFJointFeedbackControlCommand feedbackControlCommandToPack) {
        feedbackControlCommandToPack.setJoint(command.getJoint());
        feedbackControlCommandToPack.setGains((PDGainsReadOnly)gains);
        feedbackControlCommandToPack.setWeightForSolver(command.getWeight());
        feedbackControlCommandToPack.setInverseKinematics(command.getDesiredPosition(), 0.0);
    }

    public static void setRobotStateFromControllerCoreOutput(ControllerCoreOutputReadOnly controllerCoreOutput, FloatingJointBasics rootJoint, OneDoFJointBasics[] oneDoFJoints) {
        RootJointDesiredConfigurationDataReadOnly outputForRootJoint = controllerCoreOutput.getRootJointDesiredConfigurationData();
        if (rootJoint != null) {
            rootJoint.setJointConfiguration(0, (DMatrix)outputForRootJoint.getDesiredConfiguration());
            rootJoint.setJointVelocity(0, (DMatrix)outputForRootJoint.getDesiredVelocity());
        }
        JointDesiredOutputListReadOnly output = controllerCoreOutput.getLowLevelOneDoFJointDesiredDataHolder();
        for (OneDoFJointBasics joint : oneDoFJoints) {
            if (!output.hasDataForJoint((OneDoFJointReadOnly)joint)) continue;
            JointDesiredOutputReadOnly data = output.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            joint.setQ(data.getDesiredPosition());
            joint.setQd(data.getDesiredVelocity());
        }
        if (rootJoint != null) {
            rootJoint.getPredecessor().updateFramesRecursively();
        } else {
            oneDoFJoints[0].getPredecessor().updateFramesRecursively();
        }
    }

    public static void setRobotStateFromRobotConfigurationData(RobotConfigurationData robotConfigurationData, FloatingJointBasics rootJoint, OneDoFJointBasics[] oneDoFJoints) {
        IDLSequence.Float newJointAngles = robotConfigurationData.getJointAngles();
        for (int i = 0; i < newJointAngles.size(); ++i) {
            oneDoFJoints[i].setQ((double)newJointAngles.get(i));
            oneDoFJoints[i].setQd(0.0);
            oneDoFJoints[i].updateFrame();
        }
        if (rootJoint != null) {
            Vector3D translation = robotConfigurationData.getRootTranslation();
            rootJoint.getJointPose().getPosition().set(translation.getX(), translation.getY(), translation.getZ());
            Quaternion orientation = robotConfigurationData.getRootOrientation();
            rootJoint.getJointPose().getOrientation().setQuaternion(orientation.getX(), orientation.getY(), orientation.getZ(), orientation.getS());
            rootJoint.setJointVelocity(0, (DMatrix)new DMatrixRMaj(6, 1));
            rootJoint.updateFrame();
        }
    }

    public static void setRobotStateFromRawData(Pose3DReadOnly pelvisPose, List<Double> jointAngles, FloatingJointBasics desiredRootJoint, OneDoFJointBasics[] oneDoFJoints) {
        for (int i = 0; i < jointAngles.size(); ++i) {
            oneDoFJoints[i].setQ(jointAngles.get(i).doubleValue());
            oneDoFJoints[i].setQd(0.0);
        }
        if (desiredRootJoint != null) {
            desiredRootJoint.getJointPose().set(pelvisPose);
            desiredRootJoint.setJointVelocity(0, (DMatrix)new DMatrixRMaj(6, 1));
            desiredRootJoint.getPredecessor().updateFramesRecursively();
        }
    }

    static void setRobotStateFromPrivilegedConfigurationData(KinematicsToolboxPrivilegedConfigurationCommand commandWithPrivilegedConfiguration, FloatingJointBasics desiredRootJoint) {
        boolean hasPrivilegedRooJointOrientation;
        boolean hasPrivilegedRooJointPosition;
        boolean hasPrivilegedJointAngles = commandWithPrivilegedConfiguration.hasPrivilegedJointAngles();
        if (hasPrivilegedJointAngles) {
            List joints = commandWithPrivilegedConfiguration.getJoints();
            TFloatArrayList privilegedJointAngles = commandWithPrivilegedConfiguration.getPrivilegedJointAngles();
            for (int i = 0; i < privilegedJointAngles.size(); ++i) {
                OneDoFJointBasics joint = (OneDoFJointBasics)joints.get(i);
                joint.setQ((double)privilegedJointAngles.get(i));
                joint.setQd(0.0);
                joint.getFrameAfterJoint().update();
            }
        }
        if (hasPrivilegedRooJointPosition = commandWithPrivilegedConfiguration.hasPrivilegedRootJointPosition()) {
            desiredRootJoint.setJointPosition((Tuple3DReadOnly)commandWithPrivilegedConfiguration.getPrivilegedRootJointPosition());
            desiredRootJoint.setJointVelocity(0, (DMatrix)new DMatrixRMaj(6, 1));
            desiredRootJoint.getFrameAfterJoint().update();
        }
        if (hasPrivilegedRooJointOrientation = commandWithPrivilegedConfiguration.hasPrivilegedRootJointOrientation()) {
            desiredRootJoint.setJointOrientation((Orientation3DReadOnly)commandWithPrivilegedConfiguration.getPrivilegedRootJointOrientation());
            desiredRootJoint.setJointVelocity(0, (DMatrix)new DMatrixRMaj(6, 1));
            desiredRootJoint.getFrameAfterJoint().update();
        }
    }
}

