/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule;

import controller_msgs.msg.dds.JointspaceStreamingMessage;
import controller_msgs.msg.dds.KinematicsToolboxOutputStatus;
import controller_msgs.msg.dds.SE3StreamingMessage;
import controller_msgs.msg.dds.SO3StreamingMessage;
import controller_msgs.msg.dds.WholeBodyStreamingMessage;
import us.ihmc.commons.MathTools;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class KSTStreamingMessageFactory {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final FullHumanoidRobotModel fullRobotModel;
    private final HumanoidReferenceFrames referenceFrames;
    private final FloatingJointBasics rootJoint;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final OneDoFJointBasics[] neckJoints;
    private final SideDependentList<OneDoFJointBasics[]> armJoints = new SideDependentList();
    private WholeBodyStreamingMessage output;
    private boolean enableVelocity = false;
    private final FramePose3D desiredPose = new FramePose3D(worldFrame);
    private final SpatialVector desiredSpatialVelocity = new SpatialVector();
    private final FrameQuaternion desiredOrientation = new FrameQuaternion();
    private final FrameVector3D desiredAngularVelocity = new FrameVector3D();

    public KSTStreamingMessageFactory(FullHumanoidRobotModelFactory fullRobotModelFactory) {
        this.fullRobotModel = fullRobotModelFactory.createFullRobotModel();
        this.rootJoint = this.fullRobotModel.getRootJoint();
        this.oneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel);
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        RigidBodyBasics head = this.fullRobotModel.getHead();
        RigidBodyBasics chest = this.fullRobotModel.getChest();
        this.neckJoints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)chest, (RigidBodyBasics)head);
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics hand = this.fullRobotModel.getHand(robotSide);
            this.armJoints.put((Enum)robotSide, (Object)MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)chest, (RigidBodyBasics)hand));
        }
    }

    public void updateFullRobotModel(KinematicsToolboxOutputStatus solution) {
        MessageTools.unpackDesiredJointState((KinematicsToolboxOutputStatus)solution, (FloatingJointBasics)this.rootJoint, (OneDoFJointBasics[])this.oneDoFJoints);
        this.referenceFrames.updateFrames();
    }

    public void setMessageToCreate(WholeBodyStreamingMessage message) {
        this.output = message;
    }

    public void setEnableVelocity(boolean enable) {
        this.enableVelocity = enable;
    }

    public void computeArmStreamingMessages() {
        this.checkIfDataHasBeenSet();
        for (RobotSide robotSide : RobotSide.values) {
            this.computeArmStreamingMessage(robotSide);
        }
    }

    public void computeArmStreamingMessage(RobotSide robotSide) {
        this.checkIfDataHasBeenSet();
        OneDoFJointBasics[] joints = (OneDoFJointBasics[])this.armJoints.get((Enum)robotSide);
        int numberOfArmJoints = joints.length;
        JointspaceStreamingMessage armStreamingMessage = KSTStreamingMessageFactory.select(robotSide, this.output.getLeftArmStreamingMessage(), this.output.getRightArmStreamingMessage());
        armStreamingMessage.getPositions().reset();
        armStreamingMessage.getVelocities().reset();
        for (int i = 0; i < numberOfArmJoints; ++i) {
            OneDoFJointBasics joint = joints[i];
            armStreamingMessage.getPositions().add(KSTStreamingMessageFactory.getJointPosition((OneDoFJointReadOnly)joint));
            armStreamingMessage.getVelocities().add((float)(this.enableVelocity ? joint.getQd() : 0.0));
        }
        if (robotSide == RobotSide.LEFT) {
            this.output.setHasLeftArmStreamingMessage(true);
        } else {
            this.output.setHasRightArmStreamingMessage(true);
        }
    }

    public void computeHandStreamingMessages() {
        for (RobotSide robotSide : RobotSide.values) {
            this.computeHandStreamingMessage(robotSide);
        }
    }

    public void computeHandStreamingMessage(RobotSide robotSide) {
        this.checkIfDataHasBeenSet();
        MovingReferenceFrame handControlFrame = this.fullRobotModel.getHandControlFrame(robotSide);
        this.desiredPose.setToZero((ReferenceFrame)handControlFrame);
        this.desiredPose.changeFrame(worldFrame);
        KSTStreamingMessageFactory.spatialVelocity(handControlFrame, worldFrame, this.enableVelocity, (SpatialVectorBasics)this.desiredSpatialVelocity);
        SE3StreamingMessage handStreamingMessage = KSTStreamingMessageFactory.select(robotSide, this.output.getLeftHandStreamingMessage(), this.output.getRightHandStreamingMessage());
        KSTStreamingMessageFactory.packCustomControlFrame((ReferenceFrame)this.fullRobotModel.getHand(robotSide).getBodyFixedFrame(), (ReferenceFrame)handControlFrame, handStreamingMessage);
        handStreamingMessage.getFrameInformation().setTrajectoryReferenceFrameId((long)worldFrame.hashCode());
        KSTStreamingMessageFactory.packSE3TrajectoryPointMessage((Pose3DReadOnly)this.desiredPose, (SpatialVectorReadOnly)this.desiredSpatialVelocity, handStreamingMessage);
        if (robotSide == RobotSide.LEFT) {
            this.output.setHasLeftHandStreamingMessage(true);
        } else {
            this.output.setHasRightHandStreamingMessage(true);
        }
    }

    public void computeNeckStreamingMessage() {
        this.checkIfDataHasBeenSet();
        int numberOfJoints = this.neckJoints.length;
        JointspaceStreamingMessage neckStreamingMessage = this.output.getNeckStreamingMessage();
        neckStreamingMessage.getPositions().reset();
        neckStreamingMessage.getVelocities().reset();
        for (int i = 0; i < numberOfJoints; ++i) {
            OneDoFJointBasics joint = this.neckJoints[i];
            neckStreamingMessage.getPositions().add(KSTStreamingMessageFactory.getJointPosition((OneDoFJointReadOnly)joint));
            neckStreamingMessage.getVelocities().add((float)(this.enableVelocity ? joint.getQd() : 0.0));
        }
        this.output.setHasNeckStreamingMessage(true);
    }

    public void computeChestStreamingMessage() {
        this.computeChestStreamingMessage((ReferenceFrame)this.referenceFrames.getPelvisZUpFrame());
    }

    public void computeChestStreamingMessage(ReferenceFrame trajectoryFrame) {
        this.checkIfDataHasBeenSet();
        MovingReferenceFrame chestFrame = this.fullRobotModel.getChest().getBodyFixedFrame();
        this.desiredOrientation.setToZero((ReferenceFrame)chestFrame);
        this.desiredOrientation.changeFrame(worldFrame);
        KSTStreamingMessageFactory.angularVelocity(chestFrame, worldFrame, this.enableVelocity, (FrameVector3DBasics)this.desiredAngularVelocity);
        SO3StreamingMessage chestStreamingMessage = this.output.getChestStreamingMessage();
        chestStreamingMessage.getFrameInformation().setTrajectoryReferenceFrameId((long)trajectoryFrame.hashCode());
        chestStreamingMessage.getFrameInformation().setDataReferenceFrameId((long)worldFrame.hashCode());
        KSTStreamingMessageFactory.packSO3TrajectoryPointMessage((Orientation3DReadOnly)this.desiredOrientation, (Vector3DReadOnly)this.desiredAngularVelocity, chestStreamingMessage);
        this.output.setHasChestStreamingMessage(true);
    }

    public void computePelvisStreamingMessage() {
        this.checkIfDataHasBeenSet();
        MovingReferenceFrame pelvisFrame = this.fullRobotModel.getRootJoint().getFrameAfterJoint();
        this.desiredPose.setToZero((ReferenceFrame)pelvisFrame);
        this.desiredPose.changeFrame(worldFrame);
        KSTStreamingMessageFactory.spatialVelocity(pelvisFrame, worldFrame, this.enableVelocity, (SpatialVectorBasics)this.desiredSpatialVelocity);
        SE3StreamingMessage pelvisStreamingMessage = this.output.getPelvisStreamingMessage();
        pelvisStreamingMessage.getFrameInformation().setTrajectoryReferenceFrameId((long)worldFrame.hashCode());
        KSTStreamingMessageFactory.packSE3TrajectoryPointMessage((Pose3DReadOnly)this.desiredPose, (SpatialVectorReadOnly)this.desiredSpatialVelocity, pelvisStreamingMessage);
        this.output.setHasPelvisStreamingMessage(true);
    }

    private static <T> T select(RobotSide robotSide, T left, T right) {
        return robotSide == RobotSide.LEFT ? left : right;
    }

    private static void angularVelocity(MovingReferenceFrame movingFrame, ReferenceFrame outputFrame, boolean enableVelocity, FrameVector3DBasics angularVelocityToPack) {
        if (!enableVelocity) {
            angularVelocityToPack.setToZero(outputFrame);
        } else {
            angularVelocityToPack.setIncludingFrame((FrameTuple3DReadOnly)movingFrame.getTwistOfFrame().getAngularPart());
            angularVelocityToPack.changeFrame(outputFrame);
        }
    }

    private static void spatialVelocity(MovingReferenceFrame movingFrame, ReferenceFrame outputFrame, boolean enableVelocity, SpatialVectorBasics spatialVelocityToPack) {
        if (!enableVelocity) {
            spatialVelocityToPack.setToZero(outputFrame);
        } else {
            spatialVelocityToPack.setIncludingFrame((SpatialVectorReadOnly)movingFrame.getTwistOfFrame());
            spatialVelocityToPack.changeFrame(outputFrame);
        }
    }

    public static float getJointPosition(OneDoFJointReadOnly joint) {
        return (float)MathTools.clamp((double)((float)joint.getQ()), (double)(joint.getJointLimitLower() + 1.0E-7), (double)(joint.getJointLimitUpper() - 1.0E-7));
    }

    public static void packCustomControlFrame(ReferenceFrame endEffectorFrame, ReferenceFrame controlFrame, SE3StreamingMessage messageToPack) {
        messageToPack.setUseCustomControlFrame(true);
        Pose3D controlFramePose = messageToPack.getControlFramePose();
        controlFramePose.setToZero();
        controlFrame.transformFromThisToDesiredFrame(endEffectorFrame, (Transformable)controlFramePose);
    }

    public static void packSO3TrajectoryPointMessage(Orientation3DReadOnly orientation, Vector3DReadOnly angularVelocity, SO3StreamingMessage messageToPack) {
        messageToPack.getOrientation().set(orientation);
        messageToPack.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
    }

    public static void packSE3TrajectoryPointMessage(Pose3DReadOnly pose, SpatialVectorReadOnly spatialVelocity, SE3StreamingMessage messageToPack) {
        messageToPack.getPosition().set((Tuple3DReadOnly)pose.getPosition());
        messageToPack.getOrientation().set(pose.getOrientation());
        messageToPack.getLinearVelocity().set((Tuple3DReadOnly)spatialVelocity.getLinearPart());
        messageToPack.getAngularVelocity().set((Tuple3DReadOnly)spatialVelocity.getAngularPart());
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    private void checkIfDataHasBeenSet() {
        if (this.output == null) {
            throw new RuntimeException("Need to call setMessageToCreate() first.");
        }
    }

    public FloatingJointBasics getRootJoint() {
        return this.rootJoint;
    }

    public OneDoFJointBasics[] getOneDoFJoints() {
        return this.oneDoFJoints;
    }
}

