/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.KinematicsToolboxOutputStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WholeBodyStreamingMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import java.util.Arrays;
import java.util.Collections;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxModule;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KSTStreamingMessageFactory;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.YoKinematicsToolboxOutputStatus;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.kinematicsStreamingToolboxAPI.KinematicsStreamingToolboxInputCommand;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.KinematicsToolboxOutputConverter;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class KSTTools {
    private final CommandInputManager commandInputManager;
    private final CommandInputManager ikCommandInputManager;
    private final StatusMessageOutputManager statusOutputManager;
    private final FullHumanoidRobotModel desiredFullRobotModel;
    private final FullHumanoidRobotModelFactory fullRobotModelFactory;
    private final DoubleProvider time;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final YoRegistry registry;
    private final FullHumanoidRobotModel currentFullRobotModel;
    private final FloatingJointBasics currentRootJoint;
    private final OneDoFJointBasics[] currentOneDoFJoint;
    private final HumanoidKinematicsToolboxController ikController;
    private final KSTStreamingMessageFactory streamingMessageFactory;
    private final KinematicsToolboxOutputConverter trajectoryMessageFactory;
    private final WholeBodyStreamingMessage wholeBodyStreamingMessage = new WholeBodyStreamingMessage();
    private final WholeBodyTrajectoryMessage wholeBodyTrajectoryMessage = new WholeBodyTrajectoryMessage();
    private final YoDouble streamIntegrationDuration;
    private final ConcurrentCopier<RobotConfigurationData> concurrentRobotConfigurationDataCopier = new ConcurrentCopier(RobotConfigurationData::new);
    private boolean hasRobotDataConfiguration = false;
    private final RobotConfigurationData robotConfigurationDataInternal = new RobotConfigurationData();
    private final ConcurrentCopier<CapturabilityBasedStatus> concurrentCapturabilityBasedStatusCopier = new ConcurrentCopier(CapturabilityBasedStatus::new);
    private boolean hasCapturabilityBasedStatus = false;
    private final CapturabilityBasedStatus capturabilityBasedStatusInternal = new CapturabilityBasedStatus();
    private final double walkingControllerPeriod;
    private final double toolboxControllerPeriod;
    private final YoDouble walkingControllerMonotonicTime;
    private final YoDouble walkingControllerWallTime;
    private long currentMessageId = 1L;
    private final YoBoolean hasNewInputCommand;
    private final YoBoolean hasPreviousInput;
    private final YoDouble latestInputReceivedTime;
    private final YoDouble previousInputReceivedTime;
    private KinematicsStreamingToolboxInputCommand latestInput = null;
    private KinematicsStreamingToolboxInputCommand previousInput = new KinematicsStreamingToolboxInputCommand();
    private final KinematicsStreamingToolboxConfigurationCommand configurationCommand = new KinematicsStreamingToolboxConfigurationCommand();
    private final YoBoolean isNeckJointspaceOutputEnabled;
    private final YoBoolean isChestTaskspaceOutputEnabled;
    private final YoBoolean isPelvisTaskspaceOutputEnabled;
    private final SideDependentList<YoBoolean> areHandTaskspaceOutputsEnabled = new SideDependentList();
    private final SideDependentList<YoBoolean> areArmJointspaceOutputsEnabled = new SideDependentList();
    private final YoLong latestInputTimestamp;

    public KSTTools(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FullHumanoidRobotModel desiredFullRobotModel, FullHumanoidRobotModelFactory fullRobotModelFactory, double walkingControllerPeriod, double toolboxControllerPeriod, DoubleProvider time, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry) {
        this.commandInputManager = commandInputManager;
        this.statusOutputManager = statusOutputManager;
        this.desiredFullRobotModel = desiredFullRobotModel;
        this.fullRobotModelFactory = fullRobotModelFactory;
        this.walkingControllerPeriod = walkingControllerPeriod;
        this.toolboxControllerPeriod = toolboxControllerPeriod;
        this.time = time;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        this.registry = registry;
        this.walkingControllerMonotonicTime = new YoDouble("walkingControllerMonotonicTime", registry);
        this.walkingControllerWallTime = new YoDouble("walkingControllerWallTime", registry);
        this.currentFullRobotModel = fullRobotModelFactory.createFullRobotModel();
        this.currentRootJoint = this.currentFullRobotModel.getRootJoint();
        this.currentOneDoFJoint = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.currentFullRobotModel);
        this.ikCommandInputManager = new CommandInputManager(HumanoidKinematicsToolboxController.class.getSimpleName(), KinematicsToolboxModule.supportedCommands(), 32);
        this.ikController = new HumanoidKinematicsToolboxController(this.ikCommandInputManager, statusOutputManager, desiredFullRobotModel, fullRobotModelFactory, toolboxControllerPeriod, yoGraphicsListRegistry, registry);
        this.ikCommandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsToolboxCommandConverter(desiredFullRobotModel));
        this.ikController.setPreserveUserCommandHistory(false);
        this.ikController.minimizeAngularMomentum(true);
        this.streamingMessageFactory = new KSTStreamingMessageFactory(fullRobotModelFactory);
        this.trajectoryMessageFactory = new KinematicsToolboxOutputConverter(fullRobotModelFactory);
        this.streamIntegrationDuration = new YoDouble("streamIntegrationDuration", registry);
        this.streamIntegrationDuration.set(0.3);
        this.hasNewInputCommand = new YoBoolean("hasNewInputCommand", registry);
        this.hasPreviousInput = new YoBoolean("hasPreviousInput", registry);
        this.latestInputReceivedTime = new YoDouble("latestInputReceivedTime", registry);
        this.previousInputReceivedTime = new YoDouble("previousInputReceivedTime", registry);
        this.flushInputCommands();
        this.isNeckJointspaceOutputEnabled = new YoBoolean("isNeckJointspaceOutputEnabled", registry);
        this.isChestTaskspaceOutputEnabled = new YoBoolean("isChestTaskspaceOutputEnabled", registry);
        this.isPelvisTaskspaceOutputEnabled = new YoBoolean("isPelvisTaskspaceOutputEnabled", registry);
        for (RobotSide robotSide : RobotSide.values) {
            YoBoolean isHandTaskspaceOutputEnabled = new YoBoolean("is" + robotSide.getPascalCaseName() + "HandTaskspaceOutputEnabled", registry);
            this.areHandTaskspaceOutputsEnabled.put((Enum)robotSide, (Object)isHandTaskspaceOutputEnabled);
            YoBoolean isArmJointspaceOutputEnabled = new YoBoolean("is" + robotSide.getPascalCaseName() + "ArmJointspaceOutputEnabled", registry);
            this.areArmJointspaceOutputsEnabled.put((Enum)robotSide, (Object)isArmJointspaceOutputEnabled);
        }
        this.latestInputTimestamp = new YoLong("latestInputTimestamp", registry);
    }

    public void update() {
        CapturabilityBasedStatus newCapturabilityBasedStatus;
        if (this.commandInputManager.isNewCommandAvailable(KinematicsStreamingToolboxConfigurationCommand.class)) {
            this.configurationCommand.set((KinematicsStreamingToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(KinematicsStreamingToolboxConfigurationCommand.class));
        }
        this.isNeckJointspaceOutputEnabled.set(this.configurationCommand.isNeckJointspaceEnabled());
        this.isChestTaskspaceOutputEnabled.set(this.configurationCommand.isChestTaskspaceEnabled());
        this.isPelvisTaskspaceOutputEnabled.set(this.configurationCommand.isPelvisTaskspaceEnabled());
        for (RobotSide robotSide : RobotSide.values) {
            ((YoBoolean)this.areHandTaskspaceOutputsEnabled.get((Enum)robotSide)).set(this.configurationCommand.isHandTaskspaceEnabled(robotSide));
            ((YoBoolean)this.areArmJointspaceOutputsEnabled.get((Enum)robotSide)).set(this.configurationCommand.isArmJointspaceEnabled(robotSide));
        }
        RobotConfigurationData newRobotConfigurationData = (RobotConfigurationData)this.concurrentRobotConfigurationDataCopier.getCopyForReading();
        if (newRobotConfigurationData != null) {
            this.robotConfigurationDataInternal.set(newRobotConfigurationData);
            this.hasRobotDataConfiguration = true;
        }
        if ((newCapturabilityBasedStatus = (CapturabilityBasedStatus)this.concurrentCapturabilityBasedStatusCopier.getCopyForReading()) != null) {
            this.capturabilityBasedStatusInternal.set(newCapturabilityBasedStatus);
            this.hasCapturabilityBasedStatus = true;
        }
        if (this.hasRobotDataConfiguration) {
            this.walkingControllerMonotonicTime.set(Conversions.nanosecondsToSeconds((long)this.robotConfigurationDataInternal.getMonotonicTime()));
            this.walkingControllerWallTime.set(Conversions.nanosecondsToSeconds((long)this.robotConfigurationDataInternal.getWallTime()));
            for (int jointIndex = 0; jointIndex < this.currentOneDoFJoint.length; ++jointIndex) {
                this.currentOneDoFJoint[jointIndex].setQ((double)this.robotConfigurationDataInternal.getJointAngles().get(jointIndex));
            }
            Pose3DBasics rootJointPose = this.currentRootJoint.getJointPose();
            rootJointPose.set((Tuple3DReadOnly)this.robotConfigurationDataInternal.getRootTranslation(), (Orientation3DReadOnly)this.robotConfigurationDataInternal.getRootOrientation());
            this.currentFullRobotModel.updateFrames();
        }
    }

    public double getTime() {
        return this.time.getValue();
    }

    public KinematicsStreamingToolboxConfigurationCommand getConfigurationCommand() {
        return this.configurationCommand;
    }

    public void getCurrentState(KinematicsToolboxOutputStatus currentStateToPack) {
        MessageTools.packDesiredJointState((KinematicsToolboxOutputStatus)currentStateToPack, (FloatingJointReadOnly)this.currentFullRobotModel.getRootJoint(), (OneDoFJointReadOnly[])this.currentOneDoFJoint);
    }

    public void getCurrentState(YoKinematicsToolboxOutputStatus currentStateToPack) {
        KinematicsToolboxOutputStatus status = currentStateToPack.getStatus();
        MessageTools.packDesiredJointState((KinematicsToolboxOutputStatus)status, (FloatingJointReadOnly)this.currentFullRobotModel.getRootJoint(), (OneDoFJointReadOnly[])this.currentOneDoFJoint);
        currentStateToPack.set(status);
    }

    public void pollInputCommand() {
        this.hasNewInputCommand.set(this.commandInputManager.isNewCommandAvailable(KinematicsStreamingToolboxInputCommand.class));
        if (this.hasNewInputCommand.getValue()) {
            if (this.latestInput != null) {
                this.previousInput.set(this.latestInput);
                this.previousInputReceivedTime.set(this.latestInputReceivedTime.getValue());
                this.hasPreviousInput.set(true);
            }
            this.latestInput = (KinematicsStreamingToolboxInputCommand)this.commandInputManager.pollNewestCommand(KinematicsStreamingToolboxInputCommand.class);
            if (this.latestInput.getTimestamp() <= 0L) {
                this.latestInput.setTimestamp(Conversions.secondsToNanoseconds((double)this.time.getValue()));
            }
            this.latestInputTimestamp.set(this.latestInput.getTimestamp());
            this.latestInputReceivedTime.set(this.time.getValue());
        }
    }

    public boolean hasNewInputCommand() {
        return this.hasNewInputCommand.getValue();
    }

    public KinematicsStreamingToolboxInputCommand getLatestInput() {
        return this.latestInput;
    }

    public double getLatestInputReceivedTime() {
        return this.latestInputReceivedTime.getValue();
    }

    public boolean hasPreviousInput() {
        return this.hasPreviousInput.getValue();
    }

    public KinematicsStreamingToolboxInputCommand getPreviousInput() {
        return this.hasPreviousInput.getValue() ? this.previousInput : null;
    }

    public double getPreviousInputReceivedTime() {
        return this.previousInputReceivedTime.getValue();
    }

    public void flushInputCommands() {
        this.latestInput = null;
        this.commandInputManager.clearAllCommands();
        this.hasNewInputCommand.set(false);
        this.hasPreviousInput.set(false);
        this.latestInputReceivedTime.set(-1.0);
        this.previousInputReceivedTime.set(-1.0);
    }

    public WholeBodyStreamingMessage setupStreamingMessage(KinematicsToolboxOutputStatus solutionToConvert) {
        HumanoidMessageTools.resetWholeBodyStreamingMessage((WholeBodyStreamingMessage)this.wholeBodyStreamingMessage);
        this.streamingMessageFactory.updateFullRobotModel(solutionToConvert);
        this.streamingMessageFactory.setMessageToCreate(this.wholeBodyStreamingMessage);
        this.streamingMessageFactory.setEnableVelocity(true);
        for (RobotSide robotSide : RobotSide.values) {
            if (((YoBoolean)this.areHandTaskspaceOutputsEnabled.get((Enum)robotSide)).getValue()) {
                this.streamingMessageFactory.computeHandStreamingMessage(robotSide);
            }
            if (!((YoBoolean)this.areArmJointspaceOutputsEnabled.get((Enum)robotSide)).getValue()) continue;
            this.streamingMessageFactory.computeArmStreamingMessage(robotSide);
        }
        if (this.isNeckJointspaceOutputEnabled.getValue()) {
            this.streamingMessageFactory.computeNeckStreamingMessage();
        }
        if (this.isChestTaskspaceOutputEnabled.getValue()) {
            this.streamingMessageFactory.computeChestStreamingMessage(ReferenceFrame.getWorldFrame());
        }
        if (this.isPelvisTaskspaceOutputEnabled.getValue()) {
            this.streamingMessageFactory.computePelvisStreamingMessage();
        }
        this.wholeBodyStreamingMessage.setEnableUserPelvisControl(true);
        this.wholeBodyStreamingMessage.setStreamIntegrationDuration((float)this.streamIntegrationDuration.getValue());
        this.wholeBodyStreamingMessage.setTimestamp(Conversions.secondsToNanoseconds((double)this.time.getValue()));
        this.wholeBodyStreamingMessage.setSequenceId(this.currentMessageId++);
        this.wholeBodyStreamingMessage.setUniqueId(this.currentMessageId++);
        return this.wholeBodyStreamingMessage;
    }

    public WholeBodyTrajectoryMessage setupTrajectoryMessage(KinematicsToolboxOutputStatus solutionToConvert) {
        HumanoidMessageTools.resetWholeBodyTrajectoryToolboxMessage((WholeBodyTrajectoryMessage)this.wholeBodyTrajectoryMessage);
        this.trajectoryMessageFactory.updateFullRobotModel(solutionToConvert);
        this.trajectoryMessageFactory.setMessageToCreate(this.wholeBodyTrajectoryMessage);
        this.trajectoryMessageFactory.setTrajectoryTime(0.0);
        this.trajectoryMessageFactory.setEnableVelocity(true);
        for (RobotSide robotSide : RobotSide.values) {
            if (((YoBoolean)this.areHandTaskspaceOutputsEnabled.get((Enum)robotSide)).getValue()) {
                this.trajectoryMessageFactory.computeHandTrajectoryMessage(robotSide);
            }
            if (!((YoBoolean)this.areArmJointspaceOutputsEnabled.get((Enum)robotSide)).getValue()) continue;
            this.trajectoryMessageFactory.computeArmTrajectoryMessage(robotSide);
        }
        if (this.isNeckJointspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computeNeckTrajectoryMessage();
        }
        if (this.isChestTaskspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computeChestTrajectoryMessage(ReferenceFrame.getWorldFrame());
        }
        if (this.isPelvisTaskspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computePelvisTrajectoryMessage();
        }
        this.wholeBodyTrajectoryMessage.getPelvisTrajectoryMessage().setEnableUserPelvisControl(true);
        HumanoidMessageTools.configureForStreaming((WholeBodyTrajectoryMessage)this.wholeBodyTrajectoryMessage, (double)this.streamIntegrationDuration.getValue(), (long)Conversions.secondsToNanoseconds((double)this.time.getValue()));
        KSTTools.setAllIDs(this.wholeBodyTrajectoryMessage, this.currentMessageId++);
        return this.wholeBodyTrajectoryMessage;
    }

    public WholeBodyTrajectoryMessage setupFinalizeTrajectoryMessage(KinematicsToolboxOutputStatus solutionToConvert) {
        HumanoidMessageTools.resetWholeBodyTrajectoryToolboxMessage((WholeBodyTrajectoryMessage)this.wholeBodyTrajectoryMessage);
        this.trajectoryMessageFactory.updateFullRobotModel(solutionToConvert);
        this.trajectoryMessageFactory.setMessageToCreate(this.wholeBodyTrajectoryMessage);
        this.trajectoryMessageFactory.setTrajectoryTime(0.5);
        for (RobotSide robotSide : RobotSide.values) {
            if (((YoBoolean)this.areHandTaskspaceOutputsEnabled.get((Enum)robotSide)).getValue()) {
                this.trajectoryMessageFactory.computeHandTrajectoryMessage(robotSide);
            }
            if (!((YoBoolean)this.areArmJointspaceOutputsEnabled.get((Enum)robotSide)).getValue()) continue;
            this.trajectoryMessageFactory.computeArmTrajectoryMessage(robotSide);
        }
        if (this.isNeckJointspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computeNeckTrajectoryMessage();
        }
        if (this.isChestTaskspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computeChestTrajectoryMessage();
        }
        if (this.isPelvisTaskspaceOutputEnabled.getValue()) {
            this.trajectoryMessageFactory.computePelvisTrajectoryMessage();
        }
        this.wholeBodyTrajectoryMessage.getPelvisTrajectoryMessage().setEnableUserPelvisControl(false);
        HumanoidMessageTools.configureForOverriding((WholeBodyTrajectoryMessage)this.wholeBodyTrajectoryMessage);
        KSTTools.setAllIDs(this.wholeBodyTrajectoryMessage, this.currentMessageId++);
        return this.wholeBodyTrajectoryMessage;
    }

    private static void setAllIDs(WholeBodyTrajectoryMessage message, long id) {
        message.setSequenceId(id);
        message.getLeftHandTrajectoryMessage().setSequenceId(id);
        message.getRightHandTrajectoryMessage().setSequenceId(id);
        message.getLeftArmTrajectoryMessage().setSequenceId(id);
        message.getRightArmTrajectoryMessage().setSequenceId(id);
        message.getChestTrajectoryMessage().setSequenceId(id);
        message.getSpineTrajectoryMessage().setSequenceId(id);
        message.getPelvisTrajectoryMessage().setSequenceId(id);
        message.getLeftFootTrajectoryMessage().setSequenceId(id);
        message.getRightFootTrajectoryMessage().setSequenceId(id);
        message.getNeckTrajectoryMessage().setSequenceId(id);
        message.getHeadTrajectoryMessage().setSequenceId(id);
        message.setUniqueId(id);
        message.getLeftHandTrajectoryMessage().setUniqueId(id);
        message.getRightHandTrajectoryMessage().setUniqueId(id);
        message.getLeftArmTrajectoryMessage().setUniqueId(id);
        message.getRightArmTrajectoryMessage().setUniqueId(id);
        message.getChestTrajectoryMessage().setUniqueId(id);
        message.getSpineTrajectoryMessage().setUniqueId(id);
        message.getPelvisTrajectoryMessage().setUniqueId(id);
        message.getLeftFootTrajectoryMessage().setUniqueId(id);
        message.getRightFootTrajectoryMessage().setUniqueId(id);
        message.getNeckTrajectoryMessage().setUniqueId(id);
        message.getHeadTrajectoryMessage().setUniqueId(id);
        message.getLeftHandTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getRightHandTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getLeftArmTrajectoryMessage().getJointspaceTrajectory().getQueueingProperties().setMessageId(id);
        message.getRightArmTrajectoryMessage().getJointspaceTrajectory().getQueueingProperties().setMessageId(id);
        message.getChestTrajectoryMessage().getSo3Trajectory().getQueueingProperties().setMessageId(id);
        message.getSpineTrajectoryMessage().getJointspaceTrajectory().getQueueingProperties().setMessageId(id);
        message.getPelvisTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getLeftFootTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getRightFootTrajectoryMessage().getSe3Trajectory().getQueueingProperties().setMessageId(id);
        message.getNeckTrajectoryMessage().getJointspaceTrajectory().getQueueingProperties().setMessageId(id);
        message.getHeadTrajectoryMessage().getSo3Trajectory().getQueueingProperties().setMessageId(id);
    }

    public void updateRobotConfigurationData(RobotConfigurationData newConfigurationData) {
        ((RobotConfigurationData)this.concurrentRobotConfigurationDataCopier.getCopyForWriting()).set(newConfigurationData);
        this.concurrentRobotConfigurationDataCopier.commit();
        this.ikController.updateRobotConfigurationData(newConfigurationData);
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus newStatus) {
        ((CapturabilityBasedStatus)this.concurrentCapturabilityBasedStatusCopier.getCopyForWriting()).set(newStatus);
        this.concurrentCapturabilityBasedStatusCopier.commit();
        this.ikController.updateCapturabilityBasedStatus(newStatus);
    }

    public CommandInputManager getCommandInputManager() {
        return this.commandInputManager;
    }

    public CommandInputManager getIKCommandInputManager() {
        return this.ikCommandInputManager;
    }

    public StatusMessageOutputManager getStatusOutputManager() {
        return this.statusOutputManager;
    }

    public FullHumanoidRobotModel getDesiredFullRobotModel() {
        return this.desiredFullRobotModel;
    }

    public FullHumanoidRobotModelFactory getFullRobotModelFactory() {
        return this.fullRobotModelFactory;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public KinematicsToolboxOutputConverter getOutputConverter() {
        return this.trajectoryMessageFactory;
    }

    public FullHumanoidRobotModel getCurrentFullRobotModel() {
        return this.currentFullRobotModel;
    }

    public HumanoidKinematicsToolboxController getIKController() {
        return this.ikController;
    }

    public RobotConfigurationData getRobotConfigurationData() {
        return this.hasRobotDataConfiguration ? this.robotConfigurationDataInternal : null;
    }

    public CapturabilityBasedStatus getCapturabilityBasedStatus() {
        return this.hasCapturabilityBasedStatus ? this.capturabilityBasedStatusInternal : null;
    }

    public double getWalkingControllerPeriod() {
        return this.walkingControllerPeriod;
    }

    public double getToolboxControllerPeriod() {
        return this.toolboxControllerPeriod;
    }

    public static void updateFullRobotModel(RobotConfigurationData robotConfigurationData, FullHumanoidRobotModel fullRobotModelToUpdate) {
        OneDoFJointBasics[] joints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModelToUpdate);
        ForceSensorDefinition[] forceSensorDefinitions = fullRobotModelToUpdate.getForceSensorDefinitions();
        IMUDefinition[] imuDefinitions = fullRobotModelToUpdate.getIMUDefinitions();
        int jointNameHash = RobotConfigurationDataFactory.calculateJointNameHash((OneDoFJointReadOnly[])joints, (ForceSensorDefinition[])forceSensorDefinitions, (IMUDefinition[])imuDefinitions);
        if (robotConfigurationData.getJointNameHash() != jointNameHash) {
            throw new RuntimeException("Joint names do not match for RobotConfigurationData");
        }
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            joints[jointIndex].setQ((double)robotConfigurationData.getJointAngles().get(jointIndex));
        }
        Pose3DBasics rootJointPose = fullRobotModelToUpdate.getRootJoint().getJointPose();
        rootJointPose.set((Tuple3DReadOnly)robotConfigurationData.getRootTranslation(), (Orientation3DReadOnly)robotConfigurationData.getRootOrientation());
    }

    public static void copyRobotState(FullHumanoidRobotModel source, FullHumanoidRobotModel destination, JointStateType stateSelection) {
        MultiBodySystemTools.copyJointsState(Collections.singletonList(source.getRootJoint()), Collections.singletonList(destination.getRootJoint()), (JointStateType)stateSelection);
        MultiBodySystemTools.copyJointsState(Arrays.asList(source.getOneDoFJoints()), Arrays.asList(destination.getOneDoFJoints()), (JointStateType)stateSelection);
    }

    public static void computeLinearVelocity(double dt, FramePoint3DReadOnly previousPosition, FramePoint3DReadOnly currentPosition, FixedFrameVector3DBasics linearVelocityToPack) {
        linearVelocityToPack.sub((FrameTuple3DReadOnly)currentPosition, (FrameTuple3DReadOnly)previousPosition);
        linearVelocityToPack.scale(1.0 / dt);
    }

    public static void computeAngularVelocity(double dt, FrameQuaternionReadOnly previousOrientation, FrameQuaternionReadOnly currentOrientation, FixedFrameVector3DBasics angularVelocityToPack) {
        previousOrientation.checkReferenceFrameMatch((ReferenceFrameHolder)currentOrientation);
        previousOrientation.checkReferenceFrameMatch((ReferenceFrameHolder)angularVelocityToPack);
        double qDot_x = currentOrientation.getX() - previousOrientation.getX();
        double qDot_y = currentOrientation.getY() - previousOrientation.getY();
        double qDot_z = currentOrientation.getZ() - previousOrientation.getZ();
        double qDot_s = currentOrientation.getS() - previousOrientation.getS();
        double qx = -currentOrientation.getX();
        double qy = -currentOrientation.getY();
        double qz = -currentOrientation.getZ();
        double qs = currentOrientation.getS();
        double wx = qs * qDot_x + qx * qDot_s + qy * qDot_z - qz * qDot_y;
        double wy = qs * qDot_y - qx * qDot_z + qy * qDot_s + qz * qDot_x;
        double wz = qs * qDot_z + qx * qDot_y - qy * qDot_x + qz * qDot_s;
        angularVelocityToPack.set(wx, wy, wz);
        angularVelocityToPack.scale(2.0 / dt);
    }

    public static void integrateLinearVelocity(double dt, FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly linearVelocity, FixedFramePoint3DBasics finalPosition) {
        finalPosition.scaleAdd(dt, (FrameTuple3DReadOnly)linearVelocity, (FrameTuple3DReadOnly)initialPosition);
    }

    public static void integrateAngularVelocity(double dt, FrameQuaternionReadOnly initialOrientation, FrameVector3DReadOnly angularVelocity, FixedFrameQuaternionBasics finalOrientation) {
        double qInit_x = initialOrientation.getX();
        double qInit_y = initialOrientation.getY();
        double qInit_z = initialOrientation.getZ();
        double qInit_s = initialOrientation.getS();
        double x = angularVelocity.getX() * dt;
        double y = angularVelocity.getY() * dt;
        double z = angularVelocity.getZ() * dt;
        finalOrientation.setRotationVector(x, y, z);
        double qInt_x = finalOrientation.getX();
        double qInt_y = finalOrientation.getY();
        double qInt_z = finalOrientation.getZ();
        double qInt_s = finalOrientation.getS();
        double qFinal_x = qInit_s * qInt_x + qInit_x * qInt_s + qInit_y * qInt_z - qInit_z * qInt_y;
        double qFinal_y = qInit_s * qInt_y - qInit_x * qInt_z + qInit_y * qInt_s + qInit_z * qInt_x;
        double qFinal_z = qInit_s * qInt_z + qInit_x * qInt_y - qInit_y * qInt_x + qInit_z * qInt_s;
        double qFinal_s = qInit_s * qInt_s - qInit_x * qInt_x - qInit_y * qInt_y - qInit_z * qInt_z;
        finalOrientation.set(qFinal_x, qFinal_y, qFinal_z, qFinal_s);
    }
}

