/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WholeBodyStreamingMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import java.util.Map;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KSTSleepState;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KSTStreamingState;
import us.ihmc.avatar.networkProcessor.kinemtaticsStreamingToolboxModule.KSTTools;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.kinematicsToolboxAPI.KinematicsToolboxConfigurationCommand;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class KinematicsStreamingToolboxController
extends ToolboxController {
    private final KSTTools tools;
    private final YoDouble time;
    private final StateMachine<KSTState, State> stateMachine;
    private final KSTSleepState sleepState;
    private final KSTStreamingState streamingState;
    private final YoBoolean isDone;
    private long initialTimestamp;

    public KinematicsStreamingToolboxController(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, FullHumanoidRobotModel desiredFullRobotModel, FullHumanoidRobotModelFactory fullRobotModelFactory, double walkingControllerPeriod, double toolboxControllerPeriod, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        this.time = new YoDouble("time", this.registry);
        this.isDone = new YoBoolean("isDone", this.registry);
        this.initialTimestamp = -1L;
        this.tools = new KSTTools(commandInputManager, statusOutputManager, desiredFullRobotModel, fullRobotModelFactory, walkingControllerPeriod, toolboxControllerPeriod, (DoubleProvider)this.time, yoGraphicsListRegistry, this.registry);
        this.sleepState = new KSTSleepState(this.tools);
        this.streamingState = new KSTStreamingState(this.tools);
        this.stateMachine = this.createStateMachine((DoubleProvider)this.time);
        this.isDone.set(false);
    }

    public void setInitialRobotConfiguration(DRCRobotModel robotModel) {
        this.tools.getIKController().setInitialRobotConfiguration(robotModel);
    }

    public void setInitialRobotConfigurationNamedMap(Map<String, Double> initialConfiguration) {
        this.tools.getIKController().setInitialRobotConfigurationNamedMap(initialConfiguration);
    }

    public void setCollisionModel(RobotCollisionModel collisionModel) {
        this.tools.getIKController().setCollisionModel(collisionModel);
    }

    private StateMachine<KSTState, State> createStateMachine(DoubleProvider timeProvider) {
        StateMachineFactory factory = new StateMachineFactory(KSTState.class);
        factory.setNamePrefix("mainStateMachine").setRegistry(this.registry).buildYoClock(timeProvider);
        factory.addState((Enum)KSTState.SLEEP, (State)this.sleepState);
        factory.addState((Enum)KSTState.STREAMING, (State)this.streamingState);
        factory.addDoneTransition((Enum)KSTState.SLEEP, (Enum)KSTState.STREAMING);
        return factory.build((Enum)KSTState.SLEEP);
    }

    public void setTrajectoryMessagePublisher(WholeBodyTrajectoryMessagePublisher outputPublisher) {
        this.streamingState.setTrajectoryMessagerPublisher(outputPublisher);
    }

    public void setStreamingMessagePublisher(WholeBodyStreamingMessagePublisher outputPublisher) {
        this.streamingState.setStreamingMessagePublisher(outputPublisher);
    }

    @Override
    public boolean initialize() {
        this.isDone.set(false);
        this.initialTimestamp = System.nanoTime();
        return true;
    }

    @Override
    public void updateInternal() {
        try {
            this.time.set(Conversions.nanosecondsToSeconds((long)(System.nanoTime() - this.initialTimestamp)));
            if (this.tools.getCommandInputManager().isNewCommandAvailable(KinematicsToolboxConfigurationCommand.class)) {
                this.tools.getIKCommandInputManager().submitCommands(this.tools.getCommandInputManager().pollNewCommands(KinematicsToolboxConfigurationCommand.class));
            }
            this.tools.update();
            this.stateMachine.doActionAndTransition();
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                this.reportMessage(MessageTools.createControllerCrashNotificationPacket(null, (Throwable)e));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.isDone.set(true);
        }
    }

    @Override
    public void notifyToolboxStateChange(ToolboxState newState) {
        if (newState == ToolboxState.SLEEP) {
            this.stateMachine.performTransition((Enum)KSTState.SLEEP);
        }
    }

    @Override
    public boolean isDone() {
        return this.isDone.getValue();
    }

    KSTState getCurrentStateKey() {
        return (KSTState)this.stateMachine.getCurrentStateKey();
    }

    public void updateRobotConfigurationData(RobotConfigurationData newConfigurationData) {
        this.tools.updateRobotConfigurationData(newConfigurationData);
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus newStatus) {
        this.tools.updateCapturabilityBasedStatus(newStatus);
    }

    public double getTime() {
        return this.time.getDoubleValue();
    }

    public KSTTools getTools() {
        return this.tools;
    }

    public FullHumanoidRobotModel getDesiredFullRobotModel() {
        return this.tools.getDesiredFullRobotModel();
    }

    public static interface WholeBodyStreamingMessagePublisher {
        public void publish(WholeBodyStreamingMessage var1);
    }

    public static interface WholeBodyTrajectoryMessagePublisher {
        public void publish(WholeBodyTrajectoryMessage var1);
    }

    public static enum KSTState {
        SLEEP,
        STREAMING;

        private static final KSTState[] values;

        public byte toByte() {
            return (byte)this.ordinal();
        }

        public static KSTState fromByte(byte enumAsByte) {
            if (enumAsByte == -1) {
                return null;
            }
            return values[enumAsByte];
        }

        static {
            values = KSTState.values();
        }
    }
}

