/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules;

import com.google.common.base.CaseFormat;
import controller_msgs.msg.dds.ToolboxStateMessage;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.ControllerNetworkSubscriber;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.log.LogTools;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.tools.thread.CloseableAndDisposable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class ToolboxModule
implements CloseableAndDisposable {
    protected static final boolean DEBUG = false;
    protected static final double YO_VARIABLE_SERVER_DT = 0.01;
    protected static final int DEFAULT_UPDATE_PERIOD_MILLISECONDS = 1;
    protected final String name = this.getClass().getSimpleName();
    protected final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    protected final YoRegistry registry = new YoRegistry(this.name);
    protected final YoDouble yoTime = new YoDouble("localTime", this.registry);
    protected final String robotName;
    protected final FullHumanoidRobotModel fullRobotModel;
    private final boolean manageROS2Node;
    protected final RealtimeROS2Node realtimeROS2Node;
    protected final CommandInputManager commandInputManager;
    protected final StatusMessageOutputManager statusOutputManager;
    protected final ControllerNetworkSubscriber controllerNetworkSubscriber;
    protected final ThreadFactory threadFactory = ThreadTools.createNamedThreadFactory((String)this.name);
    protected final ScheduledExecutorService executorService;
    protected ScheduledFuture<?> toolboxTaskScheduled = null;
    protected ScheduledFuture<?> yoVariableServerScheduled = null;
    protected Runnable toolboxRunnable = null;
    protected final int updatePeriodMilliseconds;
    protected final YoBoolean isLogging = new YoBoolean("isLogging", this.registry);
    protected final YoDouble timeWithoutInputsBeforeGoingToSleep = new YoDouble("timeWithoutInputsBeforeGoingToSleep", this.registry);
    protected final YoDouble timeOfLastInput = new YoDouble("timeOfLastInput", this.registry);
    protected final AtomicBoolean receivedInput = new AtomicBoolean();
    private final LogModelProvider modelProvider;
    private final boolean startYoVariableServer;
    protected YoVariableServer yoVariableServer;

    public ToolboxModule(String robotName, FullHumanoidRobotModel fullRobotModelToLog, LogModelProvider modelProvider, boolean startYoVariableServer, int updatePeriodMilliseconds, RealtimeROS2Node realtimeROS2Node) {
        this(robotName, fullRobotModelToLog, modelProvider, startYoVariableServer, updatePeriodMilliseconds, realtimeROS2Node, null);
    }

    public ToolboxModule(String robotName, FullHumanoidRobotModel fullRobotModelToLog, LogModelProvider modelProvider, boolean startYoVariableServer, int updatePeriodMilliseconds, DomainFactory.PubSubImplementation pubSubImplementation) {
        this(robotName, fullRobotModelToLog, modelProvider, startYoVariableServer, updatePeriodMilliseconds, null, pubSubImplementation);
    }

    protected ToolboxModule(String robotName, FullHumanoidRobotModel fullRobotModelToLog, LogModelProvider modelProvider, boolean startYoVariableServer, int updatePeriodMilliseconds, RealtimeROS2Node realtimeROS2Node, DomainFactory.PubSubImplementation pubSubImplementation) {
        this.robotName = robotName;
        this.modelProvider = modelProvider;
        this.startYoVariableServer = startYoVariableServer;
        this.fullRobotModel = fullRobotModelToLog;
        this.updatePeriodMilliseconds = updatePeriodMilliseconds;
        boolean bl = this.manageROS2Node = realtimeROS2Node == null;
        if (realtimeROS2Node == null) {
            realtimeROS2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)pubSubImplementation, (String)("ihmc_" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name)));
        }
        this.realtimeROS2Node = realtimeROS2Node;
        this.commandInputManager = new CommandInputManager(this.name, this.createListOfSupportedCommands());
        this.statusOutputManager = new StatusMessageOutputManager(this.createListOfSupportedStatus());
        this.controllerNetworkSubscriber = new ControllerNetworkSubscriber(this.getInputTopic(), this.commandInputManager, this.getOutputTopic(), this.statusOutputManager, realtimeROS2Node);
        this.executorService = Executors.newScheduledThreadPool(1, this.threadFactory);
        this.timeWithoutInputsBeforeGoingToSleep.set(0.5);
        this.commandInputManager.registerHasReceivedInputListener(new CommandInputManager.HasReceivedInputListener(){
            private final Set<Class<? extends Command<?, ?>>> silentCommands;
            {
                this.silentCommands = ToolboxModule.this.silentCommands();
            }

            public void hasReceivedInput(Class<? extends Command<?, ?>> commandClass) {
                if (!this.silentCommands.contains(commandClass)) {
                    ToolboxModule.this.receivedInput.set(true);
                }
            }
        });
        this.controllerNetworkSubscriber.addMessageFilter(this.createMessageFilter());
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, ToolboxStateMessage.class, this.getInputTopic(), (NewMessageListener)new NewMessageListener<ToolboxStateMessage>(){
            private final ToolboxStateMessage message = new ToolboxStateMessage();

            public void onNewDataMessage(Subscriber<ToolboxStateMessage> s) {
                s.takeNextData((Object)this.message, null);
                ToolboxModule.this.receivedPacket(this.message);
            }
        });
        this.registerExtraPuSubs(realtimeROS2Node);
        if (this.manageROS2Node) {
            realtimeROS2Node.spin();
        }
    }

    public void setRootRegistry(YoRegistry rootRegistry, YoGraphicsListRegistry rootGraphicsListRegistry) {
        rootRegistry.addChild(this.registry);
        if (rootGraphicsListRegistry != null) {
            ArrayList graphicsLists = new ArrayList();
            ArrayList artifactsLists = new ArrayList();
            this.yoGraphicsListRegistry.getRegisteredYoGraphicsLists(graphicsLists);
            this.yoGraphicsListRegistry.getRegisteredArtifactLists(artifactsLists);
            for (YoGraphicsList graphicsList : graphicsLists) {
                rootGraphicsListRegistry.registerYoGraphicsList(graphicsList);
            }
            for (ArtifactList artifactList : artifactsLists) {
                rootGraphicsListRegistry.registerArtifactList(artifactList);
            }
        }
    }

    protected void setTimeWithoutInputsBeforeGoingToSleep(double time) {
        this.timeWithoutInputsBeforeGoingToSleep.set(time);
    }

    protected void startYoVariableServer() {
        if (!this.startYoVariableServer) {
            return;
        }
        DataServerSettings yoVariableServerSettings = this.getYoVariableServerSettings();
        new Thread(() -> {
            for (int tentative = 0; tentative < 10; ++tentative) {
                try {
                    LogTools.info((String)"{}: Trying to start YoVariableServer using port: {}.", (Object)this.name, (Object)yoVariableServerSettings.getPort());
                    this.yoVariableServer = new YoVariableServer(this.getClass(), this.modelProvider, yoVariableServerSettings, 0.01);
                    this.yoVariableServer.setMainRegistry(this.registry, this.fullRobotModel.getElevator(), this.yoGraphicsListRegistry);
                    this.yoVariableServer.start();
                    break;
                }
                catch (RuntimeException e) {
                    if (!(e.getCause() instanceof BindException)) {
                        throw e;
                    }
                    this.yoVariableServer = null;
                    LogTools.warn((String)"{}: Failed to start YoVariableServer, port {} is busy. Trying next port number", (Object)this.name, (Object)yoVariableServerSettings.getPort());
                    yoVariableServerSettings.setPort(yoVariableServerSettings.getPort() + 1);
                    continue;
                }
            }
            if (this.yoVariableServer == null) {
                LogTools.error((String)"{}: Failed to start the YoVariableServer.", (Object)this.name);
                return;
            }
            LogTools.info((String)"{}: Successfully started YoVariableServer on port: {}.", (Object)this.name, (Object)yoVariableServerSettings.getPort());
            this.yoVariableServerScheduled = this.executorService.scheduleAtFixedRate(this.createYoVariableServerRunnable(this.yoVariableServer), 0L, this.updatePeriodMilliseconds, TimeUnit.MILLISECONDS);
        }, this.name + "ToolboxYoVariableServer").start();
    }

    public DataServerSettings getYoVariableServerSettings() {
        return new DataServerSettings(false);
    }

    private Runnable createYoVariableServerRunnable(final YoVariableServer yoVariableServer) {
        return new Runnable(){
            double serverTime = 0.0;

            @Override
            public void run() {
                if (Thread.interrupted()) {
                    return;
                }
                this.serverTime += Conversions.millisecondsToSeconds((double)ToolboxModule.this.updatePeriodMilliseconds);
                yoVariableServer.update(Conversions.secondsToNanoseconds((double)this.serverTime));
            }
        };
    }

    public ControllerNetworkSubscriber.MessageFilter createMessageFilter() {
        return new ControllerNetworkSubscriber.MessageFilter(){
            private final Set<Class<? extends Settable<?>>> exceptions;
            {
                this.exceptions = ToolboxModule.this.filterExceptions();
            }

            public boolean isMessageValid(Object message) {
                if (this.exceptions.contains(message.getClass())) {
                    return ToolboxModule.this.toolboxTaskScheduled != null;
                }
                return true;
            }
        };
    }

    public void receivedPacket(ToolboxStateMessage message) {
        boolean isAwake;
        ToolboxState requestedState = ToolboxState.fromByte((byte)message.getRequestedToolboxState());
        if (requestedState == null) {
            return;
        }
        boolean bl = isAwake = this.toolboxRunnable != null;
        if (requestedState == ToolboxState.WAKE_UP && !isAwake) {
            this.wakeUp();
        } else if (requestedState == ToolboxState.REINITIALIZE && isAwake) {
            this.reinitialize();
        } else if (requestedState == ToolboxState.SLEEP && isAwake) {
            this.sleep();
        }
        this.handleLoggingRequest(message);
    }

    public void wakeUp() {
        if (this.getToolboxController() == null) {
            LogTools.info((String)"Toolbox is null!");
            return;
        }
        if (this.toolboxTaskScheduled != null) {
            return;
        }
        this.reinitialize();
        this.receivedInput.set(true);
        this.getToolboxController().setFutureToListenTo(this.toolboxTaskScheduled);
        this.createToolboxRunnable();
        this.toolboxTaskScheduled = this.executorService.scheduleAtFixedRate(this.toolboxRunnable, 0L, this.updatePeriodMilliseconds, TimeUnit.MILLISECONDS);
    }

    private void reinitialize() {
        if (this.getToolboxController() != null) {
            this.getToolboxController().requestInitialize();
        } else {
            LogTools.warn((String)"Toolbox is still null");
        }
    }

    public void sleep() {
        this.getToolboxController().notifyToolboxStateChange(ToolboxState.SLEEP);
        this.destroyToolboxRunnable();
        if (this.toolboxTaskScheduled == null) {
            return;
        }
        this.getToolboxController().setFutureToListenTo(null);
        this.toolboxTaskScheduled.cancel(true);
        this.toolboxTaskScheduled = null;
        if (this.isLogging.getValue()) {
            this.stopLogging();
        }
    }

    private void handleLoggingRequest(ToolboxStateMessage message) {
        boolean isAwake;
        boolean bl = isAwake = this.toolboxRunnable != null;
        if (!isAwake) {
            return;
        }
        if (message.getRequestLogging() && !this.isLogging.getValue()) {
            this.startLogging();
            this.isLogging.set(true);
        } else if (!message.getRequestLogging() && this.isLogging.getValue()) {
            this.stopLogging();
            this.isLogging.set(false);
        }
    }

    public void closeAndDispose() {
        this.destroy();
    }

    public void destroy() {
        this.sleep();
        if (this.yoVariableServerScheduled != null) {
            this.yoVariableServerScheduled.cancel(true);
            this.yoVariableServerScheduled = null;
        }
        this.executorService.shutdownNow();
        if (this.yoVariableServer != null) {
            this.yoVariableServer.close();
            this.yoVariableServer = null;
        }
        if (this.manageROS2Node) {
            this.realtimeROS2Node.destroy();
        }
    }

    private void createToolboxRunnable() {
        if (this.toolboxRunnable != null) {
            return;
        }
        this.toolboxRunnable = () -> {
            if (Thread.interrupted()) {
                return;
            }
            try {
                this.getToolboxController().update();
                this.yoTime.add(Conversions.millisecondsToSeconds((double)this.updatePeriodMilliseconds));
                if (this.receivedInput.getAndSet(false)) {
                    this.timeOfLastInput.set(this.yoTime.getDoubleValue());
                }
                if (this.yoTime.getDoubleValue() - this.timeOfLastInput.getDoubleValue() >= this.timeWithoutInputsBeforeGoingToSleep.getDoubleValue()) {
                    this.sleep();
                } else if (this.getToolboxController().isDone()) {
                    this.sleep();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.sleep();
                throw e;
            }
        };
    }

    private void destroyToolboxRunnable() {
        this.toolboxRunnable = null;
    }

    protected void startLogging() {
    }

    protected void stopLogging() {
    }

    public abstract void registerExtraPuSubs(RealtimeROS2Node var1);

    public abstract ToolboxController getToolboxController();

    public abstract List<Class<? extends Command<?, ?>>> createListOfSupportedCommands();

    public abstract List<Class<? extends Settable<?>>> createListOfSupportedStatus();

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public Set<Class<? extends Command<?, ?>>> silentCommands() {
        return Collections.emptySet();
    }

    public Set<Class<? extends Settable<?>>> filterExceptions() {
        return Collections.emptySet();
    }

    public abstract ROS2Topic<?> getOutputTopic();

    public abstract ROS2Topic<?> getInputTopic();
}

