/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules;

import controller_msgs.msg.dds.RobotConfigurationData;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.tools.thread.CloseableAndDisposable;

public class ZeroPoseMockRobotConfigurationDataPublisherModule
implements Runnable,
CloseableAndDisposable {
    private final ROS2Node ros2Node;
    private final IHMCROS2Publisher<RobotConfigurationData> publisher;
    private final FullHumanoidRobotModel fullRobotModel;
    private final ForceSensorDefinition[] forceSensorDefinitions;
    private long timeStamp = 0L;
    private volatile boolean running = true;

    public ZeroPoseMockRobotConfigurationDataPublisherModule(DRCRobotModel robotModel, DomainFactory.PubSubImplementation pubSubImplementation) {
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)pubSubImplementation, (String)"ihmc_zero_pose_mock_node");
        this.fullRobotModel = robotModel.createFullRobotModel();
        this.forceSensorDefinitions = this.fullRobotModel.getForceSensorDefinitions();
        this.publisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)this.ros2Node, RobotConfigurationData.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)robotModel.getSimpleRobotName()));
        Thread t = new Thread(this);
        t.start();
    }

    public void sendMockRobotConfiguration(long totalNsecs) {
        IMUDefinition[] imuDefinitions = this.fullRobotModel.getIMUDefinitions();
        RobotConfigurationData robotConfigurationData = RobotConfigurationDataFactory.create((OneDoFJointReadOnly[])FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel), (ForceSensorDefinition[])this.forceSensorDefinitions, (IMUDefinition[])imuDefinitions);
        for (int sensorNumber = 0; sensorNumber < imuDefinitions.length; ++sensorNumber) {
            robotConfigurationData.getImuSensorData().add();
        }
        robotConfigurationData.setRobotMotionStatus(RobotMotionStatus.STANDING.toByte());
        robotConfigurationData.setWallTime(totalNsecs);
        robotConfigurationData.setMonotonicTime(totalNsecs);
        Vector3D translation = new Vector3D();
        Quaternion orientation = new Quaternion();
        robotConfigurationData.getRootTranslation().set(translation);
        robotConfigurationData.getRootOrientation().set(orientation);
        this.publisher.publish((Object)robotConfigurationData);
    }

    @Override
    public void run() {
        while (this.running) {
            this.sendMockRobotConfiguration(this.timeStamp);
            this.timeStamp += 250000000L;
            ThreadTools.sleep((long)250L);
        }
    }

    public void closeAndDispose() {
        this.running = false;
        this.ros2Node.destroy();
    }
}

