/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules.mocap;

import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.io.IOException;
import java.util.ArrayList;
import optiTrack.MocapDataClient;
import optiTrack.MocapRigidBody;
import optiTrack.MocapRigidbodiesListener;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.modules.mocap.MocapPlanarRegionsListManager;
import us.ihmc.avatar.networkProcessor.modules.mocap.MocapToPelvisFrameConverter;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.packets.PacketDestination;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Quaternion32;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;
import us.ihmc.idl.IDLSequence;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.util.PeriodicNonRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicThreadSchedulerFactory;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class IHMCMOCAPLocalizationModule
implements MocapRigidbodiesListener,
PacketConsumer<RobotConfigurationData> {
    private static final double MOCAP_SERVER_DT = 0.002;
    private static final int PELVIS_ID = 1;
    private RobotConfigurationData latestRobotConfigurationData = null;
    private final MocapToPelvisFrameConverter mocapToPelvisFrameConverter = new MocapToPelvisFrameConverter();
    private final PacketCommunicator packetCommunicator = PacketCommunicator.createIntraprocessPacketCommunicator((NetworkPorts)NetworkPorts.MOCAP_MODULE, (NetClassList)new IHMCCommunicationKryoNetClassList());
    PacketCommunicator mocapVizPacketCommunicator = PacketCommunicator.createTCPPacketCommunicatorServer((NetworkPorts)NetworkPorts.MOCAP_MODULE_VIZ, (NetClassList)new IHMCCommunicationKryoNetClassList());
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoVariableServer yoVariableServer;
    private final FullHumanoidRobotModel fullRobotModel;
    private final MocapPlanarRegionsListManager planarRegionsListManager;
    private final WalkingStatusManager walkingStatusManager = new WalkingStatusManager();
    private final Vector3D32 pelvisTranslationFromRobotConfigurationData = new Vector3D32();
    private final Quaternion32 pelvisOrientationFromRobotConfigurationData = new Quaternion32(0.0f, 0.0f, 0.0f, 1.0f);
    private final ReferenceFrame pelvisFrameFromRobotConfigurationDataPacket = new ReferenceFrame("pelvisFrameFromRobotConfigurationDataPacket", ReferenceFrame.getWorldFrame()){

        protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            transformToParent.getTranslation().set((Tuple3DReadOnly)IHMCMOCAPLocalizationModule.this.pelvisTranslationFromRobotConfigurationData);
            transformToParent.getRotation().set((Orientation3DReadOnly)IHMCMOCAPLocalizationModule.this.pelvisOrientationFromRobotConfigurationData);
        }
    };
    private RigidBodyTransform pelvisToWorldFromMocapData = new RigidBodyTransform();
    private final ReferenceFrame pelvisFrameFromMocap = new ReferenceFrame("pelvisFrameFromMocap", ReferenceFrame.getWorldFrame()){

        protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            transformToParent.set(IHMCMOCAPLocalizationModule.this.pelvisToWorldFromMocapData);
        }
    };
    private final YoDouble computedPelvisPositionX = new YoDouble("computedPelvisPositionX", this.registry);
    private final YoDouble computedPelvisPositionY = new YoDouble("computedPelvisPositionY", this.registry);
    private final YoDouble computedPelvisPositionZ = new YoDouble("computedPelvisPositionZ", this.registry);
    private final YoDouble computedPelvisYaw = new YoDouble("computedPelvisYaw", this.registry);
    private final YoDouble computedPelvisPitch = new YoDouble("computedPelvisPitch", this.registry);
    private final YoDouble computedPelvisRoll = new YoDouble("computedPelvisRoll", this.registry);
    private final YoDouble mocapWorldToRobotWorldTransformX = new YoDouble("mocapWorldToRobotWorldTransformX", this.registry);
    private final YoDouble mocapWorldToRobotWorldTransformY = new YoDouble("mocapWorldToRobotWorldTransformY", this.registry);
    private final YoDouble mocapWorldToRobotWorldTransformZ = new YoDouble("mocapWorldToRobotWorldTransformZ", this.registry);
    private final YoDouble mocapWorldToRobotWorldTransformYaw = new YoDouble("mocapWorldToRobotWorldTransformYaw", this.registry);
    private final YoDouble mocapWorldToRobotWorldTransformPitch = new YoDouble("mocapWorldToRobotWorldTransformPitch", this.registry);
    private final YoDouble mocapWorldToRobotWorldTransformRoll = new YoDouble("mocapWorldToRobotWorldTransformRoll", this.registry);
    private final YoBoolean requestReInitialization = new YoBoolean("requestReInitialization", this.registry);
    private final YoBoolean requestFootsteps = new YoBoolean("requestFootsteps", this.registry);
    private final YoBoolean walkingAround = new YoBoolean("walkingAround", this.registry);

    public IHMCMOCAPLocalizationModule(DRCRobotModel drcRobotModel, MocapPlanarRegionsListManager planarRegionsListManager) {
        MocapDataClient mocapDataClient = new MocapDataClient();
        mocapDataClient.registerRigidBodiesListener((MocapRigidbodiesListener)this);
        this.packetCommunicator.attachListener(RobotConfigurationData.class, (PacketConsumer)this);
        this.packetCommunicator.attachListener(FootstepStatusMessage.class, (PacketConsumer)this.walkingStatusManager);
        PeriodicNonRealtimeThreadSchedulerFactory scheduler = new PeriodicNonRealtimeThreadSchedulerFactory();
        LogModelProvider logModelProvider = drcRobotModel.getLogModelProvider();
        this.planarRegionsListManager = planarRegionsListManager;
        this.yoVariableServer = new YoVariableServer(this.getClass(), (PeriodicThreadSchedulerFactory)scheduler, logModelProvider, drcRobotModel.getLogSettings(), 0.002);
        this.fullRobotModel = drcRobotModel.createFullRobotModel();
        this.yoVariableServer.setMainRegistry(this.registry, this.fullRobotModel.getElevator(), null);
        LogTools.info((String)"Starting server");
        this.yoVariableServer.start();
        try {
            this.packetCommunicator.connect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateRigidbodies(ArrayList<MocapRigidBody> listOfRigidbodies) {
        if (!this.packetCommunicator.isConnected()) {
            LogTools.info((String)"Packet communicator isn't registered, ignoring MOCAP data");
            return;
        }
        if (!this.mocapToPelvisFrameConverter.isInitialized() && this.latestRobotConfigurationData != null) {
            this.initializeMocapFrameConverter(listOfRigidbodies);
        } else if (this.latestRobotConfigurationData == null) {
            LogTools.info((String)"Waiting for robot configuration data");
            return;
        }
        if (this.requestReInitialization.getBooleanValue()) {
            this.initializeMocapFrameConverter(listOfRigidbodies);
            this.requestReInitialization.set(false);
        }
        MocapRigidBody pelvisRigidBody = this.getPelvisRigidBody(listOfRigidbodies);
        this.sendPelvisTransformToController(pelvisRigidBody);
        if (this.requestFootsteps.getBooleanValue()) {
            this.planarRegionsListManager.savePlanarRegionsAfterWalking();
            this.startWalking();
            this.walkingAround.set(true);
            this.requestFootsteps.set(false);
        }
        if (this.walkingAround.getBooleanValue() && this.walkingStatusManager.doneWalking()) {
            this.planarRegionsListManager.savePlanarRegionsAfterWalking();
            this.walkingAround.set(false);
        }
        this.yoVariableServer.update(System.currentTimeMillis());
    }

    private void initializeMocapFrameConverter(ArrayList<MocapRigidBody> listOfRigidbodies) {
        this.pelvisFrameFromRobotConfigurationDataPacket.update();
        MocapRigidBody pelvisRigidBody = this.getPelvisRigidBody(listOfRigidbodies);
        this.mocapToPelvisFrameConverter.initialize(this.pelvisFrameFromRobotConfigurationDataPacket, pelvisRigidBody);
    }

    private MocapRigidBody getPelvisRigidBody(ArrayList<MocapRigidBody> listOfRigidbodies) {
        for (int i = 0; i < listOfRigidbodies.size(); ++i) {
            MocapRigidBody rigidBody = listOfRigidbodies.get(i);
            if (rigidBody.getId() != 1) continue;
            return rigidBody;
        }
        return null;
    }

    private void setPelvisYoVariables(RigidBodyTransform pelvisTransform) {
        Vector3D pelvisTranslation = new Vector3D();
        YawPitchRoll yawPitchRoll = new YawPitchRoll();
        pelvisTranslation.set((Tuple3DReadOnly)pelvisTransform.getTranslation());
        Quaternion pelvisRotation = new Quaternion();
        pelvisRotation.set((Orientation3DReadOnly)pelvisTransform.getRotation());
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)pelvisRotation, (YawPitchRollBasics)yawPitchRoll);
        this.computedPelvisPositionX.set(pelvisTranslation.getX());
        this.computedPelvisPositionY.set(pelvisTranslation.getY());
        this.computedPelvisPositionZ.set(pelvisTranslation.getZ());
        this.computedPelvisYaw.set(yawPitchRoll.getYaw());
        this.computedPelvisPitch.set(yawPitchRoll.getPitch());
        this.computedPelvisRoll.set(yawPitchRoll.getRoll());
    }

    private void sendPelvisTransformToController(MocapRigidBody pelvisRigidBody) {
        this.mocapToPelvisFrameConverter.computePelvisToWorldTransform(pelvisRigidBody, this.pelvisToWorldFromMocapData);
        this.setPelvisYoVariables(this.pelvisToWorldFromMocapData);
    }

    public void receivedPacket(RobotConfigurationData packet) {
        this.latestRobotConfigurationData = packet;
        FloatingJointBasics rootJoint = this.fullRobotModel.getRootJoint();
        IDLSequence.Float newJointAngles = packet.getJointAngles();
        IDLSequence.Float newJointVelocities = packet.getJointAngles();
        IDLSequence.Float newJointTorques = packet.getJointTorques();
        OneDoFJointBasics[] oneDoFJoints = this.fullRobotModel.getOneDoFJoints();
        for (int i = 0; i < newJointAngles.size(); ++i) {
            oneDoFJoints[i].setQ((double)newJointAngles.get(i));
            oneDoFJoints[i].setQd((double)newJointVelocities.get(i));
            oneDoFJoints[i].setTau((double)newJointTorques.get(i));
        }
        this.pelvisTranslationFromRobotConfigurationData.set((Tuple3DReadOnly)packet.getRootTranslation());
        this.pelvisOrientationFromRobotConfigurationData.set((QuaternionReadOnly)packet.getRootOrientation());
        rootJoint.getJointPose().getPosition().set(this.pelvisTranslationFromRobotConfigurationData.getX(), this.pelvisTranslationFromRobotConfigurationData.getY(), this.pelvisTranslationFromRobotConfigurationData.getZ());
        rootJoint.getJointPose().getOrientation().setQuaternion(this.pelvisOrientationFromRobotConfigurationData.getX(), this.pelvisOrientationFromRobotConfigurationData.getY(), this.pelvisOrientationFromRobotConfigurationData.getZ(), this.pelvisOrientationFromRobotConfigurationData.getS());
        this.computeDriftTransform();
        rootJoint.getPredecessor().updateFramesRecursively();
        this.yoVariableServer.update(System.currentTimeMillis());
    }

    private void computeDriftTransform() {
        RigidBodyTransform driftTransform = new RigidBodyTransform();
        this.pelvisFrameFromMocap.update();
        this.pelvisFrameFromRobotConfigurationDataPacket.update();
        this.pelvisFrameFromMocap.getTransformToDesiredFrame(driftTransform, this.pelvisFrameFromRobotConfigurationDataPacket);
        Vector3D driftTranslation = new Vector3D();
        driftTranslation.set((Tuple3DReadOnly)driftTransform.getTranslation());
        Quaternion driftRotation = new Quaternion();
        driftRotation.set((Orientation3DReadOnly)driftTransform.getRotation());
        YawPitchRoll driftRotationYPR = new YawPitchRoll();
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)driftRotation, (YawPitchRollBasics)driftRotationYPR);
        this.mocapWorldToRobotWorldTransformX.set(driftTranslation.getX());
        this.mocapWorldToRobotWorldTransformY.set(driftTranslation.getY());
        this.mocapWorldToRobotWorldTransformZ.set(driftTranslation.getZ());
        this.mocapWorldToRobotWorldTransformYaw.set(driftRotationYPR.getYaw());
        this.mocapWorldToRobotWorldTransformPitch.set(driftRotationYPR.getPitch());
        this.mocapWorldToRobotWorldTransformRoll.set(driftRotationYPR.getRoll());
    }

    public void startWalking() {
        ArrayList<Object> listOfStepsForward = new ArrayList(8);
        ArrayList<Object> listOfStepsBackward = new ArrayList(8);
        RobotSide robotSide = RobotSide.LEFT;
        boolean isDirectionForward = true;
        listOfStepsForward = this.createFootstepList(robotSide, isDirectionForward);
        listOfStepsBackward = this.createFootstepList(robotSide, !isDirectionForward);
        ArrayList overallListOfSteps = new ArrayList(16);
        overallListOfSteps.addAll(listOfStepsForward);
        overallListOfSteps.addAll(listOfStepsBackward);
        FootstepDataListMessage footstepsListMessage = HumanoidMessageTools.createFootstepDataListMessage(overallListOfSteps, (double)1.2, (double)0.8, (ExecutionMode)ExecutionMode.QUEUE);
        footstepsListMessage.setDestination(PacketDestination.CONTROLLER.ordinal());
        this.walkingStatusManager.sendFootstepList(footstepsListMessage);
    }

    private ArrayList<FootstepDataMessage> createFootstepList(RobotSide robotSide, boolean isDirectionForward) {
        ArrayList<FootstepDataMessage> listOfSteps = new ArrayList<FootstepDataMessage>(8);
        for (int i = 0; i < listOfSteps.size(); ++i) {
            double y = robotSide == RobotSide.LEFT ? 0.15 : -0.15;
            Point3D position = new Point3D();
            position.setY(y);
            if (isDirectionForward) {
                position.setX((double)i * 0.2 + 0.2);
            } else {
                double startingPoint = 1.6;
                position.setX(startingPoint - (double)i * 0.2 - 0.2);
            }
            FootstepDataMessage footStep = HumanoidMessageTools.createFootstepDataMessage((RobotSide)robotSide, (Point3DReadOnly)position, (Orientation3DReadOnly)new Quaternion(0.0, 0.0, 0.0, 1.0));
            listOfSteps.set(i, footStep);
            robotSide = robotSide.getOppositeSide();
        }
        return listOfSteps;
    }

    private class WalkingStatusManager
    implements PacketConsumer<FootstepStatusMessage> {
        private final YoInteger footstepsCompleted;
        private final YoInteger numberOfFootstepsToTake;

        private WalkingStatusManager() {
            this.footstepsCompleted = new YoInteger("footstepsCompleted", IHMCMOCAPLocalizationModule.this.registry);
            this.numberOfFootstepsToTake = new YoInteger("numberOfFootstepsToTake", IHMCMOCAPLocalizationModule.this.registry);
        }

        public void receivedPacket(FootstepStatusMessage packet) {
            if (packet.getFootstepStatus() == FootstepStatus.COMPLETED.toByte()) {
                this.footstepsCompleted.increment();
            }
        }

        public void sendFootstepList(FootstepDataListMessage footstepDataListMessage) {
            this.numberOfFootstepsToTake.set(footstepDataListMessage.getFootstepDataList().size());
            this.footstepsCompleted.set(0);
            IHMCMOCAPLocalizationModule.this.packetCommunicator.send((Packet)footstepDataListMessage);
        }

        public boolean doneWalking() {
            return this.footstepsCompleted.getIntegerValue() == this.numberOfFootstepsToTake.getIntegerValue();
        }
    }
}

