/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules.mocap;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.HashMap;
import optiTrack.MocapRigidBody;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.humanoidRobotics.communication.subscribers.HumanoidRobotDataReceiver;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.NeckJointName;

public class MocapToHeadFrameConverter {
    HashMap<Integer, ReferenceFrame> mocapReferenceFrames = new HashMap();
    HashMap<Integer, RigidBodyTransform> mocapRigidBodyTransforms = new HashMap();
    private final HumanoidRobotDataReceiver robotDataReceiver;
    private final ReferenceFrame robotHeadFrame;
    private final ReferenceFrame mocapHeadFrame;
    private final ReferenceFrame mocapOffsetFrame;
    private final RigidBodyTransform mocapHeadPoseInZUp = new RigidBodyTransform();
    private final RigidBodyTransform transformFromMocapHeadToRobotHead = new RigidBodyTransform();
    private final RigidBodyTransform transformFromMocapHeadCentroidToHeadRoot = new RigidBodyTransform();
    private final RigidBodyTransform mocapJigCalibrationTransform = new RigidBodyTransform();
    private final RigidBodyTransform workingRigidBodyTransform = new RigidBodyTransform();
    private boolean enableMocapUpdates = false;
    private ReferenceFrame mocapOrigin = new ReferenceFrame("mocapOrigin", ReferenceFrame.getWorldFrame()){

        protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            transformToParent.setIdentity();
        }
    };

    public MocapToHeadFrameConverter(DRCRobotModel robotModel, PacketCommunicator mocapModulePacketCommunicator) {
        FullHumanoidRobotModel fullRobotModel = robotModel.createFullRobotModel();
        this.robotDataReceiver = new HumanoidRobotDataReceiver(fullRobotModel, null);
        HumanoidReferenceFrames referenceFrames = this.robotDataReceiver.getReferenceFrames();
        this.robotHeadFrame = referenceFrames.getNeckFrame(NeckJointName.PROXIMAL_NECK_PITCH);
        this.mocapHeadFrame = new ReferenceFrame("headInMocapFrame", this.mocapOrigin){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set(MocapToHeadFrameConverter.this.mocapHeadPoseInZUp);
            }
        };
        this.mocapOffsetFrame = new ReferenceFrame("mocapOffsetFrame", this.mocapOrigin){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set(MocapToHeadFrameConverter.this.transformFromMocapHeadToRobotHead);
            }
        };
        mocapModulePacketCommunicator.attachListener(RobotConfigurationData.class, (PacketConsumer)this.robotDataReceiver);
    }

    public void setTransformFromMocapCentroidToHeadRoot(RigidBodyTransform transformFromMocapCentroidToHeadRoot) {
        this.transformFromMocapHeadCentroidToHeadRoot.set(transformFromMocapCentroidToHeadRoot);
    }

    public void setMocapJigCalibrationTransform(RigidBodyTransform headJigCalibrationTransform) {
        this.mocapJigCalibrationTransform.set(headJigCalibrationTransform);
    }

    public void update(MocapRigidBody mocapObject) {
        if (this.enableMocapUpdates) {
            mocapObject.packPose(this.workingRigidBodyTransform);
            this.workingRigidBodyTransform.multiply((RigidBodyTransformReadOnly)this.mocapJigCalibrationTransform);
            this.workingRigidBodyTransform.multiply((RigidBodyTransformReadOnly)this.transformFromMocapHeadCentroidToHeadRoot);
            this.mocapHeadPoseInZUp.set(this.workingRigidBodyTransform);
            this.mocapHeadFrame.update();
            this.robotDataReceiver.updateRobotModel();
            this.mocapHeadFrame.getTransformToDesiredFrame(this.transformFromMocapHeadToRobotHead, this.robotHeadFrame);
            this.mocapOffsetFrame.update();
        }
    }

    public RigidBodyTransform convertMocapPoseToRobotFrame(MocapRigidBody mocapRigidBody) {
        int id = mocapRigidBody.getId();
        if (!this.mocapReferenceFrames.containsKey(id)) {
            ReferenceFrame mocapObjectFrame = this.createReferenceFrameForMocapObject(id);
            this.mocapReferenceFrames.put(id, mocapObjectFrame);
        }
        mocapRigidBody.packPose(this.mocapRigidBodyTransforms.get(id));
        ReferenceFrame referenceFrame = this.mocapReferenceFrames.get(id);
        referenceFrame.update();
        return referenceFrame.getTransformToDesiredFrame(this.mocapOffsetFrame);
    }

    private ReferenceFrame createReferenceFrameForMocapObject(int id) {
        final RigidBodyTransform mocapRigidBodyTransform = new RigidBodyTransform();
        this.mocapRigidBodyTransforms.put(id, mocapRigidBodyTransform);
        ReferenceFrame mocapObjectFrame = new ReferenceFrame("mocapObject" + id, this.mocapOrigin){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set(mocapRigidBodyTransform);
            }
        };
        return mocapObjectFrame;
    }

    public void enableMocapUpdates(boolean freezeMocapUpdates) {
        this.enableMocapUpdates = freezeMocapUpdates;
    }
}

