/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules.mocap;

import optiTrack.MocapRigidBody;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class MocapToPelvisFrameConverter {
    private boolean initialized = false;
    private ReferenceFrame mocapFrame = null;
    private static final double ballRadius = 0.006;
    private static final Vector3D markerPlateOriginInPelvisFrame = new Vector3D(0.17235, 0.0, 0.12888);
    private static final Vector3D plateOriginToMarker2InPelvisFrame = new Vector3D(0.011, 0.045, 0.0);
    private static final RigidBodyTransform pelvisToMarker2Transform = new RigidBodyTransform();

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(ReferenceFrame pelvisFrame, MocapRigidBody markerRigidBody) {
        RigidBodyTransform marker2ToMocapTransform = new RigidBodyTransform((Orientation3DReadOnly)markerRigidBody.getOrientation(), (Tuple3DReadOnly)markerRigidBody.getPosition());
        RigidBodyTransform worldToPelvisTransform = pelvisFrame.getTransformToWorldFrame();
        worldToPelvisTransform.invert();
        RigidBodyTransform worldToMocapTransform = new RigidBodyTransform();
        worldToMocapTransform.multiply((RigidBodyTransformReadOnly)marker2ToMocapTransform);
        worldToMocapTransform.multiply((RigidBodyTransformReadOnly)pelvisToMarker2Transform);
        worldToMocapTransform.multiply((RigidBodyTransformReadOnly)worldToPelvisTransform);
        this.mocapFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformFromParent((String)"mocapFrame", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)worldToMocapTransform);
        this.initialized = true;
    }

    public void computePelvisToWorldTransform(MocapRigidBody mocapRigidBody, RigidBodyTransform pelvisToWorldTransformToPack) {
        RigidBodyTransform pelvisToMocapTransform = new RigidBodyTransform((Orientation3DReadOnly)mocapRigidBody.getOrientation(), (Tuple3DReadOnly)mocapRigidBody.getPosition());
        pelvisToMocapTransform.multiply((RigidBodyTransformReadOnly)pelvisToMarker2Transform);
        FramePose3D pelvisPose = new FramePose3D(this.mocapFrame, (RigidBodyTransformReadOnly)pelvisToMocapTransform);
        pelvisPose.changeFrame(ReferenceFrame.getWorldFrame());
        pelvisPose.get((RigidBodyTransformBasics)pelvisToWorldTransformToPack);
    }

    public ReferenceFrame getMocapFrame() {
        return this.mocapFrame;
    }

    public static RigidBodyTransform getPelvisToMarker2Transform() {
        return pelvisToMarker2Transform;
    }

    static {
        Vector3D marker2PositionInPelvisFrame = new Vector3D((Tuple3DReadOnly)markerPlateOriginInPelvisFrame);
        marker2PositionInPelvisFrame.add((Tuple3DReadOnly)plateOriginToMarker2InPelvisFrame);
        pelvisToMarker2Transform.getTranslation().set((Tuple3DReadOnly)marker2PositionInPelvisFrame);
        pelvisToMarker2Transform.invert();
    }
}

