/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.modules.mocap;

import controller_msgs.msg.dds.IMUPacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.net.URI;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.ros.message.MessageListener;
import org.ros.namespace.GraphName;
import org.ros.node.AbstractNodeMain;
import org.ros.node.ConnectedNode;
import org.ros.node.DefaultNodeMainExecutor;
import org.ros.node.NodeConfiguration;
import org.ros.node.NodeMain;
import org.ros.node.NodeMainExecutor;
import org.ros.node.topic.Subscriber;
import sensor_msgs.JointState;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.utilities.ros.RosTools;

public class RosConnectedZeroPoseRobotConfigurationDataProducer
extends AbstractNodeMain {
    private final PacketCommunicator packetCommunicator;
    private Subscriber<JointState> jointSubscriber;
    private final DRCRobotModel robotModel;
    private final FullHumanoidRobotModel fullRobotModel;
    private final ForceSensorDefinition[] forceSensorDefinitions;
    private final HumanoidReferenceFrames referenceFrames;
    private final ReferenceFrame pelvisFrame;
    private final ReferenceFrame headFrame;
    private final AtomicReference<RigidBodyTransform> atomicPelvisPose = new AtomicReference<RigidBodyTransform>(new RigidBodyTransform());
    private final Random random = new Random();

    public RosConnectedZeroPoseRobotConfigurationDataProducer(URI rosMasterURI, PacketCommunicator objectCommunicator, DRCRobotModel robotModel) {
        this.robotModel = robotModel;
        this.packetCommunicator = objectCommunicator;
        this.fullRobotModel = robotModel.createFullRobotModel();
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        this.pelvisFrame = this.referenceFrames.getPelvisFrame();
        this.headFrame = this.referenceFrames.getNeckFrame(NeckJointName.PROXIMAL_NECK_PITCH);
        this.forceSensorDefinitions = this.fullRobotModel.getForceSensorDefinitions();
        this.updateRobotLocationBasedOnMultisensePose(new RigidBodyTransform());
        if (rosMasterURI != null) {
            NodeConfiguration nodeConfiguration = RosTools.createNodeConfiguration((URI)rosMasterURI);
            NodeMainExecutor nodeMainExecutor = DefaultNodeMainExecutor.newDefault();
            nodeMainExecutor.execute((NodeMain)this, nodeConfiguration);
        }
    }

    public void onStart(ConnectedNode connectedNode) {
        this.setupSubscribers(connectedNode);
        this.setUpListeners();
    }

    private void setUpListeners() {
        if (this.jointSubscriber != null) {
            this.jointSubscriber.addMessageListener((MessageListener)new MessageListener<JointState>(){

                public void onNewMessage(JointState message) {
                    RosConnectedZeroPoseRobotConfigurationDataProducer.this.receivedClockMessage(message.getHeader().getStamp().totalNsecs());
                }
            });
        }
    }

    protected void setupSubscribers(ConnectedNode connectedNode) {
        HumanoidRobotSensorInformation sensorInforamtion = this.robotModel.getSensorInformation();
        AvatarRobotLidarParameters lidarParameters = sensorInforamtion.getLidarParameters(0);
        if (lidarParameters != null && lidarParameters.getLidarSpindleJointTopic() != null) {
            this.jointSubscriber = connectedNode.newSubscriber(lidarParameters.getLidarSpindleJointTopic(), "sensor_msgs/JointState");
        }
    }

    public void receivedClockMessage(long totalNsecs) {
        RigidBodyTransform pelvisPoseInMocapFrame = this.atomicPelvisPose.get();
        IMUDefinition[] imuDefinitions = this.fullRobotModel.getIMUDefinitions();
        RobotConfigurationData robotConfigurationData = RobotConfigurationDataFactory.create((OneDoFJointReadOnly[])this.fullRobotModel.getOneDoFJoints(), (ForceSensorDefinition[])this.forceSensorDefinitions, (IMUDefinition[])imuDefinitions);
        for (int sensorNumber = 0; sensorNumber < imuDefinitions.length; ++sensorNumber) {
            IMUPacket imuPacket = (IMUPacket)robotConfigurationData.getImuSensorData().add();
            imuPacket.getLinearAcceleration().set((Tuple3DReadOnly)RandomGeometry.nextVector3D32((Random)this.random));
            imuPacket.getOrientation().set((QuaternionReadOnly)RandomGeometry.nextQuaternion32((Random)this.random));
            imuPacket.getAngularVelocity().set((Tuple3DReadOnly)RandomGeometry.nextVector3D32((Random)this.random));
        }
        robotConfigurationData.setRobotMotionStatus(RobotMotionStatus.STANDING.toByte());
        robotConfigurationData.setWallTime(totalNsecs);
        robotConfigurationData.setMonotonicTime(totalNsecs);
        if (pelvisPoseInMocapFrame != null) {
            Vector3D translation = new Vector3D();
            Quaternion orientation = new Quaternion();
            translation.set((Tuple3DReadOnly)pelvisPoseInMocapFrame.getTranslation());
            orientation.set((Orientation3DReadOnly)pelvisPoseInMocapFrame.getRotation());
            robotConfigurationData.getRootTranslation().set(translation);
            robotConfigurationData.getRootOrientation().set(orientation);
        }
        this.fullRobotModel.updateFrames();
        this.packetCommunicator.send((Packet)robotConfigurationData);
    }

    public GraphName getDefaultNodeName() {
        return GraphName.of((String)"darpaRoboticsChallenge/RosConnectedZeroPoseRobotConfigurationDataProducer");
    }

    public void updateRobotLocationBasedOnMultisensePose(RigidBodyTransform headPose) {
        RigidBodyTransform pelvisPose = new RigidBodyTransform();
        RigidBodyTransform transformFromHeadToPelvis = this.pelvisFrame.getTransformToDesiredFrame(this.headFrame);
        pelvisPose.set(headPose);
        pelvisPose.multiply((RigidBodyTransformReadOnly)transformFromHeadToPelvis);
        this.atomicPelvisPose.set(pelvisPose);
    }

    public HumanoidReferenceFrames getReferenceFrames() {
        return this.referenceFrames;
    }
}

