/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.quadTreeHeightMap;

import java.util.ArrayDeque;
import java.util.Iterator;
import us.ihmc.avatar.networkProcessor.quadTreeHeightMap.HeightQuadTree;
import us.ihmc.avatar.networkProcessor.quadTreeHeightMap.HeightQuadTreeNode;

public class HeightQuadTreeIteratorFactory {
    public static Iterable<HeightQuadTreeNode> iterable(HeightQuadTree heightQuadTree) {
        return new BaseIterable(heightQuadTree.getRoot(), null);
    }

    public static Iterable<HeightQuadTreeNode> leafIterable(HeightQuadTree heightQuadTree) {
        return new BaseIterable(heightQuadTree.getRoot(), HeightQuadTreeIteratorFactory.leafSelectionRule());
    }

    private static IteratorSelectionRule leafSelectionRule() {
        return new IteratorSelectionRule(){

            @Override
            public boolean test(HeightQuadTreeNode node) {
                return !node.hasChildrenArray();
            }
        };
    }

    public static interface IteratorSelectionRule {
        public boolean test(HeightQuadTreeNode var1);
    }

    private static class BaseIterator
    implements Iterator<HeightQuadTreeNode> {
        private final IteratorSelectionRule rule;
        private final ArrayDeque<HeightQuadTreeNode> stack = new ArrayDeque();
        private HeightQuadTreeNode next = null;
        private boolean hasNextHasBeenCalled = false;

        public BaseIterator(HeightQuadTreeNode root, IteratorSelectionRule rule) {
            this.rule = rule;
            this.hasNextHasBeenCalled = false;
            this.stack.clear();
            if (root != null) {
                this.stack.add(root);
            }
        }

        @Override
        public boolean hasNext() {
            this.next = null;
            if (this.stack.isEmpty()) {
                return false;
            }
            if (!this.hasNextHasBeenCalled) {
                this.next = this.searchNextNodePassingRule();
                this.hasNextHasBeenCalled = true;
            }
            return this.next != null;
        }

        @Override
        public HeightQuadTreeNode next() {
            if (!this.hasNextHasBeenCalled && !this.hasNext()) {
                throw new NullPointerException();
            }
            this.hasNextHasBeenCalled = false;
            HeightQuadTreeNode ret = this.next;
            this.next = null;
            return ret;
        }

        private HeightQuadTreeNode searchNextNodePassingRule() {
            if (this.stack.isEmpty()) {
                return null;
            }
            if (this.rule == null) {
                return this.searchNextNode();
            }
            while (!this.stack.isEmpty()) {
                HeightQuadTreeNode currentNode = this.searchNextNode();
                if (currentNode != null && !this.rule.test(currentNode)) continue;
                return currentNode;
            }
            return null;
        }

        private HeightQuadTreeNode searchNextNode() {
            if (this.stack.isEmpty()) {
                return null;
            }
            HeightQuadTreeNode currentNode = this.stack.poll();
            if (currentNode.hasChildrenArray()) {
                for (int i = 3; i >= 0; --i) {
                    HeightQuadTreeNode child = currentNode.getChild(i);
                    if (child == null) continue;
                    this.stack.add(child);
                }
            }
            return currentNode;
        }
    }

    private static class BaseIterable
    implements Iterable<HeightQuadTreeNode> {
        private final HeightQuadTreeNode root;
        private final IteratorSelectionRule rule;

        public BaseIterable(HeightQuadTreeNode root, IteratorSelectionRule rule) {
            this.root = root;
            this.rule = rule;
        }

        @Override
        public Iterator<HeightQuadTreeNode> iterator() {
            return new BaseIterator(this.root, this.rule);
        }
    }
}

