/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.quadTreeHeightMap;

import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import us.ihmc.avatar.networkProcessor.quadTreeHeightMap.HeightQuadTreeNode;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;

public class HeightQuadTreeSearchTools {
    public static HeightQuadTreeNode searchNode(HeightQuadTreeNode node, double x, double y) {
        return HeightQuadTreeSearchTools.searchNode(node, (float)x, (float)y);
    }

    public static HeightQuadTreeNode searchNode(HeightQuadTreeNode node, float x, float y) {
        HeightQuadTreeNode child;
        if (node == null) {
            return null;
        }
        if (!node.hasChildrenArray() && Math.abs(x - node.getCenterX()) < node.getSizeX() && Math.abs(y - node.getCenterY()) < node.getSizeY()) {
            return node;
        }
        if (!node.hasChildrenArray() || node.getNumberOfChildren() == 0) {
            return node;
        }
        int mortonCode = 0;
        if (x > node.getCenterX()) {
            mortonCode |= 1;
        }
        if (y > node.getCenterY()) {
            mortonCode |= 2;
        }
        if ((child = node.getChild(mortonCode)) == null) {
            return null;
        }
        return HeightQuadTreeSearchTools.searchNode(node.getChild(mortonCode), x, y);
    }

    public static void findRadiusNeighbors(HeightQuadTreeNode rootNode, double x, double y, double radius, NeighborActionRule actionRule) {
        double radiusSquared = radius * radius;
        HeightQuadTreeSearchTools.findRadiusNeighbors(rootNode, x, y, radius, radiusSquared, actionRule);
    }

    private static void findRadiusNeighbors(HeightQuadTreeNode node, double x, double y, double radius, double radiusSquared, NeighborActionRule actionRule) {
        double xNode = node.getCenterX();
        double yNode = node.getCenterY();
        if (HeightQuadTreeSearchTools.contains(node, x, y, radiusSquared)) {
            HeightQuadTreeSearchTools.doActionOnLeavesRecursively(node, actionRule);
            return;
        }
        if (node.getNumberOfChildren() == 0) {
            double dx = x - xNode;
            double dy = y - yNode;
            double distanceSquared = dx * dx + dy * dy;
            if (distanceSquared < radiusSquared) {
                actionRule.doActionOnNeighbor(node);
            }
            return;
        }
        for (int childIndex = 0; childIndex < 4; ++childIndex) {
            HeightQuadTreeNode child = node.getChild(childIndex);
            if (child == null || !HeightQuadTreeSearchTools.overlaps(child, x, y, radius, radiusSquared)) continue;
            HeightQuadTreeSearchTools.findRadiusNeighbors(child, x, y, radius, radiusSquared, actionRule);
        }
    }

    public static void doActionOnLeavesRecursively(HeightQuadTreeNode node, NeighborActionRule actionRule) {
        if (!node.hasChildrenArray()) {
            actionRule.doActionOnNeighbor(node);
            return;
        }
        for (int childIndex = 0; childIndex < 4; ++childIndex) {
            HeightQuadTreeNode childNode = node.getChild(childIndex);
            if (childNode == null) continue;
            HeightQuadTreeSearchTools.doActionOnLeavesRecursively(childNode, actionRule);
        }
    }

    public static double findNearestNeighbor(HeightQuadTreeNode rootNode, double x, double y, double minDistance, double maxDistance, MutableObject<HeightQuadTreeNode> nearestNeighborToPack) {
        MutableDouble result = new MutableDouble(maxDistance);
        nearestNeighborToPack.setValue(null);
        HeightQuadTreeSearchTools.findNearestNeighbor(rootNode, x, y, minDistance, result, nearestNeighborToPack);
        if (nearestNeighborToPack.getValue() != null) {
            return result.doubleValue();
        }
        return Double.NaN;
    }

    private static boolean findNearestNeighbor(HeightQuadTreeNode node, double x, double y, double minDistance, MutableDouble maxDistance, MutableObject<HeightQuadTreeNode> nearestNeighborToPack) {
        HeightQuadTreeNode child;
        double xNode = node.getCenterX();
        double yNode = node.getCenterY();
        if (node.getNumberOfChildren() == 0) {
            boolean isBetter;
            double maxDistanceSquared = maxDistance.doubleValue() * maxDistance.doubleValue();
            double minDistanceSquared = minDistance < 0.0 ? minDistance : minDistance * minDistance;
            double dx = x - xNode;
            double dy = y - yNode;
            double distanceSquared = dx * dx + dy * dy;
            boolean bl = isBetter = distanceSquared > minDistanceSquared && distanceSquared < maxDistanceSquared;
            if (isBetter) {
                nearestNeighborToPack.setValue((Object)node);
                maxDistance.setValue(Math.sqrt(distanceSquared));
            }
            return HeightQuadTreeSearchTools.inside(node, x, y, maxDistance.doubleValue());
        }
        int mortonCode = 0;
        if (x > xNode) {
            mortonCode |= 1;
        }
        if (y > yNode) {
            mortonCode |= 2;
        }
        if ((child = node.getChild(mortonCode)) != null && HeightQuadTreeSearchTools.findNearestNeighbor(child, x, y, minDistance, maxDistance, nearestNeighborToPack)) {
            return true;
        }
        double maxDistanceSquared = maxDistance.doubleValue() * maxDistance.doubleValue();
        for (int childIndex = 0; childIndex < 4; ++childIndex) {
            if (childIndex == mortonCode || (child = node.getChild(childIndex)) == null || !HeightQuadTreeSearchTools.overlaps(child, x, y, maxDistance.doubleValue(), maxDistanceSquared) || !HeightQuadTreeSearchTools.findNearestNeighbor(child, x, y, minDistance, maxDistance, nearestNeighborToPack)) continue;
            return true;
        }
        return HeightQuadTreeSearchTools.inside(node, x, y, maxDistance.doubleValue());
    }

    public static Point2D adjustCoordinatesToResolution(double x, double y, double resolution) {
        x = HeightQuadTreeSearchTools.adjustCoordinatesToResolution(x, resolution);
        y = HeightQuadTreeSearchTools.adjustCoordinatesToResolution(y, resolution);
        return new Point2D(x, y);
    }

    public static double adjustCoordinatesToResolution(double coord, double resolution) {
        long n = Math.round((Math.abs(coord) - 0.5 * resolution) / resolution);
        double output = (double)n * resolution - 0.5 * resolution;
        return Math.copySign(output, coord);
    }

    public static void doActionOnRayKeys(HeightQuadTreeNode root, Point2D origin, Vector2D direction, double maxRange, RayActionRule actionRule, double resolution) {
        double distanceFromOrigin;
        origin = HeightQuadTreeSearchTools.adjustCoordinatesToResolution(origin.getX(), origin.getY(), resolution);
        double[] directionArray = new double[2];
        double[] originArray = new double[2];
        double[] step = new double[2];
        double[] tMax = new double[2];
        double[] tDelta = new double[2];
        Point2D currentPosition = new Point2D();
        double[] currentPositionArray = new double[2];
        boolean isDone = actionRule.doAction(0.0, origin);
        if (isDone) {
            return;
        }
        direction.get(directionArray);
        origin.get(originArray);
        currentPosition.set(origin);
        currentPosition.get(currentPositionArray);
        for (int i = 0; i < 2; ++i) {
            step[i] = directionArray[i] > 0.0 ? resolution : (directionArray[i] < 0.0 ? -resolution : 0.0);
            if (step[i] != 0.0) {
                double voxelBorder = currentPositionArray[i];
                tMax[i] = ((voxelBorder += step[i] * resolution * 0.5) - originArray[i]) / directionArray[i];
                tDelta[i] = resolution / Math.abs(directionArray[i]);
                continue;
            }
            tMax[i] = Double.POSITIVE_INFINITY;
            tDelta[i] = Double.POSITIVE_INFINITY;
        }
        for (boolean done = false; !done; done |= actionRule.doAction(distanceFromOrigin, currentPosition)) {
            int dim = tMax[0] < tMax[1] ? 0 : 1;
            int n = dim;
            currentPositionArray[n] = currentPositionArray[n] + step[dim];
            int n2 = dim;
            tMax[n2] = tMax[n2] + tDelta[dim];
            currentPosition.set(currentPositionArray);
            distanceFromOrigin = tMax[0] < tMax[1] ? tMax[0] : tMax[1];
            if (!(distanceFromOrigin > maxRange)) continue;
            done = true;
            break;
        }
    }

    public static boolean contains(HeightQuadTreeNode node, double squareRadius, double x, double y) {
        x = Math.abs(x - (double)node.getCenterX());
        y = Math.abs(y - (double)node.getCenterY());
        return (x += (double)(0.5f * node.getSizeX())) * x + (y += (double)(0.5f * node.getSizeY())) * y < squareRadius;
    }

    public static boolean overlaps(HeightQuadTreeNode node, double x, double y, double radius, double squareRadius) {
        double dx = Math.abs(x - (double)node.getCenterX());
        double dy = Math.abs(y - (double)node.getCenterY());
        float halfSizeX = 0.5f * node.getSizeX();
        float halfSizeY = 0.5f * node.getSizeY();
        if (dx > radius + (double)halfSizeX || dy > radius + (double)halfSizeY) {
            return false;
        }
        if (dx < (double)halfSizeX || dy < (double)halfSizeY) {
            return true;
        }
        return (dx -= (double)halfSizeX) * dx + (dy -= (double)halfSizeY) * dy < squareRadius;
    }

    public static boolean inside(HeightQuadTreeNode node, double x, double y, double radius) {
        x = Math.abs(x - (double)node.getCenterX());
        y = Math.abs(y - (double)node.getCenterY());
        if (x + radius > (double)(0.5f * node.getSizeX())) {
            return false;
        }
        return !(y + radius > (double)(0.5f * node.getSizeY()));
    }

    public static interface NeighborActionRule {
        public void doActionOnNeighbor(HeightQuadTreeNode var1);
    }

    public static interface RayActionRule {
        public boolean doAction(double var1, Point2D var3);
    }
}

