/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.quadTreeHeightMap;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.quadTreeHeightMap.HeightQuadTreeMessageConverter;
import us.ihmc.commons.PrintTools;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.toolbox.heightQuadTree.command.HeightQuadTreeToolboxRequestCommand;
import us.ihmc.humanoidRobotics.communication.toolbox.heightQuadTree.command.LidarScanCommand;
import us.ihmc.idl.IDLSequence;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.lists.FrameTupleArrayList;
import us.ihmc.robotics.quadTree.Box;
import us.ihmc.robotics.quadTree.QuadTreeForGround;
import us.ihmc.robotics.quadTree.QuadTreeForGroundParameters;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.pointClouds.combinationQuadTreeOctTree.QuadTreeForGroundHeightMap;
import us.ihmc.yoVariables.registry.YoRegistry;

public class HeightQuadTreeToolboxController
extends ToolboxController {
    private static final double RESOLUTION = 0.03;
    private static final boolean DEBUG = false;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double QUAD_TREE_EXTENT = 200.0;
    private final QuadTreeForGroundHeightMap quadTree;
    private float quadtreeHeightThreshold = 0.02f;
    private float quadTreeMaxMultiLevelZChangeToFilterNoise = 0.2f;
    private int maxSameHeightPointsPerNode = 4;
    private double maxAllowableXYDistanceForAPointToBeConsideredClose = 0.2;
    private int maximumNumberOfPoints = this.maxSameHeightPointsPerNode * 75000;
    private double minRange = 0.2;
    private double maxRange = 5.0;
    private double maxZ = 0.5;
    private final CommandInputManager commandInputManager;
    private final AtomicReference<RobotConfigurationData> robotConfigurationDataToProcess = new AtomicReference<Object>(null);
    private final AtomicReference<CapturabilityBasedStatus> capturabilityBasedStatusToProcess = new AtomicReference<Object>(null);
    private final FrameTupleArrayList<FramePoint3D> contactPoints = FrameTupleArrayList.createFramePointArrayList();
    private final int expectedRobotConfigurationDataHash;
    private final FullHumanoidRobotModel fullRobotModel;
    private final FloatingJointBasics rootJoint;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final Point2D robotPosition2d = new Point2D();
    private final double quadTreeMessageMaxRadius = 5.0;
    private final FramePoint3D scanPoint = new FramePoint3D();
    private final MutableBoolean quadTreeUpdateRequested = new MutableBoolean(false);
    private final FramePoint2D contactPoint2d = new FramePoint2D();

    public HeightQuadTreeToolboxController(FullHumanoidRobotModel fullRobotModel, CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, YoRegistry parentRegistry) {
        super(statusOutputManager, parentRegistry);
        this.fullRobotModel = fullRobotModel;
        this.rootJoint = fullRobotModel.getRootJoint();
        this.commandInputManager = commandInputManager;
        this.oneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        ForceSensorDefinition[] forceSensorDefinitions = fullRobotModel.getForceSensorDefinitions();
        IMUDefinition[] imuDefinitions = fullRobotModel.getIMUDefinitions();
        this.expectedRobotConfigurationDataHash = RobotConfigurationDataFactory.calculateJointNameHash((OneDoFJointReadOnly[])this.oneDoFJoints, (ForceSensorDefinition[])forceSensorDefinitions, (IMUDefinition[])imuDefinitions);
        Box bounds = new Box(-200.0, -200.0, 200.0, 200.0);
        QuadTreeForGroundParameters quadTreeParameters = new QuadTreeForGroundParameters(0.03, (double)this.quadtreeHeightThreshold, (double)this.quadTreeMaxMultiLevelZChangeToFilterNoise, this.maxSameHeightPointsPerNode, this.maxAllowableXYDistanceForAPointToBeConsideredClose, this.maximumNumberOfPoints);
        this.quadTree = new QuadTreeForGroundHeightMap(bounds, quadTreeParameters);
    }

    @Override
    public boolean initialize() {
        return true;
    }

    @Override
    public void updateInternal() {
        this.updateRobotContactPoints();
        if (this.contactPoints.isEmpty()) {
            return;
        }
        if (this.commandInputManager.isNewCommandAvailable(HeightQuadTreeToolboxRequestCommand.class)) {
            HeightQuadTreeToolboxRequestCommand command = (HeightQuadTreeToolboxRequestCommand)this.commandInputManager.pollNewestCommand(HeightQuadTreeToolboxRequestCommand.class);
            if (command.isQuadTreeUpdateRequested()) {
                this.quadTreeUpdateRequested.setValue(true);
            }
            if (command.isClearQuadTreeRequested()) {
                PrintTools.info((String)"clearing the quad tree!");
                this.quadTree.clearTree(Double.NaN);
                this.commandInputManager.clearAllCommands();
                return;
            }
        }
        if (!this.quadTree.hasPoints()) {
            for (int contactPointIndex = 0; contactPointIndex < this.contactPoints.size(); ++contactPointIndex) {
                FramePoint3D contactPoint = (FramePoint3D)this.contactPoints.get(contactPointIndex);
                this.quadTree.addPoint(contactPoint.getX(), contactPoint.getY(), contactPoint.getZ());
            }
        }
        if (!this.commandInputManager.isNewCommandAvailable(LidarScanCommand.class)) {
            return;
        }
        List newPointClouds = this.commandInputManager.pollNewCommands(LidarScanCommand.class);
        Point3D lidarPosition = new Point3D();
        for (int pointCloudIndex = 0; pointCloudIndex < newPointClouds.size(); ++pointCloudIndex) {
            LidarScanCommand scan = (LidarScanCommand)newPointClouds.get(pointCloudIndex);
            scan.getLidarPosition(lidarPosition);
            for (int pointIndex = 0; pointIndex < scan.getNumberOfPoints(); ++pointIndex) {
                scan.getFramePoint(pointIndex, this.scanPoint);
                this.scanPoint.changeFrame(worldFrame);
                double distanceFromSensor = this.scanPoint.distance((Point3DReadOnly)lidarPosition);
                if (distanceFromSensor > this.maxRange || distanceFromSensor < this.minRange || this.scanPoint.getZ() > lidarPosition.getZ() + this.maxZ) continue;
                double x = this.scanPoint.getX();
                double y = this.scanPoint.getY();
                double z = this.scanPoint.getZ();
                this.quadTree.addPoint(x, y, z);
            }
        }
        if (this.quadTreeUpdateRequested.booleanValue()) {
            Point3D rootJointPosition = new Point3D();
            rootJointPosition.set((Tuple3DReadOnly)this.rootJoint.getJointPose().getPosition());
            this.robotPosition2d.set(rootJointPosition.getX(), rootJointPosition.getY());
            this.reportMessage(HeightQuadTreeMessageConverter.convertQuadTreeForGround((QuadTreeForGround)this.quadTree, this.robotPosition2d, 5.0));
            this.quadTreeUpdateRequested.setValue(false);
        }
    }

    private void updateRobotContactPoints() {
        CapturabilityBasedStatus capturabilityBasedStatus;
        RobotConfigurationData robotConfigurationData = this.robotConfigurationDataToProcess.getAndSet(null);
        if (robotConfigurationData != null) {
            if (this.expectedRobotConfigurationDataHash != robotConfigurationData.getJointNameHash()) {
                throw new RuntimeException("Received a " + RobotConfigurationData.class.getSimpleName() + " that does not match the fullRobotModel.");
            }
            IDLSequence.Float newJointAngles = robotConfigurationData.getJointAngles();
            for (int i = 0; i < newJointAngles.size(); ++i) {
                this.oneDoFJoints[i].setQ((double)newJointAngles.get(i));
            }
            Vector3D translation = robotConfigurationData.getRootTranslation();
            this.rootJoint.getJointPose().getPosition().set(translation.getX(), translation.getY(), translation.getZ());
            Quaternion orientation = robotConfigurationData.getRootOrientation();
            this.rootJoint.getJointPose().getOrientation().setQuaternion(orientation.getX(), orientation.getY(), orientation.getZ(), orientation.getS());
            this.rootJoint.getPredecessor().updateFramesRecursively();
        }
        if ((capturabilityBasedStatus = (CapturabilityBasedStatus)this.capturabilityBasedStatusToProcess.getAndSet(null)) != null) {
            this.contactPoints.clear();
            for (RobotSide robotSide : RobotSide.values) {
                MovingReferenceFrame soleFrame = this.fullRobotModel.getSoleFrame((Enum)robotSide);
                FrameConvexPolygon2D footSupportPolygon = HumanoidMessageTools.unpackFootSupportPolygon((CapturabilityBasedStatus)capturabilityBasedStatus, (RobotSide)robotSide);
                for (int contactPointIndex = 0; contactPointIndex < footSupportPolygon.getNumberOfVertices(); ++contactPointIndex) {
                    this.contactPoint2d.setIncludingFrame((FrameTuple2DReadOnly)footSupportPolygon.getVertex(contactPointIndex));
                    this.findProjectionOntoPlaneFrame((ReferenceFrame)soleFrame, this.contactPoint2d, (FramePoint3D)this.contactPoints.add());
                }
            }
        }
    }

    private void findProjectionOntoPlaneFrame(ReferenceFrame planeFrame, FramePoint2D pointInWorld, FramePoint3D pointProjectedOntoPlaneFrameToPack) {
        pointInWorld.checkReferenceFrameMatch(worldFrame);
        double z = this.getPlaneZGivenXY(planeFrame, pointInWorld.getX(), pointInWorld.getY());
        pointProjectedOntoPlaneFrameToPack.setIncludingFrame((FrameTuple2DReadOnly)pointInWorld, z);
    }

    private double getPlaneZGivenXY(ReferenceFrame planeFrame, double xWorld, double yWorld) {
        RigidBodyTransform fromLocalToWorldTransform = planeFrame.getTransformToWorldFrame();
        double x0 = fromLocalToWorldTransform.getM03();
        double y0 = fromLocalToWorldTransform.getM13();
        double z0 = fromLocalToWorldTransform.getM23();
        double a = fromLocalToWorldTransform.getM02();
        double b = fromLocalToWorldTransform.getM12();
        double c = fromLocalToWorldTransform.getM22();
        double z = a / c * (x0 - xWorld) + b / c * (y0 - yWorld) + z0;
        return z;
    }

    public void receivedPacket(RobotConfigurationData packet) {
        if (packet != null) {
            this.robotConfigurationDataToProcess.set(packet);
        }
    }

    public void receivedPacket(CapturabilityBasedStatus packet) {
        if (packet != null) {
            this.capturabilityBasedStatusToProcess.set(packet);
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

