/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.stepConstraintToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.PlanarRegionsListMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.StepConstraintMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.stepAdjustment.SimpleStep;
import us.ihmc.avatar.stepAdjustment.StepConstraintCalculator;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.communication.packets.ToolboxState;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintMessageConverter;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintRegion;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class StepConstraintToolboxController
extends ToolboxController {
    private final FullHumanoidRobotModel fullRobotModel;
    private final StepConstraintCalculator stepConstraintCalculator;
    private final YoDouble time;
    private final YoBoolean isDone;
    private final IHMCRealtimeROS2Publisher<StepConstraintMessage> constraintRegionPublisher;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final HumanoidReferenceFrames referenceFrames;
    private final AtomicReference<RobotConfigurationData> configurationData;
    private final AtomicReference<CapturabilityBasedStatus> capturabilityBasedStatus;
    private final AtomicReference<FootstepStatusMessage> footstepStatusMessage;
    private final AtomicReference<PlanarRegionsListMessage> planarRegions;

    public StepConstraintToolboxController(StatusMessageOutputManager statusOutputManager, IHMCRealtimeROS2Publisher<StepConstraintMessage> constraintRegionPublisher, WalkingControllerParameters walkingControllerParameters, FullHumanoidRobotModel fullRobotModel, double gravityZ, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        super(statusOutputManager, parentRegistry);
        this.time = new YoDouble("time", this.registry);
        this.isDone = new YoBoolean("isDone", this.registry);
        this.configurationData = new AtomicReference();
        this.capturabilityBasedStatus = new AtomicReference();
        this.footstepStatusMessage = new AtomicReference();
        this.planarRegions = new AtomicReference();
        this.constraintRegionPublisher = constraintRegionPublisher;
        this.fullRobotModel = fullRobotModel;
        this.referenceFrames = new HumanoidReferenceFrames(fullRobotModel);
        this.stepConstraintCalculator = new StepConstraintCalculator(walkingControllerParameters, (SideDependentList<? extends ReferenceFrame>)this.referenceFrames.getSoleZUpFrames(), this.referenceFrames.getCenterOfMassFrame(), (DoubleProvider)this.time, gravityZ);
        parentRegistry.addChild(this.stepConstraintCalculator.getYoVariableRegistry());
        if (graphicsListRegistry != null) {
            graphicsListRegistry.registerYoGraphicsLists(this.stepConstraintCalculator.getYoGraphicsListRegistry().getYoGraphicsLists());
            ArrayList artifactLists = new ArrayList();
            this.stepConstraintCalculator.getYoGraphicsListRegistry().getRegisteredArtifactLists(artifactLists);
            graphicsListRegistry.registerArtifactLists(artifactLists);
        }
        this.oneDoFJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        this.isDone.set(false);
    }

    @Override
    public boolean initialize() {
        this.isDone.set(false);
        return true;
    }

    @Override
    public void updateInternal() {
        try {
            StepConstraintRegion constraintRegion;
            PlanarRegionsListMessage planarRegions;
            FootstepStatusMessage footstepStatusMessage;
            CapturabilityBasedStatus capturabilityBasedStatus;
            RobotConfigurationData configurationData = this.configurationData.getAndSet(null);
            if (configurationData != null) {
                this.time.set(Conversions.nanosecondsToSeconds((long)configurationData.getMonotonicTime()));
                KinematicsToolboxHelper.setRobotStateFromRobotConfigurationData(configurationData, this.fullRobotModel.getRootJoint(), this.oneDoFJoints);
                this.referenceFrames.updateFrames();
            }
            if ((capturabilityBasedStatus = (CapturabilityBasedStatus)this.capturabilityBasedStatus.getAndSet(null)) != null) {
                this.stepConstraintCalculator.setRightFootSupportPolygon((List<? extends Point3DReadOnly>)capturabilityBasedStatus.getRightFootSupportPolygon3d());
                this.stepConstraintCalculator.setLeftFootSupportPolygon((List<? extends Point3DReadOnly>)capturabilityBasedStatus.getLeftFootSupportPolygon3d());
                this.stepConstraintCalculator.setOmega(capturabilityBasedStatus.getOmega());
                this.stepConstraintCalculator.setCapturePoint((Point3DReadOnly)capturabilityBasedStatus.getCapturePoint2d());
            }
            if ((footstepStatusMessage = (FootstepStatusMessage)this.footstepStatusMessage.getAndSet(null)) != null) {
                if (FootstepStatus.fromByte((byte)footstepStatusMessage.getFootstepStatus()) == FootstepStatus.STARTED) {
                    SimpleStep simpleStep = new SimpleStep(footstepStatusMessage, this.time.getDoubleValue());
                    this.stepConstraintCalculator.setCurrentStep(simpleStep);
                } else {
                    this.stepConstraintCalculator.reset();
                }
            }
            if ((planarRegions = (PlanarRegionsListMessage)this.planarRegions.getAndSet(null)) != null) {
                this.stepConstraintCalculator.setPlanarRegions(PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)planarRegions));
            }
            this.stepConstraintCalculator.update();
            if (this.stepConstraintCalculator.constraintRegionChanged() && (constraintRegion = this.stepConstraintCalculator.pollStepConstraintRegion()) != null) {
                this.constraintRegionPublisher.publish((Object)StepConstraintMessageConverter.convertToStepConstraintMessage((StepConstraintRegion)constraintRegion));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                this.reportMessage(MessageTools.createControllerCrashNotificationPacket(null, (Throwable)e));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.isDone.set(true);
        }
    }

    @Override
    public void notifyToolboxStateChange(ToolboxState newState) {
    }

    @Override
    public boolean isDone() {
        return this.isDone.getValue();
    }

    public void setSwitchPlanarRegionConstraintsAutomatically(boolean switchAutomatically) {
        this.stepConstraintCalculator.setSwitchPlanarRegionConstraintsAutomatically(switchAutomatically);
    }

    public void updateRobotConfigurationData(RobotConfigurationData newConfigurationData) {
        this.configurationData.set(newConfigurationData);
    }

    public void updateCapturabilityBasedStatus(CapturabilityBasedStatus newStatus) {
        this.capturabilityBasedStatus.set(newStatus);
    }

    public void updateFootstepStatus(FootstepStatusMessage footstepStatusMessage) {
        this.footstepStatusMessage.set(footstepStatusMessage);
    }

    public void updatePlanarRegions(PlanarRegionsListMessage planarRegionsListMessage) {
        this.planarRegions.set(planarRegionsListMessage);
    }

    public double getTime() {
        return this.time.getDoubleValue();
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }
}

