/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher;

import controller_msgs.msg.dds.LidarScanMessage;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import sensor_msgs.PointCloud2;
import us.ihmc.communication.packets.LidarPointCloudCompression;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.communication.converters.ScanPointFilter;
import us.ihmc.robotEnvironmentAwareness.communication.converters.StereoPointCloudCompression;
import us.ihmc.utilities.ros.subscriber.RosPointCloudSubscriber;

public class PointCloudData {
    private final long timestamp;
    private final int numberOfPoints;
    private final Point3D[] pointCloud;
    private final List<Point3D> filteredPointCloud = new ArrayList<Point3D>();
    private final int[] colors;

    public PointCloudData(long timestamp, Point3D[] scanPoints, int[] scanColors) {
        this.timestamp = timestamp;
        this.pointCloud = scanPoints;
        this.numberOfPoints = scanPoints.length;
        if (scanColors != null) {
            if (scanPoints.length != scanColors.length) {
                throw new IllegalArgumentException("wrong size!");
            }
            this.colors = scanColors;
        } else {
            this.colors = null;
        }
    }

    public PointCloudData(PointCloud2 rosPointCloud2, int maxSize, boolean hasColors) {
        this.timestamp = rosPointCloud2.getHeader().getStamp().totalNsecs();
        RosPointCloudSubscriber.UnpackedPointCloud unpackPointsAndIntensities = RosPointCloudSubscriber.unpackPointsAndIntensities((PointCloud2)rosPointCloud2);
        this.pointCloud = unpackPointsAndIntensities.getPoints();
        this.colors = (int[])(hasColors ? unpackPointsAndIntensities.getPointColorsRGB() : null);
        if (unpackPointsAndIntensities.getPoints().length <= maxSize) {
            this.numberOfPoints = this.pointCloud.length;
        } else {
            int currentSize;
            Random random = new Random();
            if (hasColors) {
                for (currentSize = this.pointCloud.length; currentSize > maxSize; --currentSize) {
                    int nextToRemove = random.nextInt(currentSize);
                    this.pointCloud[nextToRemove] = this.pointCloud[currentSize - 1];
                    this.colors[nextToRemove] = this.colors[currentSize - 1];
                    this.pointCloud[currentSize - 1] = null;
                    this.colors[currentSize - 1] = -1;
                }
            } else {
                while (currentSize > maxSize) {
                    int nextToRemove = random.nextInt(currentSize);
                    this.pointCloud[nextToRemove] = this.pointCloud[currentSize - 1];
                    this.pointCloud[currentSize - 1] = null;
                    --currentSize;
                }
            }
            this.numberOfPoints = maxSize;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public Point3D[] getPointCloud() {
        return this.pointCloud;
    }

    public int[] getColors() {
        return this.colors;
    }

    public StereoVisionPointCloudMessage toStereoVisionPointCloudMessage(double minimumResolution) {
        return this.toStereoVisionPointCloudMessage(minimumResolution, (index, point) -> true);
    }

    public StereoVisionPointCloudMessage toStereoVisionPointCloudMessage(double minimumResolution, ScanPointFilter filter) {
        if (this.colors == null) {
            throw new IllegalStateException("This pointcloud has no colors.");
        }
        return StereoPointCloudCompression.compressPointCloud((long)this.timestamp, (Point3DReadOnly[])this.pointCloud, (int[])this.colors, (int)this.numberOfPoints, (double)minimumResolution, (ScanPointFilter)filter);
    }

    public LidarScanMessage toLidarScanMessage() {
        return this.toLidarScanMessage(null);
    }

    public LidarScanMessage toLidarScanMessage(ScanPointFilter filter) {
        LidarScanMessage message = new LidarScanMessage();
        message.setRobotTimestamp(this.timestamp);
        message.setSensorPoseConfidence(1.0);
        if (filter == null) {
            LidarPointCloudCompression.compressPointCloud((int)this.pointCloud.length, (LidarScanMessage)message, (i, j) -> this.pointCloud[i].getElement32(j));
        } else {
            this.filteredPointCloud.clear();
            for (int i2 = 0; i2 < this.numberOfPoints; ++i2) {
                Point3D scanPoint = this.pointCloud[i2];
                if (!filter.test(i2, (Point3DReadOnly)scanPoint)) continue;
                this.filteredPointCloud.add(scanPoint);
            }
            LidarPointCloudCompression.compressPointCloud((int)this.filteredPointCloud.size(), (LidarScanMessage)message, (i, j) -> this.filteredPointCloud.get(i).getElement32(j));
        }
        return message;
    }

    public void flipToZUp() {
        for (int i = 0; i < this.numberOfPoints; ++i) {
            double x = this.pointCloud[i].getX();
            double y = this.pointCloud[i].getY();
            double z = this.pointCloud[i].getZ();
            this.pointCloud[i].set(z, -x, -y);
        }
    }

    public void applyTransform(RigidBodyTransform transform) {
        for (int i = 0; i < this.numberOfPoints; ++i) {
            this.pointCloud[i].applyTransform((Transform)transform);
        }
    }

    public String toString() {
        return "Pointcloud data, number of points: " + this.numberOfPoints;
    }
}

