/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher;

import com.google.common.util.concurrent.AtomicDouble;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import sensor_msgs.PointCloud2;
import us.ihmc.avatar.networkProcessor.lidarScanPublisher.ScanPointFilterList;
import us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher.CollidingScanPointFilter;
import us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher.PointCloudData;
import us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher.RangeScanPointFilter;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.ihmcPerception.depthData.CollisionBoxProvider;
import us.ihmc.ihmcPerception.depthData.CollisionShapeTester;
import us.ihmc.log.LogTools;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.FullRobotModelFactory;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataBuffer;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.subscriber.RosPointCloudSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class StereoVisionPointCloudPublisher {
    private static final boolean Debug = false;
    private static final int DEFAULT_MAX_NUMBER_OF_POINTS = 50000;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final String name = this.getClass().getSimpleName();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(ThreadTools.getNamedThreadFactory((String)this.name));
    private ScheduledFuture<?> publisherTask;
    private final AtomicReference<PointCloudData> rosPointCloud2ToPublish = new AtomicReference<Object>(null);
    private final String robotName;
    private final FullRobotModel fullRobotModel;
    private ReferenceFrame stereoVisionPointsFrame = worldFrame;
    private StereoVisionWorldTransformCalculator stereoVisionTransformer = null;
    private final RobotConfigurationDataBuffer robotConfigurationDataBuffer = new RobotConfigurationDataBuffer();
    private RobotROSClockCalculator rosClockCalculator = null;
    private final Consumer<StereoVisionPointCloudMessage> pointcloudPublisher;
    private int maximumNumberOfPoints = 50000;
    private RangeScanPointFilter rangeFilter = null;
    private CollidingScanPointFilter collisionFilter;
    private final ScanPointFilterList activeFilters = new ScanPointFilterList();
    private long previousTimeStamp = 0L;
    private final Point3D previousSensorPosition = new Point3D();
    private final Quaternion previousSensorOrientation = new Quaternion();
    private final AtomicBoolean enableFilter = new AtomicBoolean(false);
    private final AtomicDouble linearVelocityThreshold = new AtomicDouble(Double.MAX_VALUE);
    private final AtomicDouble angularVelocityThreshold = new AtomicDouble(Double.MAX_VALUE);
    private long publisherPeriodInMillisecond = 200L;
    private double minimumResolution = 0.005;
    private final RigidBodyTransform transformToWorld = new RigidBodyTransform();
    private final Pose3D sensorPose = new Pose3D();

    public StereoVisionPointCloudPublisher(FullRobotModelFactory modelFactory, ROS2NodeInterface ros2Node, ROS2Topic<StereoVisionPointCloudMessage> topic) {
        this(modelFactory.getRobotDescription().getName(), modelFactory.createFullRobotModel(), ros2Node, topic);
    }

    public StereoVisionPointCloudPublisher(String robotName, FullRobotModel fullRobotModel, ROS2NodeInterface ros2Node, ROS2Topic<StereoVisionPointCloudMessage> topic) {
        this.robotName = robotName;
        this.fullRobotModel = fullRobotModel;
        ROS2Tools.createCallbackSubscription((ROS2NodeInterface)ros2Node, (ROS2Topic)ROS2Tools.getRobotConfigurationDataTopic((String)robotName), s -> this.robotConfigurationDataBuffer.receivedPacket((RobotConfigurationData)s.takeNextData()));
        LogTools.info((String)"Creating stereo point cloud publisher. Topic name: {}", (Object)topic.getName());
        this.pointcloudPublisher = arg_0 -> ((IHMCROS2Publisher)ROS2Tools.createPublisher((ROS2NodeInterface)ros2Node, topic)).publish(arg_0);
    }

    public StereoVisionPointCloudPublisher(String robotName, FullRobotModel fullRobotModel, RealtimeROS2Node realtimeROS2Node, ROS2Topic<StereoVisionPointCloudMessage> topic) {
        this.robotName = robotName;
        this.fullRobotModel = fullRobotModel;
        ROS2Tools.createCallbackSubscription((RealtimeROS2Node)realtimeROS2Node, (ROS2Topic)ROS2Tools.getRobotConfigurationDataTopic((String)robotName), s -> this.robotConfigurationDataBuffer.receivedPacket((RobotConfigurationData)s.takeNextData()));
        LogTools.info((String)"Creating stereo point cloud publisher. Topic name: {}", (Object)topic.getName());
        this.pointcloudPublisher = arg_0 -> ((IHMCRealtimeROS2Publisher)ROS2Tools.createPublisher((RealtimeROS2Node)realtimeROS2Node, topic)).publish(arg_0);
    }

    public void setMaximumNumberOfPoints(int maximumNumberOfPoints) {
        this.maximumNumberOfPoints = maximumNumberOfPoints;
    }

    public void setPublisherPeriodInMillisecond(long publisherPeriodInMillisecond) {
        this.publisherPeriodInMillisecond = publisherPeriodInMillisecond;
        if (this.publisherTask != null) {
            this.publisherTask.cancel(false);
            this.start();
        }
    }

    public void start() {
        this.publisherTask = this.executorService.scheduleAtFixedRate(this::readAndPublishInternal, 0L, this.publisherPeriodInMillisecond, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.publisherTask.cancel(false);
        this.executorService.shutdownNow();
    }

    public void setMinimumResolution(double minimumResolution) {
        this.minimumResolution = minimumResolution;
    }

    public void setSelfCollisionFilter(CollisionBoxProvider collisionBoxProvider) {
        if (this.collisionFilter != null) {
            return;
        }
        this.collisionFilter = new CollidingScanPointFilter(new CollisionShapeTester(this.fullRobotModel, collisionBoxProvider));
        this.activeFilters.addFilter(this.collisionFilter);
    }

    public void setRangeFilter(double minRange, double maxRange) {
        if (this.rangeFilter == null) {
            this.rangeFilter = new RangeScanPointFilter();
            this.activeFilters.addFilter(this.rangeFilter);
        }
        this.rangeFilter.setMinRange(minRange);
        this.rangeFilter.setMaxRange(maxRange);
    }

    public void receiveStereoPointCloudFromROS1(String stereoPointCloudROSTopic, URI rosCoreURI) {
        String graphName = this.robotName + "/" + this.name;
        RosMainNode rosMainNode = new RosMainNode(rosCoreURI, graphName, true);
        this.receiveStereoPointCloudFromROS1(stereoPointCloudROSTopic, rosMainNode);
    }

    public void receiveStereoPointCloudFromROS1(String stereoPointCloudROSTopic, RosMainNode rosMainNode) {
        rosMainNode.attachSubscriber(stereoPointCloudROSTopic, (RosTopicSubscriberInterface)this.createROSPointCloud2Subscriber());
    }

    public void setROSClockCalculator(RobotROSClockCalculator rosClockCalculator) {
        this.rosClockCalculator = rosClockCalculator;
    }

    public void setCustomStereoVisionTransformer(StereoVisionWorldTransformCalculator transformer) {
        this.stereoVisionTransformer = transformer;
    }

    private RosPointCloudSubscriber createROSPointCloud2Subscriber() {
        return new RosPointCloudSubscriber(){

            public void onNewMessage(PointCloud2 pointCloud) {
                StereoVisionPointCloudPublisher.this.rosPointCloud2ToPublish.set(new PointCloudData(pointCloud, StereoVisionPointCloudPublisher.this.maximumNumberOfPoints, true));
            }
        };
    }

    public void updateScanData(PointCloudData scanDataToPublish) {
        this.rosPointCloud2ToPublish.set(scanDataToPublish);
    }

    public void readAndPublish() {
        if (this.publisherTask != null) {
            throw new RuntimeException("The publisher is running using its own thread, cannot manually update it.");
        }
        this.readAndPublishInternal();
    }

    private void readAndPublishInternal() {
        try {
            this.transformDataAndPublish();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.executorService.shutdown();
        }
    }

    private void transformDataAndPublish() {
        long robotTimestamp;
        PointCloudData pointCloudData = this.rosPointCloud2ToPublish.getAndSet(null);
        if (pointCloudData == null) {
            return;
        }
        if (this.rosClockCalculator == null) {
            robotTimestamp = pointCloudData.getTimestamp();
            this.robotConfigurationDataBuffer.updateFullRobotModelWithNewestData(this.fullRobotModel, null);
        } else {
            boolean success;
            long rosTimestamp = pointCloudData.getTimestamp();
            robotTimestamp = this.rosClockCalculator.computeRobotMonotonicTime(rosTimestamp);
            boolean waitForTimestamp = true;
            if (this.robotConfigurationDataBuffer.getNewestTimestamp() == -1L) {
                return;
            }
            boolean bl = success = this.robotConfigurationDataBuffer.updateFullRobotModel(waitForTimestamp, robotTimestamp, this.fullRobotModel, null) != -1L;
            if (!success) {
                return;
            }
        }
        if (this.stereoVisionTransformer != null) {
            this.stereoVisionTransformer.computeTransformToWorld(this.fullRobotModel, this.transformToWorld, (Pose3DBasics)this.sensorPose);
            pointCloudData.applyTransform(this.transformToWorld);
        } else {
            if (!this.stereoVisionPointsFrame.isWorldFrame()) {
                this.stereoVisionPointsFrame.getTransformToDesiredFrame(this.transformToWorld, worldFrame);
                pointCloudData.applyTransform(this.transformToWorld);
            }
            this.fullRobotModel.getHeadBaseFrame().getTransformToDesiredFrame(this.transformToWorld, worldFrame);
            this.sensorPose.set((RigidBodyTransformReadOnly)this.transformToWorld);
        }
        if (this.enableFilter.get()) {
            double timeDiff = Conversions.nanosecondsToSeconds((long)(robotTimestamp - this.previousTimeStamp));
            double linearVelocity = this.sensorPose.getPosition().distance((Point3DReadOnly)this.previousSensorPosition) / timeDiff;
            double angularVelocity = this.sensorPose.getOrientation().distance((QuaternionReadOnly)this.previousSensorOrientation) / timeDiff;
            this.previousTimeStamp = robotTimestamp;
            this.previousSensorPosition.set(this.sensorPose.getPosition());
            this.previousSensorOrientation.set(this.sensorPose.getOrientation());
            if (linearVelocity > this.linearVelocityThreshold.get() || angularVelocity > this.angularVelocityThreshold.get()) {
                return;
            }
        }
        if (this.collisionFilter != null) {
            this.collisionFilter.update();
        }
        if (this.rangeFilter != null) {
            this.rangeFilter.setSensorPosition((Point3DReadOnly)this.sensorPose.getPosition());
        }
        long startTime = System.nanoTime();
        StereoVisionPointCloudMessage message = pointCloudData.toStereoVisionPointCloudMessage(this.minimumResolution, this.activeFilters);
        if (message == null) {
            return;
        }
        message.getSensorPosition().set(this.sensorPose.getPosition());
        message.getSensorOrientation().set(this.sensorPose.getOrientation());
        long endTime = System.nanoTime();
        this.pointcloudPublisher.accept(message);
    }

    public void enableFilter(boolean enable) {
        this.enableFilter.set(enable);
    }

    public void setFilterThreshold(double linearVelocityThreshold, double angularVelocityThreshold) {
        this.linearVelocityThreshold.set(linearVelocityThreshold);
        this.angularVelocityThreshold.set(angularVelocityThreshold);
    }

    public static interface StereoVisionWorldTransformCalculator {
        public void computeTransformToWorld(FullRobotModel var1, RigidBodyTransform var2, Pose3DBasics var3);
    }
}

