/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.supportingPlanarRegionPublisher;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;

public class BipedalSupportPlanarRegionCalculator {
    private static final int LEFT_FOOT_INDEX = 0;
    private static final int RIGHT_FOOT_INDEX = 1;
    private static final int CONVEX_HULL_INDEX = 2;
    private final List<PlanarRegion> supportRegions = new ArrayList<PlanarRegion>();
    private final FullHumanoidRobotModel fullRobotModel;
    private final OneDoFJointBasics[] allJointsExcludingHands;
    private final HumanoidReferenceFrames referenceFrames;
    private final SideDependentList<ContactablePlaneBody> contactableFeet;
    private final SideDependentList<List<FramePoint2D>> scaledContactPointList = new SideDependentList(new ArrayList(), new ArrayList());

    public BipedalSupportPlanarRegionCalculator(DRCRobotModel robotModel) {
        String robotName = robotModel.getSimpleRobotName();
        this.fullRobotModel = robotModel.createFullRobotModel();
        this.allJointsExcludingHands = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel);
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFullRobotModel((FullLeggedRobotModel)this.fullRobotModel);
        contactableBodiesFactory.setReferenceFrames((CommonLeggedReferenceFrames)this.referenceFrames);
        contactableBodiesFactory.setFootContactPoints(robotModel.getContactPointParameters().getControllerFootGroundContactPoints());
        this.contactableFeet = new SideDependentList(contactableBodiesFactory.createFootContactablePlaneBodies());
        for (int i = 0; i < 3; ++i) {
            this.supportRegions.add(new PlanarRegion());
        }
    }

    public void initializeEmptyRegions() {
        this.supportRegions.set(0, new PlanarRegion());
        this.supportRegions.set(1, new PlanarRegion());
        this.supportRegions.set(2, new PlanarRegion());
    }

    public void calculateSupportRegions(double scaleFactor, CapturabilityBasedStatus capturabilityBasedStatus, RobotConfigurationData robotConfigurationData) {
        this.initializeEmptyRegions();
        for (RobotSide robotSide : RobotSide.values) {
            ((List)this.scaledContactPointList.get((Enum)robotSide)).clear();
            for (FramePoint2D contactPoint : ((ContactablePlaneBody)this.contactableFeet.get((Enum)robotSide)).getContactPoints2d()) {
                FramePoint2D scaledContactPoint = new FramePoint2D((FrameTuple2DReadOnly)contactPoint);
                scaledContactPoint.scale(scaleFactor);
                ((List)this.scaledContactPointList.get((Enum)robotSide)).add(scaledContactPoint);
            }
        }
        KinematicsToolboxHelper.setRobotStateFromRobotConfigurationData(robotConfigurationData, this.fullRobotModel.getRootJoint(), this.allJointsExcludingHands);
        this.referenceFrames.updateFrames();
        SideDependentList isInSupport = new SideDependentList((Object)(!capturabilityBasedStatus.getLeftFootSupportPolygon3d().isEmpty() ? 1 : 0), (Object)(!capturabilityBasedStatus.getRightFootSupportPolygon3d().isEmpty() ? 1 : 0));
        if (this.feetAreInSamePlane((SideDependentList<Boolean>)isInSupport)) {
            ReferenceFrame leftSoleFrame = ((ContactablePlaneBody)this.contactableFeet.get((Enum)RobotSide.LEFT)).getSoleFrame();
            ArrayList allContactPoints = new ArrayList();
            allContactPoints.addAll((Collection)this.scaledContactPointList.get((Enum)RobotSide.LEFT));
            allContactPoints.addAll((Collection)this.scaledContactPointList.get((Enum)RobotSide.RIGHT));
            allContactPoints.forEach(p -> p.changeFrameAndProjectToXYPlane(leftSoleFrame));
            this.supportRegions.set(0, new PlanarRegion());
            this.supportRegions.set(1, new PlanarRegion());
            this.supportRegions.set(2, new PlanarRegion((RigidBodyTransformReadOnly)leftSoleFrame.getTransformToWorldFrame(), (Vertex2DSupplier)new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(allContactPoints))));
        } else {
            for (RobotSide robotSide : RobotSide.values) {
                if (((Boolean)isInSupport.get((Enum)robotSide)).booleanValue()) {
                    ContactablePlaneBody contactableFoot = (ContactablePlaneBody)this.contactableFeet.get((Enum)robotSide);
                    List contactPoints = (List)this.scaledContactPointList.get((Enum)robotSide);
                    RigidBodyTransform transformToWorld = contactableFoot.getSoleFrame().getTransformToWorldFrame();
                    this.supportRegions.set(robotSide.ordinal(), new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, (Vertex2DSupplier)new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((List)contactPoints))));
                    continue;
                }
                this.supportRegions.set(robotSide.ordinal(), new PlanarRegion());
            }
            this.supportRegions.set(2, new PlanarRegion());
        }
    }

    private boolean feetAreInSamePlane(SideDependentList<Boolean> isInSupport) {
        for (RobotSide robotSide : RobotSide.values) {
            if (((Boolean)isInSupport.get((Enum)robotSide)).booleanValue()) continue;
            return false;
        }
        ReferenceFrame leftSoleFrame = ((ContactablePlaneBody)this.contactableFeet.get((Enum)RobotSide.LEFT)).getSoleFrame();
        ReferenceFrame rightSoleFrame = ((ContactablePlaneBody)this.contactableFeet.get((Enum)RobotSide.RIGHT)).getSoleFrame();
        RigidBodyTransform relativeSoleTransform = leftSoleFrame.getTransformToDesiredFrame(rightSoleFrame);
        RotationMatrixBasics relativeOrientation = relativeSoleTransform.getRotation();
        double rotationEpsilon = Math.toRadians(3.0);
        double translationEpsilon = 0.02;
        return Math.abs(relativeOrientation.getPitch()) < rotationEpsilon && Math.abs(relativeOrientation.getRoll()) < rotationEpsilon && Math.abs(relativeSoleTransform.getTranslationZ()) < translationEpsilon;
    }

    public List<PlanarRegion> getSupportRegions() {
        for (int i = 0; i < 3; ++i) {
            this.supportRegions.get(i).setRegionId(i);
        }
        return this.supportRegions;
    }

    public PlanarRegionsList getSupportRegionsAsList() {
        return new PlanarRegionsList(this.getSupportRegions());
    }
}

