/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.walkingPreview;

import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WalkingControllerPreviewOutputMessage;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.avatar.networkProcessor.walkingPreview.WalkingControllerPreviewToolboxController;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.walkingPreviewToolboxAPI.WalkingControllerPreviewInputCommand;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.yoVariables.registry.YoRegistry;

public class WalkingControllerPreviewToolboxModule
extends ToolboxModule {
    private final WalkingControllerPreviewToolboxController controller;

    public WalkingControllerPreviewToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, RealtimeROS2Node realtimeROS2Node) throws IOException {
        this(robotModel, startYoVariableServer, realtimeROS2Node, null);
    }

    public WalkingControllerPreviewToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, DomainFactory.PubSubImplementation pubSubImplementation) throws IOException {
        this(robotModel, startYoVariableServer, null, pubSubImplementation);
    }

    private WalkingControllerPreviewToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, RealtimeROS2Node realtimeROS2Node, DomainFactory.PubSubImplementation pubSubImplementation) throws IOException {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 1, realtimeROS2Node, pubSubImplementation);
        this.setTimeWithoutInputsBeforeGoingToSleep(60.0);
        this.controller = new WalkingControllerPreviewToolboxController(robotModel, 0.02, this.commandInputManager, this.statusOutputManager, this.yoGraphicsListRegistry, this.registry);
        this.startYoVariableServer();
    }

    @Override
    public void registerExtraPuSubs(RealtimeROS2Node realtimeROS2Node) {
        ROS2Topic controllerOutputTopic = ROS2Tools.getControllerOutputTopic((String)this.robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> {
            if (this.controller != null) {
                this.controller.updateRobotConfigurationData((RobotConfigurationData)s.takeNextData());
            }
        });
    }

    @Override
    public WalkingControllerPreviewToolboxController getToolboxController() {
        return this.controller;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return WalkingControllerPreviewToolboxModule.supportedCommands();
    }

    public static List<Class<? extends Command<?, ?>>> supportedCommands() {
        return Collections.singletonList(WalkingControllerPreviewInputCommand.class);
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return WalkingControllerPreviewToolboxModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        return Collections.singletonList(WalkingControllerPreviewOutputMessage.class);
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return WalkingControllerPreviewToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return ROS2Tools.WALKING_PREVIEW_TOOLBOX.withRobot(robotName).withOutput();
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return WalkingControllerPreviewToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return ROS2Tools.WALKING_PREVIEW_TOOLBOX.withRobot(robotName).withInput();
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }
}

