/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.walkingPreview;

import us.ihmc.avatar.networkProcessor.walkingPreview.WalkingPreviewContactStateHolder;
import us.ihmc.avatar.networkProcessor.walkingPreview.WalkingPreviewTask;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WalkingHighLevelHumanoidController;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class WalkingPreviewResetTask
implements WalkingPreviewTask {
    private final SideDependentList<YoPlaneContactState> footContactStates;
    private final SideDependentList<WalkingPreviewContactStateHolder> contactStateHolders = new SideDependentList();
    private final InverseDynamicsCommandList commandList = new InverseDynamicsCommandList();
    private final WalkingHighLevelHumanoidController walkingController;
    private int count = 0;
    private final int numberOfTicksBeforeDone = 2;

    public WalkingPreviewResetTask(WalkingHighLevelHumanoidController walkingController, SideDependentList<YoPlaneContactState> footContactStates) {
        this.walkingController = walkingController;
        this.footContactStates = footContactStates;
    }

    public void onEntry() {
        this.walkingController.requestImmediateTransitionToStandingAndHoldCurrent();
        for (RobotSide robotSide : RobotSide.values) {
            this.contactStateHolders.put((Enum)robotSide, (Object)WalkingPreviewContactStateHolder.holdAtCurrent((PlaneContactState)this.footContactStates.get((Enum)robotSide)));
        }
    }

    public void doAction(double timeInState) {
        this.commandList.clear();
        for (RobotSide robotSide : RobotSide.values) {
            ((WalkingPreviewContactStateHolder)this.contactStateHolders.get((Enum)robotSide)).doControl();
            this.commandList.addCommand(((WalkingPreviewContactStateHolder)this.contactStateHolders.get((Enum)robotSide)).getOutput());
        }
        ++this.count;
    }

    public void onExit() {
    }

    public boolean isDone(double timeInState) {
        return this.count >= 2;
    }

    @Override
    public InverseDynamicsCommand<?> getOutput() {
        return this.commandList;
    }
}

