/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule;

import controller_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule.WholeBodyTrajectoryToolboxHelper;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.manipulation.wholeBodyTrajectory.ConfigurationSpaceName;
import us.ihmc.humanoidRobotics.communication.packets.manipulation.wholeBodyTrajectory.WholeBodyTrajectoryToolboxSettings;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.RigidBodyExplorationConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.WaypointBasedTrajectoryCommand;
import us.ihmc.manipulation.planning.exploringSpatial.SpatialData;
import us.ihmc.manipulation.planning.exploringSpatial.SpatialNode;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;

public class ConstrainedRigidBodyTrajectory {
    private static final boolean VERBOSE = false;
    private final RigidBodyBasics rigidBody;
    private final TDoubleArrayList waypointTimes = new TDoubleArrayList();
    private final ArrayList<Pose3D> waypoints = new ArrayList();
    private final SelectionMatrix6D trajectorySelectionMatrix = new SelectionMatrix6D();
    private final SelectionMatrix6D explorationSelectionMatrix = new SelectionMatrix6D();
    private final List<ConfigurationSpaceName> explorationConfigurationSpaces = new ArrayList<ConfigurationSpaceName>();
    private final TDoubleArrayList explorationRangeUpperLimits = new TDoubleArrayList();
    private final TDoubleArrayList explorationRangeLowerLimits = new TDoubleArrayList();
    private final Pose3D controlFramePose = new Pose3D();
    private final RigidBodyTransform initialGuessResult = new RigidBodyTransform();
    private final RigidBodyTransform initialGuessHolder = new RigidBodyTransform();
    private final RigidBodyTransform initialGuessCandidate = new RigidBodyTransform();
    private final boolean hasTrajectoryCommand;
    private double weight;
    private static double DEFAULT_WEIGHT = 20.0;

    public ConstrainedRigidBodyTrajectory(RigidBodyBasics rigidBody, WaypointBasedTrajectoryCommand trajectoryCommand, RigidBodyExplorationConfigurationCommand explorationCommand) {
        this.rigidBody = rigidBody;
        if (trajectoryCommand != null) {
            for (int i = 0; i < trajectoryCommand.getNumberOfWaypoints(); ++i) {
                this.waypointTimes.add(trajectoryCommand.getWaypointTime(i));
                this.waypoints.add(new Pose3D((Pose3DReadOnly)trajectoryCommand.getWaypoint(i)));
            }
            this.trajectorySelectionMatrix.set(trajectoryCommand.getSelectionMatrix());
            FramePose3D controlFramePose = new FramePose3D((FramePose3DReadOnly)trajectoryCommand.getControlFramePose());
            controlFramePose.changeFrame((ReferenceFrame)trajectoryCommand.getEndEffector().getBodyFixedFrame());
            this.controlFramePose.set((Pose3DReadOnly)controlFramePose);
            this.hasTrajectoryCommand = true;
            this.weight = Double.isNaN(trajectoryCommand.getWeight()) || trajectoryCommand.getWeight() < 0.0 ? DEFAULT_WEIGHT : trajectoryCommand.getWeight();
        } else {
            this.waypointTimes.add(0.0);
            this.waypointTimes.add(Double.MAX_VALUE);
            Pose3D originOfRigidBody = new Pose3D((RigidBodyTransformReadOnly)rigidBody.getBodyFixedFrame().getTransformToWorldFrame());
            this.waypoints.add(originOfRigidBody);
            this.waypoints.add(originOfRigidBody);
            this.trajectorySelectionMatrix.clearSelection();
            this.controlFramePose.setToZero();
            this.hasTrajectoryCommand = false;
            this.weight = DEFAULT_WEIGHT;
        }
        this.explorationSelectionMatrix.clearSelection();
        this.explorationConfigurationSpaces.clear();
        this.explorationRangeUpperLimits.reset();
        this.explorationRangeLowerLimits.reset();
        if (explorationCommand != null && explorationCommand.getNumberOfDegreesOfFreedomToExplore() > 0) {
            for (int i = 0; i < explorationCommand.getNumberOfDegreesOfFreedomToExplore(); ++i) {
                WholeBodyTrajectoryToolboxHelper.setSelectionMatrix(this.explorationSelectionMatrix, explorationCommand.getDegreeOfFreedomToExplore(i), true);
                this.explorationRangeUpperLimits.add(explorationCommand.getExplorationRangeUpperLimits(i));
                this.explorationRangeLowerLimits.add(explorationCommand.getExplorationRangeLowerLimits(i));
                this.explorationConfigurationSpaces.add(explorationCommand.getDegreeOfFreedomToExplore(i));
            }
        }
    }

    public boolean hasTrajectoryCommand() {
        return this.hasTrajectoryCommand;
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public SelectionMatrix6D getSelectionMatrix() {
        SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
        selectionMatrix.clearSelection();
        if (this.trajectorySelectionMatrix.getLinearPart().isXSelected() || this.explorationSelectionMatrix.getLinearPart().isXSelected()) {
            selectionMatrix.getLinearPart().selectXAxis(true);
        }
        if (this.trajectorySelectionMatrix.getLinearPart().isYSelected() || this.explorationSelectionMatrix.getLinearPart().isYSelected()) {
            selectionMatrix.getLinearPart().selectYAxis(true);
        }
        if (this.trajectorySelectionMatrix.getLinearPart().isZSelected() || this.explorationSelectionMatrix.getLinearPart().isZSelected()) {
            selectionMatrix.getLinearPart().selectZAxis(true);
        }
        if (this.trajectorySelectionMatrix.getAngularPart().isXSelected() || this.explorationSelectionMatrix.getAngularPart().isXSelected()) {
            selectionMatrix.getAngularPart().selectXAxis(true);
        }
        if (this.trajectorySelectionMatrix.getAngularPart().isYSelected() || this.explorationSelectionMatrix.getAngularPart().isYSelected()) {
            selectionMatrix.getAngularPart().selectYAxis(true);
        }
        if (this.trajectorySelectionMatrix.getAngularPart().isZSelected() || this.explorationSelectionMatrix.getAngularPart().isZSelected()) {
            selectionMatrix.getAngularPart().selectZAxis(true);
        }
        return selectionMatrix;
    }

    public Pose3D getPose(double time) {
        Pose3D current = new Pose3D();
        Pose3D previous = null;
        Pose3D next = null;
        double t0 = Double.NaN;
        double tf = Double.NaN;
        for (int i = 1; i < this.waypoints.size(); ++i) {
            t0 = this.waypointTimes.get(i - 1);
            tf = this.waypointTimes.get(i);
            previous = this.waypoints.get(i - 1);
            next = this.waypoints.get(i);
            if (time < tf) break;
        }
        double alpha = (time - t0) / (tf - t0);
        alpha = MathTools.clamp((double)alpha, (double)0.0, (double)1.0);
        current.interpolate(previous, next, alpha);
        return current;
    }

    private Pose3D appendPoseToTrajectory(double timeInTrajectory, Pose3D poseToAppend) {
        Pose3D pose = this.getPose(timeInTrajectory);
        if (this.hasTrajectoryCommand) {
            pose.appendTransform((RigidBodyTransformReadOnly)new RigidBodyTransform((RigidBodyTransformReadOnly)this.initialGuessResult));
        }
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform((Orientation3DReadOnly)poseToAppend.getOrientation(), (Tuple3DReadOnly)poseToAppend.getPosition());
        pose.appendTransform((RigidBodyTransformReadOnly)rigidBodyTransform);
        return pose;
    }

    public KinematicsToolboxRigidBodyMessage createMessage(double timeInTrajectory, Pose3D poseToAppend) {
        Pose3D desiredEndEffectorPose = this.appendPoseToTrajectory(timeInTrajectory, poseToAppend);
        KinematicsToolboxRigidBodyMessage message = MessageTools.createKinematicsToolboxRigidBodyMessage((RigidBodyBasics)this.rigidBody);
        message.getDesiredPositionInWorld().set(desiredEndEffectorPose.getPosition());
        message.getDesiredOrientationInWorld().set(desiredEndEffectorPose.getOrientation());
        message.getControlFramePositionInEndEffector().set(this.controlFramePose.getPosition());
        message.getControlFrameOrientationInEndEffector().set(this.controlFramePose.getOrientation());
        message.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((SelectionMatrix3D)this.getSelectionMatrix().getAngularPart()));
        message.getLinearSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((SelectionMatrix3D)this.getSelectionMatrix().getLinearPart()));
        message.getAngularWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)this.weight));
        message.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)this.weight));
        return message;
    }

    public Pose3D getPoseToWorldFrame(Pose3D poseToAppend) {
        return this.appendPoseToTrajectory(0.0, poseToAppend);
    }

    public Pose3D getPoseToWorldFrame(SpatialNode spatialNode) {
        return this.appendPoseToTrajectory(spatialNode.getTime(), spatialNode.getSpatialData(this.getRigidBody()));
    }

    public void appendRandomSpatial(SpatialData spatialData) {
        RigidBodyTransform randomPose = new RigidBodyTransform();
        String[] configurationNames = new String[this.explorationConfigurationSpaces.size()];
        double[] configurationData = new double[this.explorationConfigurationSpaces.size()];
        block8: for (int i = 0; i < this.explorationConfigurationSpaces.size(); ++i) {
            ConfigurationSpaceName configurationSpaceName = this.explorationConfigurationSpaces.get(i);
            double lowerBound = 1.0 * this.explorationRangeLowerLimits.get(i);
            double upperBound = 1.0 * this.explorationRangeUpperLimits.get(i);
            double value = RandomNumbers.nextDouble((Random)WholeBodyTrajectoryToolboxSettings.randomManager, (double)lowerBound, (double)upperBound);
            configurationNames[i] = this.rigidBody + "_" + configurationSpaceName.name();
            configurationData[i] = value;
            switch (configurationSpaceName) {
                case X: {
                    randomPose.appendTranslation(value, 0.0, 0.0);
                    continue block8;
                }
                case Y: {
                    randomPose.appendTranslation(0.0, value, 0.0);
                    continue block8;
                }
                case Z: {
                    randomPose.appendTranslation(0.0, 0.0, value);
                    continue block8;
                }
                case ROLL: {
                    randomPose.appendRollRotation(value);
                    continue block8;
                }
                case PITCH: {
                    randomPose.appendPitchRotation(value);
                    continue block8;
                }
                case YAW: {
                    randomPose.appendYawRotation(value);
                    continue block8;
                }
            }
        }
        this.initialGuessCandidate.set(randomPose);
        spatialData.appendSpatial(this.getRigidBody().getName(), configurationNames, configurationData, randomPose);
    }

    public void holdConfiguration(RigidBodyBasics rigidBody) {
        if (this.hasTrajectoryCommand) {
            this.initialGuessHolder.set(this.initialGuessCandidate);
        } else {
            this.initialGuessHolder.set(rigidBody.getBodyFixedFrame().getTransformToWorldFrame());
        }
    }

    public void updateInitialResult() {
        if (this.hasTrajectoryCommand) {
            this.initialGuessResult.set(this.initialGuessHolder);
        } else {
            this.waypoints.set(0, new Pose3D((RigidBodyTransformReadOnly)this.initialGuessHolder));
            this.waypoints.set(1, new Pose3D((RigidBodyTransformReadOnly)this.initialGuessHolder));
        }
    }
}

