/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule.WholeBodyTrajectoryToolboxData;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.plotting.artifact.CircleArtifact;
import us.ihmc.graphicsDescription.plotting.artifact.LineArtifact;
import us.ihmc.manipulation.planning.exploringSpatial.SpatialNode;
import us.ihmc.plotting.Plotter;

public class SpatialNodePlotter {
    private int dimensionOfConfigurations;
    private double trajectoryTime;
    private List<Plotter> plotters = new ArrayList<Plotter>();
    private double[] upperLimits;
    private double[] lowerLimits;
    private int cnt;
    private boolean isFrameEnabled;

    public SpatialNodePlotter(WholeBodyTrajectoryToolboxData toolboxData, boolean enabled) {
        this.dimensionOfConfigurations = toolboxData.getExplorationDimension();
        this.upperLimits = new double[this.dimensionOfConfigurations];
        this.lowerLimits = new double[this.dimensionOfConfigurations];
        this.trajectoryTime = toolboxData.getTrajectoryTime();
        for (int i = 0; i < this.dimensionOfConfigurations; ++i) {
            Plotter plotter = new Plotter();
            plotter.setPreferredSize(400, 600);
            plotter.setViewRange(2.0);
            plotter.setXYZoomEnabled(true);
            plotter.setShowLabels(true);
            plotter.setFocusPointX(0.5);
            plotter.setFocusPointY(0.0);
            this.plotters.add(plotter);
            this.upperLimits[i] = Double.NEGATIVE_INFINITY;
            this.lowerLimits[i] = Double.POSITIVE_INFINITY;
            String plotterName = (String)toolboxData.createRandomSpatialData().getConfigurationNames().get(i);
            this.isFrameEnabled = enabled;
            if (!enabled) continue;
            plotter.showInNewWindow(plotterName, false);
        }
        this.cnt = 0;
    }

    public void closeAll() {
        for (int i = 0; i < this.plotters.size(); ++i) {
            if (!this.isFrameEnabled) continue;
            this.plotters.get(i).getJFrame().dispose();
        }
    }

    public void update(SpatialNode node, int type) {
        double normalizedTime = node.getTime() / this.trajectoryTime;
        double diameter = 0.01;
        for (int nodeIndex = 0; nodeIndex < this.dimensionOfConfigurations; ++nodeIndex) {
            Color color;
            String prefix;
            switch (type) {
                case 1: {
                    if (node.isValid()) {
                        prefix = "" + this.cnt + "_valid_" + nodeIndex;
                        color = Color.blue;
                        break;
                    }
                    prefix = "" + this.cnt + "_invalid_" + nodeIndex;
                    diameter = 0.01;
                    color = Color.red;
                    break;
                }
                case 2: {
                    prefix = "" + this.cnt + "_path_" + nodeIndex;
                    color = Color.black;
                    break;
                }
                case 3: {
                    prefix = "" + this.cnt + "_shortcut_" + nodeIndex;
                    color = Color.green;
                    break;
                }
                default: {
                    prefix = "";
                    color = Color.white;
                }
            }
            double configurationData = node.getConfigurationData(nodeIndex);
            if (node.getParent() != null && node.isValid()) {
                SpatialNode parentNode = node.getParent();
                double parentTime = parentNode.getTime() / this.trajectoryTime;
                double parentConfigurationData = parentNode.getConfigurationData(nodeIndex);
                LineArtifact lineArtifact = new LineArtifact(prefix + "_line", (Point2DReadOnly)new Point2D(parentTime, parentConfigurationData), (Point2DReadOnly)new Point2D(normalizedTime, configurationData));
                lineArtifact.setColor(color);
                this.plotters.get(nodeIndex).addArtifact((Artifact)lineArtifact);
            }
            CircleArtifact nodeArtifact = new CircleArtifact(prefix + "_node", normalizedTime, configurationData, diameter, true);
            nodeArtifact.setColor(color);
            this.plotters.get(nodeIndex).addArtifact((Artifact)nodeArtifact);
            this.plotters.get(nodeIndex).update();
        }
        ++this.cnt;
    }
}

