/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule;

import controller_msgs.msg.dds.KinematicsToolboxOutputStatus;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WholeBodyTrajectoryToolboxOutputStatus;
import gnu.trove.list.array.TFloatArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsSolver;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule.SpatialNodePlotter;
import us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule.WholeBodyTrajectoryToolboxData;
import us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule.WholeBodyTrajectoryToolboxHelper;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.PacketDestination;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.KinematicsToolboxOutputConverter;
import us.ihmc.humanoidRobotics.communication.packets.manipulation.wholeBodyTrajectory.WholeBodyTrajectoryToolboxSettings;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.ReachingManifoldCommand;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.RigidBodyExplorationConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.WaypointBasedTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.WholeBodyTrajectoryToolboxConfigurationCommand;
import us.ihmc.manipulation.planning.exploringSpatial.SpatialData;
import us.ihmc.manipulation.planning.exploringSpatial.SpatialNode;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.SpatialNodeTree;
import us.ihmc.manipulation.planning.rrt.configurationAndTimeSpace.TreeStateVisualizer;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class WholeBodyTrajectoryToolboxController
extends ToolboxController {
    private static final boolean VERBOSE = true;
    private static final int DEFAULT_NUMBER_OF_ITERATIONS_FOR_SHORTCUT_OPTIMIZATION = 10;
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_ITERATIONS = 3000;
    private static final int DEFAULT_MAXIMUM_EXPANSION_SIZE_VALUE = 1000;
    private static final int DEFAULT_NUMBER_OF_INITIAL_GUESSES_VALUE = 200;
    private static final int TERMINAL_CONDITION_NUMBER_OF_VALID_INITIAL_GUESSES = 20;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final Random randomManager = new Random(1L);
    private final HumanoidKinematicsSolver humanoidKinematicsSolver;
    private final WholeBodyTrajectoryToolboxOutputStatus toolboxSolution;
    private WholeBodyTrajectoryToolboxData toolboxData;
    private List<RigidBodyExplorationConfigurationCommand> rigidBodyCommands = null;
    private List<WaypointBasedTrajectoryCommand> trajectoryCommands = null;
    private List<ReachingManifoldCommand> manifoldCommands = null;
    private final YoInteger maximumNumberOfIterations = new YoInteger("maximumNumberOfIterations", this.registry);
    private final YoInteger currentNumberOfIterations = new YoInteger("currentNumberOfIterations", this.registry);
    private final YoInteger terminalConditionNumberOfValidInitialGuesses = new YoInteger("terminalConditionNumberOfValidInitialGuesses", this.registry);
    private final YoDouble currentTrajectoryTime = new YoDouble("currentNormalizedTime", this.registry);
    private final YoBoolean isDone = new YoBoolean("isDone", this.registry);
    private final YoDouble jointlimitScore = new YoDouble("jointlimitScore", this.registry);
    private final YoDouble bestScoreInitialGuess = new YoDouble("bestScoreInitialGuess", this.registry);
    private final YoBoolean isValidNode = new YoBoolean("isValidNode", this.registry);
    private boolean visualize;
    private SpatialNode visualizedNode;
    private final KinematicsToolboxOutputConverter configurationConverter;
    private final KinematicsToolboxOutputStatus initialConfiguration = new KinematicsToolboxOutputStatus();
    private final AtomicReference<RobotConfigurationData> currentRobotConfigurationDataReference = new AtomicReference<Object>(null);
    private FullHumanoidRobotModel visualizedFullRobotModel;
    private TreeStateVisualizer treeStateVisualizer;
    private SpatialNodePlotter nodePlotter;
    private final SideDependentList<YoFramePoseUsingYawPitchRoll> endeffectorPose = new SideDependentList();
    private final SideDependentList<YoGraphicCoordinateSystem> endeffectorFrame = new SideDependentList();
    private final YoFramePoseUsingYawPitchRoll testFramePose;
    private final YoGraphicCoordinateSystem testFrameViz;
    private final YoDouble minimumDistanceFromManifold = new YoDouble("minimumDistanceFromManifold", this.registry);
    private SpatialNode rootNode = null;
    private SpatialNodeTree tree;
    private final List<SpatialNode> path = new ArrayList<SpatialNode>();
    private final double minTimeInterval = 0.05;
    private int numberOfValidPosture = 0;
    private int numberOfInvalidPosture = 0;
    private final YoInteger currentExpansionSize = new YoInteger("currentExpansionSize", this.registry);
    private final YoInteger maximumExpansionSize = new YoInteger("maximumExpansionSize", this.registry);
    private final YoInteger currentNumberOfValidInitialGuesses = new YoInteger("currentNumberOfValidInitialGuesses", this.registry);
    private final YoInteger currentNumberOfInitialGuesses = new YoInteger("currentNumberOfInitialGuesses", this.registry);
    private final YoInteger desiredNumberOfInitialGuesses = new YoInteger("desiredNumberOfInitialGuesses", this.registry);
    private YoInteger numberOfIterationForShortcutOptimization = new YoInteger("numberOfIterationForShortcutOptimization", this.registry);
    private final YoEnum<CWBToolboxState> state = new YoEnum("state", this.registry, CWBToolboxState.class);
    private final YoDouble initialGuessComputationTime = new YoDouble("initialGuessComputationTime", this.registry);
    private final YoDouble treeExpansionComputationTime = new YoDouble("treeExpansionComputationTime", this.registry);
    private final YoDouble shortcutPathComputationTime = new YoDouble("shortcutPathComputationTime", this.registry);
    private final YoDouble motionGenerationComputationTime = new YoDouble("motionGenerationComputationTime", this.registry);
    private final YoDouble totalComputationTime = new YoDouble("totalComputationTime", this.registry);
    private long initialGuessStartTime;
    private long treeExpansionStartTime;
    private long shortcutStartTime;
    private long motionGenerationStartTime;
    private final CommandInputManager commandInputManager;

    public WholeBodyTrajectoryToolboxController(DRCRobotModel drcRobotModel, FullHumanoidRobotModel fullRobotModel, CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry, boolean visualize) {
        super(statusOutputManager, registry);
        this.commandInputManager = commandInputManager;
        this.visualizedFullRobotModel = fullRobotModel;
        this.isDone.set(false);
        this.visualize = visualize;
        this.treeStateVisualizer = visualize ? new TreeStateVisualizer("TreeStateVisualizer", "VisualizerGraphicsList", yoGraphicsListRegistry, registry) : null;
        this.state.set((Enum)CWBToolboxState.DO_NOTHING);
        for (RobotSide robotSide : RobotSide.values) {
            this.endeffectorPose.put((Enum)robotSide, (Object)new YoFramePoseUsingYawPitchRoll("" + robotSide + "endeffectorPose", ReferenceFrame.getWorldFrame(), registry));
            this.endeffectorFrame.put((Enum)robotSide, (Object)new YoGraphicCoordinateSystem("" + robotSide + "endeffectorPoseFrame", (YoFramePoseUsingYawPitchRoll)this.endeffectorPose.get((Enum)robotSide), 0.25));
            ((YoGraphicCoordinateSystem)this.endeffectorFrame.get((Enum)robotSide)).setVisible(true);
            yoGraphicsListRegistry.registerYoGraphic("" + robotSide + "endeffectorPoseViz", (YoGraphic)this.endeffectorFrame.get((Enum)robotSide));
        }
        this.numberOfIterationForShortcutOptimization.set(10);
        this.maximumNumberOfIterations.set(3000);
        this.terminalConditionNumberOfValidInitialGuesses.set(20);
        this.humanoidKinematicsSolver = new HumanoidKinematicsSolver((FullHumanoidRobotModelFactory)drcRobotModel, yoGraphicsListRegistry, registry);
        this.toolboxSolution = new WholeBodyTrajectoryToolboxOutputStatus();
        this.toolboxSolution.setDestination(-1);
        this.configurationConverter = new KinematicsToolboxOutputConverter((FullHumanoidRobotModelFactory)drcRobotModel);
        this.testFramePose = new YoFramePoseUsingYawPitchRoll("testFramePose", ReferenceFrame.getWorldFrame(), registry);
        this.testFrameViz = new YoGraphicCoordinateSystem("testFrameViz", this.testFramePose, 0.25);
        yoGraphicsListRegistry.registerYoGraphic("testFrameYoGraphic", (YoGraphic)this.testFrameViz);
    }

    @Override
    public void updateInternal() throws InterruptedException, ExecutionException {
        this.currentNumberOfIterations.increment();
        switch ((CWBToolboxState)this.state.getEnumValue()) {
            case DO_NOTHING: {
                break;
            }
            case FIND_INITIAL_GUESS: {
                this.findInitialGuess();
                break;
            }
            case EXPAND_TREE: {
                this.expandingTree();
                break;
            }
            case SHORTCUT_PATH: {
                this.shortcutPath();
                break;
            }
            case GENERATE_MOTION: {
                this.generateMotion();
            }
        }
        this.updateVisualizerRobotConfiguration();
        this.updateVisualizers();
        this.updateYoVariables();
        if (this.currentNumberOfIterations.getIntegerValue() == this.maximumNumberOfIterations.getIntegerValue()) {
            this.terminateToolboxController();
        }
    }

    private void setOutputStatus(WholeBodyTrajectoryToolboxOutputStatus outputStatusToPack, int planningResult) {
        outputStatusToPack.setPlanningResult(planningResult);
    }

    private void setOutputStatus(WholeBodyTrajectoryToolboxOutputStatus outputStatusToPack, List<SpatialNode> path) {
        if (outputStatusToPack.getPlanningResult() == 4) {
            MessageTools.copyData((Settable[])((Settable[])path.stream().map(SpatialNode::getConfiguration).toArray(KinematicsToolboxOutputStatus[]::new)), (RecyclingArrayList)outputStatusToPack.getRobotConfigurations());
            outputStatusToPack.getTrajectoryTimes().reset();
            outputStatusToPack.getTrajectoryTimes().add(path.stream().mapToDouble(SpatialNode::getTime).toArray());
        } else {
            PrintTools.info((String)"Planning has Failed.");
        }
    }

    private void generateMotion() {
        this.updateTimer(this.motionGenerationComputationTime, this.motionGenerationStartTime);
        this.setOutputStatus(this.toolboxSolution, 4);
        this.setOutputStatus(this.toolboxSolution, this.path);
        this.terminateToolboxController();
    }

    private void shortcutPath() {
        int i;
        this.path.clear();
        ArrayList<SpatialNode> revertedPath = new ArrayList<SpatialNode>();
        SpatialNode currentNode = new SpatialNode(this.tree.getLastNodeAdded());
        revertedPath.add(currentNode);
        while ((currentNode = currentNode.getParent()) != null) {
            revertedPath.add(new SpatialNode(currentNode));
        }
        int revertedPathSize = revertedPath.size();
        this.path.add(new SpatialNode((SpatialNode)revertedPath.get(revertedPathSize - 1)));
        int currentIndex = 0;
        int latestAddedIndexOfRevertedPath = revertedPathSize - 1;
        for (int j = revertedPathSize - 2; j > 0; --j) {
            double timeGapWithLatestNode = ((SpatialNode)revertedPath.get(j)).getTime() - this.path.get(currentIndex).getTime();
            if (!(timeGapWithLatestNode > 0.05)) continue;
            SpatialNode dummyNode = new SpatialNode((SpatialNode)revertedPath.get(j));
            dummyNode.setParent(this.path.get(currentIndex));
            this.updateValidity(dummyNode);
            if (dummyNode.isValid()) {
                this.path.add(new SpatialNode((SpatialNode)revertedPath.get(j)));
                latestAddedIndexOfRevertedPath = j;
                ++currentIndex;
                continue;
            }
            j = latestAddedIndexOfRevertedPath - 1;
            this.path.add(new SpatialNode((SpatialNode)revertedPath.get(j)));
            latestAddedIndexOfRevertedPath = j;
            ++currentIndex;
        }
        this.path.add(new SpatialNode((SpatialNode)revertedPath.get(0)));
        for (i = 0; i < this.path.size() - 1; ++i) {
            this.path.get(i + 1).setParent(this.path.get(i));
        }
        for (i = 0; i < this.path.size(); ++i) {
            this.nodePlotter.update(this.path.get(i), 2);
        }
        int numberOfShortcut = 0;
        int i2 = 0;
        while (i2 < this.numberOfIterationForShortcutOptimization.getIntegerValue()) {
            numberOfShortcut = i2++;
            if (this.updateShortcutPath(this.path) < 0.001) break;
        }
        for (i2 = 0; i2 < this.path.size(); ++i2) {
            this.nodePlotter.update(this.path.get(i2), 3);
        }
        this.motionGenerationStartTime = this.updateTimer(this.shortcutPathComputationTime, this.shortcutStartTime);
        PrintTools.info((String)("the size of the path is " + this.path.size() + " before dismissing " + revertedPathSize + " shortcut " + numberOfShortcut));
        this.state.set((Enum)CWBToolboxState.GENERATE_MOTION);
    }

    private void expandingTree() {
        this.currentExpansionSize.increment();
        boolean isExpandingTerminalCondition = false;
        boolean randomNodeHasParentNode = false;
        int maximumPatientCounter = 1000;
        while (!randomNodeHasParentNode) {
            SpatialData randomData = this.toolboxData.createRandomSpatialData();
            double nextDouble = WholeBodyTrajectoryToolboxSettings.randomManager.nextDouble();
            double randomTime = nextDouble * (1.0 + WholeBodyTrajectoryToolboxSettings.timeCoefficient * this.tree.getMostAdvancedTime());
            SpatialNode randomNode = new SpatialNode(randomTime, randomData);
            this.tree.setRandomNode(randomNode);
            if (this.trajectoryCommands != null) {
                randomNodeHasParentNode = this.tree.findNearestValidNodeToCandidate(true);
            }
            if (this.manifoldCommands != null) {
                randomNodeHasParentNode = this.tree.findNearestValidNodeToCandidate(false);
            }
            if (randomNodeHasParentNode) {
                this.tree.limitCandidateDistanceFromParent(this.toolboxData.getTrajectoryTime());
                SpatialNode candidate = this.tree.getCandidate();
                this.updateValidity(candidate);
                this.visualizedNode = new SpatialNode(candidate);
                this.nodePlotter.update(candidate, 1);
                if (candidate.isValid()) {
                    this.tree.attachCandidate();
                    ++this.numberOfValidPosture;
                    if (this.trajectoryCommands != null) {
                        if (!(this.tree.getMostAdvancedTime() >= this.toolboxData.getTrajectoryTime())) continue;
                        isExpandingTerminalCondition = true;
                        continue;
                    }
                    if (this.manifoldCommands != null) {
                        Pose3D testFrame = this.toolboxData.getTestFrame(this.tree.getLastNodeAdded());
                        this.testFramePose.setPosition((Tuple3DReadOnly)testFrame.getPosition());
                        this.testFramePose.setOrientation((Orientation3DReadOnly)testFrame.getOrientation());
                        this.testFrameViz.setVisible(true);
                        this.testFrameViz.update();
                        double maximumDistanceFromManifolds = this.toolboxData.getMaximumDistanceFromManifolds(this.tree.getLastNodeAdded());
                        this.minimumDistanceFromManifold.set(maximumDistanceFromManifolds);
                        if (!(maximumDistanceFromManifolds < 0.05)) continue;
                        isExpandingTerminalCondition = true;
                        continue;
                    }
                    PrintTools.warn((String)"any command is available");
                    continue;
                }
                this.tree.dismissCandidate();
                ++this.numberOfInvalidPosture;
                continue;
            }
            if (--maximumPatientCounter != 0) continue;
        }
        if (this.currentExpansionSize.getIntegerValue() >= this.maximumExpansionSize.getIntegerValue() || isExpandingTerminalCondition) {
            if (!isExpandingTerminalCondition) {
                PrintTools.info((String)("Failed to complete trajectory. " + this.numberOfValidPosture + " " + this.numberOfInvalidPosture));
                this.setOutputStatus(this.toolboxSolution, 2);
                this.terminateToolboxController();
            } else {
                PrintTools.info((String)("Successfully finished tree expansion. " + this.numberOfValidPosture + " " + this.numberOfInvalidPosture));
                this.state.set((Enum)CWBToolboxState.SHORTCUT_PATH);
            }
        }
        this.shortcutStartTime = this.updateTimer(this.treeExpansionComputationTime, this.treeExpansionStartTime);
    }

    private void findInitialGuessSub() {
        SpatialData initialGuessData = this.toolboxData.createRandomInitialSpatialData();
        SpatialNode initialGuessNode = new SpatialNode(initialGuessData);
        this.updateValidity(initialGuessNode);
        this.visualizedNode = initialGuessNode;
        double jointScore = this.visualizedNode.isValid() ? this.computeArmJointsLimitScore(this.humanoidKinematicsSolver.getDesiredFullRobotModel()) : 0.0;
        this.jointlimitScore.set(jointScore);
        if (this.bestScoreInitialGuess.getDoubleValue() < jointScore && initialGuessNode.isValid()) {
            this.bestScoreInitialGuess.set(jointScore);
            this.toolboxData.holdConfiguration(this.getSolverFullRobotModel());
            SpatialData dummyData = this.toolboxData.createRandomSpatialData();
            this.rootNode = new SpatialNode(dummyData);
            this.rootNode.setConfiguration(initialGuessNode.getConfiguration());
            this.rootNode.initializeSpatialData();
        }
        if (initialGuessNode.isValid()) {
            this.currentNumberOfValidInitialGuesses.increment();
        }
        this.currentNumberOfInitialGuesses.increment();
        if (this.currentNumberOfInitialGuesses.getIntegerValue() >= this.desiredNumberOfInitialGuesses.getIntegerValue() || this.currentNumberOfValidInitialGuesses.getIntegerValue() >= this.terminalConditionNumberOfValidInitialGuesses.getIntegerValue()) {
            if (this.rootNode == null || !this.rootNode.isValid()) {
                PrintTools.info((String)"Did not find a single valid root node.");
                this.setOutputStatus(this.toolboxSolution, 1);
                this.terminateToolboxController();
            } else {
                PrintTools.info((String)("Successfully finished initial guess stage. " + this.currentNumberOfInitialGuesses.getIntegerValue() + " " + this.currentNumberOfValidInitialGuesses.getIntegerValue()));
                this.state.set((Enum)CWBToolboxState.EXPAND_TREE);
                this.toolboxData.updateInitialConfiguration();
                this.tree = new SpatialNodeTree(this.rootNode);
            }
        }
        this.treeExpansionStartTime = this.updateTimer(this.initialGuessComputationTime, this.initialGuessStartTime);
    }

    private void findInitialGuess() {
        SpatialData initialGuessData = this.toolboxData.createRandomSpatialData();
        SpatialNode initialGuessNode = new SpatialNode(initialGuessData);
        this.updateValidity(initialGuessNode);
        this.visualizedNode = initialGuessNode;
        double jointScore = 0.0;
        if (initialGuessNode.isValid()) {
            this.tree.addInitialNode(initialGuessNode);
            this.currentNumberOfValidInitialGuesses.increment();
            jointScore = this.computeArmJointsLimitScore(this.humanoidKinematicsSolver.getDesiredFullRobotModel());
        }
        this.jointlimitScore.set(jointScore);
        this.nodePlotter.update(initialGuessNode, 1);
        this.currentNumberOfInitialGuesses.increment();
        if (this.currentNumberOfInitialGuesses.getIntegerValue() >= this.desiredNumberOfInitialGuesses.getIntegerValue() || this.currentNumberOfValidInitialGuesses.getIntegerValue() >= this.terminalConditionNumberOfValidInitialGuesses.getIntegerValue()) {
            if (this.tree.getValidNodes().size() == 0) {
                PrintTools.info((String)"Did not find a single valid root node.");
                this.setOutputStatus(this.toolboxSolution, 1);
                this.terminateToolboxController();
            } else {
                PrintTools.info((String)("Successfully finished initial guess stage. " + this.currentNumberOfInitialGuesses.getIntegerValue() + " " + this.currentNumberOfValidInitialGuesses.getIntegerValue()));
                this.state.set((Enum)CWBToolboxState.EXPAND_TREE);
            }
        }
        this.treeExpansionStartTime = this.updateTimer(this.initialGuessComputationTime, this.initialGuessStartTime);
    }

    private long updateTimer(YoDouble currentTimer, long currentTimerStartTime) {
        long endTime = System.nanoTime();
        currentTimer.set(Conversions.nanosecondsToSeconds((long)(endTime - currentTimerStartTime)));
        return endTime;
    }

    @Override
    public boolean initialize() {
        this.isDone.set(false);
        boolean success = this.updateConfiguration();
        if (!success) {
            return false;
        }
        if (!this.commandInputManager.isNewCommandAvailable(RigidBodyExplorationConfigurationCommand.class)) {
            return false;
        }
        this.rigidBodyCommands = this.commandInputManager.pollNewCommands(RigidBodyExplorationConfigurationCommand.class);
        PrintTools.info((String)"initialize CWB toolbox");
        this.configurationConverter.updateFullRobotModel(this.initialConfiguration);
        this.toolboxData = new WholeBodyTrajectoryToolboxData(this.configurationConverter.getFullRobotModel(), this.trajectoryCommands, this.manifoldCommands, this.rigidBodyCommands);
        this.bestScoreInitialGuess.set(0.0);
        this.initialGuessStartTime = System.nanoTime();
        this.initialGuessComputationTime.setToNaN();
        this.treeExpansionComputationTime.setToNaN();
        this.shortcutPathComputationTime.setToNaN();
        this.motionGenerationComputationTime.setToNaN();
        this.numberOfValidPosture = 0;
        this.numberOfInvalidPosture = 0;
        this.rootNode = null;
        this.nodePlotter = new SpatialNodePlotter(this.toolboxData, this.visualize);
        this.tree = new SpatialNodeTree();
        if (this.trajectoryCommands != null) {
            this.state.set((Enum)CWBToolboxState.FIND_INITIAL_GUESS);
        } else if (this.manifoldCommands != null) {
            this.state.set((Enum)CWBToolboxState.EXPAND_TREE);
            SpatialData rootData = this.toolboxData.createRandomSpatialData();
            SpatialNode rootNode = new SpatialNode(rootData);
            rootNode.setConfiguration(this.initialConfiguration);
            rootNode.initializeSpatialData();
            this.nodePlotter.update(rootNode, 1);
            this.tree.addInitialNode(rootNode);
            this.treeExpansionStartTime = this.updateTimer(this.initialGuessComputationTime, this.initialGuessStartTime);
        } else {
            return false;
        }
        return true;
    }

    private boolean updateConfiguration() {
        int newMaxExpansionSize = -1;
        int newNumberOfInitialGuesses = -1;
        KinematicsToolboxOutputStatus newInitialConfiguration = null;
        if (this.commandInputManager.isNewCommandAvailable(WholeBodyTrajectoryToolboxConfigurationCommand.class)) {
            WholeBodyTrajectoryToolboxConfigurationCommand command = (WholeBodyTrajectoryToolboxConfigurationCommand)this.commandInputManager.pollNewestCommand(WholeBodyTrajectoryToolboxConfigurationCommand.class);
            this.trajectoryCommands = null;
            this.manifoldCommands = null;
            if (this.commandInputManager.isNewCommandAvailable(WaypointBasedTrajectoryCommand.class)) {
                this.trajectoryCommands = this.commandInputManager.pollNewCommands(WaypointBasedTrajectoryCommand.class);
                if (this.trajectoryCommands.size() < 1) {
                    return false;
                }
            } else if (this.commandInputManager.isNewCommandAvailable(ReachingManifoldCommand.class)) {
                this.manifoldCommands = this.commandInputManager.pollNewCommands(ReachingManifoldCommand.class);
                if (this.manifoldCommands.size() < 1) {
                    return false;
                }
            } else {
                PrintTools.info((String)"wrong type received");
                return false;
            }
            newMaxExpansionSize = command.getMaximumExpansionSize();
            newNumberOfInitialGuesses = command.getNumberOfInitialGuesses();
            if (command.hasInitialConfiguration()) {
                newInitialConfiguration = command.getInitialConfiguration();
            }
        }
        if (newMaxExpansionSize > 0) {
            this.maximumExpansionSize.set(newMaxExpansionSize);
        } else {
            this.maximumExpansionSize.set(1000);
        }
        if (newNumberOfInitialGuesses > 0) {
            this.desiredNumberOfInitialGuesses.set(newNumberOfInitialGuesses);
        } else {
            this.desiredNumberOfInitialGuesses.set(200);
        }
        if (newInitialConfiguration != null) {
            this.initialConfiguration.set(newInitialConfiguration);
            return true;
        }
        RobotConfigurationData currentRobotConfiguration = this.currentRobotConfigurationDataReference.getAndSet(null);
        if (currentRobotConfiguration == null) {
            return false;
        }
        this.initialConfiguration.getDesiredRootOrientation().set(currentRobotConfiguration.getRootOrientation());
        this.initialConfiguration.getDesiredRootTranslation().set(currentRobotConfiguration.getRootTranslation());
        this.initialConfiguration.setJointNameHash(currentRobotConfiguration.getJointNameHash());
        int length = currentRobotConfiguration.getJointAngles().size();
        MessageTools.copyData((TFloatArrayList)currentRobotConfiguration.getJointAngles(), (TFloatArrayList)this.initialConfiguration.getDesiredJointAngles());
        PrintTools.info((String)"update config done");
        return true;
    }

    private void terminateToolboxController() {
        this.toolboxSolution.setDestination(PacketDestination.BEHAVIOR_MODULE.ordinal());
        this.reportMessage(this.toolboxSolution);
        this.state.set((Enum)CWBToolboxState.DO_NOTHING);
        double totalTime = 0.0;
        if (!this.initialGuessComputationTime.isNaN()) {
            totalTime += this.initialGuessComputationTime.getDoubleValue();
        }
        if (!this.treeExpansionComputationTime.isNaN()) {
            totalTime += this.treeExpansionComputationTime.getDoubleValue();
        }
        if (!this.shortcutPathComputationTime.isNaN()) {
            totalTime += this.shortcutPathComputationTime.getDoubleValue();
        }
        if (!this.motionGenerationComputationTime.isNaN()) {
            totalTime += this.motionGenerationComputationTime.getDoubleValue();
        }
        this.totalComputationTime.set(totalTime);
        PrintTools.info((String)"===========================================");
        PrintTools.info((String)("initialGuessComputationTime is " + this.initialGuessComputationTime.getDoubleValue()));
        PrintTools.info((String)("treeExpansionComputationTime is " + this.treeExpansionComputationTime.getDoubleValue()));
        PrintTools.info((String)("shortcutPathComputationTime is " + this.shortcutPathComputationTime.getDoubleValue()));
        PrintTools.info((String)("motionGenerationComputationTime is " + this.motionGenerationComputationTime.getDoubleValue()));
        PrintTools.info((String)("toolbox executing time is " + this.totalComputationTime.getDoubleValue() + " seconds " + this.currentNumberOfIterations.getIntegerValue()));
        PrintTools.info((String)"===========================================");
        this.isDone.set(true);
    }

    @Override
    public boolean isDone() {
        return this.isDone.getBooleanValue();
    }

    private boolean updateValidity(SpatialNode node) {
        if (node.getParent() != null && node.getParent().getConfiguration() != null) {
            this.humanoidKinematicsSolver.setInitialConfiguration(node.getParent().getConfiguration());
        } else {
            this.humanoidKinematicsSolver.setInitialConfiguration(this.initialConfiguration);
        }
        this.humanoidKinematicsSolver.initialize();
        this.humanoidKinematicsSolver.submit(this.toolboxData.createMessages(node));
        boolean success = this.humanoidKinematicsSolver.solve();
        node.setConfiguration(this.humanoidKinematicsSolver.getSolution());
        node.setValidity(success);
        return success;
    }

    private void updateVisualizerRobotConfiguration(KinematicsToolboxOutputStatus robotKinematicsConfiguration) {
        MessageTools.unpackDesiredJointState((KinematicsToolboxOutputStatus)robotKinematicsConfiguration, (FloatingJointBasics)this.visualizedFullRobotModel.getRootJoint(), (OneDoFJointBasics[])FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.visualizedFullRobotModel));
    }

    private void updateVisualizerRobotConfiguration() {
        MessageTools.unpackDesiredJointState((KinematicsToolboxOutputStatus)this.visualizedNode.getConfiguration(), (FloatingJointBasics)this.visualizedFullRobotModel.getRootJoint(), (OneDoFJointBasics[])FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.visualizedFullRobotModel));
    }

    private void updateVisualizers() {
        this.currentTrajectoryTime.set(this.visualizedNode.getTime());
        this.isValidNode.set(this.visualizedNode.isValid());
        if (this.visualize && this.visualizedNode != null) {
            this.treeStateVisualizer.setCurrentNormalizedTime(this.visualizedNode.getTime() / this.toolboxData.getTrajectoryTime());
            this.treeStateVisualizer.setCurrentCTTaskNodeValidity(this.visualizedNode.isValid());
            this.treeStateVisualizer.updateVisualizer();
        }
    }

    private void updateYoVariables() {
        for (RobotSide robotSide : RobotSide.values) {
            ((YoGraphicCoordinateSystem)this.endeffectorFrame.get((Enum)robotSide)).setVisible(true);
            ((YoGraphicCoordinateSystem)this.endeffectorFrame.get((Enum)robotSide)).update();
        }
    }

    private boolean updateShortcutPath(List<SpatialNode> path, int index) {
        if (index > path.size() - 3) {
            return false;
        }
        SpatialNode nodeDummy = new SpatialNode(path.get(index + 1));
        nodeDummy.setParent(path.get(index));
        nodeDummy.interpolate(path.get(index), path.get(index + 2), 0.5);
        this.updateValidity(nodeDummy);
        if (nodeDummy.isValid()) {
            path.get(index + 1).interpolate(path.get(index), path.get(index + 2), 0.5);
            path.get(index + 1).setConfiguration(nodeDummy.getConfiguration());
            return true;
        }
        return false;
    }

    private double updateShortcutPath(List<SpatialNode> path) {
        int i;
        ArrayList<SpatialNode> pathBeforeShortcut = new ArrayList<SpatialNode>();
        for (i = 0; i < path.size(); ++i) {
            pathBeforeShortcut.add(new SpatialNode(path.get(i)));
        }
        for (i = 0; i < path.size(); ++i) {
            if (!this.updateShortcutPath(path, i)) continue;
        }
        double distance = 0.0;
        for (int i2 = 0; i2 < path.size(); ++i2) {
            distance += ((SpatialNode)pathBeforeShortcut.get(i2)).computeDistance(0.0, this.tree.getPositionWeight(), this.tree.getOrientationWeight(), path.get(i2));
        }
        return distance / (double)path.size();
    }

    private double computeArmJointsLimitScore(FullHumanoidRobotModel fullRobotModel) {
        double score = 0.0;
        RigidBodyBasics chest = fullRobotModel.getChest();
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics hand = fullRobotModel.getHand(robotSide);
            score += WholeBodyTrajectoryToolboxHelper.kinematicsChainLimitScore(chest, hand);
        }
        return score;
    }

    void updateRobotConfigurationData(RobotConfigurationData newConfigurationData) {
        this.currentRobotConfigurationDataReference.set(newConfigurationData);
    }

    FullHumanoidRobotModel getSolverFullRobotModel() {
        return this.humanoidKinematicsSolver.getDesiredFullRobotModel();
    }

    private static enum CWBToolboxState {
        DO_NOTHING,
        FIND_INITIAL_GUESS,
        EXPAND_TREE,
        SHORTCUT_PATH,
        GENERATE_MOTION;

    }
}

