/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.polaris;

import us.ihmc.avatar.polaris.VehicleModelObjects;
import us.ihmc.avatar.polaris.VehicleObject;
import us.ihmc.commons.FormattingTools;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.registry.YoRegistry;

public class VehicleModelObjectVisualizer {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoGraphicsList yoGraphicsList = new YoGraphicsList("vehicleObjects");
    private final double objectFrameScale = 0.2;
    private final double vehicleFrameScale = 1.0;

    public VehicleModelObjectVisualizer(ReferenceFrame vehicleFrame, VehicleModelObjects vehicleModelObjects, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        for (VehicleObject vehicleObject : VehicleObject.values()) {
            FramePose3D framePose = vehicleModelObjects.getFramePose(vehicleFrame, vehicleObject);
            String objectName = FormattingTools.underscoredToCamelCase((String)vehicleObject.toString(), (boolean)false);
            PoseReferenceFrame objectFrame = new PoseReferenceFrame(objectName, (FramePose3DReadOnly)framePose);
            objectFrame.update();
            YoGraphicReferenceFrame yoGraphicReferenceFrame = new YoGraphicReferenceFrame((ReferenceFrame)objectFrame, this.registry, true, 0.2);
            this.yoGraphicsList.add((YoGraphic)yoGraphicReferenceFrame);
        }
        YoGraphicReferenceFrame vehicleFrameViz = new YoGraphicReferenceFrame(vehicleFrame, this.registry, true, 1.0);
        this.yoGraphicsList.add((YoGraphic)vehicleFrameViz);
        yoGraphicsListRegistry.registerYoGraphicsList(this.yoGraphicsList);
        parentRegistry.addChild(this.registry);
    }

    public void update() {
        for (YoGraphic yoGraphic : this.yoGraphicsList.getYoGraphics()) {
            yoGraphic.update();
        }
    }

    public void setVisible(boolean visible) {
        this.yoGraphicsList.setVisible(visible);
    }
}

