/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicLineSegment;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.kinematics.NumericalInverseKinematicsCalculator;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.sensorProcessing.simulatedSensors.SDFPerfectSimulatedSensorReader;
import us.ihmc.simulationConstructionSetTools.util.inputdevices.MidiSliderBoard;
import us.ihmc.simulationToolkit.outputWriters.PerfectSimulatedOutputWriter;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class DRCRobotMidiSliderBoardPositionManipulation {
    private final ArrayList<OneDegreeOfFreedomJoint> allSCSJoints = new ArrayList();
    private final ArrayList<NeckJointName> neckJointNames = new ArrayList();
    private final EnumMap<NeckJointName, OneDegreeOfFreedomJoint> neckSCSJoints = new EnumMap(NeckJointName.class);
    private final ArrayList<SpineJointName> spineJointNames = new ArrayList();
    private final EnumMap<SpineJointName, OneDegreeOfFreedomJoint> spineSCSJoints = new EnumMap(SpineJointName.class);
    private final SideDependentList<ArrayList<LegJointName>> legJointNames = new SideDependentList(new ArrayList(), new ArrayList());
    private final SideDependentList<EnumMap<LegJointName, OneDegreeOfFreedomJoint>> legSCSJoints = SideDependentList.createListOfEnumMaps(LegJointName.class);
    private final SideDependentList<ArrayList<ArmJointName>> armJointNames = new SideDependentList(new ArrayList(), new ArrayList());
    private final SideDependentList<EnumMap<ArmJointName, OneDegreeOfFreedomJoint>> armSCSJoints = SideDependentList.createListOfEnumMaps(ArmJointName.class);
    private final double fingerJointLimit = 1.57079632679;
    private final YoRegistry registry = new YoRegistry("SliderBoardRegistry");
    private final YoRegistry dontRecordRegistry = new YoRegistry("dontRecordRegistry");
    private final YoEnum<SliderSpace> sliderSpace = new YoEnum("sliderSpace", "", this.registry, SliderSpace.class, false);
    private final YoEnum<SliderBodyPart> sliderBodyPart = new YoEnum("sliderBodyPart", "", this.registry, SliderBodyPart.class, false);
    private final YoBoolean isCaptureSnapshotRequested = new YoBoolean("isCaptureSnapshotRequested", this.dontRecordRegistry);
    private final YoBoolean isSaveSequenceRequested = new YoBoolean("isSaveSequenceRequested", this.dontRecordRegistry);
    private final YoBoolean isLoadSequenceRequested = new YoBoolean("isLoadSequenceRequested", this.dontRecordRegistry);
    private final YoBoolean isClearSequenceRequested = new YoBoolean("isClearSequenceRequested", this.dontRecordRegistry);
    private final YoBoolean isLoadFrameByFrameSequenceRequested = new YoBoolean("isLoadFrameByFrameSequenceRequested", this.dontRecordRegistry);
    private final YoBoolean isPlayPoseFromFrameByFrameSequenceRequested = new YoBoolean("isPlayPoseFromFrameByFrameSequenceRequested", this.dontRecordRegistry);
    private final YoBoolean isSymmetricModeRequested = new YoBoolean("isSymmetricModeRequested", this.dontRecordRegistry);
    private final YoBoolean isResetToBasePoseRequested = new YoBoolean("isResetToBasePoseRequested", this.dontRecordRegistry);
    private final YoBoolean isLoadLastSequenceRequested = new YoBoolean("isLoadLastSequenceRequested", this.dontRecordRegistry);
    private final YoBoolean isPelvisControlRequested = new YoBoolean("isPelvisControlRequested", this.dontRecordRegistry);
    private final YoBoolean isChestControlRequested = new YoBoolean("isChestControlRequested", this.dontRecordRegistry);
    private final YoBoolean isLeftLegControlRequested = new YoBoolean("isLeftLegControlRequested", this.dontRecordRegistry);
    private final YoBoolean isRightLegControlRequested = new YoBoolean("isRightLegControlRequested", this.dontRecordRegistry);
    private final YoBoolean isLeftArmControlRequested = new YoBoolean("isLeftArmControlRequested", this.dontRecordRegistry);
    private final YoBoolean isRightArmControlRequested = new YoBoolean("isRightArmControlRequested", this.dontRecordRegistry);
    private final YoBoolean isSupportBaseControlRequested = new YoBoolean("isSupportBaseControlRequested", this.dontRecordRegistry);
    private final YoBoolean isSupportBaseToggleRequested = new YoBoolean("isSupportBaseToggleRequested", this.dontRecordRegistry);
    private final YoBoolean isSupportBaseControlTargetRequested = new YoBoolean("isSupportBaseControlTargetRequested", this.dontRecordRegistry);
    private final YoBoolean isSupportBaseTargetToggleRequested = new YoBoolean("isSupportBaseTargetToggleRequested", this.dontRecordRegistry);
    private final SideDependentList<YoBoolean> isLegControlRequested = new SideDependentList((Object)this.isLeftLegControlRequested, (Object)this.isRightLegControlRequested);
    private final SideDependentList<YoBoolean> isArmControlRequested = new SideDependentList((Object)this.isLeftArmControlRequested, (Object)this.isRightArmControlRequested);
    private final SimulationConstructionSet scs;
    private final MidiSliderBoard sliderBoard;
    private final YoDouble q_yaw = new YoDouble("q_yaw", this.registry);
    private final YoDouble q_pitch = new YoDouble("q_pitch", this.registry);
    private final YoDouble q_roll = new YoDouble("q_roll", this.registry);
    private final YoDouble q_left = new YoDouble("q_left", this.registry);
    private final YoDouble q_right = new YoDouble("q_right", this.registry);
    private final SideDependentList<YoDouble> q_hands = new SideDependentList((Object)this.q_left, (Object)this.q_right);
    private final SideDependentList<String> handSideString = new SideDependentList((Object)"q_left_f", (Object)"q_right_f");
    private boolean symmetricMode = false;
    private RobotSide symmetricControlSide;
    private final YoDouble q_qs;
    private final YoDouble q_qx;
    private final YoDouble q_qy;
    private final YoDouble q_qz;
    private final YoDouble q_x;
    private final YoDouble q_y;
    private final YoDouble q_z;
    private Quaternion qprev;
    private final YoFramePoint3D[] baseControlPoints = new YoFramePoint3D[4];
    private final ArrayList<YoGraphic> baseControlPointsList = new ArrayList();
    private final ArrayList<YoGraphic> baseControlLinesList = new ArrayList();
    private final YoFramePoint3D[] baseControlTargetPoints = new YoFramePoint3D[4];
    private final ArrayList<YoGraphic> baseControlTargetPointsList = new ArrayList();
    private final ArrayList<YoGraphic> baseControlTargetLinesList = new ArrayList();
    private final SideDependentList<SliderBodyPart> legBodyParts = new SideDependentList((Object)SliderBodyPart.LEFT_LEG, (Object)SliderBodyPart.RIGHT_LEG);
    private final SideDependentList<SliderBodyPart> armBodyParts = new SideDependentList((Object)SliderBodyPart.LEFT_ARM, (Object)SliderBodyPart.RIGHT_ARM);
    private final SideDependentList<NumericalInverseKinematicsCalculator> legInverseKinematicsCalculators = new SideDependentList();
    private final SideDependentList<NumericalInverseKinematicsCalculator> armInverseKinematicsCalculators = new SideDependentList();
    private final SideDependentList<YoFramePoseUsingYawPitchRoll> feetIKs = new SideDependentList();
    private final SideDependentList<YoFramePoseUsingYawPitchRoll> handIKs = new SideDependentList();
    private final FloatingRootJointRobot sdfRobot;
    private final FullHumanoidRobotModel fullRobotModel;
    private final SDFPerfectSimulatedSensorReader reader;
    private final PerfectSimulatedOutputWriter writer;
    private final YoBoolean controlFingers = new YoBoolean("controlFingers", this.registry);

    public DRCRobotMidiSliderBoardPositionManipulation(SimulationConstructionSet scs, FloatingRootJointRobot sdfRobot, FullHumanoidRobotModel fullRobotModel, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(false, scs, sdfRobot, fullRobotModel, yoGraphicsListRegistry);
    }

    public DRCRobotMidiSliderBoardPositionManipulation(boolean controlFingers, SimulationConstructionSet scs, FloatingRootJointRobot sdfRobot, FullHumanoidRobotModel fullRobotModel, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.scs = scs;
        this.fullRobotModel = fullRobotModel;
        this.sdfRobot = sdfRobot;
        this.reader = new SDFPerfectSimulatedSensorReader(sdfRobot, (FullRobotModel)fullRobotModel, null);
        this.writer = new PerfectSimulatedOutputWriter(sdfRobot, (FullRobotModel)fullRobotModel);
        this.controlFingers.set(controlFingers);
        sdfRobot.getAllOneDegreeOfFreedomJoints(this.allSCSJoints);
        this.sliderSpace.set((Enum)SliderSpace.JOINT);
        this.sliderBodyPart.set((Enum)SliderBodyPart.LEFT_LEG);
        scs.addYoRegistry(this.registry);
        this.sliderBoard = new MidiSliderBoard(scs);
        UpdateInverseKinematicsListener updateInverseKinematicsListener = new UpdateInverseKinematicsListener();
        this.sliderBoard.attachVariableChangedListener((YoVariableChangedListener)updateInverseKinematicsListener);
        FloatingJoint rootJoint = sdfRobot.getRootJoint();
        this.q_x = rootJoint.getQx();
        this.q_y = rootJoint.getQy();
        this.q_z = rootJoint.getQz();
        this.q_qs = rootJoint.getQuaternionQs();
        this.q_qx = rootJoint.getQuaternionQx();
        this.q_qy = rootJoint.getQuaternionQy();
        this.q_qz = rootJoint.getQuaternionQz();
        this.init();
        ChangeCurrentPartBeingControlledListener listener = new ChangeCurrentPartBeingControlledListener();
        for (RobotSide robotSide : RobotSide.values) {
            ((YoBoolean)this.isLegControlRequested.get((Enum)robotSide)).addListener((YoVariableChangedListener)listener);
            ((YoBoolean)this.isArmControlRequested.get((Enum)robotSide)).addListener((YoVariableChangedListener)listener);
        }
        this.isPelvisControlRequested.addListener((YoVariableChangedListener)listener);
        this.isChestControlRequested.addListener((YoVariableChangedListener)listener);
        PelvisRotationListener pelvisListener = new PelvisRotationListener();
        this.q_yaw.addListener((YoVariableChangedListener)pelvisListener);
        this.q_pitch.addListener((YoVariableChangedListener)pelvisListener);
        this.q_roll.addListener((YoVariableChangedListener)pelvisListener);
        if (this.controlFingers.getBooleanValue()) {
            for (RobotSide robotSide : RobotSide.values) {
                ((YoDouble)this.q_hands.get((Enum)robotSide)).addListener((YoVariableChangedListener)new HandListener(robotSide));
            }
        }
        this.isLeftLegControlRequested.set(true);
        this.isSymmetricModeRequested.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable yoVariable) {
                DRCRobotMidiSliderBoardPositionManipulation.this.symmetricMode = DRCRobotMidiSliderBoardPositionManipulation.this.isSymmetricModeRequested.getBooleanValue();
            }
        });
        RigidBodyBasics pelvis = fullRobotModel.getPelvis();
        RigidBodyBasics chest = fullRobotModel.getChest();
        double lambdaLeastSquares = 9.0E-4;
        double tolerance = 1.0E-8;
        double maxStepSize = 1.0;
        double minRandomSearchScalar = -0.5;
        double maxRandomSearchScalar = 1.0;
        int maxIterations = 10;
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics foot = fullRobotModel.getFoot((Enum)robotSide);
            RigidBodyBasics hand = fullRobotModel.getHand(robotSide);
            GeometricJacobian legJacobian = new GeometricJacobian(pelvis, foot, (ReferenceFrame)foot.getBodyFixedFrame());
            GeometricJacobian armJacobian = new GeometricJacobian(chest, hand, (ReferenceFrame)hand.getBodyFixedFrame());
            NumericalInverseKinematicsCalculator legInverseKinematicsCalculator = new NumericalInverseKinematicsCalculator(legJacobian, lambdaLeastSquares, tolerance, maxIterations, maxStepSize, minRandomSearchScalar, maxRandomSearchScalar);
            NumericalInverseKinematicsCalculator armInverseKinematicsCalculator = new NumericalInverseKinematicsCalculator(armJacobian, lambdaLeastSquares, tolerance, maxIterations, maxStepSize, minRandomSearchScalar, maxRandomSearchScalar);
            this.legInverseKinematicsCalculators.put((Enum)robotSide, (Object)legInverseKinematicsCalculator);
            this.armInverseKinematicsCalculators.put((Enum)robotSide, (Object)armInverseKinematicsCalculator);
        }
        String listName = "InverseKinematics";
        double scale = 0.2;
        for (RobotSide robotSide : RobotSide.values) {
            String sidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
            YoFramePoseUsingYawPitchRoll footIK = new YoFramePoseUsingYawPitchRoll(sidePrefix + "FootIK", "", HumanoidReferenceFrames.getWorldFrame(), this.registry);
            this.feetIKs.put((Enum)robotSide, (Object)footIK);
            YoFramePoseUsingYawPitchRoll handIK = new YoFramePoseUsingYawPitchRoll(sidePrefix + "HandIK", "", HumanoidReferenceFrames.getWorldFrame(), this.registry);
            this.handIKs.put((Enum)robotSide, (Object)handIK);
            yoGraphicsListRegistry.registerYoGraphic(listName, (YoGraphic)new YoGraphicCoordinateSystem(sidePrefix + "FootViz", footIK, scale));
            yoGraphicsListRegistry.registerYoGraphic(listName, (YoGraphic)new YoGraphicCoordinateSystem(sidePrefix + "HandViz", handIK, scale));
        }
        this.setupSymmetricModeListeners();
        this.setupSupportPolygonDisplayAndControl(yoGraphicsListRegistry);
    }

    private void setupSupportPolygonDisplayAndControl(YoGraphicsListRegistry yoGraphicsListRegistry) {
        for (int i = 0; i < this.baseControlPoints.length; ++i) {
            this.baseControlPoints[i] = new YoFramePoint3D("baseControlPoint" + i, ReferenceFrame.getWorldFrame(), this.registry);
            this.baseControlTargetPoints[i] = new YoFramePoint3D("baseControlTargetPoint" + i, ReferenceFrame.getWorldFrame(), this.registry);
        }
        this.baseControlPoints[0].set(0.18, 0.13, 0.0);
        this.baseControlPoints[1].set(0.18, -0.13, 0.0);
        this.baseControlPoints[2].set(-0.08, -0.15, 0.0);
        this.baseControlPoints[3].set(-0.08, 0.15, 0.0);
        this.baseControlTargetPoints[0].set(0.18, 0.13, 0.0);
        this.baseControlTargetPoints[1].set(0.18, -0.13, 0.0);
        this.baseControlTargetPoints[2].set(-0.08, -0.15, 0.0);
        this.baseControlTargetPoints[3].set(-0.08, 0.15, 0.0);
        SupportBaseControlRequestedListener supportBaseControlRequestedListener = new SupportBaseControlRequestedListener();
        this.isSupportBaseControlRequested.addListener((YoVariableChangedListener)supportBaseControlRequestedListener);
        this.isSupportBaseToggleRequested.addListener((YoVariableChangedListener)supportBaseControlRequestedListener);
        SupportBaseControlTargetRequestedListener supportBaseControlTargetRequestedListener = new SupportBaseControlTargetRequestedListener();
        this.isSupportBaseControlTargetRequested.addListener((YoVariableChangedListener)supportBaseControlTargetRequestedListener);
        this.isSupportBaseTargetToggleRequested.addListener((YoVariableChangedListener)supportBaseControlTargetRequestedListener);
        this.addSupportBaseControlGraphics(yoGraphicsListRegistry);
        this.addSupportBaseControlTargetGraphics(yoGraphicsListRegistry);
    }

    private void init() {
        for (NeckJointName neckJointName : NeckJointName.values) {
            OneDoFJointBasics neckJoint = this.fullRobotModel.getNeckJoint(neckJointName);
            if (neckJoint == null) continue;
            this.neckJointNames.add(neckJointName);
            this.neckSCSJoints.put(neckJointName, this.sdfRobot.getOneDegreeOfFreedomJoint(neckJoint.getName()));
        }
        for (NeckJointName neckJointName : SpineJointName.values) {
            OneDoFJointBasics spineJoint = this.fullRobotModel.getSpineJoint((SpineJointName)neckJointName);
            if (spineJoint == null) continue;
            this.spineJointNames.add((SpineJointName)neckJointName);
            this.spineSCSJoints.put((SpineJointName)neckJointName, this.sdfRobot.getOneDegreeOfFreedomJoint(spineJoint.getName()));
        }
        for (NeckJointName neckJointName : RobotSide.values) {
            for (LegJointName legJointName : LegJointName.values) {
                OneDoFJointBasics legJoint = this.fullRobotModel.getLegJoint((Enum)neckJointName, legJointName);
                if (legJoint == null) continue;
                ((ArrayList)this.legJointNames.get((Enum)neckJointName)).add(legJointName);
                ((EnumMap)this.legSCSJoints.get((Enum)neckJointName)).put(legJointName, this.sdfRobot.getOneDegreeOfFreedomJoint(legJoint.getName()));
            }
            for (LegJointName legJointName : ArmJointName.values()) {
                OneDoFJointBasics armJoint = this.fullRobotModel.getArmJoint((RobotSide)neckJointName, (ArmJointName)legJointName);
                if (armJoint == null) continue;
                ((ArrayList)this.armJointNames.get((Enum)neckJointName)).add(legJointName);
                ((EnumMap)this.armSCSJoints.get((Enum)neckJointName)).put(legJointName, this.sdfRobot.getOneDegreeOfFreedomJoint(armJoint.getName()));
            }
        }
        this.resetSliderBoard();
    }

    private void resetSliderBoard() {
        LinkedHashMap<OneDegreeOfFreedomJoint, Double> savedJointAngles = new LinkedHashMap<OneDegreeOfFreedomJoint, Double>();
        for (OneDegreeOfFreedomJoint joint : this.allSCSJoints) {
            savedJointAngles.put(joint, joint.getQYoVariable().getDoubleValue());
        }
        double temp_q_x = this.q_x.getDoubleValue();
        double temp_q_y = this.q_y.getDoubleValue();
        double temp_q_z = this.q_z.getDoubleValue();
        double temp_q_qs = this.q_qs.getDoubleValue();
        double temp_q_qx = this.q_qx.getDoubleValue();
        double temp_q_qy = this.q_qy.getDoubleValue();
        double temp_q_qz = this.q_qz.getDoubleValue();
        this.sliderBoard.reset();
        for (OneDegreeOfFreedomJoint joint : this.allSCSJoints) {
            joint.setQ(((Double)savedJointAngles.get(joint)).doubleValue());
        }
        this.q_x.set(temp_q_x);
        this.q_y.set(temp_q_y);
        this.q_z.set(temp_q_z);
        this.q_qs.set(temp_q_qs);
        this.q_qx.set(temp_q_qx);
        this.q_qy.set(temp_q_qy);
        this.q_qz.set(temp_q_qz);
        int buttonChannel = 1;
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isCaptureSnapshotRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isSaveSequenceRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isLoadSequenceRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isClearSequenceRequested);
        buttonChannel = 6;
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isLoadLastSequenceRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isLoadFrameByFrameSequenceRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isPlayPoseFromFrameByFrameSequenceRequested);
        buttonChannel = 9;
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isPelvisControlRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isChestControlRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isSymmetricModeRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isResetToBasePoseRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isSupportBaseTargetToggleRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isSupportBaseControlTargetRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isSupportBaseToggleRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isSupportBaseControlRequested);
        buttonChannel = 17;
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isLeftArmControlRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isRightArmControlRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isLeftLegControlRequested);
        this.sliderBoard.setButton(buttonChannel++, (YoVariable)this.isRightLegControlRequested);
        if (this.controlFingers.getBooleanValue()) {
            this.setUpFingerKnobs();
        }
    }

    private void setUpFingerKnobs() {
        int knobIndex = 1;
        for (RobotSide robotSide : RobotSide.values) {
            for (int f = 0; f <= 3; ++f) {
                for (int j = 1; j <= 2; ++j) {
                    this.sliderBoard.setKnob(knobIndex++, (String)this.handSideString.get((Enum)robotSide) + f + "_j" + j, (YoVariableHolder)this.scs, -1.57079632679, 1.57079632679);
                }
            }
        }
        for (RobotSide robotSide : RobotSide.values) {
            int j = 0;
            for (int f = 0; f <= 3; ++f) {
                this.sliderBoard.setKnob(knobIndex++, (String)this.handSideString.get((Enum)robotSide) + f + "_j" + j, (YoVariableHolder)this.scs, -1.57079632679, 1.57079632679);
            }
            knobIndex = 25;
        }
    }

    private void setupSymmetricModeListeners() {
        SymmetricModeListener symmetricModeListener;
        Matrix3D oppositeSignForYawAndRollOnly = new Matrix3D();
        oppositeSignForYawAndRollOnly.setIdentity();
        oppositeSignForYawAndRollOnly.setM00(-1.0);
        oppositeSignForYawAndRollOnly.setM22(-1.0);
        Vector3D unitVectorThisSide = new Vector3D();
        Vector3D unitVectorOtherSide = new Vector3D();
        for (RobotSide robotSide : RobotSide.values) {
            double sign;
            OneDegreeOfFreedomJoint otherJoint;
            OneDegreeOfFreedomJoint thisJoint;
            for (ArmJointName jointName : ((EnumMap)this.armSCSJoints.get((Enum)robotSide)).keySet()) {
                thisJoint = (OneDegreeOfFreedomJoint)((EnumMap)this.armSCSJoints.get((Enum)robotSide)).get(jointName);
                otherJoint = (OneDegreeOfFreedomJoint)((EnumMap)this.armSCSJoints.get((Enum)robotSide.getOppositeSide())).get(jointName);
                unitVectorThisSide.set(thisJoint.physics.getUnitVector());
                unitVectorOtherSide.set(otherJoint.physics.getUnitVector());
                oppositeSignForYawAndRollOnly.transform((Tuple3DBasics)unitVectorThisSide);
                sign = unitVectorOtherSide.dot((Vector3DReadOnly)unitVectorThisSide);
                symmetricModeListener = new SymmetricModeListener(otherJoint.getQYoVariable(), robotSide, sign);
                thisJoint.getQYoVariable().addListener((YoVariableChangedListener)symmetricModeListener);
            }
            for (ArmJointName jointName : ((EnumMap)this.legSCSJoints.get((Enum)robotSide)).keySet()) {
                thisJoint = (OneDegreeOfFreedomJoint)((EnumMap)this.legSCSJoints.get((Enum)robotSide)).get(jointName);
                otherJoint = (OneDegreeOfFreedomJoint)((EnumMap)this.legSCSJoints.get((Enum)robotSide.getOppositeSide())).get(jointName);
                unitVectorThisSide.set(thisJoint.physics.getUnitVector());
                unitVectorOtherSide.set(otherJoint.physics.getUnitVector());
                oppositeSignForYawAndRollOnly.transform((Tuple3DBasics)unitVectorThisSide);
                sign = unitVectorOtherSide.dot((Vector3DReadOnly)unitVectorThisSide);
                symmetricModeListener = new SymmetricModeListener(otherJoint.getQYoVariable(), robotSide, sign);
                thisJoint.getQYoVariable().addListener((YoVariableChangedListener)symmetricModeListener);
            }
        }
        if (this.controlFingers.getBooleanValue()) {
            for (RobotSide robotSide : RobotSide.values) {
                String thisSidePrefix = (String)this.handSideString.get((Enum)robotSide);
                String oppositeSidePrefix = (String)this.handSideString.get((Enum)robotSide.getOppositeSide());
                for (int f = 0; f <= 3; ++f) {
                    for (int j = 0; j <= 2; ++j) {
                        YoDouble thisVariable = (YoDouble)this.scs.findVariable(thisSidePrefix + f + "_j" + j);
                        YoDouble oppositeSideVariable = (YoDouble)this.scs.findVariable(oppositeSidePrefix + f + "_j" + j);
                        symmetricModeListener = new SymmetricModeListener(oppositeSideVariable, robotSide, 1.0);
                        thisVariable.addListener((YoVariableChangedListener)symmetricModeListener);
                    }
                }
            }
        }
    }

    public void setupSliderForLegs(RobotSide robotSide) {
        this.symmetricControlSide = robotSide;
        int sliderChannel = 1;
        switch ((SliderSpace)this.sliderSpace.getEnumValue()) {
            case JOINT: {
                for (LegJointName legJointName : (ArrayList)this.legJointNames.get((Enum)robotSide)) {
                    OneDegreeOfFreedomJoint legSCSJoint = (OneDegreeOfFreedomJoint)((EnumMap)this.legSCSJoints.get((Enum)robotSide)).get(legJointName);
                    OneDoFJointBasics legIDJoint = this.fullRobotModel.getLegJoint((Enum)robotSide, legJointName);
                    this.sliderBoard.setSlider(sliderChannel++, (YoVariable)legSCSJoint.getQYoVariable(), legIDJoint.getJointLimitLower(), legIDJoint.getJointLimitUpper());
                }
                break;
            }
            case CARTESIAN: {
                this.placeCartesianTargetsAtActuals();
                YoFramePoseUsingYawPitchRoll yoFramePose = (YoFramePoseUsingYawPitchRoll)this.feetIKs.get((Enum)robotSide);
                FramePoint3D footPosition = new FramePoint3D((ReferenceFrame)this.fullRobotModel.getFoot((Enum)robotSide).getBodyFixedFrame());
                footPosition.changeFrame(ReferenceFrame.getWorldFrame());
                double xyRange = 1.0;
                double zRange = 2.0;
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoX(), footPosition.getX() - xyRange / 2.0, footPosition.getX() + xyRange / 2.0);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoY(), footPosition.getY() - xyRange / 2.0, footPosition.getY() + xyRange / 2.0);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoZ(), footPosition.getZ() - zRange / 2.0, footPosition.getZ() + zRange / 2.0);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoYaw(), -Math.PI, Math.PI);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoPitch(), -Math.PI, Math.PI);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoRoll(), -Math.PI, Math.PI);
                break;
            }
        }
    }

    private void setupSliderForArms(RobotSide robotSide) {
        this.symmetricControlSide = robotSide;
        int sliderChannel = 1;
        switch ((SliderSpace)this.sliderSpace.getEnumValue()) {
            case JOINT: {
                for (ArmJointName armJointName : (ArrayList)this.armJointNames.get((Enum)robotSide)) {
                    OneDegreeOfFreedomJoint armSCSJoint = (OneDegreeOfFreedomJoint)((EnumMap)this.armSCSJoints.get((Enum)robotSide)).get(armJointName);
                    OneDoFJointBasics armIDJoint = this.fullRobotModel.getArmJoint(robotSide, armJointName);
                    this.sliderBoard.setSlider(sliderChannel++, (YoVariable)armSCSJoint.getQYoVariable(), armIDJoint.getJointLimitLower(), armIDJoint.getJointLimitUpper());
                }
                if (!this.controlFingers.getBooleanValue()) break;
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)this.q_hands.get((Enum)robotSide), -1.57079632679, 1.57079632679);
                this.sliderBoard.setSlider(sliderChannel++, (String)this.handSideString.get((Enum)robotSide) + "3_j0", (YoVariableHolder)this.scs, -1.57079632679, 1.57079632679);
                break;
            }
            case CARTESIAN: {
                this.placeCartesianTargetsAtActuals();
                YoFramePoseUsingYawPitchRoll yoFramePose = (YoFramePoseUsingYawPitchRoll)this.handIKs.get((Enum)robotSide);
                FramePoint3D handPosition = new FramePoint3D((ReferenceFrame)this.fullRobotModel.getHand(robotSide).getBodyFixedFrame());
                handPosition.changeFrame(ReferenceFrame.getWorldFrame());
                double xyRange = 1.0;
                double zRange = 1.0;
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoX(), handPosition.getX() - xyRange / 2.0, handPosition.getX() + xyRange / 2.0);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoY(), handPosition.getY() - xyRange / 2.0, handPosition.getY() + xyRange / 2.0);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoZ(), handPosition.getZ() - zRange / 2.0, handPosition.getZ() + zRange / 2.0);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoYaw(), -Math.PI, Math.PI);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoPitch(), -Math.PI, Math.PI);
                this.sliderBoard.setSlider(sliderChannel++, (YoVariable)yoFramePose.getYoRoll(), -Math.PI, Math.PI);
                break;
            }
        }
    }

    private void setupSliderForPelvis() {
        int sliderChannel = 1;
        double angle_min = -Math.PI;
        double angle_max = Math.PI;
        FramePoint3D pelvisPosition = new FramePoint3D((ReferenceFrame)this.fullRobotModel.getPelvis().getBodyFixedFrame());
        pelvisPosition.changeFrame(ReferenceFrame.getWorldFrame());
        double xyRange = 2.0;
        double zRange = 2.0;
        this.sliderBoard.setSlider(sliderChannel++, "q_x", (YoVariableHolder)this.scs, pelvisPosition.getX() - xyRange / 2.0, pelvisPosition.getX() + xyRange / 2.0);
        this.sliderBoard.setSlider(sliderChannel++, "q_y", (YoVariableHolder)this.scs, pelvisPosition.getY() - xyRange / 2.0, pelvisPosition.getY() + xyRange / 2.0);
        this.sliderBoard.setSlider(sliderChannel++, "q_z", (YoVariableHolder)this.scs, pelvisPosition.getZ() - zRange / 2.0, pelvisPosition.getZ() + zRange / 2.0);
        this.qprev = new Quaternion(this.q_qx.getDoubleValue(), this.q_qy.getDoubleValue(), this.q_qz.getDoubleValue(), this.q_qs.getDoubleValue());
        this.q_yaw.set(0.0);
        this.q_pitch.set(0.0);
        this.q_roll.set(0.0);
        this.sliderBoard.setSlider(sliderChannel++, "q_yaw", (YoVariableHolder)this.scs, angle_min, angle_max);
        this.sliderBoard.setSlider(sliderChannel++, "q_pitch", (YoVariableHolder)this.scs, angle_min, angle_max);
        this.sliderBoard.setSlider(sliderChannel++, "q_roll", (YoVariableHolder)this.scs, angle_min, angle_max);
    }

    private void setupSliderForChest() {
        int sliderChannel = 1;
        for (SpineJointName spineJointName : this.spineJointNames) {
            OneDegreeOfFreedomJoint spineSCSJoint = this.spineSCSJoints.get(spineJointName);
            OneDoFJointBasics spineIDJoint = this.fullRobotModel.getSpineJoint(spineJointName);
            this.sliderBoard.setSlider(sliderChannel++, (YoVariable)spineSCSJoint.getQYoVariable(), spineIDJoint.getJointLimitLower(), spineIDJoint.getJointLimitUpper());
        }
        for (NeckJointName neckJointName : this.neckJointNames) {
            OneDegreeOfFreedomJoint neckSCSJoint = this.neckSCSJoints.get(neckJointName);
            OneDoFJointBasics neckIDJoint = this.fullRobotModel.getNeckJoint(neckJointName);
            this.sliderBoard.setSlider(sliderChannel++, (YoVariable)neckSCSJoint.getQYoVariable(), neckIDJoint.getJointLimitLower(), neckIDJoint.getJointLimitUpper());
        }
    }

    private void setupSlidersForSupportBaseControl() {
        int sliderChannel = 1;
        for (int i = 0; i < this.baseControlPoints.length; ++i) {
            YoFramePoint3D baseControlPoint = this.baseControlPoints[i];
            this.sliderBoard.setSlider(sliderChannel++, (YoVariable)baseControlPoint.getYoX(), baseControlPoint.getX() - 2.0, baseControlPoint.getX() + 2.0);
            this.sliderBoard.setSlider(sliderChannel++, (YoVariable)baseControlPoint.getYoY(), baseControlPoint.getY() - 2.0, baseControlPoint.getY() + 2.0);
        }
    }

    private void setupSlidersForSupportBaseTargetControl() {
        int sliderChannel = 1;
        for (int i = 0; i < this.baseControlTargetPoints.length; ++i) {
            YoFramePoint3D baseControlTargetPoint = this.baseControlTargetPoints[i];
            this.sliderBoard.setSlider(sliderChannel++, (YoVariable)baseControlTargetPoint.getYoX(), baseControlTargetPoint.getX() - 2.0, baseControlTargetPoint.getX() + 2.0);
            this.sliderBoard.setSlider(sliderChannel++, (YoVariable)baseControlTargetPoint.getYoY(), baseControlTargetPoint.getY() - 2.0, baseControlTargetPoint.getY() + 2.0);
        }
    }

    private void placeCartesianTargetsAtActuals() {
        this.reader.read();
        for (RobotSide robotSide : RobotSide.values()) {
            YoFramePoseUsingYawPitchRoll yoFramePose = (YoFramePoseUsingYawPitchRoll)this.feetIKs.get((Enum)robotSide);
            FramePose3D framePose = new FramePose3D((ReferenceFrame)this.fullRobotModel.getFoot((Enum)robotSide).getBodyFixedFrame());
            framePose.changeFrame(ReferenceFrame.getWorldFrame());
            yoFramePose.set((FramePose3DReadOnly)framePose);
            yoFramePose = (YoFramePoseUsingYawPitchRoll)this.handIKs.get((Enum)robotSide);
            framePose = new FramePose3D((ReferenceFrame)this.fullRobotModel.getHand(robotSide).getBodyFixedFrame());
            framePose.changeFrame(ReferenceFrame.getWorldFrame());
            yoFramePose.set((FramePose3DReadOnly)framePose);
        }
        MovingReferenceFrame pelvisFrame = this.fullRobotModel.getPelvis().getBodyFixedFrame();
        FramePose3D framePose = new FramePose3D((ReferenceFrame)pelvisFrame);
        framePose.changeFrame(ReferenceFrame.getWorldFrame());
        System.out.println("Pelvis is at " + framePose);
    }

    private void setYawPitchRoll() {
        Quaternion q = new Quaternion();
        q.setYawPitchRoll(this.q_yaw.getDoubleValue(), this.q_pitch.getDoubleValue(), this.q_roll.getDoubleValue());
        q.multiply((QuaternionReadOnly)this.qprev);
        this.q_qs.set(q.getS());
        this.q_qx.set(q.getX());
        this.q_qy.set(q.getY());
        this.q_qz.set(q.getZ());
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    private void addSupportBaseControlGraphics(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.addSupportBaseGraphics(yoGraphicsListRegistry, this.baseControlPoints, this.baseControlPointsList, this.baseControlLinesList, "baseControl", YoAppearance.Green());
    }

    private void addSupportBaseControlTargetGraphics(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.addSupportBaseGraphics(yoGraphicsListRegistry, this.baseControlTargetPoints, this.baseControlTargetPointsList, this.baseControlTargetLinesList, "baseControlTarget", YoAppearance.Red());
    }

    private void addSupportBaseGraphics(YoGraphicsListRegistry yoGraphicsListRegistry, YoFramePoint3D[] basePoints, ArrayList<YoGraphic> basePointsList, ArrayList<YoGraphic> linesList, String namePrefix, AppearanceDefinition appearance) {
        AppearanceDefinition[] colors = new AppearanceDefinition[]{YoAppearance.Red(), YoAppearance.Green(), YoAppearance.Blue(), YoAppearance.Yellow()};
        YoGraphicsList yoGraphicsList = new YoGraphicsList(namePrefix + "Points");
        for (int i = 0; i < basePoints.length; ++i) {
            YoGraphicPosition baseControlPointViz = new YoGraphicPosition(namePrefix + "Point" + i, basePoints[i], 0.01, colors[i]);
            yoGraphicsList.add((YoGraphic)baseControlPointViz);
            basePointsList.add((YoGraphic)baseControlPointViz);
            for (int j = i + 1; j < basePoints.length; ++j) {
                YoGraphicLineSegment yoGraphicLineSegment = new YoGraphicLineSegment(namePrefix + "SupportLine", basePoints[i], basePoints[j], 1.0, appearance, false);
                yoGraphicsList.add((YoGraphic)yoGraphicLineSegment);
                linesList.add((YoGraphic)yoGraphicLineSegment);
            }
        }
        if (yoGraphicsListRegistry != null) {
            yoGraphicsListRegistry.registerYoGraphicsList(yoGraphicsList);
        }
        yoGraphicsList.hideYoGraphics();
    }

    public void addCaptureSnapshotListener(YoVariableChangedListener variableChangedListener) {
        this.isCaptureSnapshotRequested.addListener(variableChangedListener);
    }

    public void addSaveSequenceRequestedListener(YoVariableChangedListener variableChangedListener) {
        this.isSaveSequenceRequested.addListener(variableChangedListener);
    }

    public void addLoadSequenceRequestedListener(YoVariableChangedListener variableChangedListener) {
        this.isLoadSequenceRequested.addListener(variableChangedListener);
    }

    public void addClearSequenceRequestedListener(YoVariableChangedListener variableChangedListener) {
        this.isClearSequenceRequested.addListener(variableChangedListener);
    }

    public void addLoadFrameByFrameSequenceRequestedListener(YoVariableChangedListener variableChangedListener) {
        this.isLoadFrameByFrameSequenceRequested.addListener(variableChangedListener);
    }

    public void addLoadLastSequenceRequestedListener(YoVariableChangedListener variableChangedListener) {
        this.isLoadLastSequenceRequested.addListener(variableChangedListener);
    }

    public void addPlayPoseFromFrameByFrameSequenceRequestedListener(YoVariableChangedListener variableChangedListener) {
        this.isPlayPoseFromFrameByFrameSequenceRequested.addListener(variableChangedListener);
    }

    public void addResetToBasePoseRequestedListener(YoVariableChangedListener variableChangedListener) {
        this.isResetToBasePoseRequested.addListener(variableChangedListener);
    }

    private class HandListener
    implements YoVariableChangedListener {
        private final RobotSide robotSide;

        HandListener(RobotSide handSide) {
            this.robotSide = handSide;
        }

        public void changed(YoVariable v) {
            if (!DRCRobotMidiSliderBoardPositionManipulation.this.controlFingers.getBooleanValue()) {
                return;
            }
            double q_val = ((YoDouble)DRCRobotMidiSliderBoardPositionManipulation.this.q_hands.get((Enum)this.robotSide)).getDoubleValue();
            for (int f = 0; f <= 3; ++f) {
                for (int j = 1; j <= 2; ++j) {
                    ((YoDouble)DRCRobotMidiSliderBoardPositionManipulation.this.scs.findVariable((String)DRCRobotMidiSliderBoardPositionManipulation.this.handSideString.get((Enum)this.robotSide) + f + "_j" + j)).set(q_val);
                }
            }
        }
    }

    private class PelvisRotationListener
    implements YoVariableChangedListener {
        private PelvisRotationListener() {
        }

        public void changed(YoVariable v) {
            if (!(v instanceof YoDouble)) {
                return;
            }
            if (v.equals(DRCRobotMidiSliderBoardPositionManipulation.this.q_yaw) || v.equals(DRCRobotMidiSliderBoardPositionManipulation.this.q_pitch) || v.equals(DRCRobotMidiSliderBoardPositionManipulation.this.q_roll)) {
                DRCRobotMidiSliderBoardPositionManipulation.this.setYawPitchRoll();
            }
        }
    }

    private class SymmetricModeListener
    implements YoVariableChangedListener {
        private final YoDouble variableToSet;
        private final RobotSide robotSide;
        private final double respectiveSign;

        public SymmetricModeListener(YoDouble variableToSet, RobotSide robotSide, double sign) {
            this.variableToSet = variableToSet;
            this.robotSide = robotSide;
            this.respectiveSign = sign;
        }

        public void changed(YoVariable yoVariable) {
            if (DRCRobotMidiSliderBoardPositionManipulation.this.symmetricMode && this.robotSide == DRCRobotMidiSliderBoardPositionManipulation.this.symmetricControlSide) {
                this.variableToSet.set(this.respectiveSign * ((YoDouble)yoVariable).getDoubleValue());
            }
        }
    }

    private class UpdateInverseKinematicsListener
    implements YoVariableChangedListener {
        private final RigidBodyTransform desiredTransform = new RigidBodyTransform();

        private UpdateInverseKinematicsListener() {
        }

        public void changed(YoVariable v) {
            if (DRCRobotMidiSliderBoardPositionManipulation.this.legInverseKinematicsCalculators == null) {
                return;
            }
            DRCRobotMidiSliderBoardPositionManipulation.this.reader.read();
            DRCRobotMidiSliderBoardPositionManipulation.this.sdfRobot.update();
            if (DRCRobotMidiSliderBoardPositionManipulation.this.sliderSpace.getEnumValue() == SliderSpace.CARTESIAN) {
                for (RobotSide robotSide : RobotSide.values()) {
                    YoFramePoseUsingYawPitchRoll footIK = (YoFramePoseUsingYawPitchRoll)DRCRobotMidiSliderBoardPositionManipulation.this.feetIKs.get((Enum)robotSide);
                    FramePose3D framePose = new FramePose3D((FramePose3DReadOnly)footIK);
                    framePose.changeFrame((ReferenceFrame)DRCRobotMidiSliderBoardPositionManipulation.this.fullRobotModel.getPelvis().getBodyFixedFrame());
                    framePose.get((RigidBodyTransformBasics)this.desiredTransform);
                    ((NumericalInverseKinematicsCalculator)DRCRobotMidiSliderBoardPositionManipulation.this.legInverseKinematicsCalculators.get((Enum)robotSide)).solve(this.desiredTransform);
                    YoFramePoseUsingYawPitchRoll handIK = (YoFramePoseUsingYawPitchRoll)DRCRobotMidiSliderBoardPositionManipulation.this.handIKs.get((Enum)robotSide);
                    framePose = new FramePose3D((FramePose3DReadOnly)handIK);
                    framePose.changeFrame((ReferenceFrame)DRCRobotMidiSliderBoardPositionManipulation.this.fullRobotModel.getChest().getBodyFixedFrame());
                    framePose.get((RigidBodyTransformBasics)this.desiredTransform);
                    ((NumericalInverseKinematicsCalculator)DRCRobotMidiSliderBoardPositionManipulation.this.armInverseKinematicsCalculators.get((Enum)robotSide)).solve(this.desiredTransform);
                }
                DRCRobotMidiSliderBoardPositionManipulation.this.writer.updateRobotConfigurationBasedOnFullRobotModel();
            }
        }
    }

    private class SupportBaseControlTargetRequestedListener
    implements YoVariableChangedListener {
        private int displayState = 0;

        private SupportBaseControlTargetRequestedListener() {
        }

        public void changed(YoVariable v) {
            DRCRobotMidiSliderBoardPositionManipulation.this.setupSlidersForSupportBaseTargetControl();
            if (v.equals(DRCRobotMidiSliderBoardPositionManipulation.this.isSupportBaseTargetToggleRequested)) {
                this.toggleBaseControlTargetPointDisplay();
            }
        }

        private void toggleBaseControlTargetPointDisplay() {
            ++this.displayState;
            if (this.displayState == 6) {
                this.displayState = 0;
            }
            switch (this.displayState) {
                case 0: {
                    for (YoGraphic baseControlTargetPoint : DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetPointsList) {
                        baseControlTargetPoint.hideGraphicObject();
                    }
                    for (YoGraphic baseControlTargetLine : DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList) {
                        baseControlTargetLine.hideGraphicObject();
                    }
                    break;
                }
                case 1: {
                    for (YoGraphic baseControlTargetPoint : DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetPointsList) {
                        baseControlTargetPoint.showGraphicObject();
                    }
                    for (YoGraphic baseControlTargetLine : DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList) {
                        baseControlTargetLine.showGraphicObject();
                    }
                    break;
                }
                case 2: {
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetPointsList.get(0)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(0)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(1)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(2)).hideGraphicObject();
                    break;
                }
                case 3: {
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetPointsList.get(0)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetPointsList.get(1)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(1)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(2)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(3)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(4)).hideGraphicObject();
                    break;
                }
                case 4: {
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetPointsList.get(1)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetPointsList.get(2)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(0)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(4)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(1)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(5)).hideGraphicObject();
                    break;
                }
                default: {
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetPointsList.get(2)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetPointsList.get(3)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(1)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(3)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(2)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlTargetLinesList.get(4)).hideGraphicObject();
                }
            }
        }
    }

    private class SupportBaseControlRequestedListener
    implements YoVariableChangedListener {
        private int displayState = 0;

        private SupportBaseControlRequestedListener() {
        }

        public void changed(YoVariable v) {
            DRCRobotMidiSliderBoardPositionManipulation.this.setupSlidersForSupportBaseControl();
            if (v.equals(DRCRobotMidiSliderBoardPositionManipulation.this.isSupportBaseToggleRequested)) {
                this.toggleBaseControlPointDisplay();
            }
        }

        private void toggleBaseControlPointDisplay() {
            ++this.displayState;
            if (this.displayState == 6) {
                this.displayState = 0;
            }
            switch (this.displayState) {
                case 0: {
                    for (YoGraphic baseControlPoint : DRCRobotMidiSliderBoardPositionManipulation.this.baseControlPointsList) {
                        baseControlPoint.hideGraphicObject();
                    }
                    for (YoGraphic baseControlLine : DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList) {
                        baseControlLine.hideGraphicObject();
                    }
                    break;
                }
                case 1: {
                    for (YoGraphic baseControlPoint : DRCRobotMidiSliderBoardPositionManipulation.this.baseControlPointsList) {
                        baseControlPoint.showGraphicObject();
                    }
                    for (YoGraphic baseControlLine : DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList) {
                        baseControlLine.showGraphicObject();
                    }
                    break;
                }
                case 2: {
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlPointsList.get(0)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(0)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(1)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(2)).hideGraphicObject();
                    break;
                }
                case 3: {
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlPointsList.get(0)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlPointsList.get(1)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(1)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(2)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(3)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(4)).hideGraphicObject();
                    break;
                }
                case 4: {
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlPointsList.get(1)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlPointsList.get(2)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(0)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(4)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(1)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(5)).hideGraphicObject();
                    break;
                }
                default: {
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlPointsList.get(2)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlPointsList.get(3)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(1)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(3)).showGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(2)).hideGraphicObject();
                    ((YoGraphic)DRCRobotMidiSliderBoardPositionManipulation.this.baseControlLinesList.get(4)).hideGraphicObject();
                }
            }
        }
    }

    private class ChangeCurrentPartBeingControlledListener
    implements YoVariableChangedListener {
        private ChangeCurrentPartBeingControlledListener() {
        }

        public void changed(YoVariable v) {
            if (!(v instanceof YoBoolean)) {
                return;
            }
            for (RobotSide robotSide : RobotSide.values) {
                if (v.equals(DRCRobotMidiSliderBoardPositionManipulation.this.isLegControlRequested.get((Enum)robotSide))) {
                    DRCRobotMidiSliderBoardPositionManipulation.this.setupSliderForLegs(robotSide);
                    DRCRobotMidiSliderBoardPositionManipulation.this.sliderBodyPart.set((Enum)DRCRobotMidiSliderBoardPositionManipulation.this.legBodyParts.get((Enum)robotSide));
                }
                if (!v.equals(DRCRobotMidiSliderBoardPositionManipulation.this.isArmControlRequested.get((Enum)robotSide))) continue;
                DRCRobotMidiSliderBoardPositionManipulation.this.setupSliderForArms(robotSide);
                DRCRobotMidiSliderBoardPositionManipulation.this.sliderBodyPart.set((Enum)DRCRobotMidiSliderBoardPositionManipulation.this.armBodyParts.get((Enum)robotSide));
            }
            if (v.equals(DRCRobotMidiSliderBoardPositionManipulation.this.isPelvisControlRequested)) {
                DRCRobotMidiSliderBoardPositionManipulation.this.setupSliderForPelvis();
                DRCRobotMidiSliderBoardPositionManipulation.this.sliderBodyPart.set((Enum)SliderBodyPart.PELVIS);
            }
            if (v.equals(DRCRobotMidiSliderBoardPositionManipulation.this.isChestControlRequested)) {
                DRCRobotMidiSliderBoardPositionManipulation.this.setupSliderForChest();
                DRCRobotMidiSliderBoardPositionManipulation.this.sliderBodyPart.set((Enum)SliderBodyPart.CHEST);
            }
        }
    }

    private static enum SliderSpace {
        JOINT,
        CARTESIAN;

    }

    private static enum SliderBodyPart {
        LEFT_LEG,
        RIGHT_LEG,
        LEFT_ARM,
        RIGHT_ARM,
        PELVIS,
        CHEST;

    }
}

