/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import java.util.ArrayList;
import us.ihmc.avatar.posePlayback.PlaybackPose;
import us.ihmc.robotModels.FullRobotModel;

public class PlaybackPoseSequence {
    private final ArrayList<PlaybackPose> poseSequence = new ArrayList();
    private final FullRobotModel fullRobotModel;

    public PlaybackPoseSequence(FullRobotModel fullRobotModel) {
        this.fullRobotModel = fullRobotModel;
    }

    public void addPose(PlaybackPose playbackPose) {
        this.poseSequence.add(playbackPose);
    }

    public FullRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    public ArrayList<PlaybackPose> getPoseSequence() {
        return this.poseSequence;
    }

    public PlaybackPose getPose(int index) {
        if (index < this.poseSequence.size()) {
            return this.poseSequence.get(index);
        }
        return this.poseSequence.get(this.poseSequence.size() - 1);
    }

    public PlaybackPose getFinalPose() {
        return this.getPose(this.getNumberOfPoses() - 1);
    }

    public int getNumberOfPoses() {
        return this.poseSequence.size();
    }

    public void clear() {
        this.poseSequence.clear();
    }

    public boolean epsilonEquals(PlaybackPoseSequence otherPoseSequence, double jointEpsilon, double timeEpsilon) {
        ArrayList<PlaybackPose> otherPoseArray = otherPoseSequence.getPoseSequence();
        if (otherPoseArray.size() != this.poseSequence.size()) {
            return false;
        }
        for (int i = 0; i < this.poseSequence.size(); ++i) {
            PlaybackPose otherPose;
            PlaybackPose thisPose = this.poseSequence.get(i);
            if (!thisPose.epsilonEquals(otherPose = otherPoseArray.get(i), jointEpsilon, timeEpsilon)) continue;
            return false;
        }
        return true;
    }

    public PlaybackPoseSequence copy() {
        PlaybackPoseSequence playbackPoseSequence = new PlaybackPoseSequence(this.fullRobotModel);
        for (PlaybackPose pose : this.poseSequence) {
            playbackPoseSequence.addPose(pose.copy());
        }
        return playbackPoseSequence;
    }

    public int size() {
        return this.poseSequence.size();
    }
}

