/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import us.ihmc.avatar.posePlayback.PlaybackPose;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequence;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;

public class PlaybackPoseSequenceWriter {
    protected static final String directory = "PoseSequences/";

    public static void promptWriteToFile(final PlaybackPoseSequence posePlaybackRobotPoseSequence) {
        final JFrame saveFrame = new JFrame("Save sequence");
        saveFrame.setDefaultCloseOperation(2);
        saveFrame.setLayout(new FlowLayout());
        saveFrame.setAlwaysOnTop(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        final ArrayList<JRadioButton> buttonList = new ArrayList<JRadioButton>();
        for (PosePlaybackSequenceType sequenceType : PosePlaybackSequenceType.values()) {
            JRadioButton typeButton = new JRadioButton(sequenceType.toString());
            saveFrame.add(typeButton);
            buttonGroup.add(typeButton);
            buttonList.add(typeButton);
        }
        final JTextField fileNameInput = new JTextField("Type file name");
        saveFrame.add(fileNameInput);
        JButton saveButton = new JButton("Save");
        saveFrame.add(saveButton);
        saveFrame.pack();
        saveFrame.setVisible(true);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String sequenceDirectory = "";
                for (JRadioButton button : buttonList) {
                    if (!button.isSelected()) continue;
                    sequenceDirectory = button.getText() + "/";
                }
                PlaybackPoseSequenceWriter.writeToFile(posePlaybackRobotPoseSequence, sequenceDirectory + fileNameInput.getText());
                saveFrame.dispose();
            }
        });
    }

    public static void writeToFile(PlaybackPoseSequence posePlaybackRobotPoseSequence, String fileName) {
        if (fileName != null && !fileName.endsWith(".poseSequence")) {
            fileName = fileName + ".poseSequence";
        }
        String fullFileName = directory + fileName;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fullFileName);
            PlaybackPoseSequenceWriter.writeToOutputStream(posePlaybackRobotPoseSequence, fileOutputStream);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static void writeToOutputStream(PlaybackPoseSequence posePlaybackRobotPoseSequence, OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(outputStream));
        ArrayList<PlaybackPose> poseSequence = posePlaybackRobotPoseSequence.getPoseSequence();
        PlaybackPose firstPose = poseSequence.get(0);
        ArrayList<OneDoFJointBasics> oneDoFJoints = new ArrayList<OneDoFJointBasics>();
        firstPose.getOneDoFJoints(oneDoFJoints);
        printWriter.print("delayBeforePose poseDuration");
        for (OneDoFJointBasics oneDoFJoint : oneDoFJoints) {
            printWriter.print(" " + oneDoFJoint.getName());
        }
        printWriter.println();
        double[] jointAngles = new double[oneDoFJoints.size()];
        for (PlaybackPose posePlaybackRobotPose : poseSequence) {
            printWriter.print(String.format("%.3f \t", posePlaybackRobotPose.getPlayBackDelayBeforePose()));
            printWriter.print(String.format("%.3f \t", posePlaybackRobotPose.getPlayBackDuration()));
            posePlaybackRobotPose.getJointAngles(oneDoFJoints, jointAngles);
            double[] dArray = jointAngles;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double jointAngle = dArray[i];
                printWriter.print(String.format("%.3f \t", jointAngle));
            }
            printWriter.println();
        }
        printWriter.close();
    }

    public static enum PosePlaybackSequenceType {
        FRONT_TO_BACK,
        BACK_TO_FRONT,
        STAND_FROM_BACK,
        STAND_FROM_FRONT,
        OTHER,
        CAR_INGRESS,
        CAR_EGRESS;


        public String toString() {
            String out = "";
            switch (this) {
                case FRONT_TO_BACK: {
                    out = "FrontToBack";
                    break;
                }
                case BACK_TO_FRONT: {
                    out = "BackToFront";
                    break;
                }
                case STAND_FROM_BACK: {
                    out = "StandFromBack";
                    break;
                }
                case STAND_FROM_FRONT: {
                    out = "StandFromFront";
                    break;
                }
                case OTHER: {
                    out = "Other";
                    break;
                }
                case CAR_INGRESS: {
                    out = "CarIngress";
                    break;
                }
                case CAR_EGRESS: {
                    out = "CarEgress";
                }
            }
            return out;
        }
    }
}

