/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.posePlayback.DRCRobotMidiSliderBoardPositionManipulation;
import us.ihmc.avatar.posePlayback.PlaybackPose;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequence;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequenceReader;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequenceWriter;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.robotController.ModularRobotController;
import us.ihmc.robotics.robotController.RawSensorReader;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;
import us.ihmc.sensorProcessing.simulatedSensors.SDFPerfectSimulatedSensorReader;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJointHolder;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PoseSequenceSelectorPanel
extends JPanel {
    private static final long serialVersionUID = 7616401668436177628L;
    private final YoRegistry registry;
    private final HumanoidFloatingRootJointRobot sdfRobot;
    private final FullHumanoidRobotModel fullRobotModel;
    private final DRCRobotMidiSliderBoardPositionManipulation sliderBoard;
    private final JTable table;
    private final DefaultTableModel tableModel;
    private final PlaybackPoseSequence sequence;

    public PoseSequenceSelectorPanel(DRCRobotModel robotModel) {
        super(new GridLayout(1, 0));
        this.registry = new YoRegistry("PoseSequenceGUI");
        this.fullRobotModel = robotModel.createFullRobotModel();
        this.sdfRobot = robotModel.createHumanoidFloatingRootJointRobot(false);
        this.sequence = new PlaybackPoseSequence((FullRobotModel)this.fullRobotModel);
        HumanoidReferenceFrames referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        SDFPerfectSimulatedSensorReader reader = new SDFPerfectSimulatedSensorReader((FloatingRootJointRobot)this.sdfRobot, (FullRobotModel)this.fullRobotModel, (ReferenceFrames)referenceFrames);
        ModularRobotController controller = new ModularRobotController("Reader");
        controller.setRawSensorReader((RawSensorReader)reader);
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)this.sdfRobot);
        scs.addYoRegistry(this.registry);
        scs.startOnAThread();
        this.sliderBoard = new DRCRobotMidiSliderBoardPositionManipulation(scs, (FloatingRootJointRobot)this.sdfRobot, this.fullRobotModel, null);
        Object[] columnNames = new String[]{"#", "sy", "sp", "sr", "neck", "lhy", "lhr", "lhp", "lk", "lap", "lar", "rhy", "rhr", "rhp", "rk", "rap", "rar", "lsp", "lsr", "lep", "ler", "lwp", "lwr", "rsp", "rsr", "rep", "rer", "rwp", "rwr", "pause"};
        this.tableModel = new DefaultTableModel(columnNames, 0);
        this.table = new JTable(this.tableModel);
        this.tableInit();
    }

    private void tableInit() {
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    PoseSequenceSelectorPanel.this.updateSCS();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        for (int i = 1; i < 29; ++i) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(40);
        }
        this.table.getColumnModel().getColumn(29).setPreferredWidth(40);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.table.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
    }

    public PoseSequenceSelectorPanel(YoRegistry registry, HumanoidFloatingRootJointRobot sdfRobot, FullHumanoidRobotModel fullRobotModel, DRCRobotMidiSliderBoardPositionManipulation sliderBoard) {
        super(new GridLayout(1, 0));
        this.registry = registry;
        this.sdfRobot = sdfRobot;
        this.fullRobotModel = fullRobotModel;
        this.sliderBoard = sliderBoard;
        this.sequence = new PlaybackPoseSequence((FullRobotModel)fullRobotModel);
        Object[] columnNames = new String[]{"#", "sy", "sp", "sr", "neck", "lhy", "lhr", "lhp", "lk", "lap", "lar", "rhy", "rhr", "rhp", "rk", "rap", "rar", "lsp", "lsr", "lep", "ler", "lwp", "lwr", "rsp", "rsr", "rep", "rer", "rwp", "rwr", "pause"};
        this.tableModel = new DefaultTableModel(columnNames, 0);
        this.table = new JTable(this.tableModel);
        this.tableInit();
    }

    public void setValueAt(Object object, int row, int col) {
        this.tableModel.setValueAt(object, row, col);
    }

    public void addSequenceFromFile() {
        File selectedFile = this.selectFile();
        if (selectedFile != null) {
            PlaybackPoseSequenceReader.appendFromFile(this.sequence, selectedFile);
            this.updateTableBasedOnPoseSequence();
        }
    }

    public void newSequenceFromFile() {
        File selectedFile = this.selectFile();
        if (selectedFile != null) {
            this.sequence.clear();
            PlaybackPoseSequenceReader.appendFromFile(this.sequence, selectedFile);
            this.updateTableBasedOnPoseSequence();
        }
    }

    private File selectFile() {
        File selectedFile;
        JFileChooser chooser = new JFileChooser(new File("PoseSequences"));
        int approveOption = chooser.showOpenDialog(null);
        if (approveOption != 0) {
            System.err.println("Can not load selected file :" + chooser.getName());
            selectedFile = null;
        } else {
            selectedFile = chooser.getSelectedFile();
        }
        return selectedFile;
    }

    public void addSequence(PlaybackPoseSequence seq) {
        for (PlaybackPose pose : seq.getPoseSequence()) {
            this.sequence.addPose(pose);
        }
        this.updateTableBasedOnPoseSequence();
    }

    public void setSequence(PlaybackPoseSequence seq) {
        this.sequence.clear();
        this.addSequence(seq);
    }

    public void deleteSelectedRows() {
        this.updatePoseSequenceBasedOnTable();
        int[] selectedRows = this.table.getSelectedRows();
        int numberOfRemovedRows = 0;
        for (int row : selectedRows) {
            this.sequence.getPoseSequence().remove(row - numberOfRemovedRows);
            ++numberOfRemovedRows;
        }
        this.updateTableBasedOnPoseSequence();
    }

    public void updateSCS() {
        this.updatePoseSequenceBasedOnTable();
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        PlaybackPose selectedPose = this.sequence.getPoseSequence().get(selectedRow);
        selectedPose.setRobotAtPose((OneDegreeOfFreedomJointHolder)this.sdfRobot);
    }

    public void setRowWithSlider() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        PlaybackPose pose = new PlaybackPose((FullRobotModel)this.fullRobotModel, (OneDegreeOfFreedomJointHolder)this.sdfRobot);
        pose.setPlaybackDelayBeforePose(this.getTimeDelayFromRow(selectedRow));
        this.sequence.getPoseSequence().set(selectedRow, pose);
        this.updateTableBasedOnPoseSequence();
    }

    public void save() {
        this.updatePoseSequenceBasedOnTable();
        PlaybackPoseSequenceWriter.promptWriteToFile(this.sequence);
    }

    private void updateTableBasedOnPoseSequence() {
        this.tableModel.setRowCount(0);
        ArrayList<PlaybackPose> poseSequence = this.sequence.getPoseSequence();
        for (int i = 0; i < poseSequence.size(); ++i) {
            Object[] row = new Object[30];
            row[0] = i;
            PlaybackPose pose = poseSequence.get(i);
            double[] jointAngles = pose.getJointAngles();
            for (int j = 0; j < jointAngles.length; ++j) {
                row[j + 1] = jointAngles[j];
            }
            row[jointAngles.length + 1] = pose.getPlayBackDelayBeforePose();
            this.tableModel.addRow(row);
        }
    }

    private void updatePoseSequenceBasedOnTable() {
        throw new RuntimeException("Please implement me!");
    }

    private double[] getJointAnglesFromRow(int row) {
        double[] jointAngles = new double[28];
        for (int i = 0; i < 28; ++i) {
            try {
                jointAngles[i] = Double.parseDouble((String)this.tableModel.getValueAt(row, i + 1));
                continue;
            }
            catch (ClassCastException e) {
                jointAngles[i] = (Double)this.tableModel.getValueAt(row, i + 1);
            }
        }
        return jointAngles;
    }

    private double getTimeDelayFromRow(int row) {
        double timeDelay;
        try {
            timeDelay = Double.parseDouble((String)this.tableModel.getValueAt(row, 29));
        }
        catch (ClassCastException e) {
            timeDelay = (Double)this.tableModel.getValueAt(row, 29);
        }
        return timeDelay;
    }

    public void copyAndInsertRow() {
        this.updatePoseSequenceBasedOnTable();
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows.length == 0) {
            System.out.println("No row selected to copy.");
            return;
        }
        int row = selectedRows[0];
        this.sequence.getPoseSequence().add(row, this.sequence.getPose(row).copy());
        this.updateTableBasedOnPoseSequence();
    }

    public void insertInterpolation() {
        throw new RuntimeException("Please implement me again!");
    }

    public void switchSideDependentValues() {
        throw new RuntimeException("Please implement me again!");
    }
}

