/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import controller_msgs.msg.dds.KinematicsToolboxOutputStatus;
import controller_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.Collections;
import java.util.Random;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxModule;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class ReachabilityMapSolver {
    private static final int DEFAULT_MAX_NUMBER_OF_ITERATIONS = 100;
    private static final double DEFAULT_QUALITY_THRESHOLD = 0.001;
    private static final double DEFAULT_STABILITY_THRESHOLD = 2.0E-5;
    private static final double DEFAULT_MIN_PROGRESSION = 5.0E-4;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoInteger maximumNumberOfIterations = new YoInteger("maximumNumberOfIterations", this.registry);
    private final YoInteger numberOfIterations = new YoInteger("numberOfIterations", this.registry);
    private final YoDouble solutionQualityThreshold = new YoDouble("solutionQualityThreshold", this.registry);
    private final YoDouble solutionStabilityThreshold = new YoDouble("solutionStabilityThreshold", this.registry);
    private final YoDouble solutionMinimumProgression = new YoDouble("solutionProgressionThreshold", this.registry);
    private final int numberOfTrials = 10;
    private final Random random = new Random(645216L);
    private final KinematicsToolboxController kinematicsToolboxController;
    private final CommandInputManager commandInputManager = new CommandInputManager(KinematicsToolboxModule.supportedCommands());
    private final StatusMessageOutputManager statusOutputManager = new StatusMessageOutputManager(KinematicsToolboxModule.supportedStatus());
    private final RigidBodyBasics endEffector;
    private final OneDoFJointBasics[] robotArmJoints;
    private final RigidBodyTransform controlFramePoseInEndEffector = new RigidBodyTransform();
    private final SelectionMatrix3D angularSelection = new SelectionMatrix3D(null, true, true, true);
    private final RobotConfigurationData defaultArmConfiguration;

    public ReachabilityMapSolver(OneDoFJointBasics[] robotArmJoints, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.robotArmJoints = robotArmJoints;
        this.endEffector = robotArmJoints[robotArmJoints.length - 1].getSuccessor();
        this.kinematicsToolboxController = new KinematicsToolboxController(this.commandInputManager, this.statusOutputManager, null, robotArmJoints, Collections.singleton(this.endEffector), 0.001, yoGraphicsListRegistry, this.registry);
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsToolboxCommandConverter(MultiBodySystemTools.getRootBody((RigidBodyBasics)this.endEffector)));
        this.defaultArmConfiguration = RobotConfigurationDataFactory.create((OneDoFJointReadOnly[])robotArmJoints, (ForceSensorDefinition[])new ForceSensorDefinition[0], (IMUDefinition[])new IMUDefinition[0]);
        RobotConfigurationDataFactory.packJointState((RobotConfigurationData)this.defaultArmConfiguration, (OneDoFJointReadOnly[])robotArmJoints);
        this.maximumNumberOfIterations.set(100);
        this.solutionQualityThreshold.set(0.001);
        this.solutionStabilityThreshold.set(2.0E-5);
        this.solutionMinimumProgression.set(5.0E-4);
        parentRegistry.addChild(this.registry);
    }

    public void setControlFramePose(RigidBodyTransform controlFramePose) {
        this.controlFramePoseInEndEffector.set(controlFramePose);
    }

    public void setAngularSelection(boolean selectX, boolean selectY, boolean selectZ) {
        this.angularSelection.setAxisSelection(selectX, selectY, selectZ);
    }

    public boolean solveFor(FramePoint3DReadOnly position, FrameQuaternionReadOnly orientation) {
        this.kinematicsToolboxController.requestInitialize();
        FramePoint3D desiredPosition = new FramePoint3D((FrameTuple3DReadOnly)position);
        desiredPosition.changeFrame(ReferenceFrame.getWorldFrame());
        FrameQuaternion desiredOrientation = new FrameQuaternion(orientation);
        desiredOrientation.changeFrame(ReferenceFrame.getWorldFrame());
        KinematicsToolboxRigidBodyMessage message = MessageTools.createKinematicsToolboxRigidBodyMessage((RigidBodyBasics)this.endEffector, (Point3DReadOnly)desiredPosition, (QuaternionReadOnly)desiredOrientation);
        message.getAngularWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)1.0));
        message.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)1.0));
        message.getControlFramePositionInEndEffector().set((Tuple3DReadOnly)this.controlFramePoseInEndEffector.getTranslation());
        message.getControlFrameOrientationInEndEffector().set((Orientation3DReadOnly)this.controlFramePoseInEndEffector.getRotation());
        message.getAngularSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((SelectionMatrix3D)this.angularSelection));
        this.commandInputManager.submitMessage((Settable)message);
        return this.solveAndRetry(this.maximumNumberOfIterations.getIntegerValue());
    }

    public boolean solveFor(FramePoint3DReadOnly position) {
        this.kinematicsToolboxController.requestInitialize();
        FramePoint3D desiredPosition = new FramePoint3D((FrameTuple3DReadOnly)position);
        desiredPosition.changeFrame(ReferenceFrame.getWorldFrame());
        KinematicsToolboxRigidBodyMessage message = MessageTools.createKinematicsToolboxRigidBodyMessage((RigidBodyBasics)this.endEffector, (Point3DReadOnly)desiredPosition);
        message.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)1.0));
        message.getControlFramePositionInEndEffector().set((Tuple3DReadOnly)this.controlFramePoseInEndEffector.getTranslation());
        message.getControlFrameOrientationInEndEffector().set((Orientation3DReadOnly)this.controlFramePoseInEndEffector.getRotation());
        this.commandInputManager.submitMessage((Settable)message);
        return this.solveAndRetry(50);
    }

    private boolean solveAndRetry(int maximumNumberOfIterations) {
        this.numberOfIterations.set(0);
        boolean success = false;
        while (!success && this.numberOfIterations.getValue() < 10) {
            MultiBodySystemRandomTools.nextStateWithinJointLimits((Random)this.random, (JointStateType)JointStateType.CONFIGURATION, (OneDoFJointBasics[])this.robotArmJoints);
            success = this.solveOnce(maximumNumberOfIterations);
            this.numberOfIterations.increment();
        }
        return success;
    }

    private boolean solveOnce(int maximumNumberOfIterations) {
        boolean isSolutionGood = false;
        boolean isSolverStuck = false;
        double solutionQuality = Double.NaN;
        double solutionQualityLast = Double.NaN;
        double solutionQualityBeforeLast = Double.NaN;
        this.kinematicsToolboxController.updateRobotConfigurationData(this.defaultArmConfiguration);
        for (int iteration = 0; !isSolutionGood && iteration < maximumNumberOfIterations; ++iteration) {
            this.kinematicsToolboxController.update();
            KinematicsToolboxOutputStatus solution = this.kinematicsToolboxController.getSolution();
            solutionQuality = solution.getSolutionQuality();
            if (!Double.isNaN(solutionQualityLast)) {
                double deltaSolutionQualityLast = Math.abs(solutionQuality - solutionQualityLast);
                double deltaSolutionQualityBeforeLast = Math.abs(solutionQuality - solutionQualityBeforeLast);
                boolean isSolutionStable = deltaSolutionQualityLast < this.solutionStabilityThreshold.getDoubleValue();
                boolean isSolutionQualityHigh = solutionQuality < this.solutionQualityThreshold.getDoubleValue();
                boolean bl = isSolutionGood = isSolutionStable && isSolutionQualityHigh;
                if (!isSolutionQualityHigh) {
                    boolean stuckLast = deltaSolutionQualityLast / solutionQuality < this.solutionMinimumProgression.getDoubleValue();
                    boolean stuckBeforeLast = deltaSolutionQualityBeforeLast / solutionQuality < this.solutionMinimumProgression.getDoubleValue();
                    isSolverStuck = stuckLast || stuckBeforeLast;
                } else {
                    isSolverStuck = false;
                }
            }
            solutionQualityBeforeLast = solutionQualityLast;
            solutionQualityLast = solutionQuality;
            if (!isSolverStuck) continue;
            break;
        }
        if (isSolutionGood) {
            for (int i = 0; i < this.robotArmJoints.length; ++i) {
                this.robotArmJoints[i].setQ(this.kinematicsToolboxController.getDesiredOneDoFJoint()[i].getQ());
            }
        }
        return isSolutionGood;
    }

    public OneDoFJointBasics[] getRobotArmJoints() {
        return this.robotArmJoints;
    }
}

