/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import java.io.IOException;
import java.util.ArrayList;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapFileWriter;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapListener;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapSolver;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapTools;
import us.ihmc.avatar.reachabilityMap.Voxel3DGrid;
import us.ihmc.avatar.reachabilityMap.voxelPrimitiveShapes.SphereVoxelShape;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ReachabilitySphereMapCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private Voxel3DGrid voxel3dGrid;
    private SphereVoxelShape sphereVoxelShape;
    private final SimulationConstructionSet scs;
    private int gridSizeInNumberOfVoxels = 25;
    private double voxelSize = 0.05;
    private int numberOfRays = 50;
    private int numberOfRotationsAroundRay = 1;
    private final FramePoint3D voxelLocation = new FramePoint3D();
    private final FramePoint3D modifiableVoxelLocation = new FramePoint3D();
    private final ArrayList<ReachabilityMapListener> reachabilityMapListeners = new ArrayList();
    private final ReachabilityMapSolver solver;
    private ReachabilityMapFileWriter reachabilityMapFileWriter;
    private final PoseReferenceFrame gridFrame = new PoseReferenceFrame("gridFrame", ReferenceFrame.getWorldFrame());
    private final YoGraphicReferenceFrame gridFrameViz = new YoGraphicReferenceFrame((ReferenceFrame)this.gridFrame, this.registry, true, 0.5, YoAppearance.Blue());
    private final YoGraphicCoordinateSystem currentEvaluationPose = new YoGraphicCoordinateSystem("currentEvaluationPose", "", this.registry, true, 0.15, YoAppearance.HotPink());
    private final YoGraphicPosition currentEvaluationPosition = new YoGraphicPosition("currentEvaluationPosition", "", this.registry, 0.0125, YoAppearance.DeepPink());

    public ReachabilitySphereMapCalculator(OneDoFJointBasics[] robotArmJoints, SimulationConstructionSet scs) {
        this.scs = scs;
        this.solver = new ReachabilityMapSolver(robotArmJoints, null, this.registry);
        FramePose3D gridFramePose = new FramePose3D(ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)robotArmJoints[0].getFrameBeforeJoint().getTransformToWorldFrame());
        gridFramePose.appendTranslation(this.getGridSizeInMeters() / 2.5, 0.0, 0.0);
        this.setGridFramePose(gridFramePose);
        scs.addStaticLinkGraphics(ReachabilityMapTools.createReachibilityColorScale());
        scs.addYoGraphic((YoGraphic)this.gridFrameViz);
        scs.addYoGraphic((YoGraphic)this.currentEvaluationPose);
        scs.addYoGraphic((YoGraphic)this.currentEvaluationPosition);
        scs.addYoRegistry(this.registry);
    }

    public void setGridParameters(int gridSizeInNumberOfVoxels, double voxelSize, int numberOfRays, int numberOfRotationsAroundRay) {
        this.gridSizeInNumberOfVoxels = gridSizeInNumberOfVoxels;
        this.voxelSize = voxelSize;
        this.numberOfRays = numberOfRays;
        this.numberOfRotationsAroundRay = numberOfRotationsAroundRay;
    }

    public void setControlFramePose(RigidBodyTransform controlFramePose) {
        this.solver.setControlFramePose(controlFramePose);
    }

    public void setAngularSelection(boolean selectX, boolean selectY, boolean selectZ) {
        this.solver.setAngularSelection(selectX, selectY, selectZ);
    }

    public void setGridFramePose(FramePose3D pose) {
        pose.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.gridFrame.setPoseAndUpdate((FramePose3DReadOnly)pose);
    }

    public void setupCalculatorToRecordInFile(String robotName, Class<?> classForFilePath) throws IOException {
        if (robotName == null || robotName.isEmpty()) {
            System.err.println("Invalid robot name (either null or empty)");
            return;
        }
        this.reachabilityMapFileWriter = new ReachabilityMapFileWriter(robotName, classForFilePath);
    }

    public void attachReachabilityMapListener(ReachabilityMapListener listener) {
        this.reachabilityMapListeners.add(listener);
    }

    private void initialize() {
        this.sphereVoxelShape = new SphereVoxelShape((ReferenceFrame)this.gridFrame, this.voxelSize, this.numberOfRays, this.numberOfRotationsAroundRay, SphereVoxelShape.SphereVoxelType.graspOrigin);
        this.voxel3dGrid = new Voxel3DGrid((ReferenceFrame)this.gridFrame, this.sphereVoxelShape, this.gridSizeInNumberOfVoxels, this.voxelSize);
        if (this.reachabilityMapFileWriter != null) {
            this.reachabilityMapFileWriter.initialize(this.solver.getRobotArmJoints(), this.voxel3dGrid);
        }
        this.gridFrameViz.update();
        this.scs.addStaticLinkGraphics(ReachabilityMapTools.createBoundingBoxGraphics((FramePoint3DReadOnly)this.voxel3dGrid.getMinPoint(), (FramePoint3DReadOnly)this.voxel3dGrid.getMaxPoint()));
    }

    public void buildReachabilitySpace() {
        this.initialize();
        FrameVector3D translationFromVoxelOrigin = new FrameVector3D();
        FrameQuaternion orientation = new FrameQuaternion();
        for (int xIndex = 0; xIndex < this.gridSizeInNumberOfVoxels; ++xIndex) {
            for (int yIndex = 0; yIndex < this.gridSizeInNumberOfVoxels; ++yIndex) {
                for (int zIndex = 0; zIndex < this.gridSizeInNumberOfVoxels; ++zIndex) {
                    if (!this.isPositionReachable(xIndex, yIndex, zIndex)) continue;
                    block3: for (int rayIndex = 0; rayIndex < this.numberOfRays; ++rayIndex) {
                        this.voxel3dGrid.getVoxel(this.voxelLocation, xIndex, yIndex, zIndex);
                        for (int rotationAroundRayIndex = 0; rotationAroundRayIndex < this.numberOfRotationsAroundRay; ++rotationAroundRayIndex) {
                            this.modifiableVoxelLocation.setIncludingFrame((FrameTuple3DReadOnly)this.voxelLocation);
                            this.sphereVoxelShape.getPose(translationFromVoxelOrigin, orientation, rayIndex, rotationAroundRayIndex);
                            this.modifiableVoxelLocation.add((FrameTuple3DReadOnly)translationFromVoxelOrigin);
                            this.modifiableVoxelLocation.changeFrame(ReferenceFrame.getWorldFrame());
                            orientation.changeFrame(ReferenceFrame.getWorldFrame());
                            this.currentEvaluationPose.setPose((FramePose3DReadOnly)new FramePose3D((FrameTuple3DReadOnly)this.modifiableVoxelLocation, (FrameOrientation3DReadOnly)orientation));
                            this.currentEvaluationPose.update();
                            boolean success = this.solver.solveFor((FramePoint3DReadOnly)this.modifiableVoxelLocation, (FrameQuaternionReadOnly)orientation);
                            if (!success) continue;
                            this.voxel3dGrid.registerReachablePose(xIndex, yIndex, zIndex, rayIndex, rotationAroundRayIndex);
                            if (this.reachabilityMapFileWriter != null) {
                                this.reachabilityMapFileWriter.registerReachablePose(xIndex, yIndex, zIndex, rayIndex, rotationAroundRayIndex);
                            }
                            for (int i = 0; i < this.reachabilityMapListeners.size(); ++i) {
                                this.reachabilityMapListeners.get(i).hasReachedNewConfiguration();
                            }
                            this.scs.tickAndUpdate();
                            continue block3;
                        }
                    }
                    double reachabilityValue = this.voxel3dGrid.getD(xIndex, yIndex, zIndex);
                    if (!(reachabilityValue > 0.001)) continue;
                    Graphics3DObject voxelViz = this.sphereVoxelShape.createVisualization(this.voxelLocation, 0.25, reachabilityValue);
                    this.scs.addStaticLinkGraphics(voxelViz);
                }
            }
        }
        if (this.reachabilityMapFileWriter != null) {
            this.reachabilityMapFileWriter.exportAndClose();
        }
        System.out.println("Done!");
    }

    private boolean isPositionReachable(int xIndex, int yIndex, int zIndex) {
        this.voxel3dGrid.getVoxel(this.voxelLocation, xIndex, yIndex, zIndex);
        this.modifiableVoxelLocation.setIncludingFrame((FrameTuple3DReadOnly)this.voxelLocation);
        this.modifiableVoxelLocation.changeFrame(ReferenceFrame.getWorldFrame());
        this.currentEvaluationPosition.setPosition((FramePoint3DReadOnly)this.modifiableVoxelLocation);
        this.currentEvaluationPosition.update();
        return this.solver.solveFor((FramePoint3DReadOnly)this.voxelLocation);
    }

    public double getGridSizeInMeters() {
        return (double)this.gridSizeInNumberOfVoxels * this.voxelSize;
    }
}

