/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import java.util.ArrayList;
import us.ihmc.avatar.reachabilityMap.voxelPrimitiveShapes.SphereVoxelShape;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.linearAlgebra.PrincipalComponentAnalysis3D;

public class Voxel3DGrid
implements ReferenceFrameHolder {
    private final ReferenceFrame referenceFrame;
    private final BoundingBox3D boundingBox;
    private final SphereVoxelShape sphereVoxelShape;
    private final double gridSize;
    private final double voxelSize;
    private final int numberOfVoxelsPerDimension;
    private final int totalNumberOfVoxels;
    private final boolean[][][][] isRayReachable;
    private final boolean[][][][][] isPoseReachable;
    private final PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();

    public Voxel3DGrid(ReferenceFrame referenceFrame, SphereVoxelShape sphereVoxelShape, int gridSizeInNumberOfVoxels, double voxelSize) {
        this.sphereVoxelShape = sphereVoxelShape;
        this.referenceFrame = referenceFrame;
        this.voxelSize = voxelSize;
        this.numberOfVoxelsPerDimension = gridSizeInNumberOfVoxels;
        this.totalNumberOfVoxels = this.numberOfVoxelsPerDimension * this.numberOfVoxelsPerDimension * this.numberOfVoxelsPerDimension;
        this.gridSize = voxelSize * (double)gridSizeInNumberOfVoxels;
        this.boundingBox = new BoundingBox3D(-this.gridSize / 2.0, -this.gridSize / 2.0, -this.gridSize / 2.0, this.gridSize / 2.0, this.gridSize / 2.0, this.gridSize / 2.0);
        int numberOfRays = sphereVoxelShape.getNumberOfRays();
        int numberOfRotationsAroundRay = sphereVoxelShape.getNumberOfRotationsAroundRay();
        this.isRayReachable = new boolean[this.numberOfVoxelsPerDimension][this.numberOfVoxelsPerDimension][this.numberOfVoxelsPerDimension][numberOfRays];
        this.isPoseReachable = new boolean[this.numberOfVoxelsPerDimension][this.numberOfVoxelsPerDimension][this.numberOfVoxelsPerDimension][numberOfRays][numberOfRotationsAroundRay];
    }

    public void getVoxel(FramePoint3D voxelLocationToPack, int xIndex, int yIndex, int zIndex) {
        voxelLocationToPack.setToZero(this.referenceFrame);
        voxelLocationToPack.setX(this.getCoordinateFromIndex(xIndex));
        voxelLocationToPack.setY(this.getCoordinateFromIndex(yIndex));
        voxelLocationToPack.setZ(this.getCoordinateFromIndex(zIndex));
    }

    public void getClosestVoxel(FramePoint3D voxelLocationToPack, FramePoint3D inputPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)inputPoint);
        if (!this.boundingBox.isInsideInclusive((Point3DReadOnly)inputPoint)) {
            throw new RuntimeException("The given point is outside the grid");
        }
        voxelLocationToPack.setToZero(this.getReferenceFrame());
        voxelLocationToPack.setX(this.getCoordinateFromIndexUnsafe(this.getIndexFromCoordinateUnsafe(inputPoint.getX())));
        voxelLocationToPack.setY(this.getCoordinateFromIndexUnsafe(this.getIndexFromCoordinateUnsafe(inputPoint.getY())));
        voxelLocationToPack.setZ(this.getCoordinateFromIndexUnsafe(this.getIndexFromCoordinateUnsafe(inputPoint.getZ())));
    }

    private double getCoordinateFromIndex(int index) {
        if (index >= this.numberOfVoxelsPerDimension) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.getCoordinateFromIndexUnsafe(index);
    }

    private int getIndexFromCoordinate(double coordinate) {
        int index = (int)(coordinate / this.voxelSize + (double)(this.numberOfVoxelsPerDimension / 2) - 1.0);
        if (index >= this.numberOfVoxelsPerDimension) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return index;
    }

    private double getCoordinateFromIndexUnsafe(int index) {
        double coordinate = -this.gridSize / 2.0 + ((double)index + 0.5) * this.voxelSize;
        return coordinate;
    }

    private int getIndexFromCoordinateUnsafe(double coordinate) {
        int index = (int)(coordinate / this.voxelSize + (double)(this.numberOfVoxelsPerDimension / 2) - 1.0);
        return index;
    }

    public void registerReachablePose(int xIndex, int yIndex, int zIndex, int rayIndex, int rotationAroundRayIndex) {
        boolean poseHasAlreadyBeenRegistered = this.isPoseReachable[xIndex][yIndex][zIndex][rayIndex][rotationAroundRayIndex];
        if (!poseHasAlreadyBeenRegistered) {
            this.isPoseReachable[xIndex][yIndex][zIndex][rayIndex][rotationAroundRayIndex] = true;
            this.registerReachableRay(xIndex, yIndex, zIndex, rayIndex);
        }
    }

    public void registerReachableRay(int xIndex, int yIndex, int zIndex, int rayIndex) {
        this.isRayReachable[xIndex][yIndex][zIndex][rayIndex] = true;
    }

    public double getD(int xIndex, int yIndex, int zIndex) {
        double d = 0.0;
        int numberOfRays = this.sphereVoxelShape.getNumberOfRays();
        for (int i = 0; i < numberOfRays; ++i) {
            if (!this.isRayReachable[xIndex][yIndex][zIndex][i]) continue;
            d += 1.0;
        }
        return d /= (double)numberOfRays;
    }

    public double getD0(int xIndex, int yIndex, int zIndex) {
        double d0 = 0.0;
        int numberOfRays = this.sphereVoxelShape.getNumberOfRays();
        int numberOfRotationsAroundRay = this.sphereVoxelShape.getNumberOfRotationsAroundRay();
        for (int i = 0; i < numberOfRays; ++i) {
            for (int j = 0; j < numberOfRotationsAroundRay; ++j) {
                if (!this.isPoseReachable[xIndex][yIndex][zIndex][i][j]) continue;
                d0 += 1.0;
            }
        }
        d0 /= (double)numberOfRays;
        return d0 /= (double)numberOfRotationsAroundRay;
    }

    private void fitCone(int xIndex, int yIndex, int zIndex) {
        boolean[] isRayReachable = this.isRayReachable[xIndex][yIndex][zIndex];
        ArrayList<Point3D> reachablePointsOnly = new ArrayList<Point3D>();
        for (int i = 0; i < this.sphereVoxelShape.getNumberOfRays(); ++i) {
            if (!isRayReachable[i]) continue;
            reachablePointsOnly.add(this.sphereVoxelShape.getPointsOnSphere()[i]);
        }
        this.pca.setPointCloud(reachablePointsOnly);
        this.pca.compute();
        RotationMatrix coneRotation = new RotationMatrix();
        this.pca.getPrincipalFrameRotationMatrix(coneRotation);
        Vector3D sphereOriginToAverage = new Vector3D();
        Vector3D thirdAxis = new Vector3D();
        coneRotation.getColumn(2, (Tuple3DBasics)thirdAxis);
        FramePoint3D voxelLocation = new FramePoint3D();
        this.getVoxel(voxelLocation, xIndex, yIndex, zIndex);
        Vector3D mean = new Vector3D();
        sphereOriginToAverage.sub((Tuple3DReadOnly)mean, (Tuple3DReadOnly)voxelLocation);
        if (sphereOriginToAverage.dot((Vector3DReadOnly)thirdAxis) < 0.0) {
            RotationMatrix invertThirdAxis = new RotationMatrix();
            invertThirdAxis.setToRollOrientation(Math.PI);
            coneRotation.multiply((RotationMatrixReadOnly)invertThirdAxis);
        }
        double smallestDotProduct = Double.POSITIVE_INFINITY;
        coneRotation.getColumn(2, (Tuple3DBasics)thirdAxis);
        Vector3D testedRay = new Vector3D();
        Vector3D mostOpenedRay = new Vector3D();
        for (Point3D point : reachablePointsOnly) {
            testedRay.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)voxelLocation);
            double absDotProduct = Math.abs(testedRay.dot((Vector3DReadOnly)thirdAxis));
            if (!(absDotProduct < smallestDotProduct)) continue;
            smallestDotProduct = absDotProduct;
            mostOpenedRay.set(testedRay);
        }
        Vector3D standardDeviation = new Vector3D();
        this.pca.getStandardDeviation(standardDeviation);
        standardDeviation.scale(1.3);
        double coneBaseRadius = Math.sqrt(standardDeviation.getX() * standardDeviation.getX() + standardDeviation.getY() * standardDeviation.getY());
        double coneHeight = mostOpenedRay.dot((Vector3DReadOnly)thirdAxis);
        RigidBodyTransform coneTransform = new RigidBodyTransform();
        coneTransform.getRotation().set((RotationMatrixReadOnly)coneRotation);
        coneTransform.getTranslation().set((Tuple3DReadOnly)voxelLocation);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public SphereVoxelShape getSphereVoxelShape() {
        return this.sphereVoxelShape;
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public double getVoxelSize() {
        return this.voxelSize;
    }

    public int getNumberOfVoxelsPerDimension() {
        return this.numberOfVoxelsPerDimension;
    }

    public int getTotalNumberOfVoxels() {
        return this.totalNumberOfVoxels;
    }

    public FramePoint3D getMinPoint() {
        return new FramePoint3D(this.referenceFrame, (Tuple3DReadOnly)this.boundingBox.getMinPoint());
    }

    public FramePoint3D getMaxPoint() {
        return new FramePoint3D(this.referenceFrame, (Tuple3DReadOnly)this.boundingBox.getMaxPoint());
    }
}

