/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap.example;

import java.util.EnumMap;
import java.util.Random;
import us.ihmc.avatar.reachabilityMap.example.RobotParameters;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;

public class RobotArm
extends Robot {
    private static final RobotParameters.RobotArmJointParameters[] allJointNames = RobotParameters.RobotArmJointParameters.values();
    private final EnumMap<RobotParameters.RobotArmJointParameters, PinJoint> robotArmPinJoints = new EnumMap(RobotParameters.RobotArmJointParameters.class);
    private final EnumMap<RobotParameters.RobotArmJointParameters, RevoluteJoint> robotArmRevoluteJoints = new EnumMap(RobotParameters.RobotArmJointParameters.class);
    private final EnumMap<RobotParameters.RobotArmLinkParameters, RigidBodyBasics> robotArmRigidBodies = new EnumMap(RobotParameters.RobotArmLinkParameters.class);
    private final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final RigidBodyTransform elevatorFrameTransformToWorld = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle(), (Tuple3DReadOnly)RobotParameters.RobotArmJointParameters.getRootJoint().getJointOffset());
    private final ReferenceFrame elevatorFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"elevatorFrame", (ReferenceFrame)this.worldFrame, (RigidBodyTransformReadOnly)this.elevatorFrameTransformToWorld);
    private final RigidBodyBasics elevator = new RigidBody("elevator", this.elevatorFrame);
    private final RigidBodyTransform transformFromControlFrameToEndEffectorBodyFixedFrame = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.08));
    private final ReferenceFrame controlFrame;
    private final GeometricJacobian jacobian;
    private final Random random = new Random(464651L);

    public RobotArm() {
        super("RobotArm");
        for (RobotParameters.RobotArmJointParameters armJoint : allJointNames) {
            PinJoint pinJoint = new PinJoint(armJoint.getJointName(false), (Tuple3DReadOnly)armJoint.getJointOffset(), (Robot)this, (Vector3DReadOnly)armJoint.getJointAxis());
            pinJoint.setLimitStops(armJoint.getJointLowerLimit(), armJoint.getJointUpperLimit(), 100.0, 10.0);
            pinJoint.setDynamic(false);
            this.robotArmPinJoints.put(armJoint, pinJoint);
            RobotParameters.RobotArmLinkParameters armLink = armJoint.getAttachedLink();
            Link link = new Link(armLink.getLinkName());
            link.setLinkGraphics(armLink.getLinkGraphics());
            pinJoint.setLink(link);
        }
        RobotParameters.RobotArmJointParameters rootJoint = RobotParameters.RobotArmJointParameters.getRootJoint();
        this.addRootJoint((Joint)this.robotArmPinJoints.get((Object)rootJoint));
        for (RobotParameters.RobotArmJointParameters armJoint : allJointNames) {
            if (armJoint.getChildJoint() == null) continue;
            this.robotArmPinJoints.get((Object)armJoint).addJoint((Joint)this.robotArmPinJoints.get((Object)armJoint.getChildJoint()));
        }
        RigidBody parentBody = null;
        RevoluteJoint parentJoint = new RevoluteJoint(rootJoint.getJointName(false), this.elevator, (Vector3DReadOnly)rootJoint.getJointAxis());
        this.robotArmRevoluteJoints.put(rootJoint, parentJoint);
        for (RobotParameters.RobotArmJointParameters armJoint : allJointNames) {
            if (this.robotArmRevoluteJoints.get((Object)armJoint) == null) {
                parentJoint = new RevoluteJoint(armJoint.getJointName(false), parentBody, (Tuple3DReadOnly)armJoint.getJointOffset(), (Vector3DReadOnly)armJoint.getJointAxis());
                this.robotArmRevoluteJoints.put(armJoint, parentJoint);
            }
            RobotParameters.RobotArmLinkParameters attachedLink = armJoint.getAttachedLink();
            parentBody = new RigidBody(attachedLink.getLinkName(), (JointBasics)parentJoint, (Matrix3DReadOnly)new Matrix3D(), 1.0, (Tuple3DReadOnly)new Vector3D());
            this.robotArmRigidBodies.put(attachedLink, (RigidBodyBasics)parentBody);
        }
        for (RobotParameters.RobotArmJointParameters armJoint : allJointNames) {
            RevoluteJoint robotArmRevoluteJoint = this.robotArmRevoluteJoints.get((Object)armJoint);
            robotArmRevoluteJoint.setJointLimitLower(armJoint.getJointLowerLimit());
            robotArmRevoluteJoint.setJointLimitUpper(armJoint.getJointUpperLimit());
        }
        RigidBodyBasics endEffector = this.robotArmRigidBodies.get((Object)RobotParameters.RobotArmLinkParameters.getEndEffector());
        this.controlFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"controlFrame", (ReferenceFrame)endEffector.getBodyFixedFrame(), (RigidBodyTransformReadOnly)this.transformFromControlFrameToEndEffectorBodyFixedFrame);
        this.jacobian = new GeometricJacobian(this.elevator, endEffector, (ReferenceFrame)this.robotArmRigidBodies.get((Object)RobotParameters.RobotArmLinkParameters.HAND).getBodyFixedFrame());
    }

    public GeometricJacobian getJacobian() {
        return this.jacobian;
    }

    public ReferenceFrame getControlFrame() {
        return this.controlFrame;
    }

    public RevoluteJoint getJoint(RobotParameters.RobotArmJointParameters armJoint) {
        return this.robotArmRevoluteJoints.get((Object)armJoint);
    }

    public void copyRevoluteJointConfigurationToPinJoints() {
        for (RobotParameters.RobotArmJointParameters armJoint : allJointNames) {
            double q = this.robotArmRevoluteJoints.get((Object)armJoint).getQ();
            this.robotArmPinJoints.get((Object)armJoint).setQ(q);
        }
    }

    public void generateRandomConfiguration() {
        for (RobotParameters.RobotArmJointParameters armJoint : allJointNames) {
            double q = RandomNumbers.nextDouble((Random)this.random, (double)armJoint.getJointLowerLimit(), (double)armJoint.getJointUpperLimit());
            this.robotArmRevoluteJoints.get((Object)armJoint).setQ(q);
        }
    }

    public void updateFramesRecursively() {
        this.elevator.updateFramesRecursively();
    }

    public RigidBodyTransform getElevatorFrameTransformToWorld() {
        return this.elevatorFrameTransformToWorld;
    }
}

