/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap.footstep;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.KinematicsToolboxCenterOfMassMessage;
import controller_msgs.msg.dds.KinematicsToolboxConfigurationMessage;
import controller_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.jointAnglesWriter.JointAnglesWriter;
import us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule.KinematicsPlanningToolboxOptimizationSettings;
import us.ihmc.avatar.networkProcessor.kinematicsPlanningToolboxModule.SolutionQualityConvergenceDetector;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.HumanoidKinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxModule;
import us.ihmc.avatar.reachabilityMap.footstep.StepReachabilityFileTools;
import us.ihmc.avatar.reachabilityMap.footstep.StepReachabilityVisualizer;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityData;
import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityLatticePoint;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.KinematicsToolboxMessageFactory;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.idl.IDLSequence;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.CenterOfMassCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.robotDescription.JointDescription;
import us.ihmc.robotics.robotDescription.LinkDescription;
import us.ihmc.robotics.robotDescription.LinkGraphicsDescription;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.sensorProcessing.simulatedSensors.DRCPerfectSensorReaderFactory;
import us.ihmc.sensorProcessing.simulatedSensors.SensorDataContext;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.simulationconstructionset.util.simulationTesting.SimulationTestingParameters;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public abstract class HumanoidStepReachabilityCalculator {
    private static final Mode mode = Mode.TEST_MULTIPLE_STEPS;
    private static final double COM_WEIGHT = 1.0;
    private static final double RIGID_BODY_FEET_WEIGHT = 40.0;
    private static final double RIGID_BODY_OTHER_WEIGHT = 20.0;
    private static final double JOINT_WEIGHT = 10.0;
    private static final double SOLUTION_QUALITY_THRESHOLD = 5.0;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final YoAppearanceRGBColor ghostAppearance = new YoAppearanceRGBColor(Color.YELLOW, 0.75);
    private static final SimulationTestingParameters simulationTestingParameters = SimulationTestingParameters.createFromSystemProperties();
    private static final boolean visualize = simulationTestingParameters.getCreateGUI();
    private final CommandInputManager commandInputManager;
    private final YoRegistry mainRegistry = new YoRegistry("main");
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final HumanoidKinematicsToolboxController toolboxController;
    private final KinematicsPlanningToolboxOptimizationSettings optimizationSettings;
    private SolutionQualityConvergenceDetector solutionQualityConvergenceDetector;
    private final YoBoolean initializationSucceeded = new YoBoolean("initializationSucceeded", this.mainRegistry);
    private final YoInteger numberOfIterations = new YoInteger("numberOfIterations", this.mainRegistry);
    private final YoDouble finalSolutionQuality = new YoDouble("finalSolutionQuality", this.mainRegistry);
    private SimulationConstructionSet scs;
    private BlockingSimulationRunner blockingSimulationRunner;
    private final HumanoidFloatingRootJointRobot robot;
    private final HumanoidFloatingRootJointRobot ghost;
    private final RobotController toolboxUpdater;
    private static final double minimumOffsetX = -0.7;
    private static final double maximumOffsetX = 0.7;
    private static final double minimumOffsetY = -0.4;
    private static final double maximumOffsetY = 0.9;
    private static final double minimumOffsetZ = 0.0;
    private static final double maximumOffsetZ = 0.4;
    private static final double minimumOffsetYaw;
    private static final double maximumOffsetYaw;
    private static final double spacingXYZ = 0.3;
    private static final int yawDivisions = 3;
    private static final double yawSpacing;

    public HumanoidStepReachabilityCalculator() throws Exception {
        this.yoGraphicsListRegistry = new YoGraphicsListRegistry();
        this.optimizationSettings = new KinematicsPlanningToolboxOptimizationSettings();
        this.solutionQualityConvergenceDetector = new SolutionQualityConvergenceDetector(this.optimizationSettings, this.mainRegistry);
        DRCRobotModel robotModel = this.getRobotModel();
        DRCRobotModel ghostRobotModel = this.getRobotModel();
        FullHumanoidRobotModel desiredFullRobotModel = robotModel.createFullRobotModel();
        this.commandInputManager = new CommandInputManager(KinematicsToolboxModule.supportedCommands());
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsToolboxCommandConverter(desiredFullRobotModel));
        StatusMessageOutputManager statusOutputManager = new StatusMessageOutputManager(KinematicsToolboxModule.supportedStatus());
        double updateDT = 0.001;
        this.toolboxController = new HumanoidKinematicsToolboxController(this.commandInputManager, statusOutputManager, desiredFullRobotModel, (FullHumanoidRobotModelFactory)robotModel, updateDT, this.yoGraphicsListRegistry, this.mainRegistry);
        this.toolboxController.setInitialRobotConfiguration(robotModel);
        RobotCollisionModel collisionModel = this.getRobotCollisionModel(robotModel.getJointMap());
        this.toolboxController.setCollisionModel(collisionModel);
        this.robot = robotModel.createHumanoidFloatingRootJointRobot(false);
        this.toolboxUpdater = this.createToolboxUpdater();
        this.robot.setController(this.toolboxUpdater);
        this.robot.setDynamic(false);
        this.robot.setGravity(0.0);
        HumanoidStepReachabilityCalculator.addKinematicsCollisionGraphics(desiredFullRobotModel, (Robot)this.robot, collisionModel);
        RobotDescription robotDescription = ghostRobotModel.getRobotDescription();
        robotDescription.setName("Ghost");
        HumanoidStepReachabilityCalculator.recursivelyModifyGraphics((JointDescription)robotDescription.getChildrenJoints().get(0), (AppearanceDefinition)ghostAppearance);
        this.ghost = ghostRobotModel.createHumanoidFloatingRootJointRobot(false);
        this.ghost.setDynamic(false);
        this.ghost.setGravity(0.0);
        this.hideGhost();
        if (visualize) {
            this.scs = new SimulationConstructionSet(new Robot[]{this.robot, this.ghost}, (SimulationConstructionSetParameters)simulationTestingParameters);
            this.scs.addYoGraphicsListRegistry(this.yoGraphicsListRegistry, true);
            this.scs.setCameraFix(0.0, 0.0, 1.0);
            this.scs.setCameraPosition(8.0, 0.0, 3.0);
            this.scs.startOnAThread();
            this.blockingSimulationRunner = new BlockingSimulationRunner(this.scs, 600.0);
        }
        switch (mode) {
            case HAND_POSE: {
                this.testHandPose();
                break;
            }
            case TEST_SINGLE_STEP: {
                StepReachabilityLatticePoint leftFoot = new StepReachabilityLatticePoint(0, 1, 0, 0);
                FramePose3D rightFoot = new FramePose3D();
                this.testSingleStep(leftFoot, rightFoot, false);
                break;
            }
            case TEST_MULTIPLE_STEPS: {
                List<StepReachabilityLatticePoint> leftFootPoseList = HumanoidStepReachabilityCalculator.createLeftFootPoseList();
                HashMap<StepReachabilityLatticePoint, Double> poseValidityMap = new HashMap<StepReachabilityLatticePoint, Double>();
                FramePose3D rightFootPose = new FramePose3D();
                for (int xyzLoopIndex = 0; xyzLoopIndex < leftFootPoseList.size(); ++xyzLoopIndex) {
                    StepReachabilityLatticePoint leftFootPose = leftFootPoseList.get(xyzLoopIndex);
                    double reachabilityValue = this.testSingleStep(leftFootPose, rightFootPose, true);
                    LogTools.info((String)("Reachability value: " + reachabilityValue));
                    if (!(reachabilityValue < 5.0)) continue;
                    LogTools.info((String)"Entering yaw sweep");
                    List<StepReachabilityLatticePoint> leftFootYawSweepList = HumanoidStepReachabilityCalculator.createLeftFootYawSweepList(leftFootPose);
                    for (int yawLoopIndex = 0; yawLoopIndex < leftFootYawSweepList.size(); ++yawLoopIndex) {
                        leftFootPose = leftFootYawSweepList.get(yawLoopIndex);
                        reachabilityValue = this.testSingleStep(leftFootPose, rightFootPose, false);
                        poseValidityMap.put(leftFootPose, reachabilityValue);
                    }
                }
                StepReachabilityFileTools.writeToFile(robotModel.getStepReachabilityResourceName(), poseValidityMap, 0.3, 3, yawSpacing);
                break;
            }
            case TEST_VISUALIZATION: {
                StepReachabilityData stepReachabilityData = robotModel.getStepReachabilityData();
                new StepReachabilityVisualizer(stepReachabilityData);
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)mode) + " is not implemented yet!");
            }
        }
        ThreadTools.sleepForever();
    }

    protected abstract DRCRobotModel getRobotModel();

    protected abstract RobotCollisionModel getRobotCollisionModel(HumanoidJointNameMap var1);

    private void testHandPose() throws Exception {
        LogTools.info((String)"Entering: testHandPose");
        Random random = new Random(2134L);
        double groundHeight = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1);
        Point2D offset = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)2.0);
        double offsetYaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        FullHumanoidRobotModel initialFullRobotModel = HumanoidStepReachabilityCalculator.createFullRobotModelAtInitialConfiguration(this.getRobotModel(), groundHeight, (Tuple2DReadOnly)offset, offsetYaw);
        RobotConfigurationData robotConfigurationData = HumanoidStepReachabilityCalculator.extractRobotConfigurationData(initialFullRobotModel);
        FullHumanoidRobotModel randomizedFullRobotModel = HumanoidStepReachabilityCalculator.createFullRobotModelAtInitialConfiguration(this.getRobotModel(), groundHeight, (Tuple2DReadOnly)offset, offsetYaw);
        double averageSolutionQuality = 0.0;
        double worstSolutionQuality = -1.0;
        int numberOfTests = 30;
        for (int i = 0; i < numberOfTests; ++i) {
            for (RobotSide robotSide : RobotSide.values) {
                HumanoidStepReachabilityCalculator.randomizeArmJointPositions(random, robotSide, randomizedFullRobotModel, 0.4);
                KinematicsToolboxRigidBodyMessage message = KinematicsToolboxMessageFactory.holdRigidBodyCurrentPose((RigidBodyBasics)randomizedFullRobotModel.getHand(robotSide));
                message.getAngularWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)20.0));
                message.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)20.0));
                this.commandInputManager.submitMessage((Settable)message);
            }
            KinematicsToolboxCenterOfMassMessage message = MessageTools.createKinematicsToolboxCenterOfMassMessage((Point3DReadOnly)HumanoidStepReachabilityCalculator.computeCenterOfMass3D(randomizedFullRobotModel));
            SelectionMatrix3D selectionMatrix = new SelectionMatrix3D();
            selectionMatrix.selectZAxis(false);
            message.getSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((SelectionMatrix3D)selectionMatrix));
            message.getWeights().set(MessageTools.createWeightMatrix3DMessage((double)1.0));
            this.commandInputManager.submitMessage((Settable)message);
            KinematicsToolboxConfigurationMessage configurationMessage = new KinematicsToolboxConfigurationMessage();
            configurationMessage.setDisableSupportPolygonConstraint(true);
            configurationMessage.setEnableCollisionAvoidance(true);
            this.commandInputManager.submitMessage((Settable)configurationMessage);
            this.snapGhostToFullRobotModel(randomizedFullRobotModel);
            this.toolboxController.updateRobotConfigurationData(robotConfigurationData);
            this.toolboxController.updateCapturabilityBasedStatus(HumanoidStepReachabilityCalculator.createCapturabilityBasedStatus(randomizedFullRobotModel, this.getRobotModel(), true, true));
            this.runKinematicsToolboxController();
            if (!this.initializationSucceeded.getBooleanValue()) {
                throw new RuntimeException(KinematicsToolboxController.class.getSimpleName() + " did not manage to initialize.");
            }
            double solutionQuality = this.toolboxController.getSolution().getSolutionQuality();
            LogTools.info((String)("Solution quality: " + solutionQuality));
            averageSolutionQuality += solutionQuality / (double)numberOfTests;
            worstSolutionQuality = Math.max(worstSolutionQuality, solutionQuality);
        }
    }

    private double testSingleStep(StepReachabilityLatticePoint leftFootLatticePoint, FramePose3D rightFoot, boolean freeYaw) throws BlockingSimulationRunner.SimulationExceededMaximumTimeException {
        if (freeYaw) {
            LogTools.info((String)"Entering: testStep");
        } else {
            LogTools.info((String)"Sweeping yaw");
        }
        double groundHeight = 0.0;
        Point2D offset = new Point2D(0.0, 0.15);
        double offsetYaw = 0.0;
        FullHumanoidRobotModel targetFullRobotModel = HumanoidStepReachabilityCalculator.createFullRobotModelAtInitialConfiguration(this.getRobotModel(), groundHeight, (Tuple2DReadOnly)offset, offsetYaw);
        RobotConfigurationData robotConfigurationData = HumanoidStepReachabilityCalculator.extractRobotConfigurationData(targetFullRobotModel);
        FramePose3D leftFoot = new FramePose3D();
        leftFoot.getPosition().setX(0.3 * (double)leftFootLatticePoint.getXIndex());
        leftFoot.getPosition().setY(0.3 * (double)leftFootLatticePoint.getYIndex());
        leftFoot.getPosition().setZ(0.3 * (double)leftFootLatticePoint.getZIndex());
        leftFoot.getOrientation().setToYawOrientation(yawSpacing * (double)leftFootLatticePoint.getYawIndex());
        for (RobotSide robotSide : RobotSide.values) {
            KinematicsToolboxRigidBodyMessage rbMessage = freeYaw ? (robotSide == RobotSide.LEFT ? KinematicsToolboxMessageFactory.holdRigidBodyFreeYaw((RigidBodyBasics)targetFullRobotModel.getFoot((Enum)robotSide), (FramePose3D)leftFoot) : KinematicsToolboxMessageFactory.holdRigidBodyFreeYaw((RigidBodyBasics)targetFullRobotModel.getFoot((Enum)robotSide), (FramePose3D)rightFoot)) : (robotSide == RobotSide.LEFT ? KinematicsToolboxMessageFactory.holdRigidBodyAtTargetFrame((RigidBodyBasics)targetFullRobotModel.getFoot((Enum)robotSide), (FramePose3D)leftFoot) : KinematicsToolboxMessageFactory.holdRigidBodyAtTargetFrame((RigidBodyBasics)targetFullRobotModel.getFoot((Enum)robotSide), (FramePose3D)rightFoot));
            rbMessage.getAngularWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)40.0));
            rbMessage.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)40.0));
            this.commandInputManager.submitMessage((Settable)rbMessage);
        }
        FramePose3D centerFeet = this.interpolateFeet(leftFoot, rightFoot);
        KinematicsToolboxRigidBodyMessage rbMessage = KinematicsToolboxMessageFactory.holdRigidBodyAtTargetFrame((RigidBodyBasics)targetFullRobotModel.getChest(), (FramePose3D)centerFeet);
        rbMessage.getLinearSelectionMatrix().setZSelected(false);
        rbMessage.getAngularWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)20.0));
        rbMessage.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)20.0));
        this.commandInputManager.submitMessage((Settable)rbMessage);
        rbMessage = KinematicsToolboxMessageFactory.holdRigidBodyAtTargetFrame((RigidBodyBasics)targetFullRobotModel.getHead(), (FramePose3D)centerFeet);
        rbMessage.getLinearSelectionMatrix().setZSelected(false);
        rbMessage.getAngularWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)20.0));
        rbMessage.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)20.0));
        this.commandInputManager.submitMessage((Settable)rbMessage);
        KinematicsToolboxCenterOfMassMessage comMessage = MessageTools.createKinematicsToolboxCenterOfMassMessage((Point3DReadOnly)this.computeCoMForFeet(leftFoot, rightFoot));
        SelectionMatrix3D selectionMatrix = new SelectionMatrix3D();
        selectionMatrix.selectZAxis(false);
        comMessage.getSelectionMatrix().set(MessageTools.createSelectionMatrix3DMessage((SelectionMatrix3D)selectionMatrix));
        comMessage.getWeights().set(MessageTools.createWeightMatrix3DMessage((double)1.0));
        this.commandInputManager.submitMessage((Settable)comMessage);
        KinematicsToolboxConfigurationMessage configurationMessage = new KinematicsToolboxConfigurationMessage();
        configurationMessage.setDisableSupportPolygonConstraint(true);
        configurationMessage.setEnableCollisionAvoidance(true);
        this.commandInputManager.submitMessage((Settable)configurationMessage);
        this.toolboxController.updateRobotConfigurationData(robotConfigurationData);
        this.runKinematicsToolboxController();
        if (!this.initializationSucceeded.getBooleanValue()) {
            throw new RuntimeException(KinematicsToolboxController.class.getSimpleName() + " did not manage to initialize.");
        }
        return this.toolboxController.getSolution().getSolutionQuality();
    }

    private void runKinematicsToolboxController() throws BlockingSimulationRunner.SimulationExceededMaximumTimeException {
        this.initializationSucceeded.set(false);
        this.numberOfIterations.set(0);
        this.solutionQualityConvergenceDetector.initialize();
        if (visualize) {
            while (!this.solutionQualityConvergenceDetector.isSolved()) {
                this.blockingSimulationRunner.simulateNTicksAndBlockAndCatchExceptions(1);
                this.solutionQualityConvergenceDetector.submitSolutionQuality(this.toolboxController.getSolution().getSolutionQuality());
                this.solutionQualityConvergenceDetector.update();
            }
        } else {
            while (!this.solutionQualityConvergenceDetector.isSolved()) {
                this.toolboxUpdater.doControl();
                this.solutionQualityConvergenceDetector.submitSolutionQuality(this.toolboxController.getSolution().getSolutionQuality());
                this.solutionQualityConvergenceDetector.update();
            }
        }
        this.finalSolutionQuality.set(this.toolboxController.getSolution().getSolutionQuality());
    }

    private static List<StepReachabilityLatticePoint> createLeftFootPoseList() {
        ArrayList<StepReachabilityLatticePoint> posesToCheck = new ArrayList<StepReachabilityLatticePoint>();
        int minimumXIndex = (int)Math.round(-2.3333333333333335);
        int maximumXIndex = (int)Math.round(2.3333333333333335);
        int minimumYIndex = (int)Math.round(-1.3333333333333335);
        int maximumYIndex = (int)Math.round(3.0);
        int minimumZIndex = (int)Math.round(0.0);
        int maximumZIndex = (int)Math.round(1.3333333333333335);
        for (int xIndex = minimumXIndex; xIndex <= maximumXIndex; ++xIndex) {
            for (int yIndex = minimumYIndex; yIndex <= maximumYIndex; ++yIndex) {
                for (int zIndex = minimumZIndex; zIndex <= maximumZIndex; ++zIndex) {
                    if (xIndex == 0 && yIndex == 0) continue;
                    StepReachabilityLatticePoint latticePoint = new StepReachabilityLatticePoint(xIndex, yIndex, zIndex, 0);
                    posesToCheck.add(latticePoint);
                }
            }
        }
        return posesToCheck;
    }

    private static List<StepReachabilityLatticePoint> createLeftFootYawSweepList(StepReachabilityLatticePoint leftFootPose) {
        ArrayList<StepReachabilityLatticePoint> leftFootYawSweepList = new ArrayList<StepReachabilityLatticePoint>();
        int minimumYawIndex = -Math.floorMod((int)Math.round(minimumOffsetYaw / yawSpacing), 3);
        int maximumYawIndex = Math.floorMod((int)Math.round(maximumOffsetYaw / yawSpacing), 3);
        for (int yawIndex = minimumYawIndex; yawIndex <= maximumYawIndex; ++yawIndex) {
            StepReachabilityLatticePoint latticePoint = new StepReachabilityLatticePoint(leftFootPose.getXIndex(), leftFootPose.getYIndex(), leftFootPose.getZIndex(), yawIndex);
            leftFootYawSweepList.add(latticePoint);
        }
        return leftFootYawSweepList;
    }

    public static void recursivelyModifyGraphics(JointDescription joint, AppearanceDefinition ghostAppearance) {
        if (joint == null) {
            return;
        }
        LinkDescription link = joint.getLink();
        if (link == null) {
            return;
        }
        LinkGraphicsDescription linkGraphics = link.getLinkGraphics();
        if (linkGraphics != null) {
            List graphics3dInstructions = linkGraphics.getGraphics3DInstructions();
            if (graphics3dInstructions == null) {
                return;
            }
            for (Graphics3DPrimitiveInstruction primitive : graphics3dInstructions) {
                if (!(primitive instanceof Graphics3DInstruction)) continue;
                Graphics3DInstruction modelInstruction = (Graphics3DInstruction)primitive;
                modelInstruction.setAppearance(ghostAppearance);
            }
        }
        if (joint.getChildrenJoints() == null) {
            return;
        }
        for (JointDescription child : joint.getChildrenJoints()) {
            HumanoidStepReachabilityCalculator.recursivelyModifyGraphics(child, ghostAppearance);
        }
    }

    private RobotController createToolboxUpdater() {
        return new RobotController(){
            private final JointAnglesWriter jointAnglesWriter;
            {
                this.jointAnglesWriter = new JointAnglesWriter((Robot)HumanoidStepReachabilityCalculator.this.robot, (FullRobotModel)HumanoidStepReachabilityCalculator.this.toolboxController.getDesiredFullRobotModel());
            }

            public void doControl() {
                if (!HumanoidStepReachabilityCalculator.this.initializationSucceeded.getBooleanValue()) {
                    HumanoidStepReachabilityCalculator.this.initializationSucceeded.set(HumanoidStepReachabilityCalculator.this.toolboxController.initialize());
                    if (HumanoidStepReachabilityCalculator.this.initializationSucceeded.getValue()) {
                        this.jointAnglesWriter.updateRobotConfigurationBasedOnFullRobotModel();
                        return;
                    }
                }
                if (HumanoidStepReachabilityCalculator.this.initializationSucceeded.getBooleanValue()) {
                    HumanoidStepReachabilityCalculator.this.toolboxController.updateInternal();
                    this.jointAnglesWriter.updateRobotConfigurationBasedOnFullRobotModel();
                    HumanoidStepReachabilityCalculator.this.numberOfIterations.increment();
                }
            }

            public void initialize() {
            }

            public YoRegistry getYoRegistry() {
                return HumanoidStepReachabilityCalculator.this.mainRegistry;
            }

            public String getName() {
                return HumanoidStepReachabilityCalculator.this.mainRegistry.getName();
            }

            public String getDescription() {
                return null;
            }
        };
    }

    private void hideGhost() {
        this.ghost.setPositionInWorld((Tuple3DReadOnly)new Point3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    private void snapGhostToFullRobotModel(FullHumanoidRobotModel fullHumanoidRobotModel) {
        new JointAnglesWriter((Robot)this.ghost, (FullRobotModel)fullHumanoidRobotModel).updateRobotConfigurationBasedOnFullRobotModel();
    }

    public static FullHumanoidRobotModel createFullRobotModelAtInitialConfiguration(DRCRobotModel robotModel) {
        return HumanoidStepReachabilityCalculator.createFullRobotModelAtInitialConfiguration(robotModel, 0.0, 0.0);
    }

    public static FullHumanoidRobotModel createFullRobotModelAtInitialConfiguration(DRCRobotModel robotModel, double groundHeight, double offsetYaw) {
        return HumanoidStepReachabilityCalculator.createFullRobotModelAtInitialConfiguration(robotModel, groundHeight, (Tuple2DReadOnly)new Point2D(), offsetYaw);
    }

    public static FullHumanoidRobotModel createFullRobotModelAtInitialConfiguration(DRCRobotModel robotModel, double groundHeight, Tuple2DReadOnly offset, double offsetYaw) {
        FullHumanoidRobotModel initialFullRobotModel = robotModel.createFullRobotModel();
        HumanoidFloatingRootJointRobot robot = robotModel.createHumanoidFloatingRootJointRobot(false);
        robotModel.getDefaultRobotInitialSetup(groundHeight, offsetYaw).initializeRobot(robot, robotModel.getJointMap());
        DRCPerfectSensorReaderFactory drcPerfectSensorReaderFactory = new DRCPerfectSensorReaderFactory((FloatingRootJointRobot)robot, 0.0);
        drcPerfectSensorReaderFactory.build(initialFullRobotModel.getRootJoint(), null, null, null, null);
        SensorDataContext sensorDataContext = new SensorDataContext();
        long timestamp = drcPerfectSensorReaderFactory.getSensorReader().read(sensorDataContext);
        drcPerfectSensorReaderFactory.getSensorReader().compute(timestamp, sensorDataContext);
        initialFullRobotModel.getRootJoint().getJointPose().prependTranslation(offset.getX(), offset.getY(), 0.0);
        initialFullRobotModel.updateFrames();
        return initialFullRobotModel;
    }

    public static ConvexPolygon2D extractSupportPolygon(FullHumanoidRobotModel initialFullRobotModel, RobotContactPointParameters<RobotSide> contactPointParameters) {
        SideDependentList<ContactablePlaneBody> contactableFeet = HumanoidStepReachabilityCalculator.extractContactableFeet(initialFullRobotModel, contactPointParameters);
        ConvexPolygon2D supportPolygon = new ConvexPolygon2D();
        for (RobotSide robotSide : RobotSide.values) {
            List contactPoints = ((ContactablePlaneBody)contactableFeet.get((Enum)robotSide)).getContactPointsCopy();
            contactPoints.forEach(cp -> cp.changeFrame(worldFrame));
            supportPolygon.addVertices(Vertex3DSupplier.asVertex3DSupplier((List)contactPoints));
        }
        supportPolygon.update();
        return supportPolygon;
    }

    public static SideDependentList<ContactablePlaneBody> extractContactableFeet(FullHumanoidRobotModel robotModel, RobotContactPointParameters<RobotSide> contactPointParameters) {
        ContactableBodiesFactory factory = new ContactableBodiesFactory();
        factory.setFullRobotModel((FullLeggedRobotModel)robotModel);
        factory.setReferenceFrames((CommonLeggedReferenceFrames)new HumanoidReferenceFrames(robotModel));
        factory.setFootContactPoints(contactPointParameters.getControllerFootGroundContactPoints());
        return new SideDependentList(factory.createFootContactablePlaneBodies());
    }

    public static ConvexPolygon2D shrinkPolygon(ConvexPolygon2DReadOnly polygonToShrink, double distance) {
        ConvexPolygon2D shrunkPolygon = new ConvexPolygon2D();
        new ConvexPolygonScaler().scaleConvexPolygon(polygonToShrink, distance, (ConvexPolygon2DBasics)shrunkPolygon);
        return shrunkPolygon;
    }

    public static Point2D generateRandomPoint2DInPolygon(Random random, ConvexPolygon2DReadOnly polygon) {
        int edgeIndex = random.nextInt(polygon.getNumberOfVertices());
        Point2DReadOnly a = polygon.getCentroid();
        Point2DReadOnly b = polygon.getVertex(edgeIndex);
        Point2DReadOnly c = polygon.getNextVertex(edgeIndex);
        return EuclidGeometryRandomTools.nextPoint2DInTriangle((Random)random, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c);
    }

    public static void randomizeArmJointPositions(Random random, RobotSide robotSide, FullHumanoidRobotModel robotModelToModify) {
        HumanoidStepReachabilityCalculator.randomizeArmJointPositions(random, robotSide, robotModelToModify, 1.0);
    }

    public static void randomizeArmJointPositions(Random random, RobotSide robotSide, FullHumanoidRobotModel robotModelToModify, double percentOfMotionRangeAllowed) {
        RigidBodyBasics chest = robotModelToModify.getChest();
        RigidBodyBasics hand = robotModelToModify.getHand(robotSide);
        HumanoidStepReachabilityCalculator.randomizeKinematicsChainPositions(random, chest, hand, percentOfMotionRangeAllowed);
    }

    public static void randomizeKinematicsChainPositions(Random random, RigidBodyBasics base, RigidBodyBasics body) {
        HumanoidStepReachabilityCalculator.randomizeKinematicsChainPositions(random, base, body, 1.0);
    }

    public static void randomizeKinematicsChainPositions(Random random, RigidBodyBasics base, RigidBodyBasics body, double percentOfMotionRangeAllowed) {
        percentOfMotionRangeAllowed = MathTools.clamp((double)percentOfMotionRangeAllowed, (double)0.0, (double)1.0);
        OneDoFJointBasics[] joints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)base, (RigidBodyBasics)body);
        HumanoidStepReachabilityCalculator.randomizeJointPositions(random, joints, percentOfMotionRangeAllowed);
    }

    public static void randomizeJointPositions(Random random, OneDoFJointBasics[] joints, double percentOfMotionRangeAllowed) {
        for (OneDoFJointBasics joint : joints) {
            double jointLimitLower = joint.getJointLimitLower();
            double jointLimitUpper = joint.getJointLimitUpper();
            double rangeReduction = (1.0 - percentOfMotionRangeAllowed) * (jointLimitUpper - jointLimitLower);
            joint.setQ(RandomNumbers.nextDouble((Random)random, (double)(jointLimitLower += 0.5 * rangeReduction), (double)(jointLimitUpper -= 0.5 * rangeReduction)));
        }
        MultiBodySystemTools.getRootBody((RigidBodyBasics)joints[0].getPredecessor()).updateFramesRecursively();
    }

    public static FramePoint3D computeCenterOfMass3D(FullHumanoidRobotModel fullHumanoidRobotModel) {
        return new FramePoint3D((FrameTuple3DReadOnly)new CenterOfMassCalculator((RigidBodyReadOnly)fullHumanoidRobotModel.getElevator(), worldFrame).getCenterOfMass());
    }

    private FramePose3D interpolateFeet(FramePose3D leftFoot, FramePose3D rightFoot) {
        double interpolationAlpha = 0.5;
        FramePose3D centerFeet = new FramePose3D();
        centerFeet.interpolate((FramePose3DReadOnly)leftFoot, (FramePose3DReadOnly)rightFoot, interpolationAlpha);
        return centerFeet;
    }

    private FramePoint3D computeCoMForFeet(FramePose3D leftFoot, FramePose3D rightFoot) {
        FramePose3D centerPose = this.interpolateFeet(leftFoot, rightFoot);
        centerPose.getPosition().setZ(1.3496);
        return new FramePoint3D((FrameTuple3DReadOnly)centerPose.getPosition());
    }

    public static RobotConfigurationData extractRobotConfigurationData(FullHumanoidRobotModel fullRobotModel) {
        fullRobotModel.updateFrames();
        OneDoFJointBasics[] joints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        ForceSensorDefinition[] forceSensorDefinitions = fullRobotModel.getForceSensorDefinitions();
        IMUDefinition[] imuDefinitions = fullRobotModel.getIMUDefinitions();
        RobotConfigurationData robotConfigurationData = RobotConfigurationDataFactory.create((OneDoFJointReadOnly[])joints, (ForceSensorDefinition[])forceSensorDefinitions, (IMUDefinition[])imuDefinitions);
        RobotConfigurationDataFactory.packJointState((RobotConfigurationData)robotConfigurationData, Arrays.stream(joints).collect(Collectors.toList()));
        robotConfigurationData.getRootTranslation().set((Tuple3DReadOnly)fullRobotModel.getRootJoint().getJointPose().getPosition());
        robotConfigurationData.getRootOrientation().set((QuaternionReadOnly)fullRobotModel.getRootJoint().getJointPose().getOrientation());
        return robotConfigurationData;
    }

    public static CapturabilityBasedStatus createCapturabilityBasedStatus(FullHumanoidRobotModel currentRobotModel, DRCRobotModel drcRobotModel, boolean isLeftFootInSupport, boolean isRightFootInSupport) {
        return HumanoidStepReachabilityCalculator.createCapturabilityBasedStatus(currentRobotModel, (RobotContactPointParameters<RobotSide>)drcRobotModel.getContactPointParameters(), isLeftFootInSupport, isRightFootInSupport);
    }

    public static CapturabilityBasedStatus createCapturabilityBasedStatus(FullHumanoidRobotModel currentRobotModel, RobotContactPointParameters<RobotSide> contactPointParameters, boolean isLeftFootInSupport, boolean isRightFootInSupport) {
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        SideDependentList<ContactablePlaneBody> contactableFeet = HumanoidStepReachabilityCalculator.extractContactableFeet(currentRobotModel, contactPointParameters);
        IDLSequence.Object leftFootSupportPolygon2d = capturabilityBasedStatus.getLeftFootSupportPolygon3d();
        IDLSequence.Object rightFootSupportPolygon2d = capturabilityBasedStatus.getRightFootSupportPolygon3d();
        if (isLeftFootInSupport) {
            ((ContactablePlaneBody)contactableFeet.get((Enum)RobotSide.LEFT)).getContactPointsCopy().stream().peek(cp -> cp.changeFrame(worldFrame)).forEach(cp -> ((Point3D)leftFootSupportPolygon2d.add()).set(cp.getX(), cp.getY(), 0.0));
        }
        if (isRightFootInSupport) {
            ((ContactablePlaneBody)contactableFeet.get((Enum)RobotSide.RIGHT)).getContactPointsCopy().stream().peek(cp -> cp.changeFrame(worldFrame)).forEach(cp -> ((Point3D)rightFootSupportPolygon2d.add()).set(cp.getX(), cp.getY(), 0.0));
        }
        return capturabilityBasedStatus;
    }

    private static Graphics3DObject getGraphics(Collidable collidable) {
        FrameShape3DReadOnly shape = collidable.getShape();
        RigidBodyTransform transformToParentJoint = collidable.getShape().getReferenceFrame().getTransformToDesiredFrame((ReferenceFrame)collidable.getRigidBody().getParentJoint().getFrameAfterJoint());
        Graphics3DObject graphics = new Graphics3DObject();
        graphics.transform((RigidBodyTransformReadOnly)transformToParentJoint);
        AppearanceDefinition appearance = YoAppearance.DarkGreen();
        appearance.setTransparency(0.5);
        if (shape instanceof Sphere3DReadOnly) {
            Sphere3DReadOnly sphere = (Sphere3DReadOnly)shape;
            graphics.translate((Tuple3DReadOnly)sphere.getPosition());
            graphics.addSphere(sphere.getRadius(), appearance);
        } else if (shape instanceof Capsule3DReadOnly) {
            Capsule3DReadOnly capsule = (Capsule3DReadOnly)shape;
            RigidBodyTransform transform = new RigidBodyTransform();
            EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)capsule.getAxis(), (Orientation3DBasics)transform.getRotation());
            transform.getTranslation().set((Tuple3DReadOnly)capsule.getPosition());
            graphics.transform((RigidBodyTransformReadOnly)transform);
            graphics.addCapsule(capsule.getRadius(), capsule.getLength() + 2.0 * capsule.getRadius(), appearance);
        } else if (shape instanceof Box3DReadOnly) {
            Box3DReadOnly box = (Box3DReadOnly)shape;
            graphics.translate((Tuple3DReadOnly)box.getPosition());
            graphics.rotate((Orientation3DReadOnly)new RotationMatrix(box.getOrientation()));
            graphics.addCube(box.getSizeX(), box.getSizeY(), box.getSizeZ(), true, appearance);
        } else if (shape instanceof PointShape3DReadOnly) {
            PointShape3DReadOnly pointShape = (PointShape3DReadOnly)shape;
            graphics.translate((Tuple3DReadOnly)pointShape);
            graphics.addSphere(0.01, appearance);
        } else {
            throw new UnsupportedOperationException("Unsupported shape: " + shape.getClass().getSimpleName());
        }
        return graphics;
    }

    public static void addKinematicsCollisionGraphics(FullHumanoidRobotModel fullRobotModel, Robot robot, RobotCollisionModel collisionModel) {
        List robotCollidables = collisionModel.getRobotCollidables(fullRobotModel.getElevator());
        for (Collidable collidable : robotCollidables) {
            Graphics3DObject linkGraphics = robot.getLink(collidable.getRigidBody().getName()).getLinkGraphics();
            if (linkGraphics == null) continue;
            linkGraphics.combine(HumanoidStepReachabilityCalculator.getGraphics(collidable));
        }
    }

    static {
        simulationTestingParameters.setDataBufferSize(65536);
        minimumOffsetYaw = -Math.toRadians(70.0);
        maximumOffsetYaw = Math.toRadians(80.0);
        yawSpacing = (maximumOffsetYaw - minimumOffsetYaw) / 3.0;
    }

    private static enum Mode {
        HAND_POSE,
        TEST_SINGLE_STEP,
        TEST_MULTIPLE_STEPS,
        TEST_VISUALIZATION;

    }
}

