/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap.footstep;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.Map;
import java.util.Scanner;
import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityData;
import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityLatticePoint;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.log.LogTools;

public class StepReachabilityFileTools {
    public static void writeToFile(String fileName, Map<StepReachabilityLatticePoint, Double> feasibilityMap, double spacingXY, int yawDivisions, double yawSpacing) {
        try {
            File reachabilityDataFile = new File(fileName);
            FileTools.ensureFileExists((Path)reachabilityDataFile.toPath());
            FileWriter fileWriter = new FileWriter(reachabilityDataFile);
            fileWriter.write(spacingXY + ",");
            fileWriter.write(yawDivisions + ",");
            fileWriter.write(yawSpacing + "\n");
            for (StepReachabilityLatticePoint latticePoint : feasibilityMap.keySet()) {
                fileWriter.write(latticePoint.getXIndex() + ",");
                fileWriter.write(latticePoint.getYIndex() + ",");
                fileWriter.write(latticePoint.getZIndex() + ",");
                fileWriter.write(latticePoint.getYawIndex() + ",");
                fileWriter.write(String.valueOf(feasibilityMap.get(latticePoint)));
                fileWriter.write("\n");
            }
            fileWriter.flush();
            LogTools.info((String)"Done writing to file");
        }
        catch (Exception e) {
            LogTools.error((String)"Error logging reachability file");
            e.printStackTrace();
        }
    }

    public static StepReachabilityData loadFromFile(String filename) {
        StepReachabilityData reachabilityData = new StepReachabilityData();
        try {
            Scanner scanner = new Scanner(new File(filename));
            String gridData = scanner.nextLine();
            String[] gridDataStrings = gridData.split(",");
            double spacingXY = Double.parseDouble(gridDataStrings[0]);
            int yawDivisions = Integer.parseInt(gridDataStrings[1]);
            double yawSpacing = Double.parseDouble(gridDataStrings[2]);
            reachabilityData.setGridData(spacingXY, yawSpacing, yawDivisions);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] data = line.split(",");
                int xIndex = Integer.parseInt(data[0]);
                int yIndex = Integer.parseInt(data[1]);
                int zIndex = Integer.parseInt(data[2]);
                int yawIndex = Integer.parseInt(data[3]);
                double reachabilityValue = Double.parseDouble(data[4]);
                StepReachabilityLatticePoint latticePoint = new StepReachabilityLatticePoint(xIndex, yIndex, zIndex, yawIndex);
                reachabilityData.getLegReachabilityMap().put(latticePoint, reachabilityValue);
            }
            scanner.close();
            LogTools.info((String)"Done loading from file");
            return reachabilityData;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

