/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap.footstep;

import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityData;
import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityLatticePoint;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;

public class StepReachabilityVisualizer {
    public StepReachabilityVisualizer(StepReachabilityData stepReachabilityData) {
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters(true, 16000);
        SimulationConstructionSet scs = new SimulationConstructionSet(parameters);
        Graphics3DObject coordinate = new Graphics3DObject();
        coordinate.addCoordinateSystem(0.3);
        scs.addStaticLinkGraphics(coordinate);
        scs.setGroundVisible(false);
        scs.setCameraFix(0.0, 0.0, 1.0);
        scs.setCameraPosition(8.0, 0.0, 3.0);
        scs.startOnAThread();
        double yawDivisions = stepReachabilityData.getYawDivisions();
        for (StepReachabilityLatticePoint latticePoint : stepReachabilityData.getLegReachabilityMap().keySet()) {
            Graphics3DObject validStep = new Graphics3DObject();
            validStep.translate((double)latticePoint.getXIndex(), (double)latticePoint.getYIndex(), 0.0);
            validStep.rotate(Math.toRadians(90.0), (Vector3DReadOnly)new Vector3D(0.0, 1.0, 0.0));
            validStep.rotate(Math.toRadians(latticePoint.getYawIndex() * 10), (Vector3DReadOnly)new Vector3D(1.0, 0.0, 0.0));
            double reachabilityValue = (Double)stepReachabilityData.getLegReachabilityMap().get(latticePoint);
            if (reachabilityValue > 40.0) {
                reachabilityValue = 40.0;
            }
            AppearanceDefinition appearance = YoAppearance.RGBColor((double)(reachabilityValue / 40.0), (double)((40.0 - reachabilityValue) / 40.0), (double)0.0);
            validStep.addArrow(0.3, appearance, appearance);
            scs.addStaticLinkGraphics(validStep);
        }
    }
}

