/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap.voxelPrimitiveShapes;

import java.awt.Color;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.geometry.SpiralBasedAlgorithm;

public class SphereVoxelShape {
    private final Quaternion[][] rotations;
    private final Point3D[] pointsOnSphere;
    private final Point3D sphereOrigin = new Point3D();
    private final double voxelSize;
    private final int numberOfRays;
    private final int numberOfRotationsAroundRay;
    private final SphereVoxelType type;
    private final ReferenceFrame parentFrame;

    public SphereVoxelShape(ReferenceFrame parentFrame, double voxelSize, int numberOfRays, int numberOfRotationsAroundRay, SphereVoxelType type) {
        this.voxelSize = voxelSize;
        this.parentFrame = parentFrame;
        this.type = type;
        this.numberOfRays = numberOfRays;
        this.numberOfRotationsAroundRay = numberOfRotationsAroundRay;
        this.pointsOnSphere = SpiralBasedAlgorithm.generatePointsOnSphere((Point3DReadOnly)this.sphereOrigin, (double)voxelSize, (int)numberOfRays);
        this.rotations = SpiralBasedAlgorithm.generateOrientations((int)numberOfRays, (int)numberOfRotationsAroundRay);
    }

    public int getNumberOfRays() {
        return this.numberOfRays;
    }

    public int getNumberOfRotationsAroundRay() {
        return this.numberOfRotationsAroundRay;
    }

    public void getRay(Vector3D rayToPack, int rayIndex) {
        MathTools.checkIntervalContains((long)rayIndex, (long)0L, (long)(this.numberOfRays - 1));
        rayToPack.sub((Tuple3DReadOnly)this.sphereOrigin, (Tuple3DReadOnly)this.pointsOnSphere[rayIndex]);
        rayToPack.normalize();
    }

    public void getOrientation(FrameQuaternion orientation, int rayIndex, int rotationAroundRayIndex) {
        MathTools.checkIntervalContains((long)rayIndex, (long)0L, (long)(this.numberOfRays - 1));
        MathTools.checkIntervalContains((long)rotationAroundRayIndex, (long)0L, (long)(this.numberOfRotationsAroundRay - 1));
        orientation.setIncludingFrame(this.parentFrame, (QuaternionReadOnly)this.rotations[rayIndex][rotationAroundRayIndex]);
    }

    public void getPose(FrameVector3D translationFromVoxelOrigin, FrameQuaternion orientation, int rayIndex, int rotationAroundRayIndex) {
        MathTools.checkIntervalContains((long)rayIndex, (long)0L, (long)(this.numberOfRays - 1));
        MathTools.checkIntervalContains((long)rotationAroundRayIndex, (long)0L, (long)(this.numberOfRotationsAroundRay - 1));
        if (this.type == SphereVoxelType.graspAroundSphere) {
            translationFromVoxelOrigin.setIncludingFrame(this.parentFrame, (Tuple3DReadOnly)this.pointsOnSphere[rayIndex]);
        } else {
            translationFromVoxelOrigin.setToZero(this.parentFrame);
        }
        orientation.setIncludingFrame(this.parentFrame, (QuaternionReadOnly)this.rotations[rayIndex][rotationAroundRayIndex]);
    }

    public Point3D[] getPointsOnSphere() {
        return this.pointsOnSphere;
    }

    public Graphics3DObject createVisualization(FramePoint3D voxelLocation, double scale, double reachabilityValue) {
        ReferenceFrame originalFrame = voxelLocation.getReferenceFrame();
        voxelLocation.changeFrame(ReferenceFrame.getWorldFrame());
        Graphics3DObject voxelViz = new Graphics3DObject();
        AppearanceDefinition appearance = YoAppearance.RGBColorFromHex((int)Color.HSBtoRGB((float)(0.7 * reachabilityValue), 1.0f, 1.0f));
        voxelViz.translate(voxelLocation.getX(), voxelLocation.getY(), voxelLocation.getZ());
        voxelViz.addSphere(scale * this.voxelSize / 2.0, appearance);
        voxelLocation.changeFrame(originalFrame);
        return voxelViz;
    }

    public static enum SphereVoxelType {
        graspOrigin,
        graspAroundSphere;

    }
}

