/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import controller_msgs.msg.dds.ArmTrajectoryMessage;
import controller_msgs.msg.dds.ChestTrajectoryMessage;
import controller_msgs.msg.dds.FootTrajectoryMessage;
import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.FrameInformation;
import controller_msgs.msg.dds.HandTrajectoryMessage;
import controller_msgs.msg.dds.HeadTrajectoryMessage;
import controller_msgs.msg.dds.PelvisTrajectoryMessage;
import controller_msgs.msg.dds.QueueableMessage;
import controller_msgs.msg.dds.SE3TrajectoryPointMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import geometry_msgs.Point;
import geometry_msgs.Quaternion;
import ihmc_msgs.ArmTrajectoryRosMessage;
import ihmc_msgs.ChestTrajectoryRosMessage;
import ihmc_msgs.FootTrajectoryRosMessage;
import ihmc_msgs.FootstepDataListRosMessage;
import ihmc_msgs.FootstepDataRosMessage;
import ihmc_msgs.FrameInformationRosMessage;
import ihmc_msgs.HandTrajectoryRosMessage;
import ihmc_msgs.HeadTrajectoryRosMessage;
import ihmc_msgs.PelvisTrajectoryRosMessage;
import ihmc_msgs.Point2dRosMessage;
import ihmc_msgs.QueueableRosMessage;
import ihmc_msgs.SE3TrajectoryPointRosMessage;
import ihmc_msgs.WholeBodyTrajectoryRosMessage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.ros.internal.message.Message;
import org.ros.message.MessageFactory;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.ros.generators.RosMessagePacket;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.idl.IDLSequence;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.utilities.ros.msgToPacket.converter.CustomFieldConversions;
import us.ihmc.utilities.ros.msgToPacket.converter.GenericROSTranslationTools;
import us.ihmc.utilities.ros.msgToPacket.converter.RosEnumConversionException;

public class IHMCROSTranslationRuntimeTools {
    private static final MessageFactory messageFactory = GenericROSTranslationTools.getMessageFactory();
    private static final CustomFieldConversions customFieldConversions = CustomFieldConversions.getInstance();

    public static Message convertToRosMessage(Packet<?> ihmcMessage) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        if (ihmcMessage == null) {
            return null;
        }
        Class<?> aClass = ihmcMessage.getClass();
        if (customFieldConversions.containsConverterFor(aClass)) {
            return customFieldConversions.convert(ihmcMessage);
        }
        return GenericROSTranslationTools.convertIHMCMessageToRosMessage(ihmcMessage);
    }

    public static Packet<?> convertToIHMCMessage(Message rosMessage) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, RosEnumConversionException, NoSuchFieldException, InstantiationException, IllegalArgumentException, NoSuchMethodException, SecurityException {
        if (rosMessage == null) {
            return null;
        }
        Class<?> aClass = Class.forName(rosMessage.toRawMessage().getType().replace("/", "."));
        if (customFieldConversions.containsConverterFor(aClass)) {
            return (Packet)customFieldConversions.convert(rosMessage);
        }
        return GenericROSTranslationTools.convertRosMessageToIHMCMessage((Message)rosMessage);
    }

    private static Packet customConvertToIHMCMessage(FootstepDataListRosMessage message) {
        FootstepDataListMessage footsteps = new FootstepDataListMessage();
        footsteps.setDefaultSwingDuration(message.getDefaultSwingDuration());
        footsteps.setDefaultTransferDuration(message.getDefaultTransferDuration());
        footsteps.setUniqueId(message.getUniqueId());
        try {
            footsteps.getQueueingProperties().set((QueueableMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getQueueingProperties()));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | RosEnumConversionException e1) {
            e1.printStackTrace();
        }
        footsteps.setFinalTransferDuration(message.getFinalTransferDuration());
        footsteps.setExecutionTiming(message.getExecutionTiming());
        footsteps.setOffsetFootstepsWithExecutionError(message.getOffsetFootstepsWithExecutionError());
        ArrayList<FootstepDataMessage> stepData = new ArrayList<FootstepDataMessage>();
        for (FootstepDataRosMessage footstepDataRosMessage : message.getFootstepDataList()) {
            try {
                stepData.add((FootstepDataMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)footstepDataRosMessage));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | RosEnumConversionException e) {
                e.printStackTrace();
            }
        }
        MessageTools.copyData(stepData, (RecyclingArrayList)footsteps.getFootstepDataList());
        return footsteps;
    }

    private static Packet customConvertToIHMCMessage(FootstepDataRosMessage message) {
        FootstepDataMessage ihmcMessage = new FootstepDataMessage();
        ihmcMessage.setRobotSide(message.getRobotSide());
        ihmcMessage.getLocation().set(new Point3D((Tuple3DReadOnly)GenericROSTranslationTools.convertPoint((Point)message.getLocation())));
        ihmcMessage.getOrientation().set(new us.ihmc.euclid.tuple4D.Quaternion((Tuple4DReadOnly)GenericROSTranslationTools.convertQuaternion((Quaternion)message.getOrientation())));
        ihmcMessage.setSwingHeight(message.getSwingHeight());
        ihmcMessage.setTrajectoryType(message.getTrajectoryType());
        ihmcMessage.setUniqueId(message.getUniqueId());
        ihmcMessage.setSwingDuration(message.getSwingDuration());
        ihmcMessage.setTransferDuration(message.getTransferDuration());
        ihmcMessage.setTouchdownDuration(message.getTouchdownDuration());
        ihmcMessage.setSwingTrajectoryBlendDuration(message.getSwingTrajectoryBlendDuration());
        ArrayList<Point2D> predictedContactPoints = new ArrayList<Point2D>();
        for (Point2dRosMessage point2dRosMessage : message.getPredictedContactPoints()) {
            predictedContactPoints.add(GenericROSTranslationTools.convertPoint2DRos((Point2dRosMessage)point2dRosMessage));
        }
        Point3D[] trajectoryWaypoints = new Point3D[message.getCustomPositionWaypoints().size()];
        for (int i = 0; i < message.getCustomPositionWaypoints().size(); ++i) {
            trajectoryWaypoints[i] = new Point3D((Tuple3DReadOnly)GenericROSTranslationTools.convertPoint((Point)((Point)message.getCustomPositionWaypoints().get(i))));
        }
        for (SE3TrajectoryPointRosMessage rosTrajectoryPoint : message.getSwingTrajectory()) {
            try {
                ((SE3TrajectoryPointMessage)ihmcMessage.getSwingTrajectory().add()).set((SE3TrajectoryPointMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)rosTrajectoryPoint));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | RosEnumConversionException e) {
                e.printStackTrace();
            }
        }
        HumanoidMessageTools.packPredictedContactPoints(predictedContactPoints, (FootstepDataMessage)ihmcMessage);
        MessageTools.copyData((Settable[])trajectoryWaypoints, (RecyclingArrayList)ihmcMessage.getCustomPositionWaypoints());
        return ihmcMessage;
    }

    private static Packet customConvertToIHMCMessage(WholeBodyTrajectoryRosMessage message) {
        WholeBodyTrajectoryMessage wholeBodyTrajectoryMessage = new WholeBodyTrajectoryMessage();
        wholeBodyTrajectoryMessage.setUniqueId(message.getUniqueId());
        try {
            wholeBodyTrajectoryMessage.getLeftArmTrajectoryMessage().set((ArmTrajectoryMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getLeftArmTrajectoryMessage()));
            wholeBodyTrajectoryMessage.getRightArmTrajectoryMessage().set((ArmTrajectoryMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getRightArmTrajectoryMessage()));
            wholeBodyTrajectoryMessage.getLeftHandTrajectoryMessage().set((HandTrajectoryMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getLeftHandTrajectoryMessage()));
            wholeBodyTrajectoryMessage.getRightHandTrajectoryMessage().set((HandTrajectoryMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getRightHandTrajectoryMessage()));
            wholeBodyTrajectoryMessage.getLeftFootTrajectoryMessage().set((FootTrajectoryMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getLeftFootTrajectoryMessage()));
            wholeBodyTrajectoryMessage.getRightFootTrajectoryMessage().set((FootTrajectoryMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getRightFootTrajectoryMessage()));
            wholeBodyTrajectoryMessage.getChestTrajectoryMessage().set((ChestTrajectoryMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getChestTrajectoryMessage()));
            wholeBodyTrajectoryMessage.getPelvisTrajectoryMessage().set((PelvisTrajectoryMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getPelvisTrajectoryMessage()));
            wholeBodyTrajectoryMessage.getHeadTrajectoryMessage().set((HeadTrajectoryMessage)IHMCROSTranslationRuntimeTools.convertToIHMCMessage((Message)message.getHeadTrajectoryMessage()));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | RosEnumConversionException e) {
            e.printStackTrace();
        }
        return wholeBodyTrajectoryMessage;
    }

    private static Message customConvertToRosMessage(WholeBodyTrajectoryMessage wholeBodyTrajectoryMessage) {
        Class<WholeBodyTrajectoryMessage> ihmcMessageClass = WholeBodyTrajectoryMessage.class;
        String rosMessageClassNameFromIHMCMessage = GenericROSTranslationTools.getRosMessageClassNameFromIHMCMessage((String)ihmcMessageClass.getSimpleName());
        RosMessagePacket rosAnnotation = ihmcMessageClass.getAnnotation(RosMessagePacket.class);
        WholeBodyTrajectoryRosMessage message = (WholeBodyTrajectoryRosMessage)messageFactory.newFromType(rosAnnotation.rosPackage() + "/" + rosMessageClassNameFromIHMCMessage);
        IHMCROSTranslationRuntimeTools.checkForNullComponents(wholeBodyTrajectoryMessage);
        message.setUniqueId(wholeBodyTrajectoryMessage.getUniqueId());
        try {
            message.setChestTrajectoryMessage((ChestTrajectoryRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(wholeBodyTrajectoryMessage.getChestTrajectoryMessage()));
            message.setLeftArmTrajectoryMessage((ArmTrajectoryRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(wholeBodyTrajectoryMessage.getLeftArmTrajectoryMessage()));
            message.setRightArmTrajectoryMessage((ArmTrajectoryRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(wholeBodyTrajectoryMessage.getRightArmTrajectoryMessage()));
            message.setPelvisTrajectoryMessage((PelvisTrajectoryRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(wholeBodyTrajectoryMessage.getPelvisTrajectoryMessage()));
            message.setLeftFootTrajectoryMessage((FootTrajectoryRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(wholeBodyTrajectoryMessage.getLeftFootTrajectoryMessage()));
            message.setRightFootTrajectoryMessage((FootTrajectoryRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(wholeBodyTrajectoryMessage.getRightFootTrajectoryMessage()));
            message.setLeftHandTrajectoryMessage((HandTrajectoryRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(wholeBodyTrajectoryMessage.getLeftHandTrajectoryMessage()));
            message.setRightHandTrajectoryMessage((HandTrajectoryRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(wholeBodyTrajectoryMessage.getRightHandTrajectoryMessage()));
            message.setHeadTrajectoryMessage((HeadTrajectoryRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(wholeBodyTrajectoryMessage.getHeadTrajectoryMessage()));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return message;
    }

    private static void checkForNullComponents(WholeBodyTrajectoryMessage wholeBodyTrajectoryMessage) {
        ChestTrajectoryMessage component;
        if (wholeBodyTrajectoryMessage.getChestTrajectoryMessage() == null) {
            component = new ChestTrajectoryMessage();
            wholeBodyTrajectoryMessage.getChestTrajectoryMessage().set(component);
        }
        if (wholeBodyTrajectoryMessage.getLeftArmTrajectoryMessage() == null) {
            component = new ArmTrajectoryMessage();
            component.setRobotSide(RobotSide.LEFT.toByte());
            wholeBodyTrajectoryMessage.getLeftArmTrajectoryMessage().set((ArmTrajectoryMessage)component);
        }
        if (wholeBodyTrajectoryMessage.getRightArmTrajectoryMessage() == null) {
            component = new ArmTrajectoryMessage();
            component.setRobotSide(RobotSide.RIGHT.toByte());
            wholeBodyTrajectoryMessage.getRightArmTrajectoryMessage().set((ArmTrajectoryMessage)component);
        }
        if (wholeBodyTrajectoryMessage.getPelvisTrajectoryMessage() == null) {
            component = new PelvisTrajectoryMessage();
            wholeBodyTrajectoryMessage.getPelvisTrajectoryMessage().set((PelvisTrajectoryMessage)component);
        }
        if (wholeBodyTrajectoryMessage.getLeftFootTrajectoryMessage() == null) {
            component = new FootTrajectoryMessage();
            component.setRobotSide(RobotSide.LEFT.toByte());
            wholeBodyTrajectoryMessage.getLeftFootTrajectoryMessage().set((FootTrajectoryMessage)component);
        }
        if (wholeBodyTrajectoryMessage.getRightFootTrajectoryMessage() == null) {
            component = new FootTrajectoryMessage();
            component.setRobotSide(RobotSide.RIGHT.toByte());
            wholeBodyTrajectoryMessage.getRightFootTrajectoryMessage().set((FootTrajectoryMessage)component);
        }
        if (wholeBodyTrajectoryMessage.getLeftHandTrajectoryMessage() == null) {
            component = new HandTrajectoryMessage();
            component.setRobotSide(RobotSide.LEFT.toByte());
            wholeBodyTrajectoryMessage.getLeftHandTrajectoryMessage().set((HandTrajectoryMessage)component);
        }
        if (wholeBodyTrajectoryMessage.getRightHandTrajectoryMessage() == null) {
            component = new HandTrajectoryMessage();
            component.setRobotSide(RobotSide.RIGHT.toByte());
            wholeBodyTrajectoryMessage.getRightHandTrajectoryMessage().set((HandTrajectoryMessage)component);
        }
        if (wholeBodyTrajectoryMessage.getHeadTrajectoryMessage() == null) {
            component = new HeadTrajectoryMessage();
            wholeBodyTrajectoryMessage.getHeadTrajectoryMessage().set((HeadTrajectoryMessage)component);
        }
    }

    private static Message customConvertToRosMessage(FootstepDataMessage footstep) {
        Class<FootstepDataMessage> ihmcMessageClass = FootstepDataMessage.class;
        String rosMessageClassNameFromIHMCMessage = GenericROSTranslationTools.getRosMessageClassNameFromIHMCMessage((String)ihmcMessageClass.getSimpleName());
        RosMessagePacket rosAnnotation = ihmcMessageClass.getAnnotation(RosMessagePacket.class);
        FootstepDataRosMessage message = (FootstepDataRosMessage)messageFactory.newFromType(rosAnnotation.rosPackage() + "/" + rosMessageClassNameFromIHMCMessage);
        message.setUniqueId(footstep.getUniqueId());
        message.setLocation(GenericROSTranslationTools.convertPoint3D((Point3DReadOnly)footstep.getLocation()));
        message.setOrientation(GenericROSTranslationTools.convertTuple4d((Tuple4DReadOnly)footstep.getOrientation()));
        message.setRobotSide(footstep.getRobotSide());
        message.setSwingHeight(footstep.getSwingHeight());
        message.setTrajectoryType(footstep.getTrajectoryType());
        message.setSwingDuration(footstep.getSwingDuration());
        message.setTransferDuration(footstep.getTransferDuration());
        message.setTouchdownDuration(footstep.getTouchdownDuration());
        message.setSwingTrajectoryBlendDuration(footstep.getSwingTrajectoryBlendDuration());
        ArrayList<Point2dRosMessage> predictedContatcPointsRos = new ArrayList<Point2dRosMessage>();
        if (footstep.getPredictedContactPoints2d() != null) {
            for (Point2D predictedContactPoint : HumanoidMessageTools.unpackPredictedContactPoints((FootstepDataMessage)footstep)) {
                predictedContatcPointsRos.add(GenericROSTranslationTools.convertPoint2d((Point2D)predictedContactPoint));
            }
        }
        ArrayList<Point> positionWaypoints = new ArrayList<Point>();
        if (footstep.getCustomPositionWaypoints() != null) {
            IDLSequence.Object customPositionWaypoints = footstep.getCustomPositionWaypoints();
            for (int i = 0; i < customPositionWaypoints.size(); ++i) {
                positionWaypoints.add(GenericROSTranslationTools.convertPoint3D((Point3DReadOnly)((Point3DReadOnly)customPositionWaypoints.get(i))));
            }
        }
        ArrayList<SE3TrajectoryPointRosMessage> rosSwingTrajectory = new ArrayList<SE3TrajectoryPointRosMessage>();
        IDLSequence.Object swingTrajectory = footstep.getSwingTrajectory();
        for (int i = 0; i < swingTrajectory.size(); ++i) {
            try {
                rosSwingTrajectory.add((SE3TrajectoryPointRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage((Packet)swingTrajectory.get(i)));
                continue;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        message.setSwingTrajectory(rosSwingTrajectory);
        message.setPredictedContactPoints(predictedContatcPointsRos);
        message.setCustomPositionWaypoints(positionWaypoints);
        return message;
    }

    private static Message customConvertToRosMessage(FootstepDataListMessage footstepList) {
        Class<FootstepDataListMessage> ihmcMessageClass = FootstepDataListMessage.class;
        String rosMessageClassNameFromIHMCMessage = GenericROSTranslationTools.getRosMessageClassNameFromIHMCMessage((String)ihmcMessageClass.getSimpleName());
        RosMessagePacket rosAnnotation = ihmcMessageClass.getAnnotation(RosMessagePacket.class);
        FootstepDataListRosMessage message = (FootstepDataListRosMessage)messageFactory.newFromType(rosAnnotation.rosPackage() + "/" + rosMessageClassNameFromIHMCMessage);
        message.setDefaultSwingDuration(footstepList.getDefaultSwingDuration());
        message.setDefaultTransferDuration(footstepList.getDefaultTransferDuration());
        message.setUniqueId(footstepList.getUniqueId());
        message.setFinalTransferDuration(footstepList.getFinalTransferDuration());
        message.setOffsetFootstepsWithExecutionError(footstepList.getOffsetFootstepsWithExecutionError());
        message.setExecutionTiming(footstepList.getExecutionTiming());
        try {
            message.setQueueingProperties((QueueableRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(footstepList.getQueueingProperties()));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
        ArrayList<FootstepDataRosMessage> convertedFootsteps = new ArrayList<FootstepDataRosMessage>();
        IDLSequence.Object footstepDataList = footstepList.getFootstepDataList();
        for (int i = 0; i < footstepDataList.size(); ++i) {
            FootstepDataMessage footstepDataMessage = (FootstepDataMessage)footstepDataList.get(i);
            try {
                convertedFootsteps.add((FootstepDataRosMessage)IHMCROSTranslationRuntimeTools.convertToRosMessage(footstepDataMessage));
                continue;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        message.setFootstepDataList(convertedFootsteps);
        return message;
    }

    private static FrameInformationRosMessage convertFrameInformation(FrameInformation frameInformation) {
        Class<FrameInformation> ihmcClass = FrameInformation.class;
        String rosMessageClassNameFromIHMCClass = GenericROSTranslationTools.getRosMessageClassNameFromIHMCMessage((String)ihmcClass.getSimpleName());
        RosMessagePacket rosAnnotation = ihmcClass.getAnnotation(RosMessagePacket.class);
        FrameInformationRosMessage message = (FrameInformationRosMessage)messageFactory.newFromType(rosAnnotation.rosPackage() + "/" + rosMessageClassNameFromIHMCClass);
        message.setDataReferenceFrameId(frameInformation.getDataReferenceFrameId());
        message.setTrajectoryReferenceFrameId(frameInformation.getTrajectoryReferenceFrameId());
        return message;
    }

    private static FrameInformation convertFrameInformationRosMessage(FrameInformationRosMessage message) {
        FrameInformation frameInformation = new FrameInformation();
        frameInformation.setDataReferenceFrameId(message.getDataReferenceFrameId());
        frameInformation.setTrajectoryReferenceFrameId(message.getTrajectoryReferenceFrameId());
        return frameInformation;
    }

    public static String getROSMessageTypeStringFromIHMCMessageClass(Class outputType) {
        String rosMessageClassNameFromIHMCMessage = GenericROSTranslationTools.getRosMessageClassNameFromIHMCMessage((String)outputType.getSimpleName());
        RosMessagePacket annotation = outputType.getAnnotation(RosMessagePacket.class);
        if (annotation == null) {
            return null;
        }
        return annotation.rosPackage() + "/" + rosMessageClassNameFromIHMCMessage;
    }

    static {
        customFieldConversions.registerIHMCPacketFieldConverter(FootstepDataListMessage.class, IHMCROSTranslationRuntimeTools::customConvertToRosMessage);
        customFieldConversions.registerROSMessageFieldConverter(FootstepDataListRosMessage.class, IHMCROSTranslationRuntimeTools::customConvertToIHMCMessage);
        customFieldConversions.registerIHMCPacketFieldConverter(FootstepDataMessage.class, IHMCROSTranslationRuntimeTools::customConvertToRosMessage);
        customFieldConversions.registerROSMessageFieldConverter(FootstepDataRosMessage.class, IHMCROSTranslationRuntimeTools::customConvertToIHMCMessage);
        customFieldConversions.registerIHMCPacketFieldConverter(FrameInformation.class, IHMCROSTranslationRuntimeTools::convertFrameInformation);
        customFieldConversions.registerROSMessageFieldConverter(FrameInformationRosMessage.class, IHMCROSTranslationRuntimeTools::convertFrameInformationRosMessage);
        customFieldConversions.registerIHMCPacketFieldConverter(WholeBodyTrajectoryMessage.class, IHMCROSTranslationRuntimeTools::customConvertToRosMessage);
        customFieldConversions.registerROSMessageFieldConverter(WholeBodyTrajectoryRosMessage.class, IHMCROSTranslationRuntimeTools::customConvertToIHMCMessage);
    }
}

