/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import controller_msgs.msg.dds.HandDesiredConfigurationMessage;
import handle_msgs.HandleControl;
import java.net.URI;
import java.net.URISyntaxException;
import org.ros.namespace.GraphName;
import org.ros.node.AbstractNodeMain;
import org.ros.node.ConnectedNode;
import org.ros.node.topic.Publisher;
import us.ihmc.avatar.ros.HandDesiredConfigurationMessageToHandleControlMessageConverter;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class ROSiRobotCommunicator
extends AbstractNodeMain {
    private static final String MASTER_URI = "http://localhost:11311";
    private URI master;
    private final SideDependentList<Publisher<HandleControl>> handCommandPublishers = new SideDependentList();
    private final SideDependentList<HandleControl> handControlMessages = new SideDependentList();
    private Publisher<HandleControl> leftHandPublisher;
    private Publisher<HandleControl> rightHandPublisher;
    private HandleControl leftHandControlMessage;
    private HandleControl rightHandControlMessage;
    private ConnectedNode connectedNode;

    public ROSiRobotCommunicator() {
        try {
            this.master = new URI(MASTER_URI);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public ROSiRobotCommunicator(String uri) {
        try {
            this.master = new URI(uri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public GraphName getDefaultNodeName() {
        return GraphName.of((String)"darpaRoboticsChallenge/iRobotROSCommunicator");
    }

    public void onStart(ConnectedNode connectedNode) {
        this.connectedNode = connectedNode;
        this.setupPublishers();
        this.setupMessages();
    }

    private void setupPublishers() {
        this.leftHandPublisher = this.connectedNode.newPublisher("/left_hand/control", "handle_msgs/HandleControl");
        this.rightHandPublisher = this.connectedNode.newPublisher("/right_hand/control", "handle_msgs/HandleControl");
        this.handCommandPublishers.put((Enum)RobotSide.LEFT, this.leftHandPublisher);
        this.handCommandPublishers.put((Enum)RobotSide.RIGHT, this.rightHandPublisher);
    }

    private void setupMessages() {
        this.leftHandControlMessage = (HandleControl)this.leftHandPublisher.newMessage();
        this.rightHandControlMessage = (HandleControl)this.rightHandPublisher.newMessage();
        this.handControlMessages.put((Enum)RobotSide.LEFT, (Object)this.leftHandControlMessage);
        this.handControlMessages.put((Enum)RobotSide.RIGHT, (Object)this.rightHandControlMessage);
    }

    public void sendHandCommand(HandDesiredConfigurationMessage packet) {
        HandDesiredConfigurationMessageToHandleControlMessageConverter.convertHandDesiredConfigurationMessage(packet, (HandleControl)this.handControlMessages.get((Enum)RobotSide.fromByte((byte)packet.getRobotSide())));
        ((Publisher)this.handCommandPublishers.get((Enum)RobotSide.fromByte((byte)packet.getRobotSide()))).publish(this.handControlMessages.get((Enum)RobotSide.fromByte((byte)packet.getRobotSide())));
    }
}

